import fileinput

forwardTimes = []
backwardTimes = []

for line in fileinput.input():
    parts = line.split()
    if  len(parts) == 9 and parts[2] == "forwardMean":
        forwardTimes.append(parts[6])
        backwardTimes.append(parts[8])

def evens(xs):
    return [xs[2*i] for i in range(len(xs) / 2)]
def odds(xs):
    return [xs[2*i + 1] for i in range(len(xs) / 2)]

print "forwardTimes/backwardTimes for Fast-PPR:"
print "\t".join(evens(forwardTimes))
print "\t".join(evens(backwardTimes))
print
print "forwardTimes/backwardTimes for Fast-PPR-Balanced:"
print "\t".join(odds(forwardTimes))
print "\t".join(odds(backwardTimes))
