package edu.stanford.peer.rbtm.util;

import java.util.*;

import edu.stanford.peer.rbtm.RBTMConstants;
//import edu.stanford.peer.rbtm.util.*;

/** Stores results and their evidences. */
public class ResultEvidenceMap implements RBTMConstants
{
  static final public int DEFAULT_CAPACITY = 23;

  private int  	_type = TRACK_NONE;
  private HashMap _map;

  public ResultEvidenceMap(int trackType, int capacity) {
    _type = trackType; 
    _map = new HashMap(capacity);
  }

  public ResultEvidenceMap() { 
    this(TRACK_NONE, DEFAULT_CAPACITY);
  }

  public ResultEvidenceMap(int trackType) { 
    this(trackType, DEFAULT_CAPACITY);
  }

  /**
   * Add a Result-to-Evidence mapping.  
   * @return true if this is a new Result, false if it is not
   */
  public boolean putResultEvidence(Object result, Object evidence) {
    if (! _map.containsKey(result)) {  // New result
      switch (_type) {
      case TRACK_NONE:
	_map.put(result, null);
	break;
      case TRACK_ANY:
	_map.put(result, evidence);
	break;
      case TRACK_ALL:
	HashSet eviSet = new HashSet(7);
	eviSet.add(evidence);
	_map.put(result, eviSet);
	break;
      }
      return true;
    } else {  // Result already exist
      if (_type == TRACK_ALL) {
	((Set)_map.get(result)).add(evidence);
      }
      return false;
    }
  }
    
  public boolean containsResult(Object result) {
    return _map.containsKey(result);
  }

  public Set resultSet() {
    return _map.keySet();
  }

  public String toString() {
    return _map.toString();
  }
}
