package edu.stanford.peer.rbtm.engine;

import java.util.*;

/**
 * SimpleProofQueue maintains two queues of nodes that have not been visited, 
 * one for forward, and one for backward.
 */
public class SimpleProofQueue implements ProofQueue
{
  //HashSet 	forwardNodes = new HashSet();
  //HashSet     backwardNodes = new HashSet();
  LinkedList  forwardQueue = new LinkedList();
  LinkedList  backwardQueue = new LinkedList();
  
  public boolean hasUnexploredForwardNodes() { 
    return !forwardQueue.isEmpty(); 
  }

  public boolean hasUnexploredBackwardNodes() { 
    return !backwardQueue.isEmpty(); 
  }

  public ProofNode nextUnexploredForwardNode() { 
    return (ProofNode)forwardQueue.removeFirst(); 
  }

  public ProofNode nextUnexploredBackwardNode() { 
    return (ProofNode)backwardQueue.removeFirst(); 
  }

  public void addForwardNode(ProofNode node) {
    //if (! forwardNodes.contains(node)) {
    forwardQueue.add(node);
    //	forwardNodes.add(node);
    //}
  }

  public void addBackwardNode(ProofNode node) {
    //if (! backwardNodes.contains(node)) {
    backwardQueue.add(node);
    //	backwardNodes.add(node);
    //}
  }
}
