package edu.stanford.peer.rbtm.engine;

import java.util.*;

import edu.stanford.peer.rbtm.credential.*;
import edu.stanford.peer.rbtm.util.*;

/** 
 * A role proof node is a proof node that is centered around a simple role. 
 */
class RoleProofNode extends AbstractProofNode
{
  private ForwardLinkingMonitor monitor;

  protected RoleProofNode(ProofGraph graph, Role re, int trackType) {
    super(graph, re, trackType);
  }

  public void additionalBackwardProcess() {
    Iterator  credIt = getGraph().findCredentialsDefiningRole((Role)getRoleExp());
    while (credIt.hasNext()) {
      StaticCredential credential = (StaticCredential) credIt.next();
      ProofNode node = getGraph().addBackwardNode(credential.getSubject());
      node.addChild(this, credential);
      // addProofEdge(node, this, credential);
    }
  }

  /**
   * Role-specific extension which marks itself as a solution to itself, and
   * sets up a ForwardLinkingMonitor to check for new solutions.
   */
  public void additionalForwardProcess() {
    Role thisRole = (Role)getRoleExp();
    // Make itself a forward solution to itself
    forwardSolutionAdded(this, thisRole);
		
    if (monitor == null) {
      ProofNode node = getGraph().addForwardNode(thisRole.getBase());
      monitor = new ForwardLinkingMonitor();
      node.addForwardListener(monitor);
    }
  }

  /**
   * Internal class which, whenever the solution is not an 'RPermission', goes
   * ahead and creates a new linked role 
   */
  class ForwardLinkingMonitor implements ForwardSolutionListener {
    public void forwardSolutionAdded(ProofNode s,  ForwardSolution sol) {
      if (sol instanceof Role) {
	Role role = (Role)sol;
	if (role.getName() instanceof RPermission) {
	  return;
	}
	LinkedRole linkedRole = new LinkedRole(role, ((Role)getRoleExp()).getName());
	//if (getGraph().hasCredentialsForSubject(linkedRole)) {
	ProofNode node = getGraph().addForwardNode(linkedRole);
	node.addParent(RoleProofNode.this, s);
	// addProofEdge(this, node, s);
      }
    }

    public String toString() {
      return "Monitor " + getRoleExp();
    }
  }
	
	
} // End of class RoleProofNode
