package edu.stanford.peer.rbtm.engine;

import java.util.*;

import edu.stanford.peer.rbtm.credential.*;
import edu.stanford.peer.rbtm.util.*;

/*
 */
public interface ProofNode extends BackwardSolutionListener, ForwardSolutionListener
{
	EntityExpression getRoleExp();

	void addBackwardListener(BackwardSolutionListener sl);

	/**
	 * Process this node for search in the backward direction.  The 
	 * implementation of this method should find all nodes that can reach
	 * this node directly and do appropriate things.
	 */
	void backwardProcess();

	void invalidateForward();

	void invalidateBackward();

	void addForwardListener(ForwardSolutionListener sl);

	void forwardProcess();

	/**
	 * add a node as a parent to this node
	 * @param  node: the parent node
	 */
	void addParent(ProofNode node, Object evidence);

	void addChild(ProofNode node, Object evidence);

	ResultEvidenceMap getForwardSolutions();

	ResultEvidenceMap getBackwardSolutions();

	/**
	 * Enable this node for backward searching, it then should store all 
	 * backward solutions (entities that are member of this node).
	 */
	// void enableAllBackwardGoals();

	/**
     * If one only wants to know whether this node has some particular 
	 * backward solutions, and doesn't care about others, then one can use 
	 * this call to tell this proof node.  It might improve efficiency in 
	 * bi-direction search.
	 */
    // void enableBackwardGoal(EntityExpression g);

    // void enableAllForwardGoals();
    // void enableForwardGoal(EntityExpression g);	

    // boolean hasParent(ProofNode node);
    // boolean hasChild(ProofNode node);

} // End of class ProofNode

