package edu.stanford.peer.rbtm.engine;

import java.util.*;

import edu.stanford.peer.rbtm.credential.*;
import edu.stanford.peer.rbtm.util.*;

/**
 * The class AbstractProofGraph represents a proof graph.  It 
 * 1. makes sure that the same node is not added more than once
 * 2. makes sure that the same edge is not added more than once
 * If one wants to implement priority queue, one should extend this
 * class.
 */
interface ProofGraph extends SolutionFilter
{
    ProofNode addForwardNode(EntityExpression roleExp);
	ProofNode addBackwardNode (EntityExpression roleExp);
	Iterator findCredentialsBySubject(EntityExpression re);
	Iterator findCredentialsDefiningRole(Role r);

	/*
		public ForwardSolution getForwardSolution(EntityExpression re) {
		if (re instanceof Role) {
			return new ForwardSolution((Role)re);
		} else {
			return null;
		}
	}

	public BackwardSolution getBackwardSolution(EntityExpression re) {
		if (re instanceof Entity) {
			return new BackwardSolution((Entity)re);
		} else {
			return null;
		}
	}
	*/

	/*
    protected void addProofEdge(ProofNode from, ProofNode to, Object e) {
		from.addChild(to, e);
		to.addParent(from, e);
    }
    protected ProofEdge addProofEdge(ProofNode from, ProofNode to, Object e) {
        ProofEdge edge = new ProofEdge(from, to);
        if (! edgeTable.containsKey(edge)) {
            edgeTable.put(edge, new SmallSet(evidence));
        } else if (_trackAll) {
            ((SmallSet)edgeTable.get(edge)).add(e);
        }
        return edge;
    }
	*/

	/*
    class GoalMonitor implements SolutionListener
    {
        private EntityExpression goalRE;
        GoalMonitor(EntityExpression goal) { goalRE = goal; }
        public void solutionAdded(ProofGraph.ProofNode s,  EntityExpression re) {
            if (goalRE.equals(re)) {
                throw new GoalReachedException(s, re);
            }
        }
    }
	*/
}