package edu.stanford.peer.rbtm.engine;

import java.util.*;

import edu.stanford.peer.rbtm.credential.*;
import edu.stanford.peer.rbtm.util.*;


public class LinkedRoleProofNode extends AbstractProofNode
{
	private BackwardLinkingMonitor  monitor;

    protected LinkedRoleProofNode(ProofGraph graph, LinkedRole re, int trackType) {
		super(graph, re, trackType);
	}

    public void additionalBackwardProcess() {
		if (monitor != null) {
			return;
		}
        Role firstRole = (Role) ((LinkedRole)getRoleExp()).getFirstRole();
        ProofNode node = getGraph().addBackwardNode(firstRole);
        monitor = new BackwardLinkingMonitor();
        node.addBackwardListener(monitor);
    }

    class BackwardLinkingMonitor implements BackwardSolutionListener {
        public void backwardSolutionAdded(ProofNode s,  BackwardSolution re) {
			if (re instanceof Entity) {
	            Role  r = new Role((Entity)re, ((LinkedRole)getRoleExp()).getSecondRoleName());
	            ProofNode node = getGraph().addBackwardNode(r);
				node.addChild(LinkedRoleProofNode.this, s);
			}
        }
		
	    public String toString() {
	    	return "Monitor " + getRoleExp();
	    }
    }

	public void additionalForwardProcess() {
	}
} // End of class LinkedRoleProofNode
