/*
 * Role.java
 */

package edu.stanford.peer.rbtm.credential;

import java.util.*;

public class Role implements EntityExpression, PermissionExpression, java.io.Serializable
{
    private Entity    _base;
    private RoleName  _name;

    public Role(Entity e, RoleName n) { _base = e; _name = n; }

	public Role(Entity e, String n) {
		_base = e;
		_name = new SimpleRoleName(n);
	}

    public Role(String e, String n) { 
        _base = new SimpleEntity(e);
        _name = new SimpleRoleName(n); 
    }

    /*
	public Role(RoleName name) {
		this(Entity.self, name);
	}

	public Role(String name) {
		this(Entity.self, name);
	}
    */

    public Entity getBase() { return _base; }

    public RoleName getName() { return _name; }

    public String toString() {
        return _base.toString() + "." + _name.toString();
    }

    public int hashCode() {
        return getBase().hashCode() * 2 + getName().hashCode();
    }

    public boolean equals(Object o) {
        return (o instanceof Role) &&
               getBase().equals(((Role)o).getBase()) &&
               getName().equals(((Role)o).getName());
    }

	public boolean isPermission() {
		return _name instanceof RPermission;
	}
}
