/*
 * LinkedRole.java
 */

package edu.stanford.peer.rbtm.credential;

import java.util.*;

/**
 * Represent a LinkedRole. A linked role is expressed as 
 * <samp><pre>R.a <- S.b.c</pre></samp>; parsed another way, it is
 * <samp><pre>R.a <- (S.b) c</pre></samp> where S.b is a role, and c is the
 * name of another role. Every entity in S.b's transitive closure will have
 * the rolename c appended to it to form a new role, and every member of that
 * role will belong to R.a.
 */
public class LinkedRole implements EntityExpression
{
  private Role        firstRole;
  private RoleName    secondName;

  public LinkedRole(Role r, RoleName n) { firstRole = r;  secondName = n; }

  public LinkedRole(Role r, String n) { 
    firstRole = r;
    secondName = new SimpleRoleName(n);
  }

  public LinkedRole(Entity issuer, String n1, String n2) {
    firstRole = new Role(issuer, n1);
    secondName = new SimpleRoleName(n2);
  }

  public LinkedRole(String issuer, String n1, String n2) {
    firstRole = new Role(issuer, n1);
    secondName = new SimpleRoleName(n2);
  }

  public int hashCode() {  
    return firstRole.hashCode() * 2 + secondName.hashCode();
  }

  public boolean equals(Object o) {
    return (o instanceof LinkedRole) 
      && firstRole.equals(((LinkedRole)o).firstRole)
      && secondName.equals(((LinkedRole)o).secondName);
  }

  public String toString() {
    return firstRole.toString() + "." + secondName.toString();
  }

  public Role getFirstRole() {
    return firstRole;
  }

  public RoleName getSecondRoleName() {
    return secondName;
  }
  //public Entity getIssuer() { return (Entity)_names.get(0); }

  /*
    public LinkedRole(String[] strs) {
    _names = new ArrayList();
    _names.add(new Entity(strs[0]));
    for (int i=1; i<strs.length; i++) {
    _names.add(new SimpleRoleName(strs[i]));
    }
    }

    public LinkedRole(ArrayList strs) {
    _names = new ArrayList();
    _names.add(new Entity((String)strs.get(0)));
    for (int i=1; i<strs.size(); i++) {
    _names.add(new SimpleRoleName((String) strs.get(i)));
    }
    }
    public int hashCode() {
    long value = 0;
    for (int i=0; i<_names.size(); i++) {
    value *= 2;
    value += _names.get(i).hashCode();
    }
    return (int)value;
    }
    public boolean equals(Object o) 
    {
    return (o instanceof LinkedRole) &&
    _names.equals(((LinkedRole)o)._names);
    }
    public String toString() {
    StringBuffer buf = new StringBuffer();
    buf.append("(").append(_names.get(0));
    for (int i=1; i<_names.size(); i++) {
    buf.append("'s ").append(_names.get(i));
    }
    buf.append(")");
    return buf.toString();
    }
    public RoleName getIthRoleName(int i) { return (RoleName)_names.get(i); }

    public RoleName getLastRoleName() { 
    return (RoleName)_names.get(_names.size()-1); 
    }

  */

}
