/*
 * Credential.java
 */

package edu.stanford.peer.rbtm.credential;

/**
 * Credential is the top level class for credentials in RBTM framework.  It is 
 * an abstract class, and has two direct sub-classes: StaticCredential and 
 * DynamicCredential.
 */
public abstract class Credential implements java.io.Serializable
                            // extends java.security.cert.Certificate
{
    /**
     * Constructor for Role-Based Trust Management certificates.
    protected Credential() {
        super("RBTM");
    }
     */

    /**
     * Get the issuer of this credential.
     */
    public abstract Entity getIssuer();
}
