package edu.stanford.peer.rbtm;

import java.io.*;
import java.util.*;
import edu.stanford.peer.rbtm.engine.*;
import edu.stanford.peer.rbtm.credential.*;
import edu.stanford.peer.rbtm.util.*;

public class Test 
{
    public static void main(String args[]) throws Exception {
		//test1();
		test3();
        //test3(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
    }

    static void test1() throws Exception {
        CredentialManager cs = new CredentialManager();
        cs.addCredential(new StaticCredential("university", "professors", "university.depts.professors"));
        cs.addCredential(new StaticCredential("dept_cs", "professors", "mitchell"));
        cs.addCredential(new StaticCredential("university", "depts", "dept_cs"));
        System.out.println(cs.toString());
        System.out.println();
        cs.removeCredential(new StaticCredential("university", "depts", "dept_cs"));
        System.out.println(cs.toString());
        System.out.println();

        Role r = new Role("university", "professors");
        System.out.println(cs.backwardSearch(r));
        System.out.println(cs.forwardSearch(new SimpleEntity("mitchell")));

    }

    static void test2() throws Exception {
	    CredentialManager cs = new CredentialManager();
	    SimpleEntity 	tony = new SimpleEntity("Tony"),
	    				carmela = new SimpleEntity("Carmela"),
	    				melfi = new SimpleEntity("Jennifer Melfi"),
	    				livia = new SimpleEntity("Livia"),
	    				junior = new SimpleEntity("Junior"),
	    				chris = new SimpleEntity("Chris Moltisanti"),
	    				meadow = new SimpleEntity("Meadow"),
	    				anthony = new SimpleEntity("Anthony Jr."),
	    				paulie = new SimpleEntity("Paulie Walnuts"),
	    				jackie = new SimpleEntity("Jackie Aprile");

	    Role 	tonyWifeRole = new Role(tony, "Wife"),
	    		tonyFamilyRole = new Role(tony, "Family Members"),
	    		tonyChildrenRole = new Role(tony, "Children"),
	    		tonyCrewRole = new Role(tony, "Crew"),
	    		tonyMotherRole = new Role(tony, "Mother"),
	    		tonyBossRole = new Role(tony, "Boss"),
	    		tonyUncleRole = new Role(tony, "Uncle"),
	    		melfiPatientRole = new Role(melfi, "Patients"),
	    		melfiPreferredPatientRole = new Role(melfi, "Preferred Patients"),
	    		chrisBossRole = new Role(chris, "Boss"),
	    		chrisActingBossRole = new Role(chris, "ActingBoss"),
	    		chrisGangRole = new Role(chris, "Gang");
	    
	    ArrayList tonyCreds = new ArrayList(20);
	    
	    tonyCreds.add(new StaticCredential(tonyWifeRole, carmela));
	    tonyCreds.add(new StaticCredential(tonyFamilyRole, tonyWifeRole));
	    tonyCreds.add(new StaticCredential(tonyFamilyRole, tonyChildrenRole));
	    tonyCreds.add(new StaticCredential(tonyChildrenRole, meadow));
	    tonyCreds.add(new StaticCredential(tonyChildrenRole, anthony));
	    tonyCreds.add(new StaticCredential(tonyCrewRole, chris));
	    tonyCreds.add(new StaticCredential(tonyCrewRole, paulie));
	    tonyCreds.add(new StaticCredential(tonyMotherRole, livia));
	    tonyCreds.add(new StaticCredential(tonyBossRole, jackie));
	    tonyCreds.add(new StaticCredential(tonyUncleRole, junior));
	    // Setting up credentials for toni
	    cs.addCredentials(tonyCreds); 

	    ArrayList melfiCreds = new ArrayList(5);
	    melfiCreds.add(new StaticCredential(melfiPatientRole, melfiPreferredPatientRole));
	    melfiCreds.add(new StaticCredential(melfiPreferredPatientRole, tony));
	    cs.addCredentials(melfiCreds); 

	    
	    ArrayList chrisCreds = new ArrayList(5);
	    cs.addCredential(new StaticCredential(chrisBossRole, tony));
	    cs.addCredential(new StaticCredential(chrisActingBossRole, tonyBossRole));
	    cs.addCredential(new StaticCredential(chrisGangRole, new LinkedRole(chrisBossRole, "Crew")));

		System.out.println(cs.toString());
		System.out.println();
		System.out.println(cs.forwardSearch(carmela));
		System.out.println();

		cs.removeCredential(new StaticCredential(chrisBossRole, tony));
		cs.removeCredential(new StaticCredential(chrisActingBossRole, tonyBossRole));

		cs.addCredential(new StaticCredential(chrisGangRole, new Role("Tony", "Wife")));
		cs.addCredential(new StaticCredential(new Role("Meadow", "Mother"), new Role("Tony", "Wife")));

		System.out.println(cs.toString());
		System.out.println();
		System.out.println(cs.forwardSearch(carmela));
		System.out.println();

		//System.out.println(cs.forwardSearch(jackie));
		//System.out.println();
	}
	
	
	static void test3() throws Exception
	{
		CredentialManager store = new CredentialManager();

		store.addCredential(new StaticCredential("sbose", "picturesRead", "sbose.family"));
		store.addCredential(new StaticCredential("sbose", "picturesWrite", "sbose.family"));
		store.addCredential(new StaticCredential("sbose", "picturesRead", "sbose.family.friends"));
		store.addCredential(new StaticCredential("sbose", "picturesRead", "patrick"));
		store.addCredential(new StaticCredential("sbose", "picturesWrite", "andrew"));
		store.addCredential(new StaticCredential("sbose", "picturesWrite", "patrick"));

		System.out.println(store.toString() + "\n\n");

		ResultEvidenceMap result = store.forwardSearch(new SimpleEntity("andrew"));
		Set resultSet = result.resultSet();
		System.out.println("forward andrew is: " + resultSet);
		Iterator it = resultSet.iterator();
		while (it.hasNext()) {
		    System.out.println(it.next().toString());
		}

		//add a credential
		store.addCredential(new StaticCredential("sbose", "picturesRead", "andrew"));

		System.out.println("\n\n added credential sbose.picturesRead <- andrew");

		System.out.println("\n" + store.toString() + "\n\n" + "forward search on entity andrew:");

		result = store.forwardSearch(new SimpleEntity("andrew"));
		resultSet = result.resultSet();
		System.out.println("forward andrew is: " + resultSet);
		it = resultSet.iterator();
		while (it.hasNext()) {
		    System.out.println(it.next().toString());
		}


		//remove a credential
		//
		//

		store.removeCredential(new StaticCredential("sbose", "picturesWrite", "patrick"));

		System.out.println("\n\n removed credential sbose.picturesWrite <- patrick");

		System.out.println("\n" + store.toString() + "\n\n" + "forward search on patrick:");

		result = store.forwardSearch(new SimpleEntity("patrick"));
		resultSet = result.resultSet();
		it = resultSet.iterator();
		while (it.hasNext()) {
		    System.out.println(it.next().toString());
		}
	}



    static void test4(int l, int n) throws Exception {
        CredentialManager cs = new CredentialManager();
        for (int j=0; j<n; j++) {
            cs.addCredential(new StaticCredential("K", "C", "K.C"+l+".B"+j));
        }
            cs.addCredential(new StaticCredential("K", "C1", "K0.A"));
        for (int i=1; i<l; i++) {
            int j = i+1;
            cs.addCredential(new StaticCredential("K", "C"+j, "K.C"+i+".A"));
        }
        for (int i=0; i<n; i++) {
            cs.addCredential(new StaticCredential("K0", "A", "K"+i));
        }
        for (int i=0; i<n; i++) {
            int j = (i+1) % n;
            cs.addCredential(new StaticCredential("K"+i, "A", "K"+j+".A"));
        }
        System.out.println(cs.toString());
        cs.forwardSearch(new SimpleEntity("K0"));

        cs.backwardSearch(new Role("K", "C"));

        //engine.bidirectionSearch(new Role("K0", "B0"), new Role("K", "C"));
    }

}
