
/*
    Makes sure that name does not contain illegal charactors.
*/
function validName(name)
{
   var pattern = new RegExp("[^0-9a-zA-Z_'\.\x20\x2D]", "g");
   if(pattern.test(name)) 
   {
       return false;
   }
   return true;
}

/*
    Valid create locker form in locker page.
*/
function validateCreateLockerForm(createForm) 
{
   var l_name = createForm.lockername.value.toString();
   var l_quota = createForm.quota.value.toString();

   if(l_name == "") 
   {
       alert("You must enter a locker name.");
       return false;
   }

   if(! validName(l_name))
   {
        alert("Locker name can only have letters, numbers, hyphens, and underscores.");
        return false;
   }
   
   if(l_quota == "" || l_quota.valueOf()<=0) 
   {
       alert("You must enter a positive integer for quota.");
       return false;
   }
   if(l_quota.indexOf(".") > -1) 
   {
       alert("You must provide a positive integer value for quota.");
       return false;
   }
   if(isNaN(l_quota)) 
   {
       alert("You must provide a positive integer value for quota.");
       return false;
   }
   return true;
}

/*
    Valid upload file form in locker page.
*/
function validateUploadForm(uploadForm) 
{
   var browsedfile = uploadForm.browsedfile.value;
   if(browsedfile.toString() == "") 
   {
       alert("You must provide a file.");
       return false;
   }
   return true;
}

/*
    Prompt user to enter a favor name for a locker.
*/
function addLockerToFavorite(lockerid) 
{
    var name = prompt("Please enter a name for this favorite link", "");
    //var pattern = new RegExp("[^0-9a-zA-Z_'\.\x20\x2D]", "g");
    if(name == null) {
        window.location = "lockers?lockerid="+lockerid; 
    }else if(name == "") {
        alert("You must provide a name.");
        window.location = "lockers?lockerid="+lockerid; 
    }else if(! validName(name)) {
       alert("Favorite name can only have letters, numbers, hyphens, and underscores.");
       window.location = "lockers?lockerid="+lockerid; 
    } else {
        window.location="favorites?action=add&lockerid="+lockerid+"&name="+name;
    }
}

/*
    Ask for user confirmation when deleting a locker.
*/
function lockerDeletionConfirmation(lockerid) 
{
    if(!confirm("Are you sure you want to delete this locker?")) 
    {
        window.location = "lockers?lockerid="+lockerid;
    } 
    else 
    {
        window.location="lockers?action=delete&lockerid="+lockerid;
    }
}

/*
    Prompt user to enter new quota for a locker.
*/
function changLockerQuota(lockerid) 
{
    var name = prompt("Please enter the size amount (KB), positive integer for increasing quota and negative number for decreasing quota.", "");
    if(name == null) {
        window.location = "lockers?lockerid="+lockerid; 
    }else if(name.toString() == "") {
        alert("You must provide an integer value for size.");
        window.location = "lockers?lockerid="+lockerid; 
    }else if(name.toString().indexOf(".") > -1) {
        alert("You must provide an integer value for size.");
        window.location = "lockers?lockerid="+lockerid; 
    }else if(isNaN(name.toString())) {
        alert("You must provide an integer value for size.");
        window.location = "lockers?lockerid="+lockerid; 
    } else {
        window.location="lockers?action=expand&lockerid="+lockerid+"&addSize="+name;
    }
}

/*
    Go to a locker's bulletin board page.
*/
function lockerBulletin(lockerid) 
{
   window.location="lockers?action=bulletin&lockerid="+lockerid;
}

/*
    Check if user has selected a radio button.
*/
function checkIfRadioSelected(radio) 
{
    var isSelected = 0;
    var i = 0;
    if(radio.checked) 
    {
         return true;
    }
    while (radio[i] != null) 
    {
        if (radio[i].checked) 
        {
            isSelected = 1;
        }
        i = i + 1;
    }
    if (isSelected == 0) 
    {
        alert("You must select an option.");
        return false;
    }
    return true;
}



    


function addFileToFavorite(lockerid, fileid) 
{
    var name = prompt("Please enter a name for this favorite link", "");
    if(name == null) {
         window.location = "files?lockerid="+lockerid+"&fileid="+fileid; 
    } else if(name == "") {
         alert("You must provide a name.");
         window.location = "files?lockerid="+lockerid+"&fileid="+fileid; 
    } else {
         window.location="favorites?action=add&fileid="+fileid+"&name="+name;
    }
}



function fileBulletin(fileid) 
{
   window.location="files?action=bulletin&fileid="+fileid;
}


function sendMessage(lockerid, fileid) 
{
   window.location="files?action=message&lockerid="+lockerid+"&fileid="+fileid;
}


function versions(lockerid, fileid) 
{
  window.location="files?action=versions&fileid="+fileid+"&lockerid="+lockerid;
}

function fileDeletionConfirmation(lockerid, fileid) 
{
    if(!confirm("Are you sure you want to delete this file?")) 
    {
        window.location = "files?lockerid="+lockerid+"&fileid="+fileid;
    } 
    else 
    {
        window.location="files?action=delete&lockerid="+lockerid+"&fileid="+fileid;
    }
}


function validateAddLockerPermForm(addPermForm) 
{
   var nametype = addPermForm.nameType;

   var definedRoles = addPermForm.definedRoles.value.toString();
   var newRoles = addPermForm.newRoles.value.toString();

   var sublocker_perm = addPermForm.sublocker_perm;
   var read_perm = addPermForm.read_perm;
   var delete_perm = addPermForm.delete_perm;
   var quota = addPermForm.quota.value.toString();

   if(nametype[0].checked)  // defined role
   {
       if(definedRoles == "") 
       {
           alert("You must select a role name.");
           return false;
       }
   }
   else if(nametype[1].checked) // new role
   {
       if(newRoles == "") 
       {
           alert("You must provide a role name.");
           return false;
       }
   }
   else
   {
        alert("You must select an option");
        return false;
   }



   if(isNaN(quota)||quota.valueOf() < 0||quota.indexOf(".") > -1) 
   {
       alert("Quota must be a non-negative integer.");
       return false;
   }

   if(sublocker_perm.checked && !(quota.valueOf() > 0)) 
   {
       alert("Quota must be positive when 'Create locker' is checked.");
       return false;
   }

   if(delete_perm.checked && !(read_perm.checked)) 
   {
       alert("You cannot give delete permission without also giving read permission.");
       return false;
   }
   return true;
}





function validateAddFilePermForm(addPermForm) 
{
    //alert("Calling validateAddFilePermForm()");
    
   var nametype = addPermForm.nameType;
    //alert(" nametype = " + nametype);

   var definedRoles = addPermForm.definedRoles.value.toString();
    //alert("definedRoles = " + definedRoles);
   var newRoles = addPermForm.newRoles.value.toString();
    //alert("newRoles = " + newRoles);

   var read_perm = addPermForm.read_perm;
    //alert("read_perm = " + read_perm);
    //alert("#######");
    
   var upload_perm = addPermForm.upload_perm;
    //alert("*********");
    //alert("upload_perm = "+ upload_perm);
   var delete_perm = addPermForm.delete_perm;
    //alert("delete_perm = " + delete_perm);


   if(nametype[0].checked) 
   {
       if(definedRoles == "") {
           alert("You must select a role name.");
           return false;
       }
   }
   else if(nametype[1].checked) 
   {
       if(newRoles == "") {
           alert("You must provide a role name.");
           return false;
       }
   }
   else
   {
        alert("You must select an option");
        return false;
   }

   if(delete_perm.checked && !(read_perm.checked)) {
       alert("You cannot give delete permission without also giving read permission.");
       return false;
   }

   if (upload_perm.checked && !(read_perm.checked)) {
       alert("You cannot give upload permission without also giving read permission.");
       return false;
   }


   return true;
}

/* Need debugging */
function validateAddGroupPermForm(addPermForm)
{
    //alert(" calling validateAddGroupPermForm(&&&&&&) ");    
    var nametype = addPermForm.nameType;
    //alert("nametype  = " + nametype);

    var definedRoles = addPermForm.definedRoles.value.toString();
    //alert("definedRoles = " + definedRoles);

    var newRoles = addPermForm.newRoles.value.toString();
    //alert("newRoles  = " + newRoles);
    
    
    if(nametype[0].checked) 
    {
       if(definedRoles == "") 
       {
           alert("You must select a role name.");
           return false;
       }
    }
    else if(nametype[1].checked) 
    {
       if(newRoles == "") 
       {
           alert("You must provide a role name.");
           return false;
       }
    }
    else
    {
        alert("You must select an option");
        return false;
    }

    return true;

}



/*
    Valid search form in Favorite page.
*/
function validateSearchByNameForm(form) 
{
    var radio = form.Type;
    var name = form.LastName.value.toString();
    var cred = form.credentials.value.toString();
    var group = form.groups.value.toString();
    
    if (radio[0].checked) 
    {
        if (cred == "") {
           alert("You must select a quickname");
           return false;
        }
    }
    else if(radio[1].checked)
    {
        if(group=="")
        {
           alert("You must select a group.");
           return false;
        }
        
    }
    else if (radio[2].checked) 
    {
        if (name == "")
        {
           alert("You must enter a last name.");
           return false;
        }
        if (name.length < 2){
            alert("Please make your search more specific.");
          return false;
       }
    }
    return true;
}

/*
    Prompt user to enter a new favor name in favorite page.
*/
function renameFavor(favorpath) 
{
    var name = prompt("Please enter a new name for the favorite link", "");

    if(name == null) {
        window.location = "favorites"; 
    }else if(name == "") {
        alert("You must provide a name.");
        window.location = "favorites"; 
    }else if(! validName(name)) {
        alert("Favorite name can only have letters, numbers, hyphens, and underscores.");
        window.location = "favorites"; 
    } else {
        window.location="favorites?action=rename&resourcePath="+escape(favorpath)+"&name="+escape(name);
    }
}

/*
    Makes sure that name field is not empty in the form.
*/
function validateNameForm(inputField)
{
    var name = inputField.value.toString();
    if (name == "") 
    {
        alert("You must enter a name.");
        return false;
    }
    else if(!validName(name))
    {
       alert("Name can only have letters, numbers, hyphens, and underscores.");
       return false;
    }
    return true;
}


/*
    Valid search user by name, domain, org, and location form when
    adding a credential.
*/
function validateSearchForm(form){
    var name = form.LastName.value.toString();
    var domain = form.Domain.value.toString();
    var org = form.Organization.value.toString();
    var city = form.City.value.toString();
    var state = form.State.value.toString();
    var crit = form.Criteria;
    if (crit[0].checked) {
        if (name == ""){
            alert("You must enter a last name.");
            return false;
        }
        if (name.length < 2){
            alert("Please make your search more precise.");
            return false;
        }
        return true;
    }
    else if (crit[1].checked) {
        if (domain == ""){
            alert("You must select a domain.");
            return false;
        }
        return true;
    }
    else if (crit[2].checked) {
        if (org == ""){
            alert("You must select a university or company.");
            return false;
        }
        return true;
    }
    else if (crit[3].checked) {
        if (city == "" && state == ""){
            alert("You must select either a city or a state.");
            return false;
        }
        return true;
    }
    else { 
        alert("You must select a search criteria.");
        return false; 
    }
}




function validateAddGroupMemberForm(form)
{
    // radio selection
    var CredType = form.CredType;

    var group = form.Group.value.toString();
    var linkedGroup = form.LinkedGroup.value.toString();
    var linkingRole = form.DefinedRole2.value.toString(); 
    
    if(CredType[0].checked) // my group
    {
        if(group == "")
        {
            alert("You must select a group or user. ");
            return false;
        }
    }
    else if(CredType[1].checked) // other's group
    {
        if(linkedGroup == "")
        {
            alert("You must select a group or user. ");
            return false;
        }
        if(linkingRole == "")
        {
            alert("You must the name of a group to link to. ");
            return false;
        }
        
    }
    else
    {
        alert("You must select an option for group member type.");
        return false;
    }

    return true;
}


function validateAddPassForm(form) 
{
	var pass = form.password.value.toString();
	var pass2 = form.password2.value.toString();
	if (pass.length < 6 || pass2.length < 6) 
	{
		alert("Your password must be at least 6 characters.");
		return false;
	}
	if (pass != pass2) 
	{
		alert("Passwords must match.");
		return false;
	}
	return true;
}

/*
    Validate the write message form.
*/
function validateSendMessageForm(form)
{
    var receiver = form.receiver.value.toString();
    var subject = form.subject.value.toString();
    
    if (receiver == ""){
        alert("Whom do you want to sent the message to ? ");
        return false;
    }
    if(subject == "")
    {
        alert("You must enter a subject. ");
        return false;
    }
    return true;
}


/*
    Validate the form to add a new email in Email Manager.
*/
function validateAddEmailForm(addEmailForm) 
{
    var path = addEmailForm.email.value.toString();
    if(path == "") 
    {
        alert("You need to provide an email address.");
        return false;
    }
    else if (path.indexOf("@") < 0) 
    {
        alert("The email address you entered is poorly formatted.");
        return false;
    }
}


function validatePostForm(form)
{
    var subject = form.subject.value.toString();
    
    if(subject == "")
    {
        alert("You must enter a subject. ");
        return false;
    }
   
    return true;
    
}

function validateAddRuleForm(form)
{
   
   var domain = form.domain.value.toString();
   var l_quota = form.quota.value.toString();
   
   if(domain=="")
    {
        alert("You must provide an email address or an email domain");
        return false; 
    }
  
   if(l_quota == "" || l_quota.indexOf(".") > -1 || isNaN(l_quota)) 
   {
       alert("You must an integer for quota.");
       return false;
   }

    return true;    
}
