/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import com.oreilly.servlet.multipart.BufferedServletInputStream;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.LimitedServletInputStream;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class MultipartParser {
    private ServletInputStream in;
    private String boundary;
    private FilePart lastFilePart;
    private byte[] buf = new byte[8192];

    public MultipartParser(HttpServletRequest httpServletRequest, int n) throws IOException {
        this(httpServletRequest, n, true, true);
    }

    public MultipartParser(HttpServletRequest httpServletRequest, int n, boolean bl, boolean bl2) throws IOException {
        String string = null;
        String string2 = httpServletRequest.getHeader("Content-Type");
        String string3 = httpServletRequest.getContentType();
        if (string2 == null && string3 != null) {
            string = string3;
        } else if (string3 == null && string2 != null) {
            string = string2;
        } else if (string2 != null && string3 != null) {
            String string4 = string = string2.length() > string3.length() ? string2 : string3;
        }
        if (string == null || !string.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-dataInstead, it's '" + string + "'");
        }
        int n2 = httpServletRequest.getContentLength();
        if (n2 > n) {
            throw new IOException("Posted content length of " + n2 + " exceeds limit of " + n);
        }
        String string5 = this.extractBoundary(string);
        if (string5 == null) {
            throw new IOException("Separation boundary was not specified");
        }
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        if (bl) {
            servletInputStream = new BufferedServletInputStream(servletInputStream);
        }
        if (bl2) {
            servletInputStream = new LimitedServletInputStream(servletInputStream, n2);
        }
        this.in = servletInputStream;
        this.boundary = string5;
        String string6 = this.readLine();
        if (string6 == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!string6.startsWith(string5)) {
            throw new IOException("Corrupt form data: no leading boundary: " + string6 + " != " + string5);
        }
    }

    public Part readNextPart() throws IOException {
        if (this.lastFilePart != null) {
            this.lastFilePart.getInputStream().close();
            this.lastFilePart = null;
        }
        Vector<String> vector = new Vector<String>();
        String string = this.readLine();
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        vector.addElement(string);
        while ((string = this.readLine()) != null && string.length() > 0) {
            vector.addElement(string);
        }
        if (string == null) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object object = "text/plain";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object2;
            String string5 = (String)enumeration.nextElement();
            if (string5.toLowerCase().startsWith("content-disposition:")) {
                object2 = this.extractDispositionInfo(string5);
                string2 = object2[1];
                string3 = object2[2];
                string4 = object2[3];
                continue;
            }
            if (!string5.toLowerCase().startsWith("content-type:") || (object2 = this.extractContentType(string5)) == null) continue;
            object = object2;
        }
        if (string3 == null) {
            return new ParamPart(string2, this.in, this.boundary);
        }
        if (string3.equals("")) {
            string3 = null;
        }
        this.lastFilePart = new FilePart(string2, this.in, this.boundary, (String)object, string3, string4);
        return this.lastFilePart;
    }

    private String extractBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        if (string2.charAt(0) == '\"') {
            n = string2.lastIndexOf(34);
            string2 = string2.substring(1, n);
        }
        string2 = "--" + string2;
        return string2;
    }

    private String[] extractDispositionInfo(String string) throws IOException {
        String[] stringArray = new String[4];
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string3 = string.substring(n + 21, n2);
        if (!string3.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + string3);
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string4 = string2.substring(n + 6, n2);
        String string5 = null;
        String string6 = null;
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string6 = string5 = string2.substring(n + 10, n2);
            int n3 = Math.max(string5.lastIndexOf(47), string5.lastIndexOf(92));
            if (n3 > -1) {
                string5 = string5.substring(n3 + 1);
            }
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        stringArray[2] = string5;
        stringArray[3] = string6;
        return stringArray;
    }

    private String extractContentType(String string) throws IOException {
        String string2 = null;
        String string3 = string;
        if ((string = string3.toLowerCase()).startsWith("content-type")) {
            int n = string.indexOf(" ");
            if (n == -1) {
                throw new IOException("Content type corrupt: " + string3);
            }
            string2 = string.substring(n + 1);
        } else if (string.length() != 0) {
            throw new IOException("Malformed line after disposition: " + string3);
        }
        return string2;
    }

    private String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            stringBuffer.append(new String(this.buf, 0, n, "ISO-8859-1"));
        } while (n == this.buf.length);
        if (stringBuffer.length() == 0) {
            return null;
        }
        int n2 = stringBuffer.length();
        if (stringBuffer.charAt(n2 - 2) == '\r') {
            stringBuffer.setLength(n2 - 2);
        } else {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }
}

