/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.apps.ColorLine;
import com.stevesoft.pat.apps.ColorText;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class TestGroup
extends Panel {
    Label lab;
    static final Color darkgreen = new Color(0, 119, 0);
    static final Color darkblue = new Color(0, 0, 119);
    static final Color darkred = new Color(119, 0, 0);
    public TextField txt;
    public ColorText ctxt;

    public TestGroup(String string, boolean bl) {
        this.lab = new Label(string);
        this.lab.setAlignment(0);
        this.txt = new TextField();
        this.txt.setEditable(bl);
        this.ctxt = new ColorText();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.lab, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.txt, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.ctxt, gridBagConstraints);
        this.add(this.lab);
        this.add(this.txt);
        this.add(this.ctxt);
    }

    public void ShowError(RegSyntax regSyntax) {
        ColorLine colorLine = new ColorLine();
        colorLine.add(darkred, "RegSyntax: " + regSyntax.getMessage());
        this.ctxt.addColorLine(colorLine);
        this.ctxt.repaint();
    }

    public void ShowFail() {
        ColorLine colorLine = new ColorLine();
        colorLine.add(darkred, "Match failed!");
        this.ctxt.addColorLine(colorLine);
        this.ctxt.repaint();
    }

    public void ShowRes(Regex regex) {
        this.ctxt.clear();
        if (regex.didMatch()) {
            this.ShowSuccess(regex);
        } else {
            this.ShowFail();
        }
    }

    public void ShowSuccess(Regex regex) {
        ColorLine colorLine = new ColorLine();
        colorLine.add(darkgreen, "==>");
        colorLine.add(Color.black, regex.left());
        colorLine.add(darkgreen, "|");
        colorLine.add(darkred, regex.substring());
        colorLine.add(darkgreen, "|");
        colorLine.add(Color.black, regex.right());
        colorLine.add(darkgreen, "<==");
        this.ctxt.addColorLine(colorLine);
        this.ctxt.addColorLine(new ColorLine());
        if (regex.numSubs() > 0) {
            colorLine = new ColorLine();
            colorLine.add(darkblue, "Backreferences:");
            this.ctxt.addColorLine(colorLine);
        }
        int n = 1;
        while (n <= regex.numSubs()) {
            colorLine = new ColorLine();
            colorLine.add(darkblue, "(" + n + ") : ");
            if (regex.left(n) == null) {
                colorLine.add(darkblue, "[null]");
            } else {
                colorLine.add(Color.black, regex.left(n));
                colorLine.add(darkgreen, "|");
                colorLine.add(darkred, regex.substring(n));
                colorLine.add(darkgreen, "|");
                colorLine.add(Color.black, regex.right(n));
            }
            this.ctxt.addColorLine(colorLine);
            ++n;
        }
        this.ctxt.repaint();
    }

    public Object clone() {
        TestGroup testGroup = new TestGroup(this.lab.getText(), this.txt.isEditable());
        testGroup.txt = new TextField();
        testGroup.txt.setText(this.txt.getText());
        testGroup.ctxt = (ColorText)this.ctxt.clone();
        return testGroup;
    }

    public void repaint() {
        this.ctxt.repaint();
    }
}

