/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.apps.ColorLine;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class ColorText
extends Canvas {
    Vector v = new Vector();
    static final int x_margin = 10;
    static final int y_margin = 10;

    public ColorText() {
        this.setBackground(Color.white);
    }

    public void addColorLine(ColorLine colorLine) {
        ColorText colorText = this;
        synchronized (colorText) {
            this.v.addElement(colorLine);
        }
    }

    public void clear() {
        ColorText colorText = this;
        synchronized (colorText) {
            this.v = new Vector();
            this.repaint();
        }
    }

    public Object clone() {
        ColorText colorText = new ColorText();
        colorText.v = (Vector)this.v.clone();
        return colorText;
    }

    final void drawColorLine(Graphics graphics, FontMetrics fontMetrics, ColorLine colorLine, int n) {
        int n2 = 10;
        int n3 = fontMetrics.getAscent() + n * fontMetrics.getHeight() + 10;
        int n4 = 0;
        while (n4 < colorLine.v.size()) {
            Object e = colorLine.v.elementAt(n4);
            if (e instanceof Color) {
                graphics.setColor((Color)e);
            } else {
                graphics.drawString((String)e, n2, n3);
                n2 += fontMetrics.stringWidth((String)e);
            }
            ++n4;
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Object object;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return new Dimension(0, 0);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.v.size()) {
            object = (ColorLine)this.v.elementAt(n3);
            Dimension dimension = ((ColorLine)object).getSize(fontMetrics);
            n2 += dimension.height;
            n = n > dimension.width ? n : dimension.width;
            ++n3;
        }
        object = new Dimension(n, n2 += fontMetrics.getAscent());
        return object;
    }

    public void paint(Graphics graphics) {
        ColorText colorText = this;
        synchronized (colorText) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (fontMetrics == null) {
                Object var3_4 = null;
                return;
            }
            Rectangle rectangle = graphics.getClipRect();
            int n = rectangle.y;
            int n2 = rectangle.y + rectangle.height;
            int n3 = (n2 - 10 - fontMetrics.getAscent()) / fontMetrics.getHeight() + 2;
            int n4 = (n - 10 - fontMetrics.getAscent()) / fontMetrics.getHeight() - 2;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 > this.v.size()) {
                n3 = this.v.size();
            }
            int n5 = n4;
            while (n5 < n3) {
                this.drawColorLine(graphics, fontMetrics, (ColorLine)this.v.elementAt(n5), n5);
                ++n5;
            }
            graphics.setColor(Color.lightGray);
            graphics.drawRect(1, 1, this.size().width - 2, this.size().height - 2);
        }
    }
}

