/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Replacer;
import com.stevesoft.pat.StringLike;
import com.stevesoft.pat.TransPat;
import com.stevesoft.pat.TransRepRule;
import com.stevesoft.pat.wrap.StringWrap;

public class Transformer {
    TransPat tp;
    Regex rp = new Regex();
    boolean auto_optimize;
    Replacer repr = new Replacer();

    public Transformer(boolean bl) {
        this.auto_optimize = bl;
        this.tp = new TransPat();
        this.rp.setReplaceRule(new TransRepRule(this));
        this.rp.thePattern = this.tp;
    }

    public void add(Regex regex) {
        if (this.auto_optimize) {
            regex.optimize();
        }
        this.tp.ra[this.tp.ra_len++] = regex;
        if (this.tp.ra.length == this.tp.ra_len) {
            Regex[] regexArray = new Regex[this.tp.ra_len + 10];
            int n = 0;
            while (n < this.tp.ra_len) {
                regexArray[n] = this.tp.ra[n];
                ++n;
            }
            this.tp.ra = regexArray;
        }
        this.rp.numSubs_ = regex.numSubs_ > this.rp.numSubs_ ? regex.numSubs_ : this.rp.numSubs_;
    }

    public void add(String string) {
        Regex regex = Regex.perlCode(string);
        if (regex == null) {
            throw new NullPointerException("bad pattern to Regex.perlCode: " + string);
        }
        this.add(regex);
    }

    public void add(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n]);
            ++n;
        }
    }

    final StringLike dorep(StringLike stringLike, int n, int n2) {
        StringLike stringLike2 = this.repr.replaceAllRegion(stringLike, this.rp, n, n2);
        this.tp.lastMatchedTo = this.repr.lastMatchedTo;
        return stringLike2;
    }

    final String dorep(String string, int n, int n2) {
        return this.dorep(new StringWrap(string), n, n2).toString();
    }

    public Regex getRegexAt(int n) {
        if (n >= this.tp.ra_len) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + ">=" + this.patterns());
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + "< 0");
        }
        return this.tp.ra[n];
    }

    public Replacer getReplacer() {
        return this.rp.getReplacer();
    }

    public int patterns() {
        return this.tp.ra_len;
    }

    public StringLike replaceAll(StringLike stringLike) {
        return this.dorep(stringLike, 0, stringLike.length());
    }

    public String replaceAll(String string) {
        return this.dorep(string, 0, string.length());
    }

    public String replaceAllFrom(String string, int n) {
        return this.dorep(string, n, string.length());
    }

    public String replaceAllRegion(String string, int n, int n2) {
        return this.dorep(string, n, n2);
    }

    public String replaceFirst(String string) {
        return this.dorep(string, 0, string.length());
    }

    public String replaceFirstFrom(String string, int n) {
        return this.dorep(string, n, string.length());
    }

    public String replaceFirstRegion(String string, int n, int n2) {
        return this.dorep(string, n, n2);
    }

    public void setRegexAt(Regex regex, int n) {
        if (n >= this.tp.ra_len) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + ">=" + this.patterns());
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("i=" + n + "< 0");
        }
        this.tp.ra[n] = regex;
    }
}

