/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.PartialBuffer;
import com.stevesoft.pat.RBuffer;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Replacer;
import com.stevesoft.pat.StringBufferLike;
import com.stevesoft.pat.StringLike;
import com.stevesoft.pat.Transformer;
import com.stevesoft.pat.wrap.StringBufferWrap;
import java.io.IOException;
import java.io.Reader;

public class RegexReader
extends Reader {
    RBuffer rb = new RBuffer(new StringBuffer());
    PartialBuffer wrap;
    boolean moreToRead;
    Reader r;
    Replacer rp;
    int nmax;
    int max_lines;
    char EOLchar;

    public RegexReader(Regex regex, Reader reader) {
        this.wrap = new PartialBuffer(this.rb.sb);
        this.moreToRead = true;
        this.nmax = 2048;
        this.max_lines = 2;
        this.EOLchar = (char)10;
        this.r = reader;
        this.rp = regex.getReplacer();
    }

    public RegexReader(Transformer transformer, Reader reader) {
        this.wrap = new PartialBuffer(this.rb.sb);
        this.moreToRead = true;
        this.nmax = 2048;
        this.max_lines = 2;
        this.EOLchar = (char)10;
        this.r = reader;
        this.rp = transformer.getReplacer();
    }

    public void close() throws IOException {
        this.r.close();
    }

    public int getBufferSize() {
        return this.nmax;
    }

    public char getEOLchar() {
        return this.EOLchar;
    }

    public int getMaxLines() {
        return this.max_lines;
    }

    void getMoreData() throws IOException {
        while (this.rb.pos >= this.rb.epos) {
            this.wrap.overRun = false;
            if (this.rb.next != null) {
                this.rb = this.rb.next;
                continue;
            }
            if (this.rb.done) break;
            if (this.rb.epos >= this.rb.sb.length() && this.rb.epos > this.nmax) {
                this.rb.pos = 1;
                this.rb.epos = 1;
                this.rb.sb.setLength(1);
                this.readData();
                continue;
            }
            if (this.rb.epos >= this.rb.sb.length() && this.moreToRead) {
                this.readData();
                continue;
            }
            if (this.rp.getRegex().matchAt((StringLike)this.wrap, this.rb.epos)) {
                if (this.wrap.overRun) {
                    this.readData();
                    continue;
                }
                StringBufferWrap stringBufferWrap = new StringBufferWrap();
                StringBufferLike stringBufferLike = new StringBufferLike(stringBufferWrap);
                Regex regex = this.rp.getRegex();
                int n = regex.matchedTo();
                this.rp.setBuffer(stringBufferLike);
                this.rp.setSource((StringLike)this.wrap);
                this.rp.setPos(n);
                this.rp.apply(regex, regex.getReplaceRule());
                int n2 = this.rb.epos;
                RBuffer rBuffer = new RBuffer((StringBuffer)stringBufferWrap.unwrap());
                rBuffer.epos = rBuffer.sb.length();
                RBuffer rBuffer2 = new RBuffer(this.rb.sb);
                this.rb.next = rBuffer;
                rBuffer.next = rBuffer2;
                if (n == n2) {
                    rBuffer2.epos = n + 1;
                    if (rBuffer2.epos > rBuffer2.sb.length()) {
                        if (this.rb.pos >= this.rb.epos) {
                            this.rb = this.rb.next;
                        }
                        rBuffer2.epos = 0;
                        rBuffer2.pos = 0;
                        rBuffer2.done = true;
                    }
                    rBuffer2.pos = n;
                    continue;
                }
                rBuffer2.pos = rBuffer2.epos = n;
                continue;
            }
            if (this.wrap.overRun) {
                this.readData();
                continue;
            }
            if (this.rb.epos >= this.rb.sb.length()) break;
            ++this.rb.epos;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.rb.pos >= this.rb.epos) {
            this.getMoreData();
            if (this.rb.pos >= this.rb.epos) {
                return -1;
            }
        }
        return this.rb.sb.charAt(this.rb.pos++);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = -1;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            n3 = this.read();
            if (n3 < 0) {
                return n5 - n;
            }
            cArray[n5] = (char)n3;
            ++n5;
        }
        return n2;
    }

    void readData() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.r.read()) != -1) {
            this.rb.sb.append((char)n);
            if (n2++ > this.nmax) break;
        }
        if (n == -1 && n2 == 0) {
            this.moreToRead = false;
            this.wrap.allowOverRun = false;
        }
    }

    public void reset() throws IOException {
        this.r.reset();
        this.rb = new RBuffer(new StringBuffer());
        this.wrap = new PartialBuffer(this.rb.sb);
        this.moreToRead = true;
    }

    public void setBufferSize(int n) {
        this.nmax = n;
    }

    public void setEOLchar(char c) {
        this.EOLchar = c;
    }

    public void setMaxLines(int n) {
        this.max_lines = n;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l && this.read() != -1) {
            ++l2;
        }
        return l2;
    }
}

