/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.End;
import com.stevesoft.pat.Pattern;
import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Skipped;
import com.stevesoft.pat.StrPos;
import com.stevesoft.pat.oneChar;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileRegex
extends Regex {
    int dirflag = 0;
    static final int EITHER = 0;
    static final int DIR = 1;
    static final int NONDIR = 2;
    static final Regex root = new Regex(File.separatorChar == '/' ? "/$" : "(?:.:|)\\\\$");

    public FileRegex() {
    }

    public FileRegex(String string) {
        super(string);
    }

    public boolean accept(File file, String string) {
        if (this.dirflag != 0) {
            File file2 = new File(string);
            if (file2.isDirectory() && this.dirflag == 2) {
                return false;
            }
            if (!file2.isDirectory() && this.dirflag == 1) {
                return false;
            }
        }
        return this.matchAt(string, 0);
    }

    public void compile(String string) throws RegSyntax {
        String string2 = FileRegex.toFileRegex(string);
        super.compile(string2);
        if (File.separatorChar == '\\') {
            this.ignoreCase = true;
        }
    }

    public boolean isLiteral() {
        Pattern pattern = this.thePattern;
        while (pattern != null && !(pattern instanceof End)) {
            if (!(pattern instanceof oneChar) && !(pattern instanceof Skipped)) {
                return false;
            }
            pattern = pattern.next;
        }
        return true;
    }

    public static String[] list(String string) {
        return FileRegex.list(string, 0);
    }

    static String[] list(String string, int n) {
        Object[] objectArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        Vector vector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            FileRegex.list1((String)objectArray, vector, n, true);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void list1(String string, Vector vector, int n, boolean bl) {
        if (root.matchAt(string, 0)) {
            vector.addElement(String.valueOf(string) + ".");
            return;
        }
        File file = new File(string);
        if (file.getParent() != null && bl) {
            Vector vector2 = new Vector();
            FileRegex.list1(file.getParent(), vector2, 1, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                String string2 = String.valueOf((String)vector2.elementAt(n2)) + File.separator + file.getName();
                FileRegex.list1(string2, vector, n, false);
                ++n2;
            }
        } else {
            File file2 = new File(string);
            String string3 = file2.getParent();
            if (string3 == null) {
                string3 = ".";
            }
            File file3 = new File(string3);
            FileRegex fileRegex = new FileRegex(file2.getName());
            if (fileRegex.isLiteral()) {
                vector.addElement(String.valueOf(string3) + File.separator + file2.getName());
                return;
            }
            fileRegex.dirflag = n;
            String[] stringArray = file3.list(fileRegex);
            if (stringArray == null) {
                return;
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                vector.addElement(String.valueOf(string3) + File.separator + stringArray[n3]);
                ++n3;
            }
        }
    }

    public static String toFileRegex(String string) {
        int n;
        StrPos strPos = new StrPos(string, 0);
        StringBuffer stringBuffer = new StringBuffer();
        if (strPos.incMatch("{?e=")) {
            n = strPos.thisChar();
            strPos.inc();
            if (strPos.incMatch("}")) {
                stringBuffer.append("(?e=" + (char)n + ")^");
            } else {
                stringBuffer.append("^(?e=");
            }
            strPos.esc = n;
        }
        n = 0;
        while (!strPos.eos()) {
            if (File.separatorChar == '\\') {
                if (strPos.escaped()) {
                    stringBuffer.append("\\\\");
                }
                strPos.dontMatch = false;
            }
            if (strPos.incMatch("?")) {
                stringBuffer.append(".");
                continue;
            }
            if (strPos.incMatch(".")) {
                stringBuffer.append(strPos.esc);
                stringBuffer.append('.');
                continue;
            }
            if (strPos.incMatch("{??")) {
                stringBuffer.append("(??");
                ++n;
                continue;
            }
            if (strPos.incMatch("{?!")) {
                stringBuffer.append("(?!");
                ++n;
                continue;
            }
            if (strPos.incMatch("{?=")) {
                stringBuffer.append("(?=");
                ++n;
                continue;
            }
            if (strPos.incMatch("{")) {
                stringBuffer.append("(?:");
                ++n;
                continue;
            }
            if (strPos.incMatch("}")) {
                stringBuffer.append(')');
                --n;
                continue;
            }
            if (n != 0 && strPos.incMatch(",")) {
                stringBuffer.append('|');
                continue;
            }
            if (strPos.incMatch("*")) {
                stringBuffer.append(".*");
                continue;
            }
            stringBuffer.append(strPos.thisChar());
            strPos.inc();
        }
        stringBuffer.append("$");
        return stringBuffer.toString();
    }
}

