package userapp;

import java.util.*;
import java.io.*;
import java.net.*;
import java.security.*;
import jini.*;

public class Tester //implements Runnable 
{  
 	  private static boolean weAreDebugging = false;
	  private static void debug( String text )
	  {
				if (weAreDebugging)
						System.out.println( text );
		}

		static {    debug ("Tester Loaded");  }

		public Tester () {    debug ("Tester Created");  }

		public void run() 
		{  
				System.setSecurityManager( new SecurityManager() );
				
				SecurityManager sm = System.getSecurityManager();
				/* 
					 The problem is that all of the RMI loading is handled in 
					 LoaderHandler.loadClass(url[], string, classloader) which checks
					 if there is a security manager installed, and if not, it gives up.
				*/
				if (sm == null) { 
						System.out.println("!!!We need a security manager otherwise none of the RMI calls will work.");
						System.exit(-1);
				}
				

				debug ("Tester App Running");  

				// all of the classes used below are from the jini package
				LookupLocator ll = new LookupLocator("jini://jini.stanford.edu");

				try {

				ServiceRegistrar reg = ll.getRegistrar();

				Object service = reg.lookup("lalaland.PrinterServiceImpl");
				System.out.println();
				System.out.println( "User app obtained the printer service. Using it ..." );
				System.out.println();
				((PrinterService) service).print("User text to be printed.");

				service = reg.lookup("lalaland.VendingMachineProxy");
				System.out.println();
				System.out.println( "User app obtained the bad vending machine service. Using it ..." );
				System.out.println();
				((VendingMachine) service).queryBalance();

				} catch( Exception e ) {
						e.printStackTrace( System.out );
				}

				debug ("Tester App Finished");  
		}

		public static void main (String args[]) throws Exception 
		{
				debug( "Main in Tester App" );
				new Tester().run();
		}
}



    
