package netserver;

import java.net.*;
import java.io.*;
import java.util.*;

public class LookupServer extends Thread
{
		private static boolean weAreDebugging = true;
		private static void debug( String text )
		{
				if (weAreDebugging)
						System.out.println( text );
		}


		int port = -1;
		private boolean keepOnRunning = true;

		public LookupServer(int port) {
				this.port = port;
		}


		
		public void kill() 
		{
				keepOnRunning = false;
		}
		

	public void startServing() 
	{
			ServerSocket serv = null;
			Socket client = null;
			
			try {
					serv = new ServerSocket( port );
			} catch (Exception e) {
					e.printStackTrace( System.out );
			}
			
			
			System.out.println( "listening on " + 
													serv.getInetAddress() + " on port " + 
													serv.getLocalPort() );
			while( keepOnRunning ) {
					try {
							client = serv.accept();
							String filename = null;
							
							LineNumberReader inr = new LineNumberReader
									(  	new InputStreamReader( client.getInputStream() ) );
			
							while(true) {
									String str = inr.readLine();
									if (str == null || str.equals( "" ) ) {
											//client.close();
											break;
									}
									if ( str.startsWith("GET ") )
											filename = 
													str.substring( str.indexOf('/')+1, str.lastIndexOf(' ') ).trim();
									System.out.println( str );
									//lines.add( str );
							}
							System.out.println( );

							sendFile( client, filename );
							client.close();

							System.out.println( );
					
					} catch (Exception e) {
							e.printStackTrace( System.out );
					}
			}
	}

		public void sendFile( Socket client, String name ) throws IOException
		{
				if ( name.endsWith(".class") ) {
						ByteArrayOutputStream bos = getClassBytes( name ); 
						bos.writeTo( client.getOutputStream() );

						debug( "read and sent " + bos.size() + " bytes." );
						debug( "" );
						
						bos.close();    
				}

				else if ( name.endsWith(".object") ) {

						name = name.replace( '/', '.' );
						name = name.substring( 0, name.lastIndexOf('.') );

						debug( "server attempts to make object of class " + name ); 
						try {
								//Class cl = loader.loadClass( name );
								Class cl = Class.forName( name );
								Object obj = cl.newInstance();

								//debug( "in server -- making a MarshalledObject ");
						java.rmi.MarshalledObject mars = new java.rmi.MarshalledObject ( obj );
						
						 ObjectOutputStream outobj = 
								 new ObjectOutputStream( client.getOutputStream() );
						 outobj.writeObject( mars );
						 outobj.flush();
						 outobj.close();
						} catch (Exception e) { e.printStackTrace(); throw new IOException();}
				}
				else {
						throw new IOException( "Unexpected request: " + name );
				}
						
		}

		private ByteArrayOutputStream getClassBytes( String name ) 
				throws IOException
		{
				//FileInputStream ins = new FileInputStream( name );
				InputStream ins = ClassLoader.getSystemResourceAsStream( name ); 

				if ( ins == null ) {
						debug( "Could not find " + name + " in sendFile");
						throw new IOException("Could not find " + name + " in sendFile");
				}
				debug("We found " + name +".");
				
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				byte buff[] = new byte[1000];
				
				while( true ) {
						int r = 0;	
						r = ins.read( buff );
						if ( r == -1 )
								break;
						bos.write( buff, 0, r );
				}
				ins.close();
				return bos;
		}

		public void run() 
		{
				System.out.println( "the server started serving");
				startServing();
				System.out.println( "the server ended serving");
		}

		public static void main( String args[] ) 
		{
				LookupServer server = new LookupServer( 10005 );
				server.start();
		}				
}				
				
				
/*
						// this loader is no longer needed
						// but wanted to keep the code in case
						// i need it in the future

						ClassLoader loader = new ClassLoader () {
										protected Class findClass(String name)
												throws ClassNotFoundException					{
												String filename = 
														"net/" + name.replace( '.', '/' ) + ".class";
												InputStream ins = getResourceAsStream( filename );
												if ( ins == null ) {
														debug( "Could not find " + filename );
														throw new ClassNotFoundException("server trouble");
												}
												
												//debug("We found " + name +".");
												
												ByteArrayOutputStream baos = new ByteArrayOutputStream();
												byte buff[] = new byte[100];
												byte resultBuff[] = null;

												try { 
												while( true ) {
														int r = 0;	
														r = ins.read( buff );
														if ( r == -1 )
																break;
														baos.write( buff, 0, r );
												}

												resultBuff = baos.toByteArray();
												
												ins.close();
												baos.close();    
												} catch (Exception e) { e.printStackTrace(); }
												
												return defineClass( name, resultBuff, 0, resultBuff.length );	 
										}};

*/
