package lalaland;

import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.*;

public class ServiceRegistrarImpl implements jini.ServiceRegistrar {

 	private static boolean weAreDebugging = true;
	private static void debug( String text )
	{
			if (weAreDebugging)
					System.out.println( text );
	}

  public ServiceRegistrarImpl ()
  {
    System.out.println( "Created a new ServiceRegistrar");
  }

  public Object oldlookup()
  {
    try {
     System.out.println("The ServiceRegistrar is doing a lookup to get a service object...");

		 URL [] codebase = new URL [1];
		 codebase[0] = new URL( "http://csroam31.stanford.edu:10005/" );	 
     //codebase[0] = new URL( "file://localhost/D:/jinifilter_project/" );

		 /*
			 the MethodFilter screws up this one... thinks that loadClass() is from RMIClassLoader
			 //URLClassLoader ldr = new URLClassLoader( codebase ); 
			 //Class cl = ldr.loadClass( "lalaland.PrinterServiceImpl" );
		 */
		 
     URLClassLoader ldr = new URLClassLoader( codebase ); 
     Class cl = ldr.loadClass( "lalaland.PrinterServiceImpl" );
		 
		 //Class cl = java.rmi.server.RMIClassLoader.loadClass( codebase[0], "lalaland.PrinterServiceImpl" );
		 debug("class " + cl + " was loaded successfully by " + cl.getClassLoader() );
		 		 
		 
 		 // try to fake an RMI call passing an object over the net
		 System.out.println( "The ServiceRegistrar is faking an RMI call passing an object over the net...");
		 Object s = cl.newInstance(); 
		 //System.out.println( "==> " + java.rmi.server.RMIClassLoader.getClassAnnotation( cl ) );
		 debug( "\n\nMaking a MarshalledObject from the service object...\n\n" );
		 java.rmi.MarshalledObject mars = new java.rmi.MarshalledObject ( s );
		 debug( "\n\nMaking a service object from the MarshalledObject...\n\n" );
		 s = mars.get();
		 return s;
		 
     //System.out.println( "the urlclassloader parent is " + loader.getParent() );
     //System.out.println( "the safeclassloader parent is " + this.getClass().getClassLoader().getParent() );
		 
     //return cl.newInstance();
		 
    } catch (Exception e) {
				e.printStackTrace( System.out );
        return null;
    }
  }

  public Object lookup(String name)
  {
    try {
     System.out.println("The ServiceRegistrar is doing a lookup to get a " + name + " ..." );

		 URL codebase = new URL( "http://localhost:10005/" + name + ".object" );

		 ObjectInputStream inobj = new ObjectInputStream( codebase.openStream() );
		 MarshalledObject mars = (MarshalledObject) inobj.readObject();

		 Object obj = mars.get();
		 debug( obj + " was loaded successfully by " + obj.getClass().getClassLoader() );
		 return obj;
		 
    } catch (Exception e) {
				e.printStackTrace( System.out );
        return null;
    }
  }

}
