package jinifilter;

import java.io.*;
import java.net.*;
//import java.rmi.server.RMIClassLoader;
import java.util.*;

import jinifilter.SafeURLClassLoader;
import jinifilter.SafeClassLoader;

/*
  
* sun.rmi.server.LoaderHandler implements all the static calls in
  RMIClassLoader and also in java.rmi.MarshalledObject (which subclasses
  its input stream from sun.rmi.server.MarshalInputStream which is a 
  subclass of java.io.ObjectInputStream, overriding resolveClass(),
  which uses LoaderHandler.loadClass(ulr, name) to load the class ).
  Now the interesting part is that the LoaderHandler uses a private class
  Loader ( sun.rmi.server.LoaderHandler$Loader ) which is a subclass of 
  URLClassLoader without overriding findClass(). So, all of the RMIClasLOader
  situation should be resolved (even if we don't go for redirecting all
  ClassLoader.defineClass() ) simply by changing URLClassLoader refs to 
  SafeURLClassLoader. This way we are also saving ourselves the trouble
	chasing down to replace the sun.rmi.server.LoaderHandler...

*/

public class SafeRMIClassLoader //extends RMIClassLoader
{  

   public static Class loadClass(URL codebase, String name)
                       throws MalformedURLException, ClassNotFoundException 
  {
    System.out.println( name +" in SafeRMIClassLoader.loadClass(url, string)");

    URL [] urls = new URL [ 1 ];
    urls[ 0 ] = codebase;    
    SafeURLClassLoader loader = new SafeURLClassLoader( urls );
    return loader.loadClass( name );
  }




  public static Class loadClass(String codebase, String name)
                       throws MalformedURLException, ClassNotFoundException 
  {
    System.out.println( name +" in SafeRMIClassLoader.loadClass(string, string)");

    StringTokenizer cbt = new StringTokenizer( codebase );
    URL [] urls = new URL [ cbt.countTokens() ];
    for ( int i = 0; cbt.hasMoreTokens() ; i++) {         
	urls[ i ] = new URL( cbt.nextToken() );     
    }
    SafeURLClassLoader loader = new SafeURLClassLoader( urls );
    return loader.loadClass( name );
  }



  public static Class loadClass(String name)
                       throws MalformedURLException, ClassNotFoundException
  { 
    System.out.println( name +" in SafeRMIClassLoader.loadClass(string)");

    SafeClassLoader loader = new SafeClassLoader();
    return loader.loadClass( name );
  }

}
