package jinifilter;

import java.lang.reflect.*;


/* 
	 MainRunnable is a class that will run in its own thread,
	 loading the target class in a transparent way -- so that the application 
	 developer does not need to write wrapper classes like
	 Tester but instead can just make a class with a main() and we'll take 
	 care of the rest ...
	 There is one technical problem, though. In Java2 ver 1.2.2, I cannot
	 find a way to fully distinguish methods by their signatures or by
	 them being a 'member' or a 'static' method. So... I know, it's not
	 a big deal.
*/

class JiniFilter extends Thread
{
		private String className = null;
		private String[] params = null;
		
		public JiniFilter( String [] args ) 
		{ 
				className = args[0];
				params = new String [ args.length ];
				
				// move the args with 1 to the left since args[0] was used for 
				// the main app name
				for ( int i=1; i < args.length; i++ )
						params[i-1] = args[i];
				params[ params.length - 1 ] = null; // the last element is null
		}
		
		public void run() 
		{
				try {
						
						ClassLoader loader = //this.getClass().getClassLoader();
								Thread.currentThread().getContextClassLoader();
						Class mainClass = loader.loadClass( className );
						Class[] paramClasses = 
								new Class[] { (new String[1]).getClass() };
						if ( paramClasses[0] == null )
								System.out.println("paramClasses[0] is null");
						
						Method mainMethod = 
								mainClass.getDeclaredMethod( "main", paramClasses );
						
						if ( mainMethod == null ) 
								throw new RuntimeException("Cannot find 'main' in " + className);
						mainMethod.invoke( null, params );
				} catch ( Exception e ) {
						e.printStackTrace( System.out );
				}
		}

		public static void main (String args[]) throws Exception 
		{
				/* the following paragraph is needed only for demo purposes
					 this starts a local http server which delivers classs
					 files from the net/ directory
					 it can be extended to deliver service objects also...
				*
				System.out.println( "Starting the lookup server thread...");
				net.LookupServer server = new net.LookupServer( 10005 );
				server.setDaemon(true); 
				server.start();
				Thread.sleep( 20 * 1000 ); // to give time to the server to start...
				// end demo paragraph
				*/

				System.out.println( "Starting " + args[0] + " ...");
				
				SafeClassLoader loader = new SafeClassLoader();
				
				/*
				Class c = loader.loadClass (args[0]);    
				Object cTester = c.newInstance();
				//((Runnable) cTester).run();
				Thread th = new Thread( (Runnable) cTester );
				th.setContextClassLoader( loader );
				th.start(); 
				*/

				JiniFilter mainApp = new JiniFilter( args );
				mainApp.setContextClassLoader( loader );
				mainApp.start(); 
		}


}
