package de.fub.bytecode.generic;

/** 
 * ASTORE - Store reference into local variable
 * <PRE>Stack ..., objectref -&gt; ... </PRE>
 *
 * @version $Id: ASTORE.java,v 1.4 2000/04/19 08:47:01 dahm Exp $
 * @author  <A HREF="http://www.inf.fu-berlin.de/~dahm">M. Dahm</A>
 */
public class ASTORE extends LocalVariableInstruction {
  /**
   * Empty constructor needed for the Class.newInstance() statement in
   * Instruction.readInstruction(). Not to be used otherwise.
   */
  ASTORE() {
    super(ASTORE, ASTORE_0);
  }

  /** Store reference into local variable
   * @param n index of local variable
   */
  public ASTORE(int n) {
    super(ASTORE, ASTORE_0, n);
  }
}

