#!/bin/bash

exit_on_error()
{
  if [ $? -ne 0 ] ; then
    exit 1
  fi
}

#if [ $# -ne 1 ] ; then
#  echo "$0: wrong number of arguments" >&2
#  echo "  Usage: $0 <request identificator>" >&2
#  exit 1
#fi

cd c:/cygwin/

SSL="c:/OpenSA/OpenSSL/bin"
SESSIONID="$1"
DIR="c:/cygwin/tmp/cert/$SESSIONID"
CERT="$2"
EXPR="$3"

#   make sure environment exists
#if [ ! -d ca.db.certs ]; then
#    mkdir ca.db.certs
#fi
#if [ ! -f ca.db.serial ]; then
#    echo '01' >ca.db.serial
#fi
#if [ ! -f ca.db.index ]; then
#   cp /dev/null ca.db.index
#fi

#  create the CA requirement to sign the cert
c:/cygwin/bin/cat >ca.config <<EOT
[ ca ]
default_ca              = default_CA
[ default_CA ]
dir                     = .
certs                   = \$dir
new_certs_dir           = \$dir/ca.db.certs
database                = \$dir/ca.db.index
serial                  = \$dir/ca.db.serial
RANDFILE                = \$dir/random-bits
certificate             = \$dir/ca.crt
private_key             = \$dir/ca.key
default_days            = 365
default_crl_days        = 30
default_md              = md5
preserve                = yes
x509_extensions		= user_cert
policy                  = policy_anything
[ policy_anything ]
commonName              = supplied
emailAddress            = supplied
countryName            	= optional 
stateOrProvinceName   	= optional 
localityName         	= optional 
organizationName     	= optional 
organizationalUnitName	= optional

[ user_cert ]
#SXNetID		= 3:yeak
subjectAltName		= email:copy
basicConstraints	= critical,CA:false
authorityKeyIdentifier	= keyid:always
extendedKeyUsage	= clientAuth,emailProtection
EOT


if grep SPKAC $DIR/req.raw 1> /dev/null 2>&1 ; then
#
#     Netscape stuff
#
#
#  sign the certificate
#


$SSL/openssl ca -enddate $EXPR -key password -spkac $DIR/req.raw \
   -config ca.config \
   -out c:/OpenSA/Apache/htdocs/$CERT.cert
exit_on_error

else
#
#      MSIE stuff
#

#
#       convert the certificate request from DER format to PEM
#

$SSL/openssl base64 -d < $DIR/req | $SSL/openssl req -inform der -text > $DIR/req.pem
exit_on_error

#
#       sign certificate
#

$SSL/openssl ca -enddate $EXPR -key password -batch -gencrl -policy policy_anything \
   -config ca.config \
   -out $DIR/cert.signed \
   -infiles $DIR/req.pem
exit_on_error

$SSL/openssl crl2pkcs7 -certfile $DIR/cert.signed \
   -in $DIR/cert.signed -out $DIR/cert._pkcs7
exit_on_error

#
#       Take out the base64 encoded PKCS#7 signed certificate
#

c:/Perl/bin/perl -ne '$a=/BEGIN /../END /;print if($a>1 && $a!~/E0/);' \
     $DIR/cert._pkcs7 > $DIR/cert.pkcs7

#
#       Build HTML page with VBS code to download the certificate to MSIE
#


(
               c:/cygwin/bin/cat << EOF1=================================================
<HTML>
<HEAD>
<TITLE>Downloading your Signed certificate</TITLE>
</HEAD>

<BODY LANGUAGE="VBScript" ONLOAD="InstallCert">

<OBJECT CLASSID="clsid:127698e4-e730-4e5c-a2b1-21490a70c8a1"
        CODEBASE="/xenroll.cab#Version=5,131,3659,0"
        ID=Enroll>
</OBJECT>

<SCRIPT LANGUAGE="VBSCRIPT">
Sub InstallCert

  'On Error Resume Next

  credentials = "" & _
EOF1=================================================
               c:/Perl/bin/perl -npe 's/^/        "/;s/$/" & _/;' $DIR/cert.pkcs7
               c:/cygwin/bin/cat <<EOF2=================================================
        ""
  Call Enroll.AcceptPKCS7(credentials)

  html = "" & _
"<H1>Certificate download status</H1>"            & chr(13) & chr(10)

  If err.Number <> 0 Then

    html = html & _
"There were problems downloading"                 & chr(13) & chr(10) & _
"your signed certificate to your browser."        & chr(13) & chr(10) & _
"<P>"                                             & chr(13) & chr(10) & _
"The error code is: 0x" & Hex(err)                & chr(13) & chr(10)

  else

    html = html & _
"Your signed certificate has been downloaded"     & chr(13) & chr(10) & _
"successfully to your browser."                   & chr(13) & chr(10)

  End if

  document.write(html)

End sub
</SCRIPT>

</BODY>
</HTML>
EOF2=================================================
) \
               > c:/OpenSA/Apache/htdocs/$CERT.html


fi

exit 0