
C  WIZARDRY ROUTINES (START, MAINT, WIZCHK, HOURS(X), NEWHRS(X), MOTD, POOF, GRIPE, GSPEAK)


	LOGICAL FUNCTION START(DUMMY)

C  CHECK TO SEE IF THIS IS "PRIME TIME".  IF SO, ONLY WIZARDS MAY PLAY, THOUGH
C  OTHERS MAY BE ALLOWED A SHORT GAME FOR DEMONSTRATION PURPOSES.  IF SETUP<0,
C  WE'RE CONTINUING FROM A SAVED GAME, SO CHECK FOR SUITABLE LATENCY.  RETURN
C  TRUE IF THIS IS A DEMO GAME (VALUE IS IGNORED FOR RESTARTS).

	IMPLICIT INTEGER (A-Z)
	LOGICAL PTIME,SOON,YESM,WIZARD
	DIMENSION HNAME(4)
#include "ttycom.h"
#include "wizcom.h"

C  FIRST FIND OUT WHETHER IT IS PRIME TIME (SAVE IN PTIME) AND, IF RESTARTING,
C  WHETHER IT'S TOO SOON (SAVE IN SOON).  PRIME-TIME SPECS ARE IN WKDAY, WKEND,
C  AND HOLID; SEE MAINT ROUTINE FOR DETAILS.  LATNCY IS REQUIRED DELAY BEFORE
C  RESTARTING.  WIZARDS MAY CUT THIS TO A THIRD.

	CALL DATIME(D,T)
	PRIMTM=WKDAY
	IF(MOD(D,7).LE.1)PRIMTM=WKEND
	IF(D.GE.HBEGIN.AND.D.LE.HEND)PRIMTM=HOLID
	PTIME=(PRIMTM.AND.SHIFT(1,T/60)).NE.0
	SOON=.FALSE.
	IF(SETUP.GE.0)GOTO 20
	DELAY=(D-SAVED)*1440+(T-SAVET)
	IF(DELAY.GE.LATNCY)GOTO 20
	WRITE(TTYOUT,10),DELAY
10	FORMAT(' This adventure was suspended a mere',I3,' minutes ago.')
	SOON=.TRUE.
	IF(DELAY.GE.LATNCY/3)GOTO 20
	CALL MSPEAK(2)
	STOP

C  IF NEITHER TOO SOON NOR PRIME TIME, NO PROBLEM.  ELSE SPECIFY WHAT'S WRONG.

20	START=.FALSE.
	IF(SOON)GOTO 30
	IF(PTIME)GOTO 25
22	SAVED=-1
	RETURN

C  COME HERE IF NOT RESTARTING TOO SOON (MAYBE NOT RESTARTING AT ALL), BUT IT'S
C  PRIME TIME.  GIVE OUR HOURS AND SEE IF HE'S A WIZARD.  IF NOT, THEN CAN'T
C  RESTART, BUT IF JUST BEGINNING THEN WE CAN OFFER A SHORT GAME.

25	CALL MSPEAK(3)
	CALL HOURS
	CALL MSPEAK(4)
	IF(WIZCHK(0))GOTO 22
	IF(SETUP.LT.0)GOTO 33
	START=YESM(5,7,7)
	IF(START)GOTO 22
	STOP 

C  COME HERE IF RESTARTING TOO SOON.  IF HE'S A WIZARD, LET HIM GO (AND NOTE
C  THAT IT THEN DOESN'T MATTER WHETHER IT'S PRIME TIME).  ELSE, TOUGH BEANS.

30	CALL MSPEAK(8)
	IF(WIZCHK(0))GOTO 22
33	CALL MSPEAK(9)
	STOP
	END



	SUBROUTINE MAINT

C  SOMEONE SAID THE MAGIC WORD TO INVOKE MAINTENANCE MODE.  MAKE SURE HE'S A
C  WIZARD.  IF SO, LET HIM TWEAK ALL SORTS OF RANDOM THINGS, THEN EXIT SO CAN
C  SAVE TWEAKED VERSION.  SINCE MAGIC WORD MUST BE FIRST COMMAND GIVEN, ONLY
C  THING WHICH NEEDS TO BE FIXED UP IS ABB(1).

	IMPLICIT INTEGER (A-Z)
	LOGICAL YESM,WIZARD
	DIMENSION HNAME(4)
#include "lincom.h"
#include "ltxcom.h"
#include "ttycom.h"
#include "wizcom.h"

	IF(.NOT.WIZCHK(0))RETURN
	IF(YESM(10,0,0))CALL HOURS
	IF(YESM(11,0,0))CALL NEWHRS
	IF(.NOT.YESM(26,0,0))GOTO 10
	CALL MSPEAK(27)
	READ(TTYIN,1),HBEGIN
1	FORMAT(G)
	CALL MSPEAK(28)
	READ(TTYIN,1),HEND
	CALL DATIME(D,T)
	HBEGIN=HBEGIN+D
	HEND=HBEGIN+HEND-1
	CALL MSPEAK(29)
	READ(TTYIN,2),HNAME
2	FORMAT(4A5)
10	WRITE(TTYOUT,12),SHORT
12	FORMAT(' LENGTH OF SHORT GAME (NULL TO LEAVE AT',I3,'):')
	READ(TTYIN,1),X
	IF(X.GT.0)SHORT=X
	CALL MSPEAK(12)
	CALL GETIN(X,Y,Y,Y)
	IF(X.NE.' ')MAGIC=X
C	CALL MSPEAK(13)
C	READ(TTYIN,1),X
C	IF(X.GT.0)MAGNM=X
	WRITE(TTYOUT,16),LATNCY
16	FORMAT(' LATENCY FOR RESTART (NULL TO LEAVE AT',I3,'):')
	READ(TTYIN,1),X
	IF(X.GT.0.AND.X.LT.45)CALL MSPEAK(30)
	IF(X.GT.0)LATNCY=MAX0(45,X)
	IF(YESM(14,0,0))CALL MOTD(.TRUE.)
	SAVED=0
	SETUP=2
	ABB(1)=0
	CALL MSPEAK(15)
	CALL CIAO
	END
	LOGICAL FUNCTION WIZCHK(DUMMY)

C  ASK IF HE'S A WIZARD.  IF HE SAYS YES, MAKE HIM PROVE IT.
C  RETURN TRUE IF HE REALLY IS A WIZARD.

	IMPLICIT INTEGER (A-Z)
	LOGICAL YESM,WIZARD,AWIZ
	DIMENSION HNAME(4),VAL(5)
#include "ttycom.h"
#include "wizcom.h"

	IF (WIZARD) GOTO 100
	IF (AWIZ(DUMMY)) GOTO 100

	WIZCHK=YESM(16,0,7)
	IF(.NOT.WIZCHK)RETURN

C  HE SAYS HE IS.  FIRST STEP: DOES HE KNOW ANYTHING MAGICAL?

	CALL MSPEAK(17)
	CALL GETIN(WORD,X,Y,Z)
	IF(WORD.NE.MAGIC)GOTO 99

C  BY GEORGE, HE REALLY *IS* A WIZARD!

88	CALL MSPEAK(19)

100	WIZARD = .TRUE.
	WIZCHK = .TRUE.
	RETURN

C  AHA!  AN IMPOSTOR!

99	CALL MSPEAK(20)
	WIZCHK=.FALSE.
	RETURN
	END
	SUBROUTINE HOURS

C  ANNOUNCE THE CURRENT HOURS WHEN THE CAVE IS OPEN FOR ADVENTURING.  THIS INFO
C  IS STORED IN WKDAY, WKEND, AND HOLID, WHERE BIT SHIFT(1,N) IS ON IFF THE
C  HOUR FROM N:00 TO N:59 IS "PRIME TIME" (CAVE CLOSED).  WKDAY IS FOR
C  WEEKDAYS, WKEND FOR WEEKENDS, HOLID FOR HOLIDAYS.  NEXT HOLIDAY IS FROM
C  HBEGIN TO HEND.

	IMPLICIT INTEGER (A-Z)
	DIMENSION HNAME(4),VAL(5)
	LOGICAL WIZARD
#include "ttycom.h"
#include "wizcom.h"

	WRITE(TTYOUT,1)
1	FORMAT()
	CALL HOURSX(WKDAY,'MON -',' FRI:')
	CALL HOURSX(WKEND,'SAT -',' SUN:')
	CALL HOURSX(HOLID,'HOLID','AYS: ')
	CALL DATIME(D,T)
	IF(HEND.LT.D.OR.HEND.LT.HBEGIN)RETURN
	IF(HBEGIN.GT.D)GOTO 10
	WRITE(TTYOUT,5),HNAME
5	FORMAT(/' Today is a holiday, namely ',4A5)
	RETURN

10	D=HBEGIN-D
	T='DAYS,'
	IF(D.EQ.1)T='DAY, '
	WRITE(TTYOUT,15),D,T,HNAME
15	FORMAT(/' The next holiday will be in',I3,' ',A5,' namely ',4A5)
	RETURN
	END



	SUBROUTINE HOURSX(H,DAY1,DAY2)

C  USED BY HOURS (ABOVE) TO PRINT HOURS FOR EITHER WEEKDAYS OR WEEKENDS.

	IMPLICIT INTEGER (A-Z)
#include "ttycom.h"
	LOGICAL FIRST

	FIRST=.TRUE.
	FROM=-1
	IF(H.NE.0)GOTO 10
	WRITE(TTYOUT,2),DAY1,DAY2
2	FORMAT(10X,2A5,'  Open all day')
	RETURN

10	FROM=FROM+1
	IF((H.AND.SHIFT(1,FROM)).NE.0)GOTO 10
	IF(FROM.GE.24)GOTO 20
	TILL=FROM
14	TILL=TILL+1
	IF((H.AND.SHIFT(1,TILL)).EQ.0.AND.TILL.NE.24)GOTO 14
	IF(FIRST)WRITE(TTYOUT,16),DAY1,DAY2,FROM,TILL
	IF(.NOT.FIRST)WRITE(TTYOUT,18),FROM,TILL
16	FORMAT(10X,2A5,I4,':00 to',I3,':00')
18	FORMAT(20X,I4,':00 to',I3,':00')
	FIRST=.FALSE.
	FROM=TILL
	GOTO 10

20	IF(FIRST)WRITE(TTYOUT,22),DAY1,DAY2
22	FORMAT(10X,2A5,'  Closed all day')
	RETURN
	END



	SUBROUTINE NEWHRS

C  SET UP NEW HOURS FOR THE CAVE.  SPECIFIED AS INVERSE--I.E., WHEN IS IT
C  CLOSED DUE TO PRIME TIME?  SEE HOURS (ABOVE) FOR DESC OF VARIABLES.

	IMPLICIT INTEGER (A-Z)
	LOGICAL WIZARD
	DIMENSION HNAME(4)
#include "wizcom.h"

	CALL MSPEAK(21)
	WKDAY=NEWHRX('WEEKD','AYS:')
	WKEND=NEWHRX('WEEKE','NDS:')
	HOLID=NEWHRX('HOLID','AYS:')
	CALL MSPEAK(22)
	CALL HOURS
	RETURN
	END



	INTEGER FUNCTION NEWHRX(DAY1,DAY2)

C  INPUT PRIME TIME SPECS AND SET UP A WORD OF INTERNAL FORMAT.

	IMPLICIT INTEGER (A-Z)
#include "ttycom.h"

	NEWHRX=0
	WRITE(TTYOUT,1),DAY1,DAY2
1	FORMAT(' PRIME TIME ON ',2A5)
10	WRITE(TTYOUT,2)
2	FORMAT(' FROM:')
	READ(TTYIN,3),FROM
3	FORMAT(G)
	IF(FROM.LT.0.OR.FROM.GE.24)RETURN
	WRITE(TTYOUT,4)
4	FORMAT(' TILL:')
	READ(TTYIN,3),TILL
	TILL=TILL-1
	IF(TILL.LT.FROM.OR.TILL.GE.24)RETURN
	DO 5 I=FROM,TILL
5	NEWHRX=(NEWHRX.OR.SHIFT(1,I))
	GOTO 10
	END
	SUBROUTINE MOTD(ALTER)

C  HANDLES MESSAGE OF THE DAY.  IF ALTER IS TRUE, READ A NEW MESSAGE FROM THE
C  WIZARD.  ELSE PRINT THE CURRENT ONE.  MESSAGE IS INITIALLY NULL.

	IMPLICIT INTEGER (A-Z)
#include "ttycom.h"
	LOGICAL ALTER
	DIMENSION MSG(100)
	DATA MSG/100*-1/

	IF(ALTER)GOTO 50

	WRITE(TTYOUT,5)
5	FORMAT(1H )
	K=1
10	IF(MSG(K).LT.0)RETURN
	WRITE(TTYOUT,20),(MSG(I),I=K+1,MSG(K)-1)
20	FORMAT(' ',14A5)
	K=MSG(K)
	GOTO 10

50	M=1
	CALL MSPEAK(23)
55	READ(TTYIN,56),(MSG(I),I=M+1,M+14),K
56	FORMAT(15A5)
	IF(K.EQ.' ')GOTO 60
	CALL MSPEAK(24)
	GOTO 55
60	DO 62 I=1,14
	K=M+15-I
	IF(MSG(K).NE.' ')GOTO 65
62	CONTINUE
	GOTO 90
65	MSG(M)=K+1
	M=K+1
	IF(M+14.LT.100)GOTO 55
	CALL MSPEAK(25)
90	MSG(M)=-1
	RETURN
	END



	SUBROUTINE POOF

C  AS PART OF DATABASE INITIALISATION, WE CALL POOF TO SET UP SOME DUMMY
C  PRIME-TIME SPECS, MAGIC WORDS, ETC.

	IMPLICIT INTEGER (A-Z)
	LOGICAL WIZARD
	DIMENSION HNAME(4)
#include "wizcom.h"

C  CLOSES FROM 10AM - 5PM WEEKDAYS
C	WKDAY="00376000
	WIZARD=.FALSE.
	WKDAY=0
	WKEND=0
	HOLID=0
	HBEGIN=0
	HEND=-1
	SHORT=35
	MAGIC='TROLL'
	MAGNM=11111
	LATNCY=90
	RETURN
	END

	SUBROUTINE GRIPE(LOC,SCORE,CLOSNG,CLOSED)

C  ALLOW PLAYER TO WRITE ANY LENGTH MESSAGE TO A GRIPE FILE.  ALSO INCLUDE
C  ENVIRONMENTAL INFO, IN CASE THIS IS A BUG REPORT.

	IMPLICIT INTEGER (A-Z)
#include "diecom.h"
#include "ttycom.h"
	DIMENSION DDD(2),MSG(15)
	DOUBLEPRECISION CAVE,USER

	ERCNT=0
	CALL DATE(DDD)
	CALL TIME(TTT)
	CALL ALOG(USER,MMM,SSS)

10	OPEN(UNIT=20,ACCESS='APPEND',ERR=200,
     1		DIRECTORY='4,5345',FILE='GRIPE.LOG')
	OPEN(UNIT=21,ACCESS='APPEND',ERR=300,FILE='GRIPE.DAT')

	CAVE='open.'
	IF(CLOSNG)CAVE='closing.'
	IF(CLOSED)CAVE='closed.'

	WRITE (20,20),USER,(DDD(I),I=1,2),TTT,TURNS,SCORE,NUMDIE,CAVE
	WRITE (21,20),USER,(DDD(I),I=1,2),TTT,TURNS,SCORE,NUMDIE,CAVE
20	FORMAT(//' Player: ',A10,4X,2A5,A5,
	1/I4,' Turns;',I5,' Points;',I3,' Resurrections;',
	2'  Cave is ',A6)
	CALL GSPEAK(LOC)
	WRITE (20,32)
	WRITE (21,32)
32	FORMAT(' Text:')
	CALL MSPEAK(23)

55	READ(TTYIN,56),(MSG(I),I=1,14),K
56	FORMAT(15A5)
	IF(K.EQ.' ')GOTO 60
	CALL MSPEAK(24)
	GOTO 55

60	DO 62 I=1,14
	K=15-I
	IF(MSG(K).NE.' ')GOTO 65
62	CONTINUE
	GOTO 90

65	WRITE (20,67),(MSG(I),I=1,K)
	WRITE (21,67),(MSG(I),I=1,K)
67	FORMAT(15A5)
	GOTO 55

90	CLOSE (UNIT=20)
	CLOSE (UNIT=21)
	RETURN

200	ERCNT=ERCNT+1
	IF(ERCNT.GT.3)RETURN
	WRITE(TTYOUT,202),ERCNT
202	FORMAT(/' CAN''T OPEN GRIPE FILE.  WAIT...(',I1,')')
	CALL DISMIS(5)
	GOTO 10

300	WRITE(TTYOUT,302)
302	FORMAT(/' BUG: CAN''T OPEN GRIPE FILE.')
	RETURN

	END
	SUBROUTINE GSPEAK(LOC)

C  PRINT LOCATION DESCRIPTIONS.  WORKS JUST LIKE SPEAK, EXCEPT THAT
C  LOCATION NUMBER IS PREFIXED TO EACH LINE.  THIS IS A SLAVE RTN FOR
C  GRIPE.  WOULD USE XSPEAK, EXCEPT THAT XSPEAK USES 'PRINT' STMTS
C  INSTEAD OF WRITES, THANX TO LOSING '$' FEATURE WHEN TRYING TO SEND
C  MULTI-PART LINES TO A DISK FILE.

	IMPLICIT INTEGER (A-Z)
#include "txtcom.h"
#include "ltxcom.h"
#include "placom.h"
#include "objcom.h"
	DIMENSION OLINE(15)

	K=STEXT(LOC)
	IF(K.EQ.0.OR.LINES(K+1).EQ.('>$<'.XOR.'CLYDE'))K=LTEXT(LOC)
1	L=IABS(LINES(K))-K-1
	DO 2 I=1,L
2	OLINE(I)=LINES(K+I).XOR.'CLYDE'
	WRITE (20,3),LOC,(OLINE(I),I=1,L)
	WRITE (21,3),LOC,(OLINE(I),I=1,L)
3	FORMAT (1X,I3,'  ',14A5)
	K=K+L+1
	IF(LINES(K).GE.0)GOTO 1

C  NOW PRINT OUT NAMES OF OBJECTS AT THIS LOCATION

	DO 7 OBJ=1,MAXOBJ
	IF(LOC.NE.PLACE(OBJ).AND.LOC.NE.FIXED(OBJ))GOTO 7
	SKIP=PROP(OBJ)
	IF(OBJ.EQ.STEPS.AND.LOC.EQ.FIXED(STEPS))SKIP=1
C***
	M=PTEXT(OBJ)
	IF(SKIP.LT.0)GOTO 40
	DO 30 I=0,SKIP
10	M=IABS(LINES(M))
	IF(LINES(M).GE.0)GOTO 10
30	CONTINUE
C***
40	L=IABS(LINES(M))-M-1
	DO 6 I=1,L
6	OLINE(I)=LINES(M+I).XOR.'CLYDE'
	WRITE (20,9),(OLINE(J),J=1,L)
	WRITE (21,9),(OLINE(J),J=1,L)
9	FORMAT (8X,14A5)
7	CONTINUE
	RETURN

	END

	SUBROUTINE DATIME(D,T)

C  RETURN THE DATE AND TIME IN D AND T.  D IS NUMBER OF DAYS SINCE 01-JAN-77,
C  T IS MINUTES PAST MIDNIGHT.  THIS IS HARDER THAN IT SOUNDS, BECAUSE THE
C  FINAGLED DEC FUNCTIONS RETURN THE VALUES ONLY AS ASCII STRINGS!

	IMPLICIT INTEGER (A-Z)
	DIMENSION DAT(2),MONTHS(12),HATH(12)
	DATA MONTHS/'-JAN-','-FEB-','-MAR-','-APR-','-MAY-','-JUN-',
     1		'-JUL-','-AUG-','-SEP-','-OCT-','-NOV-','-DEC-'/
	DATA HATH/31,28,31,30,31,30,31,31,30,31,30,31/

C  FUNCTION I2 TAKES 2-DIGIT ASCII AND YIELDS DECIMAL VALUE.

	I2(X)=(SHIFT(X,-29).AND.15)*10+(SHIFT(X,-22).AND.15)

	CALL DATE(DAT)
	CALL TIME(TIM)

	YEAR=I2(SHIFT(DAT(2),14))-77
	D=I2(DAT(1))-1
	X=((SHIFT(DAT(1),14).OR.SHIFT(DAT(2),-21)).AND..NOT."1004020001)
     1		.OR.'-@@@-'
C  ABOVE FUNNY EXPRESSION GUARANTEES (A) UPPER-CASE, AND (B) BOTTOM BIT OKAY.
	DO 1 MON=1,12
	IF(X.EQ.MONTHS(MON))GOTO 2
1	D=D+HATH(MON)
	CALL BUG(28)

2	D=D+YEAR*365+YEAR/4
	IF(MOD(YEAR,4).EQ.3.AND.MON.GT.2)D=D+1
	T=I2(TIM)*60+I2(SHIFT(TIM,21))
	RETURN
	END



	SUBROUTINE CIAO

C  EXITS, AFTER ISSUING REMINDER TO SAVE NEW CORE IMAGE.  USED WHEN SUSPENDING
C  AND WHEN CREATING NEW VERSION VIA MAGIC MODE.  ON SOME SYSTEMS, THE CORE
C  IMAGE IS LOST ONCE THE PROGRAM EXITS.  IF SO, SET K=31 INSTEAD OF 32.

	IMPLICIT INTEGER (A-Z)
	DATA K/32/

	CALL MSPEAK(K)
	IF(K.EQ.31)CALL GETIN(A,B,C,D)
C	STOP
	CALL AQUIT
	END



	SUBROUTINE LOG(SCORE,TURNS,NUMDIE,EGRESS,CLOSNG,CLOSED)
	IMPLICIT INTEGER (A-Z)
#include "ttycom.h"
#include "vercom.h"
	DOUBLEPRECISION DDD,USER
	DIMENSION GONZO(2,5),CAVE(2,3)
	DATA GONZO(1,1)/'Kille'/,GONZO(2,1)/'d.'/
	DATA GONZO(1,2)/'Quit.'/,GONZO(2,2)/' '/
	DATA GONZO(1,3)/'Flush'/,GONZO(2,3)/'ed.'/
	DATA GONZO(1,4)/'Escap'/,GONZO(2,4)/'ed.'/
	DATA GONZO(1,5)/'Wizar'/,GONZO(2,5)/'d.'/
	DATA CAVE(1,1)/'open.'/
	DATA CAVE(1,2)/'closi'/, CAVE(2,2)/'ng.'/
	DATA CAVE(1,3)/'close'/, CAVE(2,3)/'d.'/

C  FOR NOW USE BIZARRE LOG FUNCTION.

	CALL LOGMIL(SCORE)

	RETURN

	CVSTAT=1
	IF(CLOSNG)CVSTAT=2
	IF(CLOSED)CVSTAT=3

	ERCNT=0
	CALL DATE(DDD)
	CALL TIME(TTT)
	CALL ALOG(USER,MMM,SSS)
100	OPEN(UNIT=20,ACCESS='APPEND',ERR=200,
     1		DIRECTORY='4,5345',FILE='GAMES.LOG')

	WRITE (20,102),USER,DDD,TTT,VERSN,SUBVER,BUGFIX,MMM,SSS,
     1		(GONZO(I,EGRESS),I=1,2),(CAVE(I,CVSTAT),I=1,2),
     2		SCORE,TURNS,NUMDIE
102	FORMAT(/1X,A10,' finished ADVENTURE at ',A10,A5,2X,
	1'VER: ',I1,'.',I1,'/',I2,'.',
	2/8X,'Played for ',I3,' minutes, ',I2,' seconds.',2X,2A5,
     2	 'Cave is ',2A5,
	3/8X,I3,' points; ',I4,' Turns;  ',I1,' Reincarnations.')
	CLOSE (UNIT=20)
	RETURN

200	ERCNT=ERCNT+1
	IF(ERCNT.GT.2)RETURN
	WRITE(TTYOUT,202),ERCNT
202	FORMAT(/' LOG FILE BLOCKED.  WAIT...(',I1,')')
	CALL DISMIS(2)
	GOTO 100

	END
C  UTILITY ROUTINES FOR CREATING A READABLE CAVE MAP. (XSPEAK, XMAP)

	SUBROUTINE XSPEAK(LOC)

C  PRINT LOCATION DESCRIPTIONS.  WORKS JUST LIKE SPEAK, EXCEPT THAT
C  LOCATION NUMBER IS PREFIXED TO EACH LINE.

	IMPLICIT INTEGER (A-Z)
#include "txtcom.h"
#include "ltxcom.h"
#include "placom.h"
#include "objcom.h"
	DIMENSION OLINE(15)

C	K=STEXT(LOC)
	K=LTEXT(LOC)
	IF(K.EQ.0.OR.LINES(K+1).EQ.('>$<'.XOR.'CLYDE'))K=LTEXT(LOC)
	WRITE (22,5)
C	PRINT 5
	WRITE (22,5)
C	PRINT 5
5	FORMAT (1H )
1	L=IABS(LINES(K))-K-1
	DO 2 I=1,L
2	OLINE(I)=LINES(K+I).XOR.'CLYDE'
	WRITE (22,3),LOC,(OLINE(I),I=1,L)
C	PRINT 3,LOC,(OLINE(I),I=1,L)
3	FORMAT (1X,I3,'  ',14A5)
	K=K+L+1
	IF(LINES(K).GE.0)GOTO 1
	DO 7 OBJ=1,MAXOBJ
	IF(LOC.NE.PLAC(OBJ).AND.LOC.NE.FIXD(OBJ))GOTO 7
	K=PTEXT(OBJ)
	L=IABS(LINES(K))-K-1
	DO 6 I=1,L
6	OLINE(I)=LINES(K+I).XOR.'CLYDE'
	WRITE (22,9),(OLINE(J),J=1,L)
C	PRINT 9,(OLINE(J),J=1,L)
7	CONTINUE
	WRITE (22,5)
C	PRINT 5
	RETURN

9	FORMAT (8X,14A5)
	END


	SUBROUTINE XMAP

C  PRINT A CAVE MAP.

	IMPLICIT INTEGER (A-Z)
#include "voccom.h"
#include "ltxcom.h"
#include "trvcom.h"

	DIMENSION TK(20)

	OPEN(UNIT=22,ACCESS='SEQOUT',FILE='MAP.DAT')
	DO 9 LOC=1,LOCSIZ
	IF(STEXT(LOC).EQ.0.AND.LTEXT(LOC).EQ.0)GOTO 9
	CALL XSPEAK(LOC)
	N=KEY(LOC)

3	LL=IABS(TRAVEL(N))/1000
	CD=LL/5000
	RM=LL-CD*5000
	WRITE (22,10),CD,RM
C	PRINT 10,LL
4	K=MOD(IABS(TRAVEL(N)),1000)
	IF(K.GT.1)GOTO 6
	IF(K.EQ.1)WRITE (22,14)
C	IF(K.EQ.1)PRINT 14
	GOTO 9

6	KK=0
	DO 7 J=1,TABSIZ
	IF(KTAB(J).EQ.-1)GOTO 8
	IF(K.NE.KTAB(J))GOTO 7
	JJ=ATAB(J).XOR.'PHROG'
	IF(KK.NE.1)WRITE (22,11),JJ
C	IF(KK.NE.1)PRINT 11,JJ
	IF(KK.EQ.1)WRITE (22,12),JJ
C	IF(KK.EQ.1)PRINT 12,JJ
	KK=KK+1
7	CONTINUE

8	N=N+1
	IF(KK.GT.1)WRITE (22,13)
C	IF(KK.GT.1)PRINT 13
	IF(TRAVEL(N-1).LT.0)GOTO 9
	JJ=IABS(TRAVEL(N))/1000
	IF(JJ.EQ.LL)GOTO 4
	WRITE (22,15)
C	PRINT 15
	GOTO 3

9	CONTINUE
	RETURN

10	FORMAT ('+  ',2I8)
11	FORMAT ('+  ',A5)
12	FORMAT ('+ (',A5)
13	FORMAT ('+)')
14	FORMAT ('+	[FORCED LOC]')
15	FORMAT (1H )

	END

	SUBROUTINE LOGMIL(SCORE)

C  SUBROUTINE TO WRITE A MILESTONE LOG.  THIS WRITES ZERO LENGTH
C  FILES IN THE ADVLOG DIRECTORY WITH THE SCORE, MILESTONES AND
C  VERSION INFO.

	IMPLICIT INTEGER (A-Z)
	INTEGER CODES(32), CHARS(10), MIBITS(5), ANAME(2)
	DOUBLEPRECISION FNAME

	EQUIVALENCE (FNAME,ANAME(1))

#include "usrcom.h"
#include "milcom.h"
#include "vercom.h"

	DATA CODES /'0','1','2','3','4','5','6','7','8','9',
     +	            'A','B','C','D','E','F','G','H','I','J',
     +	            'K','L','M','N','O','P','Q','R','S','T',
     +	            'U','V'/
	DATA MIBITS /16,8,4,2,1/

	S = 1023 - SCORE
	CHARS(1)=CODES(S/32+1)
	CHARS(2)=CODES(MOD(S,32)+1)

	DO 30 C=1,4
	MILCHR=0
	DO 20 B=1,5
	M = 26 - (5*C+B)
	MILCHR = MILCHR .OR. MISCOR(M) * MIBITS(B)
20	CONTINUE
30	CHARS(C+2) = CODES(MILCHR+1)

	CHARS(7)='.'
	CHARS(8)=CODES(USRID/(32*32)+1)
	CHARS(9)=CODES(MOD(USRID/32,32)+1)
	CHARS(10)=CODES(MOD(USRID,32)+1)

	ANAME(1)=0
	ANAME(2)=0

	DO 40 I = 0,9
	C = SHIFT(CHARS(I+1),-29)
	W = I/5 + 1
40	ANAME(W) = ANAME(W) .OR. SHIFT(C, 7*(4-MOD(I,5))+1)

	OPEN(UNIT=1,ACCESS='SEQOUT',DIRECTORY='4,5410',FILE=FNAME,ERR=50)
	ENDFILE 1
50	RETURN

	END
