C  setup.C  Last modified on Tue Mar  2 12:05:00 2010 by eroberts
C  ----------

#include "params.h"

	IMPLICIT INTEGER(A-Z)
#include "adjcom.h"
#include "allcom.h"
#include "bltcom.h"
#include "bitcom.h"
#include "concom.h"
#include "detcom.h"
#include "diecom.h"
#include "dwfcom.h"
#include "gencom.h"
#include "hldcom.h"
#include "hntcom.h"
#include "lincom.h"
#include "liqcom.h"
#include "loccom.h"
#include "milcom.h"
#include "mnecom.h"
#include "ltxcom.h"
#include "objcom.h"
#include "placom.h"
#include "prpcom.h"
#include "trvcom.h"
#include "txtcom.h"
#include "usrcom.h"
#include "utxcom.h"
#include "vercom.h"
#include "voccom.h"
#include "wizcom.h"
#include "wrdcom.h"

	CHARACTER*5 C5A,C5B,ERR5,ITOC5
	CHARACTER*24 TODAY
	LOGICAL BITSET,TREASR

	DATA HNTMIN/7/, SETUP/0/, INDLIN/.FALSE./

C  PHUCE CONSISTS OF FOUR PAIRS OF ORIGIN/DESTINATION LOCATIONS FROM/TO
C  WHICH ONE IS TRANSPORTED ON UTTERING THE ELFIN CURSE AT THE TINY
C  DOOR.  HE CAN GO FROM BIG TO SMALL OR SMALL TO BIG, ON EITHER SIDE OF
C  THE DOOR.

	DATA ((PHUCE(I,J),I=1,2),J=1,4)/158,160,160,158,167,166,166,167/

C  TOPBOT IS A LIST OF PAIRS OF TOPS AND BOTTOMS OF THINGS SO THAT THE
C  BELT WORKS AND THINGS FALL TO THE RIGHT PLACE.

	DATA TOPBOT /  17,209 ,  27,209 ,  35,109 , 110,109 ,  88,25  ,
     +		      117,306 , 122,306 , 205,202 , 282,285 , 263,305 ,
     +                262,305 ,  34,100 , 100,96  ,  57,13  ,  74,75  ,
     +                272,2   , 126,299 , 235,77  , 190,77  , 318,316 ,
     +                  0,0   ,   0,0   ,   0,0   ,   0,0   ,   0,0/
	DATA NPAIRS, FALLRM / 20 , 296 /

C  BITS(N) IS A ONE-BIT IN POSITION N, WHERE THE RIGHTMOST BIT IS BIT ZERO.
	DATA BITS /
     1     1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768,
     2     65536,131072,262144,524288,1048576,2097152,4194304,8388608,
     3     16777216,33554432,67108864,134217728,268435456,536870912/

	DATA DEADBT,OPENBT,LOCKBT,BURNBT,WEARBT /10,2,4,5,12/


C  READ THE DATABASE IF WE HAVE NOT YET DONE SO

	ECHO = 0

	WRITE(TTYOUT,1000)
1000	FORMAT('INITIALIZING...')

C  CLEAR OUT THE VARIOUS TEXT-POINTER ARRAYS.  ALL TEXT IS STORED IN ARRAY
C  LINES; EACH LINE IS PRECEDED BY A WORD POINTING TO THE NEXT POINTER (I.E.
C  THE WORD FOLLOWING THE END OF THE LINE).  THE POINTER IS NEGATIVE IF THIS IS
C  FIRST LINE OF A MESSAGE.  THE TEXT-POINTER ARRAYS CONTAIN INDICES OF
C  POINTER-WORDS IN LINES.  STEXT(N) IS SHORT DESCRIPTION OF LOCATION N.
C  LTEXT(N) IS LONG DESCRIPTION.  PTEXT(N) POINTS TO MESSAGE FOR PROP(	PROPN)=0.
C  SUCCESSIVE PROP MESSAGES ARE FOUND BY CHASING POINTERS.  RTEXT CONTAINS
C  SECTION 6'S STUFF.  CTEXT(N) POINTS TO A PLAYER-CLASS MESSAGE.  MTEXT IS FOR
C  SECTION 12.  WE ALSO CLEAR COND.  SEE DESCRIPTION OF SECTION 9 FOR DETAILS.

	DO 1001 I=1,MAXLOC
	IF(I.LE.MAXOBJ)PTEXT(I)=0
	IF(I.LE.RTXSIZ)RTEXT(I)=0
	IF(I.LE.CLSMAX)CTEXT(I)=0
	IF(I.LE.MAGSIZ)MTEXT(I)=0
	IF(I.GT.LOCSIZ)GOTO 1001
	STEXT(I)=0
	LTEXT(I)=0
	LOCCON(I)=0
1001	CONTINUE

	OPEN(1,FILE='text.dat')
	SETUP=1
	LINUSE=1
	TRVS=1
	PTBS=1
	ATBS=1
	CLSSES=1

C  START NEW DATA SECTION.  SECT IS THE SECTION NUMBER.

	READ (1,998) VERSN,SUBVER,BUGFIX
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,998) VERSN,SUBVER,BUGFIX
998	FORMAT(3I8)
	CALL FDATE(TODAY)
	VERDAT = TODAY(9:10)//'-'//TODAY(5:7)//'-'//TODAY(23:24)
1002	READ (1,1003) SECT
1003	FORMAT(I8)
	WRITE(TTYOUT,1015)SECT
1015	FORMAT ('READING TABLE ',I2,'...')

	OLDLOC=-1
	GOTO(1190,1004,1004,1040,1030,1004,1004,1050,1060,1070,1004,
     1       1080,1004,1090,1100,1120,1140) (SECT+1)
C	      (0)  (1)  (2)  (3)  (4)  (5)  (6)  (7)  (8)  (9)  (10)
C	     (11) (12) (13) (14) (15) (16)
999	CALL BUG(9)

C  SECTIONS 1, 2, 5, 6, 10, 12.  READ MESSAGES AND SET UP POINTERS.

1004	READ (1,1005) LOC,(LINES(J),J=LINUSE+1,LINUSE+14),C5A

	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1005) LOC,(LINES(J),J=LINUSE+1,LINUSE+14),C5A
1005	FORMAT(I8,15A5)
	IF(C5A.EQ.'     ')GOTO 1017
	WRITE(TTYOUT,1016)LOC
1016	FORMAT ('LINE FOR LOCN ',I4,' TOO LONG.')
	CALL BUG(0)

1017	IF(LOC.EQ.-1)GOTO 1002
	DO 1006 K=1,14
	KK=LINUSE+15-K
	IF(LINES(KK).NE.'     ')GOTO 1007
1006	CONTINUE
	IF(LOC.EQ.0)GOTO 1004
C  ABOVE KLUGE IS TO AVOID F40 BUG IF CRLF BROKEN ACROSS RECORD BOUNDARY
	CALL BUG(1)

1007	DO 1008 K=LINUSE+1,KK
1008	LINES(K)=LINES(K)
	LINES(LINUSE)=ITOC5(KK+1)
	IF(LOC.EQ.OLDLOC)GOTO 1020
	IF(LOC.GT.OLDLOC .OR. SECT.EQ.5)GOTO 1019
	WRITE (TTYOUT,1018) LOC,SECT
1018	FORMAT (/'LINE ',I3,' OUT OF ORDER IN SECTION ',I2)
	CALL BUG(10)

1019	LINES(LINUSE)=ITOC5(-C5TOI(LINES(LINUSE)))
	IF(SECT.EQ.12)GOTO 1013
	IF(SECT.EQ.10)GOTO 1012
	IF(SECT.EQ.6)GOTO 1011
	IF(SECT.EQ.5)GOTO 1010
	IF(SECT.EQ.1)GOTO 1009

	STEXT(LOC)=LINUSE
	GOTO 1020

1009	LTEXT(LOC)=LINUSE
	GOTO 1020

1010	IF(LOC.GT.0 .AND. LOC.LE.MAXOBJ)PTEXT(LOC)=LINUSE
	GOTO 1020

1011	IF(LOC.GT.RTXSIZ)CALL BUG(6)
	RTEXT(LOC)=LINUSE
	GOTO 1020

1012	CTEXT(CLSSES)=LINUSE
	CVAL(CLSSES)=LOC
	CLSSES=CLSSES+1
	GOTO 1020

1013	IF(LOC.GE.MAGSIZ)CALL BUG(6)
	MTEXT(LOC)=LINUSE

1020	LINUSE=KK+1
	LINES(LINUSE)=ITOC5(-1)
	OLDLOC=LOC
	IF(LINUSE+14 .GT. LINSIZ)CALL BUG(2)
	GOTO 1004

C  THE STUFF FOR SECTION 4 IS ENCODED HERE.  EACH "FROM-LOCATION" GETS A
C  CONTIGUOUS SECTION OF THE "TRAVEL" ARRAY.  EACH ENTRY IN TRAVEL
C             (LCODE*5000+NEWLOC)
C  CORRESPONDING TO A TRKEY ENTRY CONTAINING THE VOCABULARY ENTRY.
C  THE TRAVEL ENTRY IS NEGATED IF THIS IS THE LAST ENTRY FOR THIS
C  LOCATION.  KEY(N) IS THE INDEX IN TRAVEL OF THE FIRST OPTION AT
C  LOCATION N.

1030	READ (1,1031) LOC,LCODE,NEWLOC,CARRAY
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1031) LOC,LCODE,NEWLOC,CARRAY
1031	FORMAT(3I8,20A5)
	IF(LOC.EQ.0)GOTO 1030
C  ABOVE KLUGE IS TO AVOID AFOREMENTIONED F40 BUG
	IF(LOC.EQ.-1)GOTO 1002
	IF(LOC.GE.OLDLOC)GOTO 1032
	WRITE (TTYOUT,1018) LOC,SECT
	CALL BUG(10)

1032	IF(KEY(LOC).NE.0)GOTO 1033
	KEY(LOC)=TRVS
	GOTO 1035

1033	TRAVEL(TRVS-1)=-TRAVEL(TRVS-1)
1035	DO 1037 L=1,20
	IF(CARRAY(L).EQ.' ')GOTO 1039
	K=VOCAB(CARRAY(L),-1)
	IF (K .EQ. -1) CALL BUG(5)
	TRAVEL(TRVS)=LCODE*5000+NEWLOC
	TRKEY(TRVS)=K
	TRVS=TRVS+1
	IF(TRVS.EQ.TRVSIZ)CALL BUG(3)
1037	CONTINUE
1039	TRAVEL(TRVS-1)=-TRAVEL(TRVS-1)
	GOTO 1030

C  HERE WE READ IN THE VOCABULARY.  KTAB(N) IS THE WORD NUMBER, ATAB(N) IS
C  THE CORRESPONDING WORD.  THE -1 AT THE END OF SECTION 3 IS LEFT IN KTAB
C  AS AN END-MARKER.

1040	DO 1042 TABNDX=1,TABSIZ
1043	READ (1,1041) KTAB(TABNDX),ATAB(TABNDX)
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1041) KTAB(TABNDX),ATAB(TABNDX)
1041	FORMAT(I8,A5)
	IF(KTAB(TABNDX).EQ.0)GOTO 1043
C  ABOVE KLUGE IS TO AVOID AFOREMENTIONED F40 BUG
	IF(KTAB(TABNDX).EQ.-1)GOTO 1002
1042	ATAB(TABNDX)=ATAB(TABNDX)
	CALL BUG(4)

C  READ IN THE INITIAL LOCATIONS FOR EACH OBJECT.  ALSO THE IMMOVABILITY INFO.
C  PLAC CONTAINS INITIAL LOCATIONS OF OBJECTS.  FIXD IS -1 FOR IMMOVABLE
C  OBJECTS (INCLUDING THE SNAKE), OR = SECOND LOC FOR TWO-PLACED OBJECTS.
C  WEIGHT CONTAINS THE HEAVINESS OF EACH OBJ, IN POUNDS.

1050	READ (1,1052) OBJ,J,K,KK,TSC,TPROP,C5A,C5B
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1052) OBJ,J,K,KK,TSC,TPROP,C5A,C5B
1052	FORMAT(6I8,2A5)
	IF(OBJ.EQ.-1)GOTO 1002
	IF(OBJ.LE.0 .OR. OBJ.GT.MAXOBJ)CALL BUG(17)
	PLAC(OBJ)=J
	FIXD(OBJ)=K
	WEIGHT(OBJ)=KK
	POINTS(OBJ)=TSC*1000+TPROP
C  READ DEFAULT OBJECT NAMES.  FOR USE IN 'TAKE ALL' COMMANDS.
	NTXT(OBJ,1)=C5A
	NTXT(OBJ,2)=C5B
C  READ POINT VALUES FOR TREASURES.
	GOTO 1050

C  READ DEFAULT MESSAGE NUMBERS FOR ACTION VERBS, STORE IN ACTSPK.

1060	READ (1,1061) VERB,J
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1061) VERB,J
1061	FORMAT(21I8)
	IF(VERB.EQ.-1)GOTO 1002
	ACTSPK(VERB)=J
	GOTO 1060

C  READ INFO ABOUT AVAILABLE LIQUIDS AND OTHER CONDITIONS, STORE IN COND.

1070	READ (1,1061) K,TK
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1061) K,TK
	IF(K.EQ.-1)GOTO 1002
	DO 1071 I=1,20
	LOC=TK(I)
	IF(LOC.EQ.0)GOTO 1070
	IF(BITSET(LOCCON(LOC),K))CALL BUG(8)
1071	LOCCON(LOC)=LOCCON(LOC)+BITS(K+1)
	GOTO 1070

C  READ DATA FOR HINTS.

1080	HNTMAX=0
1081	READ (1,1061) K,TK
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1061) K,TK
	IF(K.EQ.-1)GOTO 1002
	IF(K.EQ.0)GOTO 1081
	IF(K.LT.0 .OR. K.GT.HNTSIZ)CALL BUG(7)
	DO 1083 I=1,4
1083	HINTS(K,I)=TK(I)
	HNTMAX=MAX0(HNTMAX,K)

	GOTO 1081

C  READ MILESTONE DATA BASE

1090	READ (1,1092) K,K1,K2,K3,CARRAY
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1092) K,K1,K2,K3,CARRAY
1092	FORMAT(4I8,20A5)
	IF(K.EQ.-1)GOTO 1002
	IF(K.EQ.0)GOTO 1090
	IF(K.GT.MAXMIL)CALL BUG(12)
	MILOBJ(K)=K1
	MIPLPR(K)=K2
	MIRSPK(K)=K3
	GOTO 1090

C  SECTION 14 IS THE PREPOSITION TABLE.
1100	READ (1,1101) C5A,C5B,CARRAY
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1101) C5A,C5B,CARRAY
1101	FORMAT(A5,A5,20A5)
	IF(C5A.EQ.'-1')GOTO 1002
	VERB=VAL(VOCAB(C5A,-4))
	ERR5=C5A
	IF(VERB.EQ.-1)GOTO 1113
	PREP=VAL(VOCAB(C5B,-6))
	ERR5=C5B
	IF(PREP.EQ.-1)GOTO 1113

	IF(VKEY(VERB).NE.0)GOTO 1104
	VKEY(VERB)=PTBS
	GOTO 1105

1104	PTAB(PTBS-1)=-PTAB(PTBS-1)
1105	DO 1110 L=1,20
	IF(CARRAY(L).EQ.' ')GOTO 1111
	K=VAL(VOCAB(CARRAY(L),-3))
	IF(K.NE.-1)GOTO 1108
	K=999
	IF(L.EQ.1 .AND. CARRAY(1).EQ.'ANY')GOTO 1108
	ERR5 = CARRAY(L)
	GOTO 1113

1108	PTAB(PTBS)=PREP*1000+K
	PTBS=PTBS+1
	IF(PTBS.EQ.PTBSIZ)CALL BUG(15)
1110	CONTINUE
1111	PTAB(PTBS-1)=-PTAB(PTBS-1)
	GOTO 1100
1113	WRITE (TTYOUT,1114) ERR5
1114	FORMAT(/'UNRECOGNIZED WORD "',A5,'" IN PREP/OBJ TABLE.')
	CALL BUG(14)

C  READ CONDITION BITS FOR OBJECTS.  KK IS THE BIT; TK(I), THE OBJ LIST.

1120	READ (1,1061) KK,TK
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1061) KK,TK
	IF(KK.EQ.-1)GOTO 1002
	DO 1125 I=1,20
	OBJ=TK(I)
	IF(OBJ.EQ.0)GOTO 1120
	IF(OBJ.LE.0 .OR. OBJ.GT.MAXOBJ)CALL BUG(17)
	IF(BITSET(OBJCND(OBJ),KK))CALL BUG(16)
1125	OBJCND(OBJ)=OBJCND(OBJ)+BITS(KK+1)
	GOTO 1120

C  SECTION 17 IS THE ADJECTIVE TABLE.
1140	READ (1,1141) C5A,CARRAY
	IF (ECHO.EQ.-1 .OR. ECHO.EQ.SECT)
     +		WRITE (TTYOUT,1141) C5A,CARRAY
1141	FORMAT(A5,20A5)
	IF(C5A.EQ.'-1')GOTO 1002
	ADJ=VOCAB(C5A,-7)
	IF(ADJ.EQ.-1 .OR. CLASS(ADJ).NE.6)GOTO 1148
	ADJ=VAL(ADJ)
	IF(ADJKEY(ADJ).NE.0)GOTO 1142
	ADJKEY(ADJ)=ATBS
	GOTO 1143

1142	ADJTAB(ATBS-1)=-ADJTAB(ATBS-1)
1143	DO 1145 L=1,20
	IF(CARRAY(L).EQ.' ')GOTO 1146
	C5A=CARRAY(L)
	K=VOCAB(CARRAY(L),-3)
	IF(K.EQ.-1 .OR. CLASS(K).NE.2)GOTO 1148
	ADJTAB(ATBS)=VAL(K)
	ATBS=ATBS+1
	IF(ATBS.EQ.MAXOBJ)CALL BUG(18)
1145	CONTINUE
1146	ADJTAB(ATBS-1)=-ADJTAB(ATBS-1)
	GOTO 1140

1148	WRITE (TTYOUT,1149) C5A
1149	FORMAT(/'UNRECOGNIZED WORD "',A5,'" IN ADJECTIVE TABLE.')
	CALL BUG(13)


C  EVERYTHING IS READ!  NOW FINISH CONSTRUCTING INTERNAL DATA FORMAT.

C  DEFINE SOME HANDY MNEMONICS.  THESE CORRESPOND TO OBJECT NUMBERS.
C  (INCLUDES TREASURES.)

1190	AMULET=VOCAB('AMULE',2)
	ANVIL=VOCAB('ANVIL',2)
	AXE=VOCAB('AXE  ',2)
	BALL=VOCAB('BALL ',2)
	BAR=VOCAB('BAR  ',2)
	BASE=VOCAB('BASE ',2)
	BATTER=VOCAB('BATTE',2)
	BEAR=VOCAB('BEAR ',2)
	BEES=VOCAB('BEES ',2)
	BELT=VOCAB('BELT ',2)
	BILL=VOCAB('BILL ',2)
	BILLBD=VOCAB('BILLB',2)
	BIRD=VOCAB('BIRD ',2)
	BOAT=VOCAB('BOAT ',2)
	BOOK=VOCAB('MANUS',2)
	BOOTH=VOCAB('BOOTH',2)
	BOTTLE=VOCAB('BOTTL',2)
	BOX=VOCAB('BOX  ',2)
	BRUSH=VOCAB('BRUSH',2)
	CAGE=VOCAB('CAGE ',2)
	CAKES=VOCAB('CAKES',2)
	CARVNG=VOCAB('CARVI',2)
	CASK=VOCAB('CASK ',2)
	CHAIN=VOCAB('CHAIN',2)
	CHAIR=VOCAB('CHAIR',2)
	CHASM=VOCAB('CHASM',2)
	CHASM2=CHASM+1
	CHEST=VOCAB('CHEST',2)
	CLAM=VOCAB('CLAM ',2)
	CLIFF=VOCAB('CLIFF',2)
	CLOAK=VOCAB('CLOAK',2)
	COINS=VOCAB('COINS',2)
	CROWBR=VOCAB('CROWB',2)
	CROWN=VOCAB('CROWN',2)
	DIADEM=VOCAB('DIADE',2)
	DIALS=VOCAB('DIALS',2)
	DOG=VOCAB('DOG  ',2)
	DOOR=VOCAB('DOOR ',2)
	DRAGON=VOCAB('DRAGO',2)
	DWARF=VOCAB('DWARF',2)
	EGGS=VOCAB('EGGS ',2)
	ELEPH=VOCAB('ELEPH',2)
	ELVES=VOCAB('ELVES',2)
	EMRALD=VOCAB('EMERA',2)
	FIGURE=VOCAB('FIGUR',2)
	FISSUR=VOCAB('FISSU',2)
	FLOWER=VOCAB('FLOWE',2)
	FOOD=VOCAB('FOOD ',2)
	GLASS=VOCAB('GLASS',2)
	GLIQ=VOCAB('LIQUI',2)
	GRAIL=VOCAB('GRAIL',2)
	GRATE=VOCAB('GRATE',2)
	GROUND=VOCAB('GROUN',2)
	HANDS=VOCAB('HANDS',2)
	HEELS=VOCAB('HEELS',2)
	HIVE=VOCAB('HIVE ',2)
	HOOP=VOCAB('HOOP ',2)
	HONEY=VOCAB('HONEY',2)
	HORN=VOCAB('HORN ',2)
	JEWELS=VOCAB('JEWEL',2)
	JUNK=VOCAB('JUNK ',2)
	KEYS=VOCAB('KEYS ',2)
	KNIFE=VOCAB('KNIFE',2)
	LAMP=VOCAB('LAMP ',2)
	LETTER=VOCAB('$LETT',2)
	LYRE=VOCAB('LYRE ',2)
	MAGZIN=VOCAB('MAGAZ',2)
	MAIL=VOCAB('MAIL ',2)
	MATCH=VOCAB('MATCH',2)
	MESSAG=VOCAB('MESSA',2)
	MIRROR=VOCAB('MIRRO',2)
	MUSHRM=VOCAB('MUSHR',2)
	NOTE=VOCAB('NOTE ',2)
	NOISES=VOCAB('$NOIS',2)
	NOTEBK=VOCAB('NOTEB',2)
	NUGGET=VOCAB('NUGGE',2)
	OIL=VOCAB('OIL  ',2)
C	OIL2=OIL+1
	OYSTER=VOCAB('OYSTE',2)
	PEARL=VOCAB('PEARL',2)
	PHONE=VOCAB('PHONE',2)
	PILLOW=VOCAB('PILLO',2)
	PLANT=VOCAB('PLANT',2)
	PLANT2=PLANT+1
	POLE=VOCAB('POLE ',2)
	POSTER=VOCAB('POSTE',2)
	PYRAM=VOCAB('PYRAM',2)
	RADIUM=VOCAB('RADIU',2)
	RECEIP=VOCAB('RECEI',2)
	RING=VOCAB('RING ',2)
	ROCKS=VOCAB('ROCKS',2)
	ROD=VOCAB('ROD  ',2)
	ROD2=ROD+1
	ROPE=VOCAB('ROPE ',2)
	RUG=VOCAB('RUG  ',2)
	SACK=VOCAB('SACK ',2)
	SAFE=VOCAB('SAFE ',2)
	SCABB=VOCAB('SCABB',2)
	SCROLL=VOCAB('SCROL',2)
	SHEET=VOCAB('SHEET',2)
	SHIELD=VOCAB('TUBE ',2)
	SHOES=VOCAB('SHOES',2)
	SILMAR=VOCAB('SILMA',2)
	SKEY=VOCAB('KEY  ',2)
	SLAB=VOCAB('SLAB ',2)
	SLIT=VOCAB('SLIT ',2)
	SLUGS=VOCAB('SLUGS',2)
	SNAKE=VOCAB('SNAKE',2)
	SPHERE=VOCAB('SPHER',2)
	SPICES=VOCAB('SPICE',2)
	STALAG=VOCAB('STALG',2)
	STATUE=VOCAB('STATU',2)
	STEPS=VOCAB('STEPS',2)
	STICKS=VOCAB('STICK',2)
	SWORD=VOCAB('SWORD',2)
	TABLET=VOCAB('TABLE',2)
	TDOOR=DOOR+1
	TDOOR2=TDOOR+1
	PDOOR=TDOOR2+1
	THRONE=VOCAB('THRON',2)
	TMACH=VOCAB('$TIME',2)
	TORCH=VOCAB('TORCH',2)
	TRIDNT=VOCAB('TRIDE',2)
	TROLL=VOCAB('TROLL',2)
	TROLL2=TROLL+1
	VASE=VOCAB('VASE ',2)
	VEND=VOCAB('$VEND',2)
	VIAL=VOCAB('VIAL ',2)
	VOLCAN=VOCAB('VOLCA',2)
	WALL=VOCAB('WALL ',2)
	WALL2=WALL+1
	WATER=VOCAB('WATER',2)
C	WATER2=WATER+1
	WINDOW=VOCAB('LOOKO',2)
	WINE=VOCAB('WINE ',2)
C	WINE2=WINE+1
	WUMPUS=VOCAB('WUMPU',2)

C  THESE ARE MOTION-VERB NUMBERS.

	BACK=VOCAB('BACK ',1)
	CAVE=VOCAB('CAVE ',1)
	DPRSSN=VOCAB('DEPRE',1)
	ENTER=VOCAB('ENTER',1)
	ENTRNC=VOCAB('ENTRA',1)
	EXIT=VOCAB('EXIT ',1)
	NULL=VOCAB('NULL ',1)
	OVER=VOCAB('OVER ',1)


C  AND SOME ACTION VERBS.

	DRINK=VOCAB('DRINK',3)
	DROPVB=VOCAB('DROP ',3)
	FEED=VOCAB('FEED ',3)
	FIND=VOCAB('FIND ',3)
	GET=VOCAB('GET  ',3)
	GO=VOCAB('GO   ',3)
	HIT=VOCAB('HIT  ',3)
	INVENT=VOCAB('INVEN',3)
	LEAVE=VOCAB('LEAVE',3)
	LIGHT=VOCAB('LIGHT',3)
	LOCK=VOCAB('LOCK ',3)
	LOOK=VOCAB('LOOK ',3)
	NOTHNG=VOCAB('NOTHI',3)
	PICK=VOCAB('PICK ',3)
	POUR=VOCAB('POUR ',3)
	PUTVB=VOCAB('PUT  ',3)
	SAY=VOCAB('SAY  ',3)
	SCORE=VOCAB('SCORE',3)
	SHUT=VOCAB('CLOSE',3)
	TAKE=VOCAB('TAKE ',3)
	THROW=VOCAB('THROW',3)
	UNLOCK=VOCAB('UNLOC',3)
	WEAR=VOCAB('WEAR ',3)
	WZGOTO=VOCAB('GOTO ',3)
	YANK=VOCAB('YANK ',3)
	YELL=VOCAB('CALL ',3)

C  AND A FEW PREPOSITIONS.  PREFIX 'PREP' TO DISTINGUISH THEM FROM FUNCTIONS & RANDOMNESS.

	PREPAT=VOCAB('AT   ',5)
	PREPDN=VOCAB('DOWN ',5)
	PREPFR=VOCAB('FROM ',5)
	PREPIN=VOCAB('IN   ',5)
	PREPOF=VOCAB('OFF  ',5)
	PREPON=VOCAB('ON   ',5)
	PRTHRU=VOCAB('THROU',5)

	Y2=33
	LAB=321
	LAB2=322
	RMACH=323

1200	DO 1201 I=1,MAXOBJ
	PLACE(I)=0
	PROP(I)=0
	HOLDER(I)=0
	HLINK(I)=0
	LINK(I)=0
1201	LINK(I+MAXOBJ)=0

	DO 1202 I=1,LOCSIZ
	ABB(I)=0
	IF(LTEXT(I).EQ.0 .OR. KEY(I).EQ.0)GOTO 1202
	K=KEY(I)
	IF(TRKEY(K).EQ.1)LOCCON(I)=2
1202	ATLOC(I)=0

C  SET UP THE ATLOC AND LINK ARRAYS AS DESCRIBED ABOVE.  WE'LL USE THE DROP
C  SUBROUTINE, WHICH PREFACES NEW OBJECTS ON THE LISTS.  SINCE WE WANT THINGS
C  IN THE OTHER ORDER, WE'LL RUN THE LOOP BACKWARDS.  IF THE OBJECT IS IN TWO
C  LOCS, WE DROP IT TWICE.  THIS ALSO SETS UP "PLACE" AND "FIXED" AS COPIES OF
C  "PLAC" AND "FIXD".  ALSO, SINCE TWO-PLACED OBJECTS ARE TYPICALLY BEST
C  DESCRIBED LAST, WE'LL DROP THEM FIRST.

	DO 1206 I=1,MAXOBJ
	K=MAXOBJ+1-I
	IF(FIXD(K).LE.0)GOTO 1206
	CALL DROP(K+MAXOBJ,FIXD(K))
	CALL DROP(K,PLAC(K))
1206	CONTINUE

	DO 1207 I=1,MAXOBJ
	K=MAXOBJ+1-I
	FIXED(K)=FIXD(K)
	IF(PLAC(K).GE.0 .AND. FIXD(K).LE.0)CALL DROP(K,PLAC(K))
1207	CONTINUE

C
C  NOW INSERT THINGS WHICH ARE INSIDE OTHER THINGS
C
	DO 1208 I=1,MAXOBJ
	K=MAXOBJ+1-I
	IF(PLAC(K).GE.0)GOTO 1208
	CK=IABS(PLAC(K))
	TEMP=HOLDER(CK)
	HOLDER(CK)=K
	HLINK(K)=TEMP
	PLACE(K)=-CK
1208	CONTINUE

C  INITIALIZE MILESTONE SCORES TO ZERO

	DO 1209 I=1,MAXMIL
1209	MISCOR(I)=0

C  MAKE SURE ALL THE RIGHT THINGS GET CLOSED AND LOCKED, ETC., BEFORE
C  WE GET STARTED.

	DO 1220 I=1,MAXOBJ
1220	OBJCON(I)=OBJCND(I)

C  TREASURES, AS NOTED EARLIER, ARE OBJECTS WITH BITSET(14) IN OBJCON.
C  THEIR PROPS ARE INITIALLY -1, AND ARE SET TO 0 THE FIRST TIME THEY ARE
C  DESCRIBED.  TALLY KEEPS TRACK OF HOW MANY ARE NOT YET FOUND, SO WE KNOW
C  WHEN TO CLOSE THE CAVE.  TALLY2 COUNTS HOW MANY CAN NEVER BE FOUND (E.G. IF
C  LOST BIRD OR BRIDGE).

	TALLY=0
	TALLY2=0
	DO 1240 I=1,MAXOBJ
	IF(.NOT.TREASR(I))GOTO 1240
	IF(PTEXT(I).NE.0)PROP(I)=-1
	TALLY=TALLY-PROP(I)
1240	CONTINUE

C  CLEAR THE HINT STUFF.  HINTLC(I) IS HOW LONG HE'S BEEN AT LOC WITH COND BIT
C  I.  HINTED(I) IS TRUE IFF HINT I HAS BEEN USED.

	DO 1300 I=1,HNTMAX
	HINTED(I)=.FALSE.
1300	HINTLC(I)=0

C  INITIALISE THE DWARVES.  DLOC IS LOC OF DWARVES, HARD-WIRED IN.  ODLOC IS
C  PRIOR LOC OF EACH DWARF, INITIALLY GARBAGE.  DALTLC IS ALTERNATE INITIAL LOC
C  FOR DWARF, IN CASE ONE OF THEM STARTS OUT ON TOP OF THE ADVENTURER.  (NO 2
C  OF THE 5 INITIAL LOCS ARE ADJACENT.)  DSEEN IS TRUE IF DWARF HAS SEEN HIM.
C  DFLAG CONTROLS THE LEVEL OF ACTIVATION OF ALL THIS:
C	0	NO DWARF STUFF YET (WAIT UNTIL REACHES HALL OF MISTS)
C	1	REACHED HALL OF MISTS, BUT HASN'T MET FIRST DWARF
C	2	MET FIRST DWARF, OTHERS START MOVING, NO KNIVES THROWN YET
C	3	A KNIFE HAS BEEN THROWN (FIRST SET ALWAYS MISSES)
C	3+	DWARVES ARE MAD (INCREASES THEIR ACCURACY)
C  SIXTH DWARF IS SPECIAL (THE PIRATE).  HE ALWAYS STARTS AT HIS CHEST'S
C  EVENTUAL LOCATION INSIDE THE MAZE.  THIS LOC IS SAVED IN CHLOC FOR REF.
C  THE DEAD END IN THE OTHER MAZE HAS ITS LOC STORED IN CHLOC2.

	CHLOC=114
	CHLOC2=140
	DO 1700 I=1,DWFMAX
1700	DSEEN(I)=.FALSE.
	DFLAG=0
	DLOC(1)=PLAC(SNAKE)
	DLOC(2)=PLAC(BOOTH)
	DLOC(3)=Y2
	DLOC(4)=44
	DLOC(5)=PLAC(CLAM)
C	DLOC(6)=PLAC(VEND)
	DLOC(DWFMAX)=CHLOC
	DALTLC=PLAC(NUGGET)


C  SETUP THE LIQUIDS ACCORDING TO CONTAINER PROP VALUES
	LIQTYP(1)=WATER
	LIQTYP(2)=0
	LIQTYP(3)=OIL
	LIQTYP(4)=0
	LIQTYP(5)=WINE

	PROP(POLE)=1
	PROP(SKEY)=1
	PLACE(WATER)=-1
	CALL INSERT(WATER,BOTTLE)


	JJ=0
	DO 1989 K=1,VKYSIZ
1989	IF(VKEY(K).NE.0)JJ=JJ+1

	DO 1998 K=1,LOCSIZ
	KK=LOCSIZ+1-K
	IF(LTEXT(KK).NE.0)GOTO 1997
1998	CONTINUE

1997	LL=0
	OBJ=0
	DO 1996 K=1,MAXOBJ
	IF(TREASR(K))LL=LL+1
1996	IF(PTEXT(K).NE.0)OBJ=OBJ+1

	DO 1995 K=1,TABNDX
1995	IF(KTAB(K)/1000 .EQ. 2)VERB=KTAB(K)-2000

	DO 1994 K=1,RTXSIZ
	J=RTXSIZ+1-K
	IF(RTEXT(J).NE.0)GOTO 1993
1994	CONTINUE

1993    DO 1992 K=1,MAGSIZ
	I=MAGSIZ+1-K
	IF(MTEXT(I).NE.0)GOTO 1991
1992	CONTINUE

1991	SCORE=RATING(MXSCOR,0,0,0,0,0)


	K=MAXOBJ
	WRITE (TTYOUT,2000)
2000	FORMAT ('TABLE SPACE USED:')
        WRITE (TTYOUT,2001) LINUSE,LINSIZ
2001    FORMAT (I6,' OF ',I6,' WORDS OF MESSAGES')
        WRITE (TTYOUT,2002) TRVS,TRVSIZ
2002    FORMAT (I6,' OF ',I6,' TRAVEL OPTIONS')
        WRITE (TTYOUT,2003) TABNDX,TABSIZ
2003    FORMAT (I6,' OF ',I6,' VOCABULARY WORDS')
        WRITE (TTYOUT,2004) KK,LOCSIZ
2004    FORMAT (I6,' OF ',I6,' LOCATIONS')
        WRITE (TTYOUT,2005) OBJ,K,LL
2005    FORMAT (I6,' OF ',I6,' OBJECTS OF WHICH ',I2,' ARE TREASURES.')
        WRITE (TTYOUT,2006) VERB,VRBSIZ
2006    FORMAT (I6,' OF ',I6,' ACTION VERBS')
        WRITE (TTYOUT,2007) J,RTXSIZ
2007    FORMAT (I6,' OF ',I6,' RTEXT MESSAGES')
        WRITE (TTYOUT,2008) CLSSES,CLSMAX
2008    FORMAT (I6,' OF ',I6,' CLASS MESSAGES')
        WRITE (TTYOUT,2009) HNTMAX,HNTSIZ
2009    FORMAT (I6,' OF ',I6,' HINTS')
        WRITE (TTYOUT,2010) I,MAGSIZ
2010    FORMAT (I6,' OF ',I6,' MAGIC MESSAGES')
        WRITE (TTYOUT,2011) PTBS,PTBSIZ
2011    FORMAT (I6,' OF ',I6,' VERB/PREP/OBJ OPTIONS')
        WRITE (TTYOUT,2012) JJ,VERB
2012    FORMAT (I6,' OF ',I6,' VERBS TAKE PREPOSITIONS')
        WRITE (TTYOUT,2013) MXSCOR
2013    FORMAT ('MAXIMUM SCORE FOR THIS VERSION IS ',I4,' POINTS.')

	CALL CDUMP
	END
