C  newadv.F
C  Last modified on Wed Mar  3 09:09:57 2010 by eroberts
C  ----------

#include "params.h"

	IMPLICIT INTEGER(A-Z)
#include "adjcom.h"
#include "allcom.h"
#include "bltcom.h"
#include "bitcom.h"
#include "concom.h"
#include "detcom.h"
#include "diecom.h"
#include "dwfcom.h"
#include "gencom.h"
#include "hldcom.h"
#include "hntcom.h"
#include "lincom.h"
#include "liqcom.h"
#include "loccom.h"
#include "milcom.h"
#include "mnecom.h"
#include "ltxcom.h"
#include "objcom.h"
#include "placom.h"
#include "prpcom.h"
#include "trvcom.h"
#include "txtcom.h"
#include "usrcom.h"
#include "utxcom.h"
#include "vercom.h"
#include "voccom.h"
#include "wizcom.h"
#include "wrdcom.h"

	INTEGER RANINT
	LOGICAL CKMAIL
	LOGICAL WZDARK, RDFLAG

	LOGICAL AJAR,AT,ATHAND,BITSET,BLIND,BURNS,
     1   	DARK,DEAD,DEMO,EDIBLE,ENCLSD,FORCED,HOLDNG,
     2   	GAVEUP,HERE,HINGED,INSIDE,LIVING,LOCKS,OPAQUE,
     3   	OUTSID,PCT,PLURAL,PRINTD,SMALL,TEETER,
     4   	TINY,TOTING,TREASR,LOCKED,VESSEL,WEARNG,WORN,YEA,YES


C  STATEMENT FUNCTIONS
C
C
C  AJAR(OBJ)	= TRUE IF THE OBJECT IS OPEN
C  AT(OBJ)	= TRUE IF ON EITHER SIDE OF TWO-PLACED OBJECT
C  ATHAND(OBJ)	= TRUE IF OBJECT IS HERE AND NOT IN CLOSED CONTAINER.
C  BITSET(C,N)  = TRUE IF C HAS BIT N SET (BIT 0 IS UNITS BIT)
C  BLIND(DUMMY)	= TRUE IF HERO CAN'T SEE (TOO DARK OR GLAREY)
C  BURNS(OBJ)   = TRUE IF THE OBJECT IS FLAMMABLE
C  DARK(DUMMY)	= TRUE IF LOCATION "LOC" IS DARK
C  DEAD(OBJ)	= TRUE IF CRITTER IS KILLED (OR IN ENCHANTED SLEEP)
C  FORCED(LOC)	= TRUE IF LOC MOVES WITHOUT ASKING FOR INPUT (COND=2)
C  HERE(OBJ)	= TRUE IF THE OBJ IS AT "LOC" (OR IS BEING CARRIED)
C  HINGED(OBJ)	= TRUE IF OBJECT CAN BE OPENED/SHUT.
C  INSIDE(LOC)	= TRUE IF LOCATION IS WELL WITHIN THE CAVE
C  LIQ(DUMMY)	= OBJECT NUMBER OF LIQUID IN BOTTLE
C  LIQLOC(LOC)	= OBJECT NUMBER OF LIQUID (IF ANY) AT LOC
C  LIVING(OBJ)	= TRUE IF OBJ IS SOME SORT OF CRITTER
C  LOCKED(OBJ)	= TRUE IF OBJECT IS LOCKED. (NEED NOT HAVE A LOCK,
C		   E.G., RUSTY DOOR)
C  LOCKS(OBJ)	= TRUE IF OBJECT HAS A LOCK.
C  OPAQUE(OBJ)	= TRUE IF CONTAINER IS NOT TRANSPARENT (SACK, CHEST)
C		  TRANSPARENT OBJS: BOTTLE(GLASS), CAGE(WICKER)
C  OUTSID(LOC)	= TRUE IF LOCATION IS OUTSIDE THE CAVE
C  PCT(N)       = TRUE N% OF THE TIME (N INTEGER FROM 0 TO 100)
C  PLURAL(OBJ)	= TRUE IF IT IS A PLURAL OBJ (SHOES, KEYS, ETC.)
C  PRINTD(OBJ)	= TRUE IF OBJECT CAN BE READ.
C  SMALL(OBJ)	= TRUE IF OBJ FITS INTO SACK
C  TINY(OBJ)    = TRUE IF THE OBJ IS TINY
C  TOTING(OBJ)	= TRUE IF THE OBJ IS BEING CARRIED
C  TREASR(OBJ)	= TRUE IF OBJECT IS A TREASURE
C  VESSEL(OBJ)	= TRUE IF OBJECT IS A CONTAINER
C  WEARNG(OBJ)	= TRUE IF OBJECT IS BEING WORN
C  WORN(OBJ)	= TRUE IF THE OBJECT CAN BE WORN
C
C  CLOSED SAYS WHETHER WE'RE ALL THE WAY CLOSED
C  CLOSNG SAYS WHETHER ITS CLOSING TIME YET
C  DEMO IS TRUE IF THIS IS A PRIME-TIME DEMONSTRATION GAME
C  GAVEUP SAYS WHETHER HE EXITED VIA "QUIT"
C  LMWARN SAYS WHETHER HE'S BEEN WARNED ABOUT LAMP GOING DIM
C  PANIC SAYS WHETHER HE'S FOUND OUT HE'S TRAPPED IN THE CAVE
C  SCORNG INDICATES TO THE RATING ROUTINE WHETHER WE'RE DOING A "SCORE" COMMAND
C  WZDARK SAYS WHETHER THE LOC HE'S LEAVING WAS DARK
C  YEA IS RANDOM YES/NO REPLY


	BURNS(OBJ)=BITSET(OBJCON(OBJ),BURNBT)
	DEAD(OBJ)=BITSET(OBJCON(OBJ),10)
	EDIBLE(OBJ)=BITSET(OBJCON(OBJ),7)
	LOCKS(OBJ)=BITSET(OBJCON(OBJ),3)
	SMALL(OBJ)=BITSET(OBJCON(OBJ),16)
	TINY(OBJ)=BITSET(OBJCON(OBJ),17)
	WORN(OBJ)=BITSET(OBJCON(OBJ),11)



C  OTHER RANDOM FLAGS AND COUNTERS, AS FOLLOWS:
C	ABBNUM	HOW OFTEN WE SHOULD PRINT NON-ABBREVIATED DESCRIPTIONS
C	BCROSS	NUMBER OF TIMES COLLAPSING BRIDGE HAS BEEN TRAVERSED.
C	BLTCNT	TELLS HOW MANY TIMES HAS USED BELT.
C	BLTCLK	TICKS DOWN SINCE LAST BELT USE.
C	BONUS	USED TO DETERMINE AMOUNT OF BONUS IF HE REACHES CLOSING
C	CHASE	TELLS HOW CLOSE THE WUMPUS IS TO GOBBLING HIM UP
C	CLOCK1	NUMBER OF TURNS FROM FINDING LAST TREASURE TILL CLOSING
C	CLOCK2	NUMBER OF TURNS FROM FIRST WARNING TILL BLINDING FLASH
C	CLOCK3	NUMBER OF TURNS IN REPOSITORY TILL PHONE RINGS.
C		AFTER TICKING TO 0, TICKS 7 TIMES TO WAKE DWARVES.
C	LCLOCK	OIL LAMP COUNTER
C	MCLOCK	MATCH COUNTER.
C	COMBO	CURRENT PROGRESS IN GIVING SAFE'S COMBINATION
C	DETAIL	HOW OFTEN WE'VE SAID "NOT ALLOWED TO GIVE MORE DETAIL"
C	DKILL	NUMBER OF DWARVES KILLED (UNUSED IN SCORING, NEEDED FOR MSG)
C	FOOBAR	CURRENT PROGRESS IN SAYING "FEE FIE FOE FOO".
C	HEALTH	PERCENTAGE OF MAXIMUM (100) FITNESS
C	IWEST	HOW MANY TIMES HE'S SAID "WEST" INSTEAD OF "W"
C	KNFLOC	0 IF NO KNIFE HERE, LOC IF KNIFE HERE, -1 AFTER CAVEAT
C	LIMIT	LIFETIME OF LAMP (NOT SET HERE)
C	MAXDIE	NUMBER OF REINCARNATION MESSAGES AVAILABLE (UP TO 5)
C	NUMDIE	NUMBER OF TIMES KILLED SO FAR
C	TERSE	IF TRUE, NEVER PRINT LONG LOCATION DESCRIPTIONS
C	TURNS	TALLIES HOW MANY COMMANDS HE'S GIVEN (IGNORES YES/NO)
C	WASTE	TELLS HOW LONG HE HAS USED LAMP IN LIGHTED AREA.

C	LOGICALS WERE EXPLAINED EARLIER

C  A POPULAR LOCATION IS:

	SETUP=2

	ABBNUM=5
	BCROSS=0
	BLTCNT=0
	BLTCLK=0
	BONUS=0
	ICLK1=30
	CLOCK1=ICLK1
	CLOCK2=20
	CLOCK3=100+RANINT(20)
	LCLOCK=0
	MCLOCK=0
	CHASE=0
	CLOSED=.FALSE.
	CLOSNG=.FALSE.
	COMBO=0
	DETAIL=0
	DKILL=0
	FOOBAR=0
	GAVEUP=.FALSE.
	HEALTH=100
	OLDJX=0
	IWEST=0
	KNFLOC=0
	LMWARN=.FALSE.
	DO 1800 I=0,4
1800	IF(RTEXT(2*I+81).NE.0)MAXDIE=I+1
	NUMDIE=0
	PANIC=.FALSE.
	SCORNG=.FALSE.
	TERSE=.FALSE.
	TURNS=0
	WASTE=0

C  AND CLEAR OUT ANY LEFTOVER WORD VECTORS...
	CALL CLRLIN
	DO 1810 WDX=1,35
1810	WORDS(WDX)=0
	WDX=0



1	WIZARD = .TRUE.
	DEMO=.FALSE.
	SAVED = -1
C	CALL MOTD(.FALSE.)
	I=RANINT(1)
	USRID = 0
	IF (BUGFIX.LT.10) WRITE (TTYOUT,5101) VERSN,BUGFIX,VERDAT
	IF (BUGFIX.GE.10) WRITE (TTYOUT,5102) VERSN,BUGFIX,VERDAT
5101	FORMAT('-- ADVENTURE (V',I1,'.',I1,'), ',A9,' --'/)
5102	FORMAT('-- ADVENTURE (V',I1,'.',I2,'), ',A9,' --'/)
C	CALL RSPEAK(325)
C	CALL BLKLIN
	HINTED(3)=YES(65,1,0)
	NEWLOC=1
	SETUP=3
	LIMIT=400
	IF(HINTED(3))LIMIT=600
	IF (CKMAIL(0))CALL DROP(LETTER,1)
	GOTO 3

C  CAN'T LEAVE CAVE ONCE IT'S CLOSING (EXCEPT BY MAIN OFFICE).

2	CALL BLKLIN
3	IF(.NOT.OUTSID(NEWLOC) .OR. NEWLOC.EQ.0 .OR. .NOT.CLOSNG)GOTO 71
	CALL RSPEAK(130)
	NEWLOC=LOC
	IF(.NOT.PANIC)CLOCK2=15
	PANIC=.TRUE.

C  SEE IF A DWARF HAS SEEN HIM AND HAS COME FROM WHERE HE WANTS TO GO.  IF SO,
C  THE DWARF'S BLOCKING HIS WAY.  IF COMING FROM PLACE FORBIDDEN TO PIRATE
C  (DWARVES ROOTED IN PLACE) LET HIM GET OUT (AND ATTACKED).

71	IF(NEWLOC.EQ.LOC .OR. FORCED(LOC) .OR. BITSET(LOCCON(LOC),4))GOTO 74
	DO 73 I=1,DWFMAX-1
	IF(ODLOC(I).NE.NEWLOC .OR. .NOT.DSEEN(I))GOTO 73
	NEWLOC=LOC
	CALL RSPEAK(2)
	GOTO 74
73	CONTINUE
74	LOC=NEWLOC

C  DWARF STUFF.  SEE EARLIER COMMENTS FOR DESCRIPTION OF VARIABLES.  REMEMBER
C  SIXTH DWARF IS PIRATE AND IS THUS VERY DIFFERENT EXCEPT FOR MOTION RULES.

C  FIRST OFF, DON'T LET THE DWARVES FOLLOW HIM INTO A PIT OR A WALL.  ACTIVATE
C  THE WHOLE MESS THE FIRST TIME HE GETS AS FAR AS THE HALL OF MISTS (LOC 15).
C  IF NEWLOC IS FORBIDDEN TO PIRATE (IN PARTICULAR, IF IT'S BEYOND THE TROLL
C  BRIDGE), BYPASS DWARF STUFF.  THAT WAY PIRATE CAN'T STEAL RETURN TOLL, AND
C  DWARVES CAN'T MEET THE BEAR.  ALSO MEANS DWARVES WON'T FOLLOW HIM INTO DEAD
C  END IN MAZE, BUT C'EST LA VIE.  THEY'LL WAIT FOR HIM OUTSIDE THE DEAD END.

	IF(LOC.EQ.0 .OR. FORCED(LOC) .OR. BITSET(LOCCON(NEWLOC),4))GOTO 2001

	IF(DFLAG.NE.0)GOTO 6000
	IF(INSIDE(LOC))DFLAG=1
	GOTO 2001

C  WHEN WE ENCOUNTER THE FIRST DWARF, WE KILL 0, 1, OR 2 OF THE DWFMAX DWARVES.
C  IF ANY OF THE SURVIVORS IS AT LOC, REPLACE HIM WITH THE ALTERNATE.

6000	IF(DFLAG.NE.1)GOTO 6010

6998	IF(.NOT.INSIDE(LOC) .OR. PCT(95))GOTO 2001
6999	DFLAG=2

	DO 6001 I=1,2
	J=1+RANINT(DWFMAX-1)
C  IF SAVED NOT = -1, HE BYPASSED THE "START" CALL.
6001	IF(PCT(50) .AND. SAVED.EQ.-1)DLOC(J)=0
	DO 6002 I=1,DWFMAX-1
	IF(DLOC(I).EQ.LOC)DLOC(I)=DALTLC
C
C  REMOVE ALL THE DWARVES IN THIS VERSION, EXCEPT THE PIRATE
C
	DLOC(I)=0

6002	ODLOC(I)=DLOC(I)
	CALL RSPEAK(3)
	CALL DROP(AXE,LOC)
	GOTO 2001

C  THINGS ARE IN FULL SWING.  MOVE EACH DWARF AT RANDOM, EXCEPT IF HE'S SEEN US
C  HE STICKS WITH US.  DWARVES NEVER GO TO LOCS WHICH ARE OUTSIDE OR IN
C  EITHER OF THE TWO PORTAL AREAS.  IF WANDERING AT RANDOM, THEY
C  DON'T BACK UP UNLESS THERE'S NO ALTERNATIVE.  IF THEY DON'T HAVE TO
C  MOVE, THEY ATTACK.  AND, OF COURSE, DEAD DWARVES DON'T DO MUCH OF ANYTHING.

6010	DTOTAL=0
	ATTACK=0
	STICK=0
	DO 6030 I=1,DWFMAX
	IF(DLOC(I).EQ.0)GOTO 6030
	J=1
	IF(I.EQ.DWFMAX .AND. PLACE(CHEST).EQ.0 .AND. TURNS.GT.500)
     +	  GOTO 6019
	KK=KEY(DLOC(I))
	IF(KK.EQ.0)GOTO 6016
6012	NEWLOC=MOD(IABS(TRAVEL(KK)),10000)
	IF(NEWLOC.GT.MAXLOC .OR. NEWLOC.EQ.ODLOC(I)
     1   	 .OR. .NOT.INSIDE(NEWLOC)
     2   	 .OR. (J.GT.1 .AND. NEWLOC.EQ.TK(J-1)) .OR. J.GE.20
     3   	 .OR. NEWLOC.EQ.DLOC(I) .OR. FORCED(NEWLOC)
     4   	 .OR. (I.EQ.DWFMAX .AND. BITSET(LOCCON(NEWLOC),4))
     5   	 .OR. TRKEY(KK).EQ.100)GOTO 6014
	TK(J)=NEWLOC
	J=J+1
6014	KK=KK+1
	IF(TRAVEL(KK-1).GE.0)GOTO 6012
6016	TK(J)=ODLOC(I)
	IF(J.GE.2)J=J-1
	J=1+RANINT(J)
	ODLOC(I)=DLOC(I)
	DLOC(I)=TK(J)
	DSEEN(I)=(DSEEN(I) .AND. INSIDE(LOC))
     1   	 .OR. (DLOC(I).EQ.LOC .OR. ODLOC(I).EQ.LOC)
	IF(.NOT.DSEEN(I))GOTO 6030
6019	DLOC(I)=LOC
	IF(I.NE.DWFMAX)GOTO 6027

C  THE PIRATE'S SPOTTED HIM.  HE LEAVES HIM ALONE ONCE WE'VE FOUND CHEST.
C  K COUNTS IF A TREASURE IS HERE.  IF NOT, AND TALLY=TALLY2 PLUS ONE FOR
C  AN UNSEEN CHEST, LET THE PIRATE BE SPOTTED.

	IF(LOC.EQ.CHLOC .OR. PROP(CHEST).GE.0)GOTO 6030
	K=0
	DO 6020 J=1,MAXOBJ
C  PIRATE WON'T TAKE PYRAMID FROM PLOVER ROOM OR DARK ROOM (TOO EASY!).
C  ALSO WON'T TAKE DIADEM FROM BOX
	IF(.NOT.TREASR(J) .OR. (J.EQ.CASK .AND. LIQ(CASK).NE.WINE))GOTO 6020
	IF((J.EQ.DIADEM .OR. J.EQ.BOX) .AND. PLACE(DIADEM).EQ.-BOX)GOTO 6020
	IF(J.EQ.PYRAM .AND. (LOC.EQ.PLAC(PYRAM)
     1   	 .OR. LOC.EQ.PLAC(EMRALD)))GOTO 6020
	IF(TOTING(J) .AND. ATHAND(J))GOTO 6022
6020	IF(HERE(J) .AND. TREASR(J))K=1
	IF(TURNS.GT.500 .AND. K.EQ.0 .AND. PLACE(CHEST).EQ.0
     1   	.AND.ATHAND(LAMP) .AND. PROP(LAMP).EQ.1)GOTO 6025
	IF(ODLOC(DWFMAX).NE.DLOC(DWFMAX) .AND. PCT(30))CALL RSPEAK(127)
	GOTO 6030

6022	CALL RSPEAK(128)
C  DON'T STEAL CHEST BACK FROM TROLL!
	IF(PLACE(MESSAG).EQ.0)CALL MOVE(CHEST,CHLOC)
	CALL MOVE(MESSAG,CHLOC2)
	DO 6023 J=1,MAXOBJ
	IF(.NOT.TREASR(J) .OR. (J.EQ.PYRAM .AND. 
     1   	(LOC.EQ.PLAC(PYRAM) .OR. LOC.EQ.PLAC(EMRALD))) .OR. 
     2   	(J.EQ.CASK .AND. LIQ(CASK).NE.WINE) .OR. 
     3   	(ENCLSD(J) .AND. .NOT.ATHAND(J)))GOTO 6023
	IF(AT(J) .AND. FIXED(J).EQ.0)CALL CARRY(J,LOC)
	IF(ENCLSD(J))CALL REMOVE(J)
	IF(.NOT.HOLDNG(J))GOTO 6023
	CALL INSERT(J,CHEST)
	IF(.NOT.WEARNG(J))GOTO 6023
	PROP(J)=0
	CALL BITOFF(J,WEARBT)
6023	CONTINUE
6024	DLOC(DWFMAX)=CHLOC
	ODLOC(DWFMAX)=CHLOC
	DSEEN(DWFMAX)=.FALSE.
	GOTO 6030

6025	CALL RSPEAK(186)
	CALL MOVE(CHEST,CHLOC)
	CALL MOVE(MESSAG,CHLOC2)
	GOTO 6024

C  THIS THREATENING LITTLE DWARF IS IN THE ROOM WITH HIM!

6027	DTOTAL=DTOTAL+1
	IF(ODLOC(I).NE.DLOC(I))GOTO 6030
	ATTACK=ATTACK+1
	IF(KNFLOC.GE.0)KNFLOC=LOC
	IF(RANINT(1000).LT.95*(DFLAG-2))STICK=STICK+1
6030	CONTINUE

C  NOW WE KNOW WHAT'S HAPPENING.  LET'S TELL THE POOR SUCKER ABOUT IT.

	IF(DTOTAL.EQ.0)GOTO 2001
	IF(DTOTAL.EQ.1)GOTO 75
	WRITE (TTYOUT,67) DTOTAL
67	FORMAT('There are ',I1,' threatening little dwarves in the room with you!')
	GOTO 77
75	CALL RSPEAK(4)
77	IF(ATTACK.EQ.0)GOTO 2001
	IF(DFLAG.EQ.2)DFLAG=3
C  IF SAVED NOT = -1, HE BYPASSED THE "START" CALL.  DWARVES GET *VERY* MAD!
	IF(SAVED.NE.-1)DFLAG=20
	IF(ATTACK.EQ.1)GOTO 79
	WRITE (TTYOUT,78) ATTACK
78	FORMAT(I1,' of them throw knives at you!')
	K=6
82	IF(WEARNG(MAIL) .AND. STICK.NE.0)GOTO 85
	IF(STICK.GT.1)GOTO 83
	CALL RSPEAK(K+STICK)
	IF(STICK.EQ.0)GOTO 2001
	GOTO 84
83	WRITE (TTYOUT,68) STICK
68	FORMAT(I1,' of them get you!')
84	OLDLC2=LOC
	GOTO 94100

85	RSPK=472
	IF (ATTACK .GT. 1)  RSPK=473
	CALL RSPEAK(RSPK)
	GOTO 2001

79	CALL RSPEAK(5)
	K=52
	GOTO 82



C  DESCRIBE THE CURRENT LOCATION AND (MAYBE) GET NEXT COMMAND.

C  PRINT TEXT FOR CURRENT LOC.

2000	CALL BLKLIN
2001	IF(LOC.EQ.0)GOTO 94100
	IF (LOC.EQ.FALLRM .AND. PRVLOC.EQ.FALLRM) LOC = FALLRM-1
2002	PRVLOC=LOC
	KK=STEXT(LOC)
	IF(VERB.EQ.LOOK .OR. KK.EQ.0 .OR. 
     1    (.NOT.TERSE .AND. MOD(ABB(LOC),ABBNUM).EQ.0) )KK=LTEXT(LOC)
	IF((FORCED(LOC) .OR. .NOT.DARK(0)) .AND. LOC.NE.200)GOTO 2004
	IF(LOC.NE.200.AND. (DARK(0) .OR. PROP(LAMP).EQ.0
     1   	 .OR. .NOT.ATHAND(LAMP)) )GOTO 2003
	IF(PROP(LAMP).EQ.0 .OR. .NOT.ATHAND(LAMP))GOTO 2007
	IF(PCT(35))GOTO 94000
	KK=RTEXT(294)
	GOTO 2007

2003	IF(WZDARK .AND. PCT(35))GOTO 94000
	KK=RTEXT(16)
2004	IF(HOLDNG(BEAR) .AND. .NOT.DARK(0))CALL RSPEAK(141)
2007	CALL SPEAK(KK)
	K=1
	ABB(LOC)=ABB(LOC)+1
	IF(.NOT.FORCED(LOC))GOTO 2022
	CALL TRAVL(K)
	IF(KILLED)GOTO 94100
	GOTO 2

2022	ABB(LOC)=ABB(LOC)-1
	IF(LOC.EQ.Y2 .AND. PCT(25) .AND. .NOT.CLOSNG)CALL RSPEAK(8)
	IF(LOC.EQ.147 .AND. ABB(LOC).EQ.1)CALL RSPEAK(216)

C  SEE IF HE IS WASTING HIS BATTERIES OUT IN THE OPEN.
	K=0
	IF(.NOT.OUTSID(LOC) .OR. PROP(LAMP).EQ.0)GOTO 2030
	K=WASTE+1
	IF(K.LE.12)GOTO 2030
	CALL RSPEAK(324)
	K=0
2030	WASTE=K

C  IF WUMPUS IS CHASING STOOGE, SEE IF WUMPUS GETS HIM.
	IF(CHASE.EQ.0)GOTO 2040
	CHASE=CHASE+1
	KK=CHASE/2
	PROP(WUMPUS)=KK
	CALL MOVE(WUMPUS,LOC)
	IF(KK.LT.5)GOTO 2040
	IF(DARK(0))CALL RSPEAK(270)
	CALL PSPEAK(WUMPUS,5)
	GOTO 94100

C  CHECK FOR RADIATION POISONING.
2040	K=1
	IF(OUTSID(LOC))K=3
	HEALTH=MIN0(HEALTH+1,100)
	IF(.NOT.HERE(RADIUM) .OR. 
     1    (PLACE(RADIUM).EQ.-SHIELD .AND. .NOT.AJAR(SHIELD)) )GOTO 2045
	HEALTH=HEALTH-K-8
	IF(HEALTH.GE.60)GOTO 2045
	CALL RSPEAK(391+(60-HEALTH)/10)
	IF(HEALTH.LE.0)GOTO 94100

C  PRINT OUT DESCRIPTIONS OF OBJECTS AT THIS LOCATION.  IF NOT CLOSING AND
C  PROPERTY VALUE IS NEGATIVE, TALLY OFF ANOTHER TREASURE.  RUG IS SPECIAL
C  CASE; ONCE SEEN, ITS PROP IS 1 (DRAGON ON IT) TILL DRAGON IS KILLED.
C  SIMILARLY FOR CHAIN; PROP IS INITIALLY 1 (LOCKED TO BEAR).
C  LIKEWISE, FOR SWORD (MUST PROVE ELFIN ROYALTY).

2045	IF(BLIND(0))GOTO 2100
	ABB(LOC)=ABB(LOC)+1
	I=ATLOC(LOC)
2050	IF(I.EQ.0)GOTO 2080
	OBJ=I
	IF(OBJ.GT.MAXOBJ)OBJ=OBJ-MAXOBJ
	IF(PROP(OBJ).GE.0)GOTO 2056
	IF(CLOSED)GOTO 2058
	PROP(OBJ)=0
	IF(OBJ.EQ.RUG .OR. OBJ.EQ.CHAIN .OR. OBJ.EQ.SWORD
     1   	 .OR. OBJ.EQ.CASK)PROP(OBJ)=1
	IF(OBJ.EQ.CLOAK .OR. OBJ.EQ.RING)PROP(OBJ)=2
	TALLY=TALLY-1
C  IF REMAINING TREASURES TOO ELUSIVE, ZAP HIS LAMP.
	IF(TALLY.EQ.TALLY2 .AND. TALLY.NE.0)LIMIT=MIN0(35,LIMIT)
2056	CALL PSPEAK(OBJ,PROP(OBJ))
	CALL LOOKIN(OBJ)
2058	I=LINK(I)
	GOTO 2050

C  "I DON'T UNDERSTAND THAT!"
2060	SPK=CONFUZ(0)
	GOTO 2011

C  "YOU CAN'T DO THAT!"  (AN IMPOSSIBLE ACT, E.G., "OPEN SWORD", "FEED BOAT", ETC.)
2070	SPK=NOWAY(0)
	GOTO 2011

2080	IF(.NOT.TOTING(BOAT))GOTO 2085
	CALL PSPEAK(BOAT,1)
	CALL LOOKIN(BOAT)
	GOTO 2100
2085	IF(.NOT.TOTING(THRONE))GOTO 2087
	CALL PSPEAK(THRONE,1)
	CALL LOOKIN(THRONE)
	GOTO 2100
2087	IF(.NOT.TOTING(THRONE+1))GOTO 2090
	CALL PSPEAK(THRONE+1,1)
	CALL LOOKIN(THRONE+1)
	GOTO 2100

2090	IF(LOC.NE.311 .OR. .NOT.AT(BALL))GOTO 2100
	CALL BLKLIN
	CALL RSPEAK(586)
	CALL MOVE(BALL, 319)
	GOTO 2100

2009	SPK=54
2011	IF(OBJ.EQ.0 .OR. (OBJS(2).EQ.0 .AND. IOBJS(2).EQ.0))GOTO 2015
	CALL PSPEAK(OBJ,-1)
	INDLIN=.TRUE.
2015	CALL RSPEAK(SPK)
	INDLIN=.FALSE.
2100	RDFLAG=.FALSE.
	IF(OBJX.EQ.0)GOTO 2110
	OBJX=OBJX+1
	IF(OBJS(OBJX).EQ.0)OBJX=0
2110	IF(OBJX.GT.0 .AND. OBJS(OBJX).NE.0)GOTO 2120
	IF(IOBX.EQ.0)GOTO 2120
	IOBX=IOBX+1
	IF(IOBJS(IOBX).EQ.0)IOBX=0
	IF(IOBX.NE.0 .AND. OBJS(1).NE.0)OBJX=1

2120	IF(OBJX.GT.0 .OR. IOBX.GT.0)GOTO 2600
	IF(OBJS(1).NE.0)OBJX=1
	IF(IOBJS(1).NE.0)IOBX=1
	VRBX=VRBX+1
	IF(VERBS(VRBX).NE.0)GOTO 2600
2500	CALL CLRLIN
	RDFLAG=.TRUE.

C  CHECK IF THIS LOC IS ELIGIBLE FOR ANY HINTS.  IF BEEN HERE LONG ENOUGH,
C  BRANCH TO HELP SECTION (ON LATER PAGE).  HINTS ALL COME BACK HERE EVENTUALLY
C  TO FINISH THE LOOP.  IGNORE "HINTS" < HNTMIN (SPECIAL STUFF, SEE DATABASE
C  NOTES).

2600	HINT = HNTMIN
2601	IF (HINT .GT. HNTMAX) GOTO 2603
	IF(HINTED(HINT))GOTO 2602
	IF(.NOT.BITSET(LOCCON(LOC),HINT))HINTLC(HINT)=-1
	HINTLC(HINT)=HINTLC(HINT)+1
	IF(HINTLC(HINT).GE.HINTS(HINT,1))GOTO 40000
2602	HINT = HINT + 1
	GOTO 2601

C  KICK THE RANDOM NUMBER GENERATOR JUST TO ADD VARIETY TO THE CHASE.  ALSO,
C  IF CLOSING TIME, CHECK FOR ANY OBJECTS BEING TOTED WITH PROP < 0 AND SET
C  THE PROP TO -1-PROP.  THIS WAY OBJECTS WON'T BE DESCRIBED UNTIL THEY'VE
C  BEEN PICKED UP AND PUT DOWN SEPARATE FROM THEIR RESPECTIVE PILES.  DON'T
C  TICK CLOCK1 UNLESS WELL INTO CAVE (AND NOT AT Y2).

2603	IF(.NOT.CLOSED)GOTO 2605
	IF(PROP(OYSTER).LT.0 .AND. TOTING(OYSTER))
     1   	CALL PSPEAK(OYSTER,1)
	DO 2604 I=1,MAXOBJ
2604	IF(TOTING(I) .AND. PROP(I).LT.0)PROP(I)=-1-PROP(I)
2605	WZDARK=DARK(0)
	IF(KNFLOC.GT.0 .AND. KNFLOC.NE.LOC)KNFLOC=0
	I=RANINT(1)
	IF(.NOT.RDFLAG)GOTO 2608

C  GET A NEW INPUT CLAUSE, OR FINISH GETTING CURRENT ONE.

	CALL PARSE
	VRBX=1
	OBJX=0
	IF(OBJS(1).NE.0)OBJX=1
	IOBX=0
	IF(IOBJS(1).NE.0)IOBX=1
	RDFLAG=.TRUE.

C  EVERY INPUT, CHECK "FOOBAR" FLAG.  IF ZERO, NOTHING'S GOING ON.  IF POS,
C  MAKE NEG.  IF NEG, HE SKIPPED A WORD, SO MAKE IT ZERO.

2608	FOOBAR=MIN0(0,-FOOBAR)
	COMBO=MIN0(0,-COMBO)
	TURNS=TURNS+1
	IF(DEMO .AND. TURNS.GE.SHORT)GOTO 92800
C	IF(TURNS.EQ.3)CALL DATIME(XXD,XXT)
C	IF(TURNS.NE.45)GOTO 2609
C  SEE IF TIMER UUO HAS BEEN ZAPPED; IF SO, HE'S CHEATING.
C  FLUSHING THIS FOR NOW.  EATS CPU IN PA1050.  [D. LONG]
C	CALL DATIME(YYD,YYT)
C	IF(XXD.EQ.YYD .AND. XXT.EQ.YYT)SAVED=0
C2609	IF(TURNS.EQ.310 .AND. ABBNUM.NE.10000 .AND. .NOT.TERSE)
C	1	CALL RSPEAK(273)

C  CHECK MILESTONE ENTRIES

	DO 2615 I=1,MAXMIL
	IF (MILOBJ(I).EQ.0 .OR. MISCOR(I).NE.0) GOTO 2615
	IF (MILOBJ(I).EQ.1) GOTO 2612
	IF (MIPLPR(I).EQ.-1)GOTO 2611
	IF (MIPLPR(I).EQ.PROP(MILOBJ(I)))GOTO 2614
	GOTO 2615
2611	IF (TOTING(MILOBJ(I)))GOTO 2614
	GOTO 2615
2612	IF (LOC.NE.MIPLPR(I))GOTO 2615
2614	MISCOR(I)=1
2615	CONTINUE

C  BUMP ALL THE RIGHT CLOCKS FOR RECONNING BATTERY LIFE AND CLOSING.

	IF(BLTCLK.EQ.1) BLTCNT=0
	IF(BLTCLK.GT.0) BLTCLK=BLTCLK-1
	IF(LCLOCK.EQ.0) GOTO 2618
	LCLOCK = LCLOCK-1
	IF(LCLOCK.NE.0) GOTO 2618
	CALL REMOVE(OIL)
	PROP(BOTTLE)=1
	PLACE(OIL)=0
	IF (HERE(BOTTLE)) CALL RSPEAK(555)
2618	IF(PROP(GLIQ).EQ.0)  GOTO 2619
	PROP(GLIQ)=PROP(GLIQ)+1
	IF(PROP(GLIQ).NE.5)GOTO 2619
	PROP(GLIQ)=0
	CALL DSTROY(GLIQ)
2619	IF(MCLOCK.NE.0 .AND. MCLOCK.LT.4) MCLOCK=MCLOCK+1
	IF(MCLOCK.LT.4) GOTO 2620
	CALL RSPEAK(426)
	MCLOCK=-1
2620	IF(CLOSED)CLOCK3=CLOCK3-1
	IF(LOC.NE.115 .AND. LOC.NE.116 .AND. CLOCK3.EQ.0)CLOCK3=1
	IF(CLOCK3.EQ.-7)GOTO 93300
	IF(CLOCK3.NE.0)GOTO 2621
	PROP(PHONE)=0
	PROP(BOOTH)=0
	CALL RSPEAK(284)
2621	IF(TALLY.GT.0)GOTO 2622
	CLOCK1=CLOCK1-1
	IF(CLOCK1.NE.ICLK1-1)GOTO 2622
	CALL RSPEAK(582)
	CALL BLKLIN
2622	IF(CLOCK1.EQ.0)GOTO 90000
	IF(CLOCK1.LT.0)CLOCK2=CLOCK2-1
	IF(CLOCK2.EQ.0 .AND. AT(CHAIR))GOTO 20161
	IF(CLOCK2.EQ.0)GOTO 91000
	IF(PROP(LAMP).EQ.1)LIMIT=LIMIT-1
	IF(LIMIT.EQ.0)GOTO 92400
	IF(LIMIT.LT.0 .AND. OUTSID(LOC) .AND. 
     +     (.NOT.ATHAND(BATTER) .OR. PROP(BATTER).NE.0))GOTO 92600
	IF(LIMIT.LE.40)GOTO 92000


19999	VERB=VAL(VERBS(VRBX))
	OBJ=0
	IF(OBJX.NE.0)OBJ=OBJS(OBJX)
	IOBJ=0
	IF(IOBX.NE.0)IOBJ=IOBJS(IOBX)
	GOTO (2750,2700,4000,2710) CLASS(VERBS(VRBX))
2700	CALL BUG(22)

2710	SPK=VERB
	GOTO 2011

C  IT IS A MOTION VERB.  ANALYZE IT & LOOP TO 2, IF NOT DEAD.
2750	CALL TRAVL(VERB)
	IF(KILLED)GOTO 94100
	GOTO 3

C  ACTION VERB 'LEAVE' (DROP) HAS NO OBJECT.
3100	CALL BUG(29)



C  ANALYSE A VERB.
C 01-10	   TAKE  DROP   SAY  OPEN  NOTH CLOSE    ON   OFF  WAVE  CALM
C 11-20	   WALK  KILL  POUR   EAT DRINK   RUB THROW  QUIT  FIND INVEN
C 21-30	   FEED  FILL BLAST SCORE   FOO BRIEF  READ BREAK  WAKE SUSPD
C 31-40	   HOUR  YANK  WEAR   HIT ANSWR  BLOW LEAVE  YELL  DIAL  PLAY
C 41-50	   PICK   PUT  TURN   GET INSRT REMOV  BURN GRIPE  LOCK UNLOK
C 51-60	 HEALTH  LOOK COMBO SWEEP TERSE BOARD DISEM  GOTO  PUSH MELT
C 61-70    ROLL  SIT  KLARF CLICK WEIGH ABYSM

C  The rather brain-damaged jump table is included to get around
C  a limitation of the Unix FORTRAN compiler/assembler.

4000	SPK=ACTSPK(VERB)
	IF (OBJ.NE.0 .OR. IOBJ.NE.0)GOTO 4100

C  ANALYSE AN INTRANSITIVE VERB (IE, NO OBJECT GIVEN YET).

	GOTO(
     1    4001,4002,4003,4004,4005,4006,4007,4008,4009,4010,
     2    4011,4012,4013,4014,4015,4016,4017,4018,4019,4020,
     3    4021,4022,4023,4024,4025,4026,4027,4028,4029,4030,
     4    4031,4032,4033,4034,4035,4036,4037,4038,4039,4040,
     5    4041,4042,4043,4044,4045,4046,4047,4048,4049,4050,
     6    4051,4052,4053,4054,4055,4056,4057,4058,4059,4060,
     7    4061,4062,4063,4064,4065,4066,4067,4068)VERB
	CALL BUG(23)

4001	GOTO 10100
4002	GOTO 10000
4003	GOTO 10000
4004	GOTO 10400
4005	GOTO 2009
4006	GOTO 10400
4007	GOTO 20700
4008	GOTO 20800
4009	GOTO 20900
4010	GOTO 10000
4011	GOTO 2011
4012	GOTO 21200
4013	GOTO 11300
4014	GOTO 11400
4015	GOTO 11500
4016	GOTO 10000
4017	GOTO 10000
4018	GOTO 11800
4019	GOTO 10000
4020	GOTO 12000
4021	GOTO 10000
4022	GOTO 12200
4023	GOTO 12300
4024	GOTO 12400
4025	GOTO 12500
4026	GOTO 12600
4027	GOTO 10000
4028	GOTO 10000
4029	GOTO 10000
4030	GOTO 13000
4031	GOTO 13100
4032	GOTO 10100
4033	GOTO 10000
4034	GOTO 10000
4035	GOTO 13500
4036	GOTO 23600
4037	GOTO 3100
4038	GOTO 13800
4039	GOTO 10000
4040	GOTO 10000
4041	GOTO 10000
4042	GOTO 10000
4043	GOTO 10000
4044	GOTO 10100
4045	GOTO 10100
4046	GOTO 10100
4047	GOTO 10100
4048	GOTO 14800
4049	GOTO 10500
4050	GOTO 10500
4051	GOTO 25100
4052	GOTO 25200
4053	GOTO 25300
4054	GOTO 25400
4055	GOTO 25500
4056	GOTO 25600
4057	GOTO 25700
4058	GOTO 19000
4059	GOTO 10000
4060	GOTO 10000
4061	GOTO 10000
4062	GOTO 16200
4063	GOTO 16300
4064	GOTO 10000
4065	GOTO 16500
4066	GOTO 16600
4067	GOTO 16700
4068	GOTO 16800



C  ANALYSE A TRANSITIVE VERB.

4100	GOTO(
     1    4101,4102,4103,4104,4105,4106,4107,4108,4109,4110,
     2	  4111,4112,4113,4114,4115,4116,4117,4118,4119,4120,
     3	  4121,4122,4123,4124,4125,4126,4127,4128,4129,4130,
     4	  4131,4132,4133,4134,4135,4136,4137,4138,4139,4140,
     5	  4141,4142,4143,4144,4145,4146,4147,4148,4149,4150,
     6	  4151,4152,4153,4154,4155,4156,4157,4158,4159,4160,
     7	  4161,4162,4163,4164,4165,4166,4167,4168)VERB
	CALL BUG(24)

4101	GOTO 20100
4102	GOTO 20200
4103	GOTO 2060
4104	GOTO 20400
4105	GOTO 2009
4106	GOTO 20600
4107	GOTO 20700
4108	GOTO 20800
4109	GOTO 20900
4110	GOTO 2011
4111	GOTO 2011
4112	GOTO 21200
4113	GOTO 21300
4114	GOTO 21400
4115	GOTO 21500
4116	GOTO 21600
4117	GOTO 21700
4118	GOTO 2011
4119	GOTO 21900
4120	GOTO 21900
4121	GOTO 22100
4122	GOTO 22200
4123	GOTO 12300
4124	GOTO 22400
4125	GOTO 2011
4126	GOTO 22600
4127	GOTO 22700
4128	GOTO 22800
4129	GOTO 22900
4130	GOTO 2011
4131	GOTO 2011
4132	GOTO 23200
4133	GOTO 23300
4134	GOTO 23400
4135	GOTO 23500
4136	GOTO 23600
4137	GOTO 20200
4138	GOTO 2070
4139	GOTO 23900
4140	GOTO 24000
4141	GOTO 24100
4142	GOTO 24200
4143	GOTO 24300
4144	GOTO 24400
4145	GOTO 24500
4146	GOTO 24600
4147	GOTO 24700
4148	GOTO 2060
4149	GOTO 24900
4150	GOTO 25000
4151	GOTO 2060
4152	GOTO 25200
4153	GOTO 2070
4154	GOTO 25400
4155	GOTO 2060
4156	GOTO 25600
4157	GOTO 25700
4158	GOTO 19000
4159	GOTO 25800
4160	GOTO 25900
4161	GOTO 26000
4162	GOTO 26200
4163	GOTO 2011
4164	GOTO 26400
4165	GOTO 26500
4166	GOTO 2011
4167	GOTO 2011
4168	GOTO 2011



C  ROUTINES FOR PERFORMING THE VARIOUS ACTION VERBS

C  STATEMENT NUMBERS IN THIS SECTION ARE 10000 FOR INTRANSITIVE VERBS, 20000 FOR
C  TRANSITIVE, PLUS 100 TIMES THE VERB NUMBER.  MANY INTRANSITIVE VERBS USE THE
C  TRANSITIVE CODE, AND SOME VERBS USE CODE FOR OTHER VERBS, AS NOTED BELOW.

C  RANDOM INTRANSITIVE VERBS COME HERE.  CLEAR OBJ JUST IN CASE (SEE "ATTACK").

10000	CALL A5LCA1(VTXT(VRBX,1),VTXT(VRBX,2),'what?',C1ARR,K)
	WRITE (TTYOUT,10002) (C1ARR(I),I=1,K)
10002	FORMAT(20A1)
	OBJS(1)=0
	OBJX=0
	GOTO 2500


10010	CALL A5LCA1(VTXT(VRBX,1),VTXT(VRBX,2),'it?  ',C1ARR,K)
	WRITE (TTYOUT,10012) (C1ARR(I),I=1,K)
10012	FORMAT('Where do you want to ',20A1)
	GOTO 2500


C  CONSTRUCT MSG: "I DON'T KNOW HOW TO [VERB] THE [OBJ]", AND VARIANTS.

C TELEPORTATION FOR DEBUGGING

19000	SPK=485
	IF (.NOT.WIZARD) GOTO 2011
	IF (OBJ.EQ.0) GOTO 19010
	LOC = OBJ
19005	LOC = PLACE(LOC)
	IF (LOC.EQ.0 .OR. LOC.EQ.-1)  GOTO 19010
	IF (LOC.GT.0)  GOTO 19020
	LOC = - LOC
	GOTO 19005

19010	WRITE(TTYOUT, 19001)
19001	FORMAT('Where to, boss?  '$)
	READ (TTYIN, 19002) LOC
19002	FORMAT(I8)
	IF (LOC.EQ.0) GOTO 91001
19020	IF (TOTING(LAMP))  GOTO 2001
	CALL MOVE(LAMP, LOC)
	CALL CARRY(LAMP, LOC)
	PROP(LAMP)=1
	GOTO 2001


C  CARRY, NO OBJECT GIVEN YET.  OK IF ONLY ONE OBJECT PRESENT.

10100	IF(ATLOC(LOC).EQ.0 .OR. LINK(ATLOC(LOC)).NE.0 .OR. BLIND(0))
     1   	GOTO 10000
	DO 10110 I=1,DWFMAX-1
	IF(DLOC(I).EQ.LOC .AND. DFLAG.GE.2)GOTO 10000
10110	CONTINUE
	OBJ=ATLOC(LOC)
	IF(VERB.EQ.YANK)GOTO 23200
	IF(VERB.EQ.WEAR)GOTO 23300

C  CARRY AN OBJECT.  SPECIAL CASES FOR BIRD AND CAGE (IF BIRD IN CAGE, CAN'T
C  TAKE ONE WITHOUT THE OTHER.  LIQUIDS ALSO SPECIAL, SINCE THEY DEPEND ON
C  STATUS OF BOTTLE.  ALSO VARIOUS SIDE EFFECTS, ETC.
C  "YANK" AND "WEAR" ALSO WEAVE INTO THIS CODE, SINCE THEY ARE MOSTLY
C  JUST RESTRICTED CARRY'S.

20100	IF(OBJ.EQ.BOAT)SPK=281
	IF(PLURAL(OBJ))SPK=297
	IF(PREP.NE.PREPOF)GOTO 20104
	IF(OBJ.NE.0 .AND. IOBJ.NE.0)GOTO 2060
	IF(OBJ.EQ.0)OBJ=IOBJ
	IOBJ=0
	GOTO 20200

20104	IF(HOLDNG(OBJ))GOTO 2011
	ASSIGN 20106 TO RETN
	GOTO 20190

20106	IF(PREP.EQ.PREPIN)GOTO 24500
	IF(PREP.EQ.PREPFR .OR. ENCLSD(OBJ))GOTO 24600

C  THE NEXT LINES ARE FOR 'TAKING' LIQUIDS (WATER, OIL & WINE).
C  IF WE ARE HOLDING A CONTAINER (BOTTLE OR CASK), WE CAN TAKE THE
C  THE LIQUID BY FILLING THE CONTAINER.  IF THERE IS A CONTAINER NEARBY
C  HOLDING THE REQUESTED LIQUID, WE WILL PICK UP THE CONTAINER.

	IF(IOBJ.EQ.0)GOTO 20110
	SPK=313
	IF(OBJ.NE.CASK .AND. OBJ.NE.BOTTLE)GOTO 2011
	K=0
	IF(OBJ.EQ.CASK)K=1
	IOBJ=IOBJ+K
	IF(LIQ(OBJ).EQ.IOBJ)GOTO 20116
	SPK=302+K
	IF(PROP(OBJ).NE.1)GOTO 2011
	GOTO 20118

20110	SPK=71
	IF(OBJ.EQ.GLIQ)GOTO 2011
	IF(OBJ.NE.WATER .AND. OBJ.NE.OIL .AND. OBJ.NE.WINE)GOTO 20120
	IOBJ=OBJ
	K=0
	OBJ=BOTTLE
	IF(.NOT.HERE(BOTTLE))GOTO 20114
	IF(PROP(BOTTLE).NE.1)GOTO 20112
	IF(.NOT.HERE(CASK) .OR. (HERE(CASK) .AND. PROP(CASK).EQ.1))
     1   	GOTO 20118
	OBJ=0
	CALL RSPEAK(304)
	GOTO 2500

20112	IF(LIQ(BOTTLE).EQ.IOBJ)GOTO 20116
20114	SPK=312
	IF(.NOT.HERE(CASK))GOTO 2011
	OBJ=CASK
	K=1
	IF(PROP(CASK).EQ.1)GOTO 20118
	IF(LIQ(CASK).EQ.IOBJ)GOTO 20116
	SPK=315
	IF(.NOT.ATHAND(BOTTLE))SPK=303
	GOTO 2011

20116	IF(.NOT.HOLDNG(OBJ))GOTO 20120
	SPK=302+K
	GOTO 2011

20118	IF(HOLDNG(OBJ))GOTO 22200
	GOTO 20120
C  *** END OF LIQUID STUFF

C  'WEAR' AND 'YANK' WEAVE IN HERE.

20120	SPK=343
	IF(OBJ.EQ.BEAR .OR. BURDEN(0)+BURDEN(OBJ).LE.MAXCAR )GOTO 20125
	SPK=92
	IF(.NOT.WEARNG(OBJ))GOTO 2011
	PROP(OBJ)=0
	CALL BITOFF(OBJ,WEARBT)
	GOTO 2011

C  CLOAK.  BIG TROUBLE AHEAD.  CAN ONLY GET HERE VIA 'YANK'.
20125	IF(OBJ.NE.CLOAK .OR. PROP(CLOAK).NE.2)GOTO 20130
	PROP(ROCKS)=1
	PROP(CLOAK)=0
	FIXED(CLOAK)=0
	CALL CARRY(CLOAK,LOC)
	CALL RSPEAK(241)
	IF(AT(WUMPUS) .AND. PROP(WUMPUS).EQ.0)GOTO 22900
	GOTO 2100

C  POSTER: WILL HIDE SOMETHING EVENTUALLY.
20130	IF(OBJ.NE.POSTER)GOTO 20135
	PROP(POSTER)=1
	GOTO 20180

C  CRYSTAL BOX:  CAN'T TAKE IT IF IT'S SET INTO THE ROCK
20135	IF(OBJ.NE.BOX .OR. PROP(OBJ).NE.0) GOTO 20140
	SPK=588
	GOTO 2011

C  NUGGET:  SLIDES SLAB INTO STAIRS

20140	IF(OBJ.NE.NUGGET)GOTO 20150
	PROP(STEPS)=1
	KK=KEY(LOC)
	IF(KK.EQ.0)GOTO 20185
20145	NL=MOD(IABS(TRAVEL(KK)),10000)
	IF (NL.EQ.PLACE(STEPS) .OR. NL.EQ.FIXED(STEPS))SPK=492
	KK=KK+1
	IF(TRAVEL(KK-1).GE.0)GOTO 20145
	IF(AT(STEPS))SPK=491
	GOTO 20185

C  BOAT: NEED THE POLE TO PUSH IT
20150	IF(OBJ.NE.BOAT)GOTO 20155
	SPK=218
	IF(.NOT.TOTING(POLE) .AND. PLACE(POLE).NE.-BOAT)GOTO 2011
	PROP(BOAT)=1
	SPK=221
	GOTO 20180

C  THRONE: SIMILAR TO BOAT
20155	IF(OBJ.NE.THRONE .AND. OBJ.NE.THRONE+1)GOTO 20160
	SPK=522
	IF(PROP(THRONE).NE.0)GOTO 2011
	PROP(THRONE)=1
	PROP(THRONE+1)=1
	SPK=512
	GOTO 20180

C  DEVIL'S CHAIR:  SLIDE AWAY TO CATHEDRAL
20160	IF(OBJ.NE.CHAIR)GOTO 20165
	NEWLOC=210
	LOC=NEWLOC
	IF (TALLY.LE.0)GOTO 20162
	GOTO 3
20161	CALL RSPEAK(582)
20162	CALL SPEAK(LTEXT(210))
	CALL BLKLIN
	GOTO 91001

C  BIRD: GOT TO HAVE CAGE, BUT ROD CAN'T BE AROUND TO TAKE BIRD
20165	IF(OBJ.NE.BIRD)GOTO 20170
	SPK=24
	IF(ENCLSD(BIRD))GOTO 2011
	SPK=26
	IF(TOTING(ROD))GOTO 2011
	SPK=27
	IF(.NOT.HOLDNG(CAGE))GOTO 2011
	CALL INSERT(BIRD,CAGE)
	CALL BITOFF(CAGE,OPENBT)
	GOTO 2009

C  SWORD: IF IN ANVIL, NEEDS CROWN & MUST YANK.
20170	IF(OBJ.NE.SWORD .OR. PROP(SWORD).EQ.0)GOTO 20180
	IF(IOBJ.NE.0 .AND. IOBJ.NE.ANVIL)GOTO 2070

C  HE WANTS THE SWORD, BUT HASN'T ESTABLISHED HIS ROYAL BLOOD, OR HE
C  HASN'T PULLED HARD ENOUGH.  OR NEITHER.

	IF(WEARNG(CROWN))GOTO 20180
	IF(.NOT.YES(215,0,0))GOTO 2009
	CALL PSPEAK(SWORD,2)
	IF(CLOSED)GOTO 93000
	FIXED(SWORD)=-1
	PROP(SWORD)=3
	GOTO 2100

20180	IF(PROP(OBJ).GE.0)  GOTO 20185
	PROP(OBJ)=0
	TALLY=TALLY-1

20185	CALL CARRY(OBJ,LOC)
	IF(OBJ.EQ.POLE .OR. OBJ.EQ.SKEY .OR. OBJ.EQ.SWORD
     1   	 .OR. ((OBJ.EQ.CLOAK .OR. OBJ.EQ.RING)
     2   		.AND..NOT.WEARNG(OBJ)) )PROP(OBJ)=0
	IF(VERB.NE.YANK .OR. OBJ.EQ.SWORD)GOTO 2011
	SPK=204
	GOTO 2011


C  THIS IS A QUASI-SUBROUTINE, CALLED FROM 'TAKE' AND FROM 'INSERT', WHEN
C  THE ITEM IS NOT CURRENTLY BEING TOTED.  'RETN' IS A VARIABLE DEFINED
C  TO BE THE RETURN ADDRESS.

20190	SPK=NOWAY(0)
	IF(OBJ.EQ.PLANT .AND. PROP(PLANT).LE.0)SPK=115
	IF(OBJ.EQ.BEAR .AND. PROP(BEAR).EQ.1)SPK=169
	IF(OBJ.EQ.CHAIN .AND. PROP(BEAR).NE.0)SPK=170
	IF(OBJ.EQ.SWORD .AND. PROP(SWORD).EQ.5)SPK=208
	IF(OBJ.EQ.CLOAK .AND. PROP(CLOAK).EQ.2)SPK=242
	IF(OBJ.EQ.AXE .AND. PROP(AXE).EQ.2)SPK=246
	IF(OBJ.EQ.PHONE)SPK=251
	IF(OBJ.EQ.BEES .OR. OBJ.EQ.HIVE)SPK=295
	IF(OBJ.EQ.STICKS)SPK=296
	IF(OBJ.EQ.OYSTER .AND. CLOSED)SPK=412
	IF(OBJ.EQ.JUNK)SPK=590
	IF(FIXED(OBJ).NE.0)GOTO 2011
	GOTO RETN

C  DROP/DISCARD OBJECT.  "THROW" ALSO COMES HERE FOR MOST OBJECTS.
C  SPECIAL CASES FOR BIRD (MIGHT ATTACK SNAKE OR DRAGON) AND CAGE (MIGHT
C  CONTAIN BIRD) AND VASE/GLASS.
C  DROP COINS IN VENDING MACHINE FOR EXTRA BATTERIES.

20200	IF(HOLDNG(ROD2) .AND. OBJ.EQ.ROD .AND. .NOT.HOLDNG(ROD))OBJ=ROD2
	IF(PLURAL(OBJ))SPK=105
	K=LIQ(BOTTLE)
	IF(K.EQ.OBJ)OBJ=BOTTLE
	IF(OBJ.NE.BOTTLE)K=LIQ(CASK)
	IF(OBJ.NE.BOTTLE .AND. K.EQ.OBJ)OBJ=CASK
	IF(.NOT.TOTING(OBJ))GOTO 2011
	IF(PREP.EQ.PREPIN)GOTO 24500

20220	SPK=344
	IF(VERB.EQ.LEAVE)SPK=353
	IF(VERB.EQ.THROW)SPK=352
	IF(OBJ.EQ.BOAT)SPK=409
	IF(OBJ.EQ.THRONE .OR. OBJ.EQ.THRONE+1)SPK=513
	IF(VERB.EQ.TAKE)SPK=54
	IF(PREP.EQ.PRTHRU .OR. PREP.EQ.PREPDN)GOTO 20250
20225	IF(OBJ.NE.POLE .OR. .NOT.HOLDNG(BOAT))GOTO 20230
	SPK=280
	GOTO 2011

20230	IF(OBJ.NE.BIRD)GOTO 20240
	SPK=407
	IF(.NOT.HERE(SNAKE))GOTO 20235
	CALL RSPEAK(30)
	IF(CLOSED)GOTO 93000
	CALL REMOVE(BIRD)
	CALL DSTROY(SNAKE)
C  SET SNAKE PROP FOR USE BY TRAVEL OPTIONS
	PROP(SNAKE)=1
	CALL DROP(BIRD,LOC)
	GOTO 2100

20235	IF(.NOT.AT(DRAGON) .OR. PROP(DRAGON).NE.0) GOTO 20240
	CALL RSPEAK(154)
	CALL REMOVE(BIRD)
	CALL DSTROY(BIRD)
	IF(PLACE(SNAKE).EQ.PLAC(SNAKE))TALLY2=TALLY2+1
	GOTO 2100

C  NUGGET:  SLIDES SLAB INTO STAIRS

20240	IF(OBJ.NE.NUGGET)GOTO 20260
	PROP(STEPS)=0
	KK=KEY(LOC)
	IF(KK.EQ.0)GOTO 20260
20245	NL=MOD(IABS(TRAVEL(KK)),10000)
	IF (NL.EQ.PLACE(STEPS) .OR. NL.EQ.FIXED(STEPS))SPK=492
	KK=KK+1
	IF(TRAVEL(KK-1).GE.0)GOTO 20245
	IF(AT(STEPS))SPK=493
	GOTO 20260

20250	IF(AT(SLIT) .AND. OBJ.NE.MATCH)GOTO 20254
	IF(AT(WINDOW) .AND. .NOT.TINY(OBJ))GOTO 20254
	IF(LOC.EQ.126 .AND. OBJ.EQ.AMULET) GOTO 21740
	DO 20251 I = 1,NPAIRS
	NN = 2 * I
20251	IF (TOPBOT(NN-1).EQ.LOC)  GOTO 20252
	LDROP = 0
	GOTO 20253
20252	LDROP=TOPBOT(NN)
20253	IF (LDROP .NE. 0) GOTO 20255
	IF (PREP .EQ. PREPDN) GOTO 20225
	SPK=487
	GOTO 2011
20254	SPK=437
	GOTO 2011
20255	IF (OBJ.NE.VASE)  GOTO 20256
	PROP(VASE)=2
	FIXED(VASE)=-1
	GOTO 20290
20256	IF (OBJ.NE.GLASS)  GOTO 20257
	PROP(GLASS)=4
	FIXED(GLASS)=-1
	GOTO 20290
20257	IF (OBJ.EQ.HOOP)  PROP(HOOP)=2
	GOTO 20290

20260	IF(OBJ.NE.BEAR .OR. .NOT.AT(TROLL))GOTO 20265
	SPK=163
	CALL DSTROY(TROLL)
	CALL DSTROY(TROLL+MAXOBJ)
	CALL MOVE(TROLL2,PLAC(TROLL))
	CALL MOVE(TROLL2+MAXOBJ,FIXD(TROLL))
	CALL JUGGLE(CHASM)
	PROP(TROLL)=2
	GOTO 20280

20265	IF(OBJ.EQ.FLOWERS .AND. AT(BEES))GOTO 22171
	IF(OBJ.NE.BALL .OR. LOC.NE.314)GOTO 20270
	CALL MOVE(BALL, 319)
	SPK=578
	GOTO 2011

20270	IF(OBJ.NE.VASE .OR. LOC.EQ.PLAC(PILLOW))GOTO 20275
	PROP(VASE)=2
	IF(AT(PILLOW))PROP(VASE)=0
	CALL PSPEAK(VASE,PROP(VASE)+1)
	IF(PROP(VASE).NE.0)FIXED(VASE)=-1
	SPK=-1
	GOTO 20280

20275	IF(OBJ.NE.GLASS .OR. LOC.EQ.PLAC(PILLOW))GOTO 20280
	PROP(GLASS)=4
	IF(AT(PILLOW))PROP(GLASS)=2
	CALL PSPEAK(GLASS,PROP(GLASS)+1)
	IF(PROP(GLASS).NE.2)FIXED(GLASS)=-1
	SPK=-1
	GOTO 20280

20280	LDROP = LOC
20290	IF(WEARNG(OBJ) .OR. OBJ.EQ.POLE .OR. OBJ.EQ.BOAT)PROP(OBJ)=0
	IF(OBJ.NE.THRONE .AND. OBJECT.NE.THRONE+1) GOTO 20292
	PROP(THRONE)=0
	PROP(THRONE+1)=0
20292	IF(WEARNG(OBJ))CALL BITOFF(OBJ,WEARBT)
	IF(OBJ.EQ.POLE)PROP(BOAT)=0
	IF(ENCLSD(OBJ))CALL REMOVE(OBJ)
	IF(OBJ.EQ.NUGGET) PROP(STEPS)=0
	IF(OBJ.NE.THRONE .AND. OBJ.NE.THRONE+1)GOTO 20294
	PROP(THRONE)=0
	PROP(THRONE+1)=0
20294	CALL MOVE(OBJ,LDROP)
	IF (SPK .EQ. -1)  GOTO 2100
	GOTO 2011


C  OPEN/CLOSE/LOCK/UNLOCK: NO OBJECT GIVEN.
C  ASSUME VARIOUS THINGS IF PRESENT.

10400	SPK=403
	K=0
	DO 10410 I=1,MAXOBJ
	IF(.NOT.(HERE(I) .AND. HINGED(I)))GOTO 10410
	OBJ=I
	K=K+1
10410	CONTINUE
	IF(K.GT.1)GOTO 10000
	IF(OBJ.NE.0)GOTO 10520
	IF(VERB.EQ.LOCK .OR. VERB.EQ.UNLOCK)GOTO 2011
	GOTO 10000

10500	SPK=28
	K=0
	DO 10510 I=1,MAXOBJ
	IF(.NOT.(HERE(I) .AND. LOCKS(I)))GOTO 10510
	OBJ=I
	K=K+1
10510	CONTINUE
	IF(K.GT.1)GOTO 10000
	IF(OBJ.NE.0)GOTO 10520
	IF(VERB.EQ.LOCK .OR. VERB.EQ.UNLOCK)GOTO 2011
	GOTO 10000

10520	IF(VERB.EQ.LOCK)GOTO 24900
	IF(VERB.EQ.UNLOCK)GOTO 25000
	IF(VERB.EQ.SHUT)GOTO 20600

C  OPEN.   SPECIAL STUFF FOR OPENING CLAM/OYSTER.
C  THE FOLLOWING CAN BE OPENED WITHOUT A KEY:
C	CLAM/OYSTER, DOOR, PDOOR, BOTTLE, CASK, CAGE

20400	IF(OBJ.EQ.0)  GOTO 10400
	IF(.NOT.HINGED(OBJ))GOTO 2070
	SPK=336
	IF(AJAR(OBJ))GOTO 2011
	IF(LOCKS(OBJ) .OR. IOBJ.EQ.KEYS .OR. IOBJ.EQ.SKEY)GOTO 25000
	SPK=337
	IF(OBJ.EQ.DOOR)SPK=111
	IF(LOCKED(OBJ))GOTO 2011
	IF(OBJ.EQ.BOX .AND. PROP(BOX).EQ.0)GOTO 20450
	IF(OBJ.EQ.CLAM .OR. OBJ.EQ.OYSTER)GOTO 20410
	IF(OBJ.EQ.CAGE .AND. ENCLSD(BIRD))GOTO 20430
	CALL BITON(OBJ,OPENBT)
	GOTO 2009

C  CLAM/OYSTER.
20410	K=0
	IF(OBJ.EQ.OYSTER)K=1
	SPK=124+K
	IF(HOLDNG(OBJ))SPK=120+K
	IF(.NOT.ATHAND(TRIDNT) .AND. .NOT.ATHAND(CROWBR))SPK=122+K
	IF(IOBJ.NE.0 .AND. IOBJ.NE.TRIDNT .AND. IOBJ.NE.CROWBR)SPK=376+K
	IF(CLOSED .AND. SPK.EQ.125)GOTO 20420
	IF(SPK.NE.124)GOTO 2011
	CALL DSTROY(CLAM)
	CALL DROP(OYSTER,LOC)
	CALL DROP(PEARL,105)
	GOTO 2011

20420	PROP(OYSTER)=2
	CALL BITON(OBJ,OPENBT)
	LOCCON(LOC)=LOCCON(LOC)+BITS(3+1)
	SPK=411
	GOTO 2011

C  OPENING THE CAGE, RELEASES THE BIRD.

20430	SPK=407
	CALL BITON(OBJ,OPENBT)
	OBJ=BIRD
	GOTO 20230

C  OPENING THE BOX.  NOT POSSIBLE UNLESS REMOVED.

20450	SPK=589
	GOTO 2011

C  CLOSE.  SHUT.
C  THE FOLLOWING CAN BE CLOSED WITHOUT KEYS:
C	DOOR, PDOOR, BOTTLE, CASK, CAGE

20600	IF(OBJ.EQ.0)  GOTO 10400
	IF(.NOT.HINGED(OBJ))GOTO 2070
	SPK=413
	IF(OBJ.EQ.OYSTER .AND. PROP(OYSTER).EQ.2)GOTO 2011
	SPK=338
	IF(.NOT.AJAR(OBJ))GOTO 2011
	IF(LOCKS(OBJ))GOTO 24900
	CALL BITOFF(OBJ,OPENBT)
	GOTO 2009

C  LIGHT LAMP

20700	IF(OBJ.EQ.MATCH .OR. BURNS(OBJ))GOTO 24700
	IF(.NOT.TOTING(LAMP))GOTO 2011
	SPK=184
	IF(LIMIT.LT.0)GOTO 2011
	SPK=321
	IF(PROP(LAMP).EQ.1)GOTO 2011
	PROP(LAMP)=1
	K=39
	IF(LOC.EQ.200)K=108
	CALL RSPEAK(K)
	IF(WZDARK)GOTO 2000
	GOTO 2100

C  LAMP OFF

20800	IF(OBJ.EQ.BOTTLE)GOTO 20805
	IF(.NOT.ATHAND(LAMP))GOTO 2011
	SPK=322
	IF(PROP(LAMP).EQ.0)GOTO 2011
	PROP(LAMP)=0
	CALL RSPEAK(40)
	GOTO 20810

20805	IF (LCLOCK .EQ. 0 .OR. .NOT. ATHAND(BOTTLE)) GOTO 2011
	LCLOCK=0
	CALL RSPEAK(546)
20810	IF(DARK(0))CALL RSPEAK(16)
	GOTO 2100



C  WAVE.

20900	IF(OBJ.EQ.0 .OR. OBJ.EQ.HANDS)GOTO 20950
	SPK=29
	IF(.NOT.HOLDNG(OBJ) .AND. (OBJ.NE.ROD .OR. .NOT.HOLDNG(ROD2)))
     +     GOTO 2011
	SPK=42
	IF(OBJ.NE.ROD)GOTO 2011
	IF(PROP(FISSUR).EQ.0)SPK=503
	DO 20910 I=1,NPAIRS
	KBOT=2*I
20910	IF (TOPBOT(KBOT-1).EQ.LOC)  GOTO 20920
	GOTO 2011
20920	DO 20930 I=1,NPAIRS
	JBOT=2*I
20930	IF(TOPBOT(KBOT).EQ.TOPBOT(JBOT) .AND. JBOT.NE.KBOT) GOTO 20940
	GOTO 2011
20940	SPK=520
	IF(.NOT.AT(FISSUR)) GOTO 2011
	PROP(FISSUR)=1-PROP(FISSUR)
	CALL RSPEAK(508-PROP(FISSUR))
	IF(CHASE.EQ.0 .OR. PROP(FISSUR).NE.0)GOTO 2100

C  DEMISE OF THE WUMPUS.  CHAMP MUST HAVE JUST CROSSED BRIDGE.

	IF((LOC.EQ.17 .AND. OLDLOC.NE.27)
     1   	 .OR. (LOC.EQ.27 .AND. OLDLOC.NE.17))GOTO 2100
	CALL RSPEAK(244)
	CHASE=0
	CALL DROP(RING,209)
	CALL MOVE(WUMPUS,209)
	PROP(WUMPUS)=6
	FIXED(WUMPUS)=-1
	CALL BITON(WUMPUS,DEADBT)
	IF(PLACE(AXE).NE.PLAC(WUMPUS))GOTO 2100
	FIXED(AXE)=0
	PROP(AXE)=0
	GOTO 2100

20950	SPK=502
	IF(AT(FIGURE) .AND. .NOT.BLIND(0))SPK=501
	GOTO 2011


C  ATTACK.  ASSUME TARGET IF UNAMBIGUOUS.  "THROW" ALSO LINKS HERE.  ATTACKABLE
C  OBJECTS FALL INTO TWO CATEGORIES: ENEMIES (SNAKE, DWARF, ETC.)  AND OTHERS
C  (BIRD, CLAM).  AMBIGUOUS IF TWO ENEMIES, OR IF NO ENEMIES BUT TWO OTHERS.

C  KILL OBJ WITH IOBJ.

21200	IF(OBJ.EQ.BAR)GOTO 24245
	SPK=NOWAY(0)
	DO 21210 DWARFN=1,DWFMAX-1
	IF(DLOC(DWARFN).EQ.LOC .AND. DFLAG.GE.2)GOTO 21220
21210	CONTINUE
	DWARFN=0
21220	IF(OBJ.NE.0)GOTO 21240
	IF(DWARFN.NE.0)OBJ=DWARF
	IF(HERE(SNAKE))OBJ=OBJ*MAXOBJ+SNAKE
	IF(AT(DRAGON) .AND. PROP(DRAGON).EQ.0)OBJ=OBJ*MAXOBJ+DRAGON
	IF(AT(TROLL))OBJ=OBJ*MAXOBJ+TROLL
	IF(HERE(DOG))OBJ=OBJ*MAXOBJ+DOG
	IF(HERE(BEAR) .AND. PROP(BEAR).EQ.0)OBJ=OBJ*MAXOBJ+BEAR
	IF(HERE(WUMPUS) .AND. PROP(WUMPUS).NE.6)OBJ=OBJ*MAXOBJ+WUMPUS
	IF(HERE(ELVES))OBJ=OBJ*MAXOBJ+ELVES
	IF(OBJ.GT.MAXOBJ)GOTO 10000
	IF(OBJ.NE.0)GOTO 21240
C  CAN'T ATTACK BIRD BY THROWING AXE.
	IF(HERE(BIRD) .AND. VERB.NE.THROW)OBJ=BIRD
C  CLAM AND OYSTER BOTH TREATED AS CLAM FOR INTRANSITIVE CASE; NO HARM DONE.
	IF(HERE(CLAM) .OR. HERE(OYSTER))OBJ=MAXOBJ*OBJ+CLAM
	IF(OBJ.GT.MAXOBJ)GOTO 10000
21240	IF(OBJ.NE.BIRD)GOTO 21250
	SPK=137
	IF(CLOSED)GOTO 2011
	CALL DSTROY(BIRD)
	PROP(BIRD)=0
	IF(PLACE(SNAKE).EQ.PLAC(SNAKE))TALLY2=TALLY2+1
	SPK=45
21250	IF(OBJ.EQ.DWARF)GOTO 21270
	IF(OBJ.EQ.ELVES)GOTO 21280
	IF(OBJ.EQ.0)SPK=44
	IF(OBJ.EQ.CLAM .OR. OBJ.EQ.OYSTER)SPK=150
	IF(AT(DOG) .AND. PROP(DOG).EQ.1)SPK=291
	IF(OBJ.EQ.SNAKE)SPK=46
	IF(OBJ.EQ.DRAGON .OR. (OBJ.EQ.WUMPUS .AND. PROP(WUMPUS).EQ.6))SPK=167
	IF(OBJ.EQ.TROLL)SPK=157
	IF(OBJ.EQ.BEAR)SPK=165+(PROP(BEAR)+1)/2
	IF(IOBJ.NE.AXE .OR. VERB.EQ.THROW .OR. 
     1   	(OBJ.NE.DOG .AND. OBJ.NE.WUMPUS .AND. OBJ.NE.DRAGON
     2   	 .AND.OBJ.NE.TROLL))GOTO 21253
	IOBJ=OBJ
	OBJ=IOBJS(IOBX)
	GOTO 21700

21253	IF(OBJ.EQ.DRAGON .AND. PROP(DRAGON).EQ.0)GOTO 21254
	IF(IOBJ.NE.0 .AND. IOBJ.NE.AXE)GOTO 2070
	GOTO 2011

C  FUN STUFF FOR DRAGON.  IF HE INSISTS ON ATTACKING IT, WIN!  SET PROP TO DEAD,
C  MOVE DRAGON TO CENTRAL LOC (STILL FIXED), MOVE RUG THERE (NOT FIXED), AND
C  MOVE HIM THERE, TOO.  THEN DO A NULL MOTION TO GET NEW DESCRIPTION.
C  THERE IS SOME AMOUNT OF PAIN HERE, TO FORCE PARSE TO DO THE RIGHT THING.

21254	IF(IOBJ.EQ.HANDS)  GOTO 21255
	CALL RSPEAK(49)
	CALL GETLIN
	WDX=0
	CALL CLRLIN
	IF(TXT(1,1).EQ.'Y' .OR. TXT(1,1).EQ.'YES')GOTO 21255
	WORDS(1)=-2
	RDFLAG=.TRUE.
	GOTO 2600

21255	CALL PSPEAK(DRAGON,1)
	CALL BITON(DRAGON,DEADBT)
	PROP(DRAGON)=2
	PROP(RUG)=0
	K=(PLAC(DRAGON)+FIXD(DRAGON))/2
	CALL MOVE(DRAGON+MAXOBJ,-1)
	CALL MOVE(RUG+MAXOBJ,0)
	CALL MOVE(DRAGON,K)	
        CALL MOVE(RUG,K)
	DO 21260 OBJ=1,MAXOBJ
	IF(PLACE(OBJ).EQ.PLAC(DRAGON) .OR. PLACE(OBJ).EQ.FIXD(DRAGON))
     1   	CALL MOVE(OBJ,K)
21260	CONTINUE
	WORDS(1)=0
	LOC=K
	NEWLOC=K
	GOTO 3

C  HE IS ATTACKING A DWARF.  IF USING SOMETHING OTHER THAN AXE OR SWORD,
C  GOODBYE CHARLIE.  IF USING NOTHING, DON'T LET HIM.  IF USING AXE OR
C  SWORD, THE FOLLOWING ODDS PREVAIL (IF I CALCULATED THIS MESS RIGHT!)
C  (THE END OF LINE FIGURE IS THE CULULATIVE PROBABILITY OF THE EVENT):
C  .25 - HERO KILLS DWARF (.25)
C  .75 - HERO MISSES
C	.25 - HERO GETS KNIFE IN (HIS) RIBS.  DIES. (.1875)
C	.75 - HERO CAN'T MAKE A CLEAN THRUST
C		.36 - STANDOFF (.2)
C		.64 - DWARF SLASHES
C			.61 - DWARF MISSES! (.22)
C			.39 - DWARF KILLS HERO (.14)
C  ADVENTURER HAS 1/3 CHANCE OF GETTING NAILED, 1/4 CHANCE OF NAILING
C  DWARF.  ALL BY WAY OF ENCOURAGING HIM TO THROW THE AXE.

21270	IF(OBJ.EQ.DWARF .AND. CLOSED)GOTO 93000
	SPK=49
	IF(IOBJ.EQ.0)GOTO 2011
	SPK=355
	IF(IOBJ.NE.AXE .AND. IOBJ.NE.SWORD)GOTO 21275
	IF(PCT(25))GOTO 21753
	IF(PCT(25))GOTO 21275
	CALL RSPEAK(354)
	IF(PCT(36))GOTO 2100
	CALL RSPEAK(356)
	SPK=52
	IF(PCT(61))GOTO 2011
	SPK=53

C  HERO IS GONZO.
21275	IF (WEARNG(MAIL) .AND. PCT(60)) GOTO 21277
	CALL RSPEAK(SPK)
	OLDLC2=LOC
	GOTO 94100

21277	SPK=470
	GOTO 2011

C  ATTACKING ELVES

21280	PROP(ELVES)=PROP(ELVES)+2
	CALL PSPEAK(ELVES,PROP(ELVES)-1)
	IF (PROP(ELVES) .LT. 4)  GOTO 2100
	GOTO 94100


C  POUR.  IF NO OBJECT, ASSUME LIQ IN CONTAINER, IF HOLDING ONLY ONE.
C  SPECIAL TESTS FOR POURING WATER OR OIL ON PLANT OR RUSTY DOOR.

11300	IF(.NOT.HOLDNG(BOTTLE) .AND. .NOT.HOLDNG(CASK))GOTO 10000
	K=LIQ(BOTTLE)
	KK=LIQ(CASK)
	IF(HOLDNG(BOTTLE) .AND. K.NE.0 .AND. HOLDNG(CASK)
     1   	.AND.KK.NE.0)GOTO 10000
	IF(KK.EQ.0 .OR. .NOT.HOLDNG(CASK))  GOTO 11302
	OBJ=CASK
	OTXT(OBJX,1)='CASK'
	OTXT(OBJX,2)=' '
	GOTO 21300
11302	IF(K.EQ.0 .OR. .NOT.HOLDNG(BOTTLE))  GOTO 11304
	OBJ=BOTTLE
	OTXT(OBJX,1)='BOTTL'
	OTXT(OBJX,2)='E'
	GOTO 21300
11304	IF(OBJ.EQ.0)GOTO 10000

C  POUR OBJ FROM IOBJ.
21300	IF(OBJ.EQ.GLIQ .OR. OBJ.EQ.VIAL)GOTO 21370
	SPK=78
	IF(OBJ.NE.BOTTLE .AND. OBJ.NE.CASK)GOTO 21310
	IOBJ=OBJ
	OBJ=LIQ(IOBJ)
	SPK=316
	IF(OBJ.EQ.0)GOTO 2011
	GOTO 21320

21310	IF(OBJ.LT.WATER .OR. OBJ.GT.WINE+1)GOTO 2011
	SPK=29
	IF(.NOT.HOLDNG(BOTTLE) .AND. .NOT.HOLDNG(CASK))GOTO 2011
	IF(HOLDNG(BOTTLE) .AND. LIQ(BOTTLE).EQ.OBJ)IOBJ=BOTTLE
	IF(HOLDNG(CASK) .AND. LIQ(CASK).EQ.OBJ)IOBJ=CASK
	IF(IOBJ.EQ.0)GOTO 2011
21320	IF(AJAR(IOBJ)) GOTO 21322
	IF(LOCKED(IOBJ))GOTO 21335
	CALL BITON(IOBJ,OPENBT)
21322	IF(IOBJ.EQ.CASK)OBJ=OBJ+1
	PROP(IOBJ)=1
	CALL REMOVE(OBJ)
	PLACE(OBJ)=0
	SPK=77
	IF(IOBJ.NE.CASK)GOTO 21330
	OBJ=OBJ-1
	SPK=104
21330	IF(.NOT.(AT(PLANT) .OR. AT(DOOR) .OR. AT(SWORD)) .OR. 
     1   	AT(SWORD) .AND. PROP(SWORD).EQ.0)GOTO 2011

	IF(AT(DOOR))GOTO 21340
	IF(AT(SWORD))GOTO 21350
	SPK=112
	IF(OBJ.NE.WATER)GOTO 2011
	CALL RSPEAK(443+PROP(PLANT))
	PROP(PLANT)=MOD(PROP(PLANT)+1,3)
	PROP(PLANT2)=PROP(PLANT)
	NEWLOC=LOC
	GOTO 3

21334	CTLOC=OBJ
	GOTO 21336
21335	CTLOC=IOBJ
21336	SPK=335
	IF (AJAR(CTLOC)) SPK=545
	CALL RSPEAK(SPK)
	GOTO 2100

21340	PROP(DOOR)=0
	IF(OBJ.NE.OIL)GOTO 21341
	PROP(DOOR)=1
	CALL BITOFF(DOOR,LOCKBT)
	CALL BITON(DOOR,OPENBT)
21341	SPK=113+PROP(DOOR)
	GOTO 2011

C  IF SWORD IS ALREADY OILY, DON'T LET HIM CLEAN IT.  NO SOAP.

21350	IF(PROP(SWORD).EQ.5)GOTO 21360
	PROP(SWORD)=4
	IF(OBJ.NE.OIL)GOTO 21360
	PROP(SWORD)=5
	FIXED(SWORD)=-1
21360	SPK=206+PROP(SWORD)-4
	GOTO 2011

C  REMOVE GREEN LIQUID FROM VIAL

21370	SPK=316
	IF (PROP(VIAL).EQ.2) GOTO 2011
	PROP(VIAL) = 2
	CALL REMOVE(GLIQ)
	CALL DROP(GLIQ,LOC)
	PROP(GLIQ)=2
	FIXED(GLIQ)=-1
	CALL PSPEAK(GLIQ,1)
	GOTO 2000


C  EAT.  INTRANSITIVE: ASSUME EDIBLE IF PRESENT, ELSE ASK WHAT.  TRANSITIVE:
C  FOOD/MUSHROOMS/CAKES OK, SOME THINGS LOSE APPETITE, REST ARE RIDICULOUS.
C  IF HE HAS MORE THAN ONE EDIBLE, OR NONE, 'EAT' IS AMBIGUOUS WITHOUT
C  AN EXPLICIT OBJECT.

11400	K=0
	DO 11410 I=1,MAXOBJ
	IF(.NOT.(HERE(I) .AND. EDIBLE(I))) GOTO 11410
	K=K+1
	KK=I
11410	CONTINUE
	IF(K.NE.1)GOTO 10000
	OBJ=KK
	IF(OBJ.NE.FOOD .AND. OBJ.NE.HONEY)GOTO 21400
11420	IF(OBJ.EQ.HONEY)TALLY2=TALLY2+1
	CALL DSTROY(OBJ)
	SPK=72
	GOTO 2011

C  IF HE ATE THE RIGHT THING AND IS IN THE RIGHT PLACE, MOVE HIM TO
C  THE OTHER PLACE WITH ALL HIS JUNK.  OTHERWISE, NARKY MESSAGE.
21400	IF(OBJ.EQ.FOOD .OR. OBJ.EQ.HONEY)GOTO 11420
	IF(OBJ.EQ.BIRD .OR. OBJ.EQ.SNAKE .OR. OBJ.EQ.CLAM .OR. OBJ.EQ.OYSTER
     1   	 .OR. OBJ.EQ.FLOWER)SPK=301
	IF(OBJ.EQ.DWARF .OR. OBJ.EQ.DRAGON .OR. OBJ.EQ.TROLL
     1     .OR.OBJ.EQ.DOG .OR. OBJ.EQ.WUMPUS .OR. OBJ.EQ.BEAR)SPK=250
	IF(OBJ.NE.MUSHRM)GOTO 21450
	IF(.NOT.TOTING(OBJ)) CALL CARRY(OBJ,LOC)
	SPK=496
	IF(INSIDE(LOC))SPK=497
	IF(LOC.EQ.92)SPK=498
	IF(LOC.EQ.158)SPK=229
	IF(LOC.EQ.160 .OR. LOC.EQ.167 .OR. LOC.EQ.176)SPK=523
	IF(LOC.EQ.2)SPK=551
	KK=146
	IF(KK.EQ.LOC)KK=6
	CALL DROP(OBJ,KK)
	IF(SPK.EQ.496 .OR. SPK.EQ.498) GOTO 2011
	NEWLOC=159
	IF(SPK.EQ.497)NEWLOC=0
	IF(LOC.EQ.160)NEWLOC=158
	IF(LOC.EQ.167)NEWLOC=166
	IF(LOC.EQ.176)NEWLOC=8
	CALL RSPEAK(SPK)
	LOC=NEWLOC
	GOTO 3

21450	IF(OBJ.NE.CAKES)GOTO 2011
	IF(.NOT.TOTING(OBJ)) CALL CARRY(OBJ,LOC)
	SPK=42
	IF(LOC.NE.159)GOTO 2011
	CALL RSPEAK(230)
	CALL DROP(OBJ,159)
	NEWLOC=158
	LOC=NEWLOC
	GOTO 3


C  DRINK.  IF NO OBJECT, ASSUME WATER OR WINE AND LOOK FOR THEM HERE.
C  IF POTABLE IS IN BOTTLE OR CASK, DRINK THAT.  IF NOT, SEE IF THERE
C  IS SOMETHING DRINKABLE NEARBY (STREAM, LAKE, WINE FOUNTAIN, ETC.),
C  AND DRINK THAT.  IF HE HAS STUFF IN BOTH CONTAINERS, ASK WHICH.

C  DRINK OBJ FROM IOBJ
11500	LL=LIQLOC(LOC)
	IF(.NOT.ATHAND(BOTTLE) .AND. .NOT.ATHAND(CASK)
     1   	.AND.LL.NE.WINE .AND. LL.NE.WATER)GOTO 10000
	K=LIQ(BOTTLE)
	KK=LIQ(CASK)
	IF(.NOT.ATHAND(BOTTLE) .OR. K.EQ.0)GOTO 11520
	IF(ATHAND(CASK) .AND. KK.NE.0 .AND. KK.NE.K)GOTO 10000
	OBJ=K
	IOBJ=BOTTLE
	GOTO 21560

11520	IF(.NOT.ATHAND(CASK) .OR. KK.EQ.0)GOTO 11540
	OBJ=KK
	IOBJ=CASK
	GOTO 21560

11540	IF(LL.EQ.0)GOTO 10000
	OBJ=LL
	IOBJ=-1
	GOTO 21560

21500	IF(OBJ.EQ.0 .AND. (IOBJ.EQ.BOTTLE .OR. IOBJ.EQ.CASK))OBJ=LIQ(IOBJ)
	SPK=110
	IF(OBJ.EQ.OIL)SPK=301
	IF(OBJ.NE.WATER .AND. OBJ.NE.WINE)GOTO 2011
	IF(IOBJ.NE.0)GOTO 21560
	IF(OBJ.EQ.LIQLOC(LOC))IOBJ=-1
	IF(ATHAND(CASK) .AND. OBJ.EQ.LIQ(CASK))IOBJ=CASK
	IF(ATHAND(BOTTLE) .AND. OBJ.EQ.LIQ(BOTTLE))IOBJ=BOTTLE
21560	SPK=73
	IF(IOBJ.EQ.-1)GOTO 21570
	IF(IOBJ.EQ.CASK)OBJ=OBJ+1
	CALL REMOVE(OBJ)
	PLACE(OBJ)=0
	PROP(IOBJ)=1
	SPK=74
	IF(IOBJ.EQ.CASK)SPK=299
21570	IF(OBJ.EQ.WATER .OR. OBJ.EQ.WATER+1)GOTO 2011

C  UH-OH.  HE'S A WINO.  LET HIM REAP THE REWARDS OF INCONTINENCE.
C  HE'LL WANDER AROUND FOR AWHILE, THEN WAKE UP SOMEWHERE OR OTHER,
C  HAVING DROPPED MOST OF HIS STUFF.

	CALL RSPEAK(300)
	IF(PROP(LAMP).EQ.1)LIMIT=LIMIT-RANINT(LIMIT)/2
	IF(LIMIT.LT.10)LIMIT=25
	NEWLOC=174
	IF (PCT(50)) NEWLOC=250
	DO 21580 J=1,MAXOBJ
	IF(J .EQ. AXE .OR. J .EQ. LAMP) GOTO 21580
	IF(.NOT.WEARNG(J))GOTO 21576
	PROP(J) = 0
	CALL BITOFF(J,WEARBT)
21576	IF(J.NE.RING .OR. .NOT.ATHAND(RING)) GOTO 21577
	CALL DROP(RING,209)
	PROP(RING)=0
	CALL RSPEAK(476)
	GOTO 21580
21577	IF(J.EQ.NUGGET)PROP(STEPS)=0
	IF(J.NE.THRONE .AND. J.NE.THRONE+1)GOTO 21578
	PROP(THRONE)=0
	PROP(THRONE+1)=0
21578	IF(HOLDNG(J))CALL DROP(J,LOC)
21580	CONTINUE
	LOC=NEWLOC
	GOTO 3

C  RUB.  YIELDS VARIOUS SNIDE REMARKS.

21600	IF(OBJ.EQ.RING)GOTO 21610
	IF(OBJ.EQ.ELEPH)GOTO 21630
	IF(OBJ.NE.LAMP)SPK=76
	GOTO 2011

21610	IF(WEARNG(RING))GOTO 21620
	SPK=29
	IF(.NOT. TOTING(RING)) GOTO 2011
	CALL RSPEAK(475)
21615	CALL DROP(RING,209)
	PROP(RING)=0
	GOTO 2100
21620	CALL DROP(RING,209)
	IF(TOTING(BALL)) CALL DROP(BALL,LOC)
	CALL RSPEAK(476)
	PROP(RING)=0
	CALL BITOFF(RING,WEARBT)
	NEWLOC=250
	LOC=NEWLOC
	GOTO 3

21630	SPK=557
	GOTO 23605


C  THROW OBJ AT IOBJ.
C  SAME AS DISCARD UNLESS AXE.  THEN SAME AS ATTACK EXCEPT IGNORE BIRD,
C  AND IF DWARF IS PRESENT THEN ONE MIGHT BE KILLED.
C  AXE ALSO SPECIAL FOR DRAGON, BEAR, DOG, WUMPUS, ELVES AND TROLL.
C  TORCH, AMULET ARE SPECIAL ALSO.
C  TREASURES SPECIAL FOR TROLL.
C  IF THROWING FOOD AT SOMEONE WHO MIGHT BE HUNGRY, GO FEED HIM.

21700	SPK=29
	IF(PREP.EQ.PREPDN)GOTO 20200
	IF(HOLDNG(ROD2) .AND. OBJ.EQ.ROD .AND. .NOT.HOLDNG(ROD))OBJ=ROD2
	IF(.NOT.HOLDNG(OBJ))GOTO 2011
	IF(OBJ.EQ.BOAT .OR. OBJ.EQ.BEAR)GOTO 2070
	IF(OBJ.EQ.AMULET .AND. LOC.EQ.126)GOTO 21740
	IF(OBJ.EQ.TORCH .AND. (HERE(ROD2) .OR. (PLACE(ROD2).EQ.115 .AND. 
     1   	LOC.EQ.116) .OR. (PLACE(ROD2).EQ.116 .AND. LOC.EQ.115)))
     2   	GOTO 12310
	DWARFN=0
	IF(IOBJ.NE.0)GOTO 21750

C  NO INDIRECT OBJ WAS SPECIFIED.  IF A DWARF IS PRESENT, ASSUME IT
C  IS THE IOBJ.  IF NOT, LOOK FOR ANY OTHER LIVING THING.  IF NO LIVING
C  THINGS PRESENT, TREAT 'THROW' AS 'DROP'.

	DO 21710 DWARFN=1,DWFMAX-1
	IF(DLOC(DWARFN).EQ.LOC .AND. DFLAG.GE.2)GOTO 21718
21710	CONTINUE
	DWARFN=0

C  NO DWARVES PRESENT; FIGURE OUT PLAUSIBLE OBJECT.

	K=0
	DO 21715 I=1,MAXOBJ
	IF(.NOT. (AT(I) .AND. LIVING(I)) )GOTO 21715
	IOBJ=I
	K=K+1
21715	CONTINUE
	IF(K.EQ.0)GOTO 20200

C  IT IS A BEASTIE OF SOME SORT.  IS THERE MORE THAN ONE?
C  DON'T KILL THE BIRD BY DEFAULT.

21717	IF(K.EQ.1)GOTO 21718
	CALL RSPEAK(43)
	GOTO 2500

21718	IF(IOBJ.EQ.BIRD)GOTO 20200
	IF(TREASR(OBJ) .AND. AT(TROLL))IOBJ=TROLL
	GOTO 21750

C  THROWING AMULET AT RIGHT PLACE

21740	CALL MOVE(AMULET,299,0)
	CALL MOVE(SCROLL,LOC,0)
	CALL RSPEAK(455)
C	CALL DISMIS(3)
	SPK=456
	GOTO 2011

21750	IF(TREASR(OBJ) .AND. IOBJ.EQ.TROLL)GOTO 21790
	IF(OBJ.EQ.SWORD .OR. OBJ.EQ.BOTTLE)GOTO 22800
	IF(DWARFN.NE.0)IOBJ=DWARF
	IF(EDIBLE(OBJ) .AND. LIVING(IOBJ))GOTO 22100
	IF(OBJ.NE.AXE)GOTO 20200
	SPK=152
	IF(IOBJ.EQ.DRAGON .AND. PROP(DRAGON).EQ.0)GOTO 21755
	SPK=158
	IF(IOBJ.EQ.TROLL)GOTO 21755
	IF(IOBJ.NE.DWARF)GOTO 21760
	SPK=48
C  IF SAVED NOT = -1, HE BYPASSED THE "START" CALL.
	IF(RANINT(3).EQ.0 .OR. SAVED.NE.-1)GOTO 21755
	IF(DWARFN.NE.0)GOTO 21753
	DO 21752 DWARFN=1,DWFMAX-1
	IF(DLOC(DWARFN).EQ.LOC .AND. DFLAG.GE.2)GOTO 21753
21752	CONTINUE
C  'ATTACK' WITH AXE OR SWORD LINKS IN HERE.
21753	DSEEN(DWARFN)=.FALSE.
	DLOC(DWARFN)=0
	SPK=47
	DKILL=DKILL+1
	IF(DKILL.EQ.1)SPK=149
21755	CALL RSPEAK(SPK)
	CALL DROP(AXE,LOC)
	NEWLOC=LOC
	GOTO 3

C  THIS'LL TEACH HIM TO THROW THE AXE AT THE BEAR!
21760	IF(IOBJ.NE.BEAR .OR. PROP(BEAR).NE.0)GOTO 21765
	SPK=164
	CALL DROP(AXE,LOC)
	FIXED(AXE)=-1
	PROP(AXE)=1
	CALL JUGGLE(BEAR)
	GOTO 2011

C  OR THE WUMPUS!
21765	IF(IOBJ.NE.WUMPUS .OR. PROP(WUMPUS).EQ.6)GOTO 21770
	IF(PROP(WUMPUS).EQ.6)GOTO 20200
	SPK=245
	PROP(AXE)=2
	IF(PROP(WUMPUS).EQ.0)GOTO 21780
	SPK=243
	CALL DSTROY(AXE)
	GOTO 2011

C  OR THE NICE DOGGIE!
21770	IF(IOBJ.NE.DOG .OR. PROP(DOG).EQ.1)GOTO 21790
	SPK=248
	PROP(AXE)=3
21780	CALL DROP(AXE,LOC)
	FIXED(AXE)=-1
	CALL JUGGLE(IOBJ)
	GOTO 2011

C  SNARF A TREASURE FOR THE TROLL.
21790	IF(IOBJ.NE.TROLL)GOTO 21795
	PREP=0
	IF(OBJ.EQ.CASK .AND. LIQ(CASK).NE.WINE)GOTO 20200
	SPK=159
	IF(OBJ.EQ.NUGGET)PROP(STEPS)=0
	CALL DROP(OBJ,0)
	IF(OBJ.EQ.CASK)PLACE(WINE+1)=0
	CALL MOVE(TROLL,0)
	CALL MOVE(TROLL+MAXOBJ,0)
	CALL DROP(TROLL2,PLAC(TROLL))
	CALL DROP(TROLL2+MAXOBJ,FIXD(TROLL))
	CALL JUGGLE(CHASM)
	GOTO 2011

C	AT ELVES

21795	IF(IOBJ.NE.ELVES)GOTO 21797
	CALL PSPEAK(ELVES, 3)
	GOTO 94100

C  THROWING AXE AT NONE OF THE ABOVE.  ASSUME 'ATTACK'.
21797	OBJ=IOBJ
	IOBJ=OBJS(OBJX)
	GOTO 21200

C  QUIT.  INTRANSITIVE ONLY.  VERIFY INTENT AND EXIT IF THAT'S WHAT HE WANTS.

11800	GAVEUP=YES(22,54,54)
11850	IF(GAVEUP)GOTO 95000
	GOTO 2100

C  FIND.  MIGHT BE CARRYING IT, OR IT MIGHT BE HERE.  ELSE GIVE CAVEAT.

21900	IF(AT(OBJ) .OR. (LIQ(BOTTLE).EQ.OBJ .AND. AT(BOTTLE))
     1   	 .OR. K.EQ.LIQLOC(LOC))SPK=94
	DO 21920 I=1,DWFMAX-1
21920	IF(DLOC(I).EQ.LOC .AND. DFLAG.GE.2 .AND. OBJ.EQ.DWARF)SPK=94
	IF(CLOSED)SPK=138
	IF(ATHAND(OBJ))SPK=24
	GOTO 2011



C  INVENTORY.  IF OBJECT, TREAT SAME AS FIND.  ELSE REPORT ON CURRENT BURDEN.
C  THERE ARE SOME FUNNY CASES, LIKE THE WEARABLE THINGS.  ALSO, BOAT
C  AND BEAR, WHICH AREN'T REALLY CARRIED.  LIST OUTER-LEVEL CONTAINERS
C  AND CONTENTS, IF CONTAINER IS OPEN OR TRANSPARENT.

12000	SPK=98
	DO 12050 I=1,MAXOBJ
	IF(I.EQ.BEAR .OR. I.EQ.BOAT .OR. I.EQ.THRONE .OR. I.EQ.THRONE+1
     +	   .OR..NOT.HOLDNG(I))GOTO 12050
	IF(WEARNG(I))GOTO 12050
	IF(SPK.EQ.98)CALL RSPEAK(99)
	CALL PSPEAK(I,-1)
	SPK=0
	IF(I.NE.BOAT)CALL LOOKIN(I)
12050	CONTINUE

C  TELL HIM WHAT HE IS WEARING.

	K=0
	INDLIN=.TRUE.
	DO 12060 I=1,MAXOBJ
	IF(.NOT.WEARNG(I))GOTO 12060
	IF(K.EQ.0)WRITE(TTYOUT,12052)
12052	FORMAT('You are wearing:')
	CALL PSPEAK(I,-1)
	K=-1
12060	CONTINUE
	INDLIN=.FALSE.

	IF(.NOT.HOLDNG(BOAT))GOTO 12090
	CALL RSPEAK(221)
	CALL LOOKIN(BOAT)
12090	IF(.NOT.HOLDNG(THRONE))GOTO 12092
	CALL RSPEAK(512)
	CALL LOOKIN(THRONE)
12092	IF(.NOT.HOLDNG(THRONE+1))GOTO 12094
	CALL RSPEAK(512)
	CALL LOOKIN(THRONE+1)
12094	IF(HOLDNG(BEAR))SPK=141
	GOTO 2011

C  FEED.  IF BIRD, NO SEED.  SNAKE, DRAGON, TROLL: QUIP.  IF DWARF, MAKE HIM
C  MAD.  BEAR, SPECIAL.

C  CASE 1: FEED CRITTER.   *OR*
C  CASE 2: FEED CRITTER EDIBLE.
C	 [** THIS CASE TRANSFORMED BY PARSER INTO CASE 3 **]
C  CASE 3: FEED EDIBLE TO CRITTER.

22100	IF(IOBJ.NE.0 .AND. LIVING(IOBJ))GOTO 22120
	SPK=100
	IF(OBJ.EQ.BIRD)GOTO 2011
	IF(.NOT.LIVING(OBJ))GOTO 2070

C  SEE IF THERE IS ANYTHING EDIBLE AROUND HERE.
	KK=0
	K=0
	DO 22110 I=1,MAXOBJ
	IF(.NOT.HERE(I) .OR. .NOT.EDIBLE(I))GOTO 22110
	K=K+1
	KK=I
22110	CONTINUE
	IOBJ=OBJ
	OBJ=KK
	IF(K.EQ.1 .OR. DEAD(IOBJ))GOTO 22120
	CALL A5LCA1(OTXT(OBJX,1),OTXT(OBJX,2),'?    ',C1ARR,K)
	WRITE (TTYOUT,22112) (C1ARR(I),I=1,K)
22112	FORMAT ('What do you want to feed the ',20A1)
	OBJS(1)=0
	OBJX=0
	GOTO 2500

C  FEED OBJ TO IOBJ.
22120	IF(IOBJ.NE.SNAKE .AND. IOBJ.NE.DRAGON .AND. IOBJ.NE.TROLL)GOTO 22130
	SPK=102
	IF(IOBJ.EQ.DRAGON .AND. PROP(DRAGON).NE.0)SPK=NOWAY(0)
	IF(IOBJ.EQ.TROLL)SPK=182
	IF(IOBJ.NE.SNAKE .OR. CLOSED .OR. OBJ.NE.BIRD)GOTO 2011
	SPK=101
	CALL DSTROY(BIRD)
	PROP(BIRD)=0
	TALLY2=TALLY2+1
	GOTO 2011

C  FEED DWARF?
22130	IF(IOBJ.NE.DWARF)GOTO 22140
	SPK=103
	DFLAG=DFLAG+1
	GOTO 2011

C  FEED BEAR?
22140	SPK=102
	IF(IOBJ.NE.BEAR)GOTO 22150
	IF(PROP(BEAR).EQ.3)SPK=NOWAY(0)
	IF(PROP(BEAR).EQ.1 .OR. PROP(BEAR).EQ.2)SPK=264
	IF(OBJ.EQ.FOOD)SPK=278
	IF(OBJ.NE.HONEY)GOTO 2011
	PROP(BEAR)=1
	FIXED(AXE)=0
	PROP(AXE)=0
	SPK=168
	CALL DSTROY(HONEY)
	GOTO 2011

C  FEED DOG?
22150	IF(IOBJ.NE.DOG)GOTO 22160
	IF(PROP(DOG).EQ.1)SPK=291
	IF(OBJ.NE.FOOD .OR. PROP(DOG).EQ.1)GOTO 2011
	SPK=249
	CALL DSTROY(FOOD)
	GOTO 2011

C  FEED WUMPUS?
22160	IF(IOBJ.NE.WUMPUS)GOTO 22170
	IF(PROP(WUMPUS).EQ.6)SPK=326
	IF(PROP(WUMPUS).EQ.0)SPK=327
	IF(OBJ.EQ.FOOD)SPK=240
	GOTO 2011

C  FEED BEES?
22170	IF(IOBJ.NE.BEES .OR. OBJ.NE.FLOWER)GOTO 2070
22171	IF(ENCLSD(FLOWER))CALL REMOVE(FLOWER)
	CALL DROP(FLOWER,LOC)
	FIXED(FLOWER)=-1
	PROP(FLOWER)=1
	CALL DROP(HONEY,LOC)
	CALL JUGGLE(HONEY)
	SPK=267
	PROP(HIVE)=1
	GOTO 2011

C  FILL.  BOTTLE/CASK MUST BE EMPTY, AND SOME LIQUID AVAILABLE.
C  (VASE IS NASTY & GRAIL IS CRACKED.)
12200	IF( (.NOT.HERE(BOTTLE) .AND. .NOT.HERE(CASK)) .OR.
     1   	(HERE(BOTTLE) .AND. HERE(CASK)) )GOTO 10000
	IF(PROP(CASK).EQ.1 .AND. HERE(CASK))OBJ=CASK
	IF(PROP(BOTTLE).EQ.1 .AND. HERE(BOTTLE))OBJ=BOTTLE
	IF(OBJ.EQ.0)GOTO 10000

C  FILL OBJ WITH IOBJ
22200	SPK=313
	IF(.NOT.VESSEL(OBJ))GOTO 2011
	IF(.NOT.AJAR(OBJ))GOTO 21334
	IF(IOBJ.EQ.0)IOBJ=LIQLOC(LOC)
	IF(OBJ.NE.BOTTLE .AND. OBJ.NE.CASK)GOTO 22220
	K=0
	IF(OBJ.EQ.CASK)K=1
	SPK=304+K
	IF(IOBJ.EQ.0)GOTO 2011
	SPK=302+K
	IF(LIQ(OBJ).NE.0)GOTO 2011
	SPK=378+K
	IF(IOBJ.LT.WATER .OR. IOBJ.GT.WINE+1)GOTO 2011
	SPK=306+K
	IF(IOBJ.EQ.OIL)SPK=308+K
	IF(IOBJ.EQ.WINE)SPK=310+K
	PROP(OBJ)=MOD(LOCCON(LOC),8)/2*2
	PLACE(IOBJ+K)=-1
	CALL INSERT(IOBJ+K,OBJ)
	GOTO 2011

C  VASE.  (NASTY).
22220	IF(OBJ.NE.VASE)GOTO 22230
	SPK=144
	IF(IOBJ.EQ.0 .OR. .NOT.HOLDNG(VASE))GOTO 2011
	CALL RSPEAK(145)
	PROP(VASE)=2
	FIXED(VASE)=-1
	GOTO 20290

C  GRAIL OR OTHER.
22230	SPK=339
	IF(OBJ.EQ.GRAIL)SPK=298
	GOTO 2011

C  BLAST.  NO EFFECT UNLESS YOU'VE GOT DYNAMITE, WHICH IS A NEAT TRICK!

12300	IF(.NOT.(HERE(ROD2) .OR. (LOC.EQ.115 .AND. PLACE(ROD2).EQ.116)
     1   	 .OR. (LOC.EQ.116 .AND. PLACE(ROD2).EQ.115)))GOTO 2011
	SPK=14
	GOTO 2011

C  WEAVE INTO HERE FROM THROW.

12310	BONUS=133
	IF(LOC.EQ.115)BONUS=134
12350	IF(HERE(ROD2))BONUS=135
	CALL RSPEAK(BONUS)
	GOTO 95000

C  SCORE.

12400	SCORNG=.TRUE.
	SCORE=RATING(MXSCOR,BONUS,GAVEUP,SCORNG,CLOSNG,CLOSED)
	SCORNG=.FALSE.
	WRITE (TTYOUT,12412) SCORE,MXSCOR
12412	FORMAT('If you were to quit now, you would score',I4,' out of a possible',I4,'.')
	GOTO 2100

C  APPRAISE AN OBJECT

22400	PTS=POINTS(OBJ)/1000
	SPK=527+PTS
	IF (OBJ.EQ.AMULET) SPK=533
	IF (OBJ.EQ.BALL) SPK=577
	IF (OBJ.EQ.CASK .AND. PROP(CASK).NE.4) SPK=193
	GOTO 2011

C  FEE FIE FOE FOO (AND FUM).  ADVANCE TO NEXT STATE IF GIVEN IN PROPER ORDER.
C  LOOK UP WD1 IN SECTION 3 OF VOCAB TO DETERMINE WHICH WORD WE'VE GOT.  LAST
C  WORD ZIPS THE EGGS BACK TO THE GIANT ROOM (UNLESS ALREADY THERE).

12500	K=VOCAB(VTXT(VRBX,1),4)
	SPK=42
	IF(FOOBAR.EQ.1-K)GOTO 12520
	IF(FOOBAR.NE.0)SPK=151
	GOTO 2011

12520	FOOBAR=K
	IF(K.NE.4)GOTO 2009
	FOOBAR=0
	IF(PLACE(EGGS).EQ.PLAC(EGGS)
     1   	 .OR. (TOTING(EGGS) .AND. LOC.EQ.PLAC(EGGS)))GOTO 2011
C  BRING BACK TROLL IF WE STEAL THE EGGS BACK FROM HIM BEFORE CROSSING.
	IF(PLACE(EGGS).EQ.0 .AND. PLACE(TROLL).EQ.0 .AND. PROP(TROLL).EQ.0)
     1   	PROP(TROLL)=1
	K=2
	IF(HERE(EGGS))K=1
	IF(LOC.EQ.PLAC(EGGS))K=0
	CALL MOVE(EGGS,PLAC(EGGS))
	IF (TEETER(LOC)) GOTO 12540
12530	CALL PSPEAK(EGGS,K)
	GOTO 2100

12540	NEWLOC=LOC
	IF (NEWLOC.EQ.312 .OR. NEWLOC.EQ.315)  GOTO 12550
	IF (NEWLOC.GE.311 .AND. NEWLOC.LE.318) CALL RSPEAK(562)
	GOTO 2

12550	CALL RSPEAK(563)
	GOTO 94100

C  BRIEF/UNBRIEF.  INTRANSITIVE ONLY.
C  SUPPRESS LONG DESCRIPTIONS AFTER FIRST TIME.

12600	DETAIL=1
	TERSE=.FALSE.
	IF(ABBNUM.EQ.10000)GOTO 12610
	SPK=156
	ABBNUM=10000
	GOTO 2011

12610	ABBNUM=5
	SPK=374
	GOTO 2011

22600	IF(OBJ.NE.0 .AND. LIVING(OBJ) .AND. IOBJ.NE.0)GOTO 2011
	GOTO 2060

C  READ.  MAGAZINES IN DWARVISH, MESSAGE WE'VE SEEN, AND . . . OYSTER?

22700	SPK=504
22701	IF(BLIND(0))GOTO 2011
	IF(OBJ.NE.0 .AND. IOBJ.NE.0)GOTO 2060
	IF(OBJ.EQ.0)OBJ=IOBJ
	IF(OBJ.EQ.AMULET)SPK=451
	IF(OBJ.EQ.BALL)GOTO 22730
	IF(OBJ.EQ.BAR)SPK=587
	IF(OBJ.EQ.BELT)SPK=541
	IF(OBJ.EQ.BELT .AND. BLTCNT.EQ.3)SPK=542
	IF(OBJ.EQ.BELT .AND. BLTCNT.GE.4)SPK=543
	IF(OBJ.EQ.BILL)SPK=467
	IF(OBJ.EQ.BILLBD)GOTO 22710
	IF(OBJ.EQ.BOOK)SPK=526
	IF(OBJ.EQ.BOOK .AND. AJAR(OBJ))SPK=142
	IF(OBJ.EQ.CARVNG)SPK=372
	IF(OBJ.EQ.CHEST)SPK=558
	IF(OBJ.EQ.CLIFF .AND. PROP(CLIFF).EQ.0 .AND. LOC.EQ.258)SPK=434
	IF(OBJ.EQ.CLIFF .AND. PROP(CLIFF).EQ.0 .AND. LOC.EQ.259)SPK=438
	IF(OBJ.EQ.DIALS)GOTO 22750
	IF(OBJ.EQ.ELEPH)SPK=474
	IF(OBJ.EQ.FIGURE)SPK=500
	IF(OBJ.EQ.LETTER)GOTO 22740
	IF(OBJ.EQ.MAGZIN)SPK=190
	IF(OBJ.EQ.MATCH)GOTO 20706
	IF(OBJ.EQ.MESSAG)SPK=191
	IF(OBJ.EQ.MIRROR)SPK=452
	IF(OBJ.EQ.MIRROR .AND. TOTING(AMULET))SPK=453
	IF(OBJ.EQ.MIRROR .AND. WEARNG(AMULET))SPK=454
	IF(OBJ.EQ.NOTE)SPK=459
	IF(OBJ.EQ.NOTEBK)GOTO 22720
	IF(OBJ.EQ.RECEIP)SPK=537
	IF(OBJ.EQ.ROD2)SPK=549
	IF(OBJ.EQ.GROUND)SPK=460
	IF(OBJ.EQ.POSTER)SPK=370
	IF(OBJ.EQ.TABLET)SPK=196
	IF(OBJ.EQ.THRONE .OR. OBJ.EQ.THRONE+1)SPK=509
	IF(OBJ.EQ.TMACH)SPK=592
	IF(OBJ.EQ.SCROLL)SPK=457
	IF(OBJ.EQ.SHEET)SPK=544
	IF(OBJ.EQ.SLIT)SPK=401
	IF(OBJ.EQ.SLIT .AND. LOC.NE.Y2+1)SPK=402
	IF(OBJ.EQ.STATUE)SPK=406
	IF(OBJ.EQ.WINDOW)SPK=449
	IF(OBJ.EQ.OYSTER .AND. CLOSED)SPK=192
	GOTO 2011

20706	CALL RSPEAK(427)
	SPK=428+PROP(MATCH)
	GOTO 2011

C  READ CURRENT MESSAGE ON BILLBOARD.
22710	OPEN(1, FILE='/usr/games/billboard.txt',
     1		STATUS='old', ERR=22718)
22711	READ(1, 22712, END=22716) CARRAY
22712	FORMAT(20A5)
	DO 22713 I = 1,20
	K = 21-I
	IF (CARRAY(K) .NE. ' ') GOTO 22714
22713	CONTINUE
22714	WRITE (TTYOUT, 22712) (CARRAY(I), I=1,K)
	GOTO 22711
22716	CLOSE(1)
	GOTO 2100
22718	CALL RSPEAK(602)
	GOTO 2100

C  READ CURRENT MESSAGE IN NOTEBOOK.
22720	OPEN(1, FILE='/usr/games/notebook.txt',
     1		STATUS='old', ERR=22728)
22721	READ(1, 22722, END=22726) CARRAY
22722	FORMAT(20A5)
	DO 22723 I = 1,20
	K = 21-I
	IF (CARRAY(K) .NE. ' ') GOTO 22724
22723	CONTINUE
22724	WRITE (TTYOUT, 22722) (CARRAY(I), I=1,K)
	GOTO 22721
22726	CLOSE(1)
	GOTO 2100
22728	CALL RSPEAK(603)
	GOTO 2100

C  LOOK INTO CRYSTAL BALL

22730	HSPK=574
	CALL RSPEAK(400)
	DO 22735 I=1,MAXMIL
	IF (MISCOR(I).NE.0 .OR. MIRSPK(I).EQ.0) GOTO 22735
	HSPK=MIRSPK(I)
	GOTO 22736
22735	CONTINUE
22736	CALL RSPEAK(HSPK)
	SPK=575
	GOTO 2011

C  READ LETTER

22740	CALL RSPEAK(584)
	CALL BLKLIN
	CALL BLKLIN
	CALL RDMAIL
	CALL DSTROY(LETTER)
	SPK=585
	GOTO 2011

22750	CALL PSPEAK(DIALS,PROP(DIALS))
	GOTO 2000


C  BREAK.  WORKS FOR MIRROR IN REPOSITORY AND, OF COURSE, THE
C  VASE, GLASS, HOOP AND BOTTLE.
C  ALSO, THE SWORD IS MORE BRITTLE THAN IT APPEARS.

22800	IF(OBJ.EQ.MIRROR)SPK=148
	IF(OBJ.EQ.GLASS .AND. PROP(GLASS).LE.3)GOTO 22810
	IF(OBJ.EQ.HOOP .AND. PROP(HOOP).EQ.0)GOTO 22815
	IF(OBJ.EQ.VASE .AND. PROP(VASE).EQ.0)GOTO 22820
	IF(OBJ.EQ.BOTTLE .AND. PROP(BOTTLE).NE.3)GOTO 22840
	IF(OBJ.EQ.SWORD)GOTO 22860
	IF(OBJ.NE.MIRROR .OR. .NOT.CLOSED)GOTO 2011
	CALL RSPEAK(197)
	GOTO 93000

22810	PROP(GLASS)=4
	FIXED(GLASS)=-1
	SPK=450
	GOTO 22830

22815	PROP(HOOP)=1
	SPK=466
	GOTO 22830

22820	SPK=198
	PROP(VASE)=2
22830	IF(ENCLSD(OBJ))CALL REMOVE(OBJ)
	IF(OBJ.EQ.NUGGET)PROP(STEPS)=0
	IF(OBJ.NE.THRONE .AND. OBJ.NE.THRONE+1)GOTO 22835
	PROP(THRONE)=0
	PROP(THRONE+1)=0
22835	IF(HOLDNG(OBJ))CALL DROP(OBJ,LOC)
	FIXED(OBJ)=-1
	GOTO 2011

22840	SPK=231
	K=LIQ(BOTTLE)
	PROP(BOTTLE)=3
	IF(K.EQ.0)GOTO 22830
	CALL REMOVE(K)
	PLACE(K)=0
	GOTO 22830

C  HE'D BETTER NOT SLING THE SWORD AROUND!
22860	SPK=29
	IF(.NOT.HOLDNG(SWORD))GOTO 2011
	SPK=279
	PROP(SWORD)=4
	GOTO 22830
 
C  ERWACHE.  ONLY USE IS TO DISTURB THE DWARVES OR THE WUMPUS.
C  OTHER WUMPUS-WAKERS LINK HERE.

22900	IF(.NOT.AT(WUMPUS))GOTO 22940
	CHASE=1
	PROP(WUMPUS)=1
	SPK=276
	GOTO 2011

22940	IF(AT(DOG) .AND. PROP(DOG).EQ.1)SPK=291
	IF(OBJ.NE.DWARF .OR. .NOT.CLOSED)GOTO 2011
	CALL RSPEAK(199)
	GOTO 93000

C  SUSPEND.  OFFER TO EXIT LEAVING THINGS RESTARTABLE, BUT REQUIRING A DELAY
C  BEFORE RESTARTING (SO CAN'T SAVE THE WORLD BEFORE TRYING SOMETHING RISKY).
C  UPON RESTARTING, SETUP=-1 CAUSES RETURN TO 13050 TO PICK UP AGAIN.

13000	SPK=201
	GOTO 2011

13050	SETUP=3
	VERBS(1)=NULL
	VRBX=1
	VERBS(2)=0
	OBJS(1)=0
	OBJX=0
	GOTO 2750

C  HOURS.  REPORT CURRENT NON-PRIME-TIME HOURS.

13100	CALL MSPEAK(6)
	GOTO 2100


C  YANK.  A VARIANT OF 'CARRY'.  IN GENERAL, NOT A GOOD IDEA.
C  AT MOST, IT GETS THE CLOAK OR A COUPLE SNIDE COMMENTS.

23200	IF(OBJ.EQ.BAR .AND. PROP(BAR).EQ.1)
     +		GOTO (25880, 25850, 25870), PROP(DIALS)+1
	IF(OBJ.EQ.PLANT .OR. OBJ.EQ.SWORD .OR. OBJ.EQ.CHAIN)GOTO 20100
	IF(.NOT.TOTING(OBJ))SPK=205
	IF(OBJ.EQ.BEAR .AND. PROP(CHAIN).EQ.1)GOTO 2011
	IF(OBJ.EQ.CLOAK .AND. PROP(CLOAK).EQ.2)GOTO 20120
	GOTO 20100

C  WEAR: ONLY GOOD FOR JEWELS, RUBY SLIPPERS, CLOAK & CROWN.
C  BUT HE MIGHT TRY THE SWORD.  ANYTHING ELSE IS RIDICULOUS.
C  ANOTHER VARIANT OF 'CARRY'.

23300	SPK=209
	IF(OBJ.EQ.SWORD .AND. PROP(SWORD).NE.3)GOTO 2011
	IF(WORN(OBJ))GOTO 23320
23310	CALL A5LCA1(OTXT(OBJX,1),OTXT(OBJX,2),'?    ',C1ARR,K)
	WRITE (TTYOUT,23312) (C1ARR(I),I=1,K)
23312	FORMAT('Just exactly how does one wear a ',20A1)
	GOTO 2100

23320	SPK=242
	IF(OBJ.EQ.CLOAK .AND. PROP(CLOAK).EQ.2)GOTO 2011
	SPK=210
	IF(OBJ.EQ.SHOES)SPK=227
	IF(WEARNG(OBJ))GOTO 2011
	IF(PROP(OBJ).LT.0) TALLY=TALLY-1
	PROP(OBJ)=1
	CALL BITON(OBJ,WEARBT)
	IF(ENCLSD(OBJ))CALL REMOVE(OBJ)
	SPK=54
	IF(OBJ.EQ.CLOAK)SPK=490
	IF(HOLDNG(OBJ))GOTO 2011
	IF(OBJ.EQ.CLOAK)GOTO 20185
	GOTO 20120

C  HIT.  IF NOT PUNCHING OUT TELEPHONE, ASSUME ATTACK.
C        IF OBJECT IS MATCH, THEN ASSUME STRIKE (I.E. BURN)

23400	IF(AT(WUMPUS) .AND. PROP(WUMPUS).EQ.0)GOTO 22900
	IF(OBJ.EQ.MATCH)GOTO 24700
	IF(OBJ.NE.PHONE)GOTO 21200
	SPK=256
	IF(PROP(PHONE).EQ.2)GOTO 2011
	CALL DROP(SLUGS,LOC)
	IF(CLOSED .AND. (.NOT.HERE(PILLOW) .OR. HOLDNG(PILLOW)))GOTO 93100
	SPK=257
	IF(CLOSED)SPK=415
	PROP(PHONE)=2
	PROP(BOOTH)=1
	GOTO 2011

C  ANSWER (TELEPHONE).  SMARTASS FOR ANYTHING ELSE.
13500	IF(LOC.NE.189 .OR. PROP(PHONE).NE.0)GOTO 10000
	OBJ=PHONE
23500	IF(OBJ.NE.PHONE)GOTO 23520
	SPK=269
	IF(PROP(PHONE).NE.0)GOTO 2011
	IF(CLOSED)GOTO 93200
	SPK=261
	PROP(PHONE)=1
	PROP(BOOTH)=1
	GOTO 2011

23520	IF(OBJ.EQ.DWARF .OR. OBJ.EQ.WUMPUS .OR. OBJ.EQ.SNAKE .OR. OBJ.EQ.BEAR
     1   	 .OR. OBJ.EQ.DRAGON)SPK=259
	IF(OBJ.EQ.TROLL)SPK=258
	IF(OBJ.EQ.BIRD)SPK=260
	GOTO 2011

C  BLOW.  JOSHUA FIT DE BATTLE OF JERICHO, AND DE WALLS....

23600	IF(OBJ.NE.0 .AND. IOBJ.NE.0)GOTO 2060
	IF(OBJ.EQ.0)OBJ=IOBJ
	IOBJ=0
	IF(PREP.EQ.PRTHRU .AND. 
     +	   (OBJ.EQ.BOTTLE .OR. OBJ.EQ.ROPE .OR. OBJ.EQ.OIL))GOTO 20805
	IF(OBJ.EQ.0)SPK=268
	IF(AT(ROCKS))SPK=524
	IF(OBJ.NE.HORN)GOTO 2011
	SPK=266
	IF(LOC.EQ.170)SPK=538
	IF(OUTSID(LOC))SPK=277

C  RUBBING THE ELEPHANT ALSO COMES HERE

23605	IF(.NOT.AT(WUMPUS))GOTO 23610
	IF(PROP(WUMPUS).NE.0)GOTO 2011
	CALL RSPEAK(SPK)
	GOTO 22900

23610	IF(PROP(WALL).EQ.1 .OR. (LOC.NE.102 .AND. LOC.NE.194))GOTO 2011
	K=196
	IF(LOC.EQ.194)K=195
	CALL RSPEAK(SPK-1)
	PROP(WALL)=1
	DO 23620 OBJ=1,MAXOBJ
	IF(PLACE(OBJ).EQ.LOC .OR. FIXED(OBJ).EQ.LOC)CALL MOVE(OBJ,K)
23620	CONTINUE
	NEWLOC=K
	GOTO 3

C  CALL.  IF NO PHONE IS HANDY, YELL.

13800	IF(.NOT.HERE(PHONE))GOTO 10000
	GOTO 23910

C  DIAL.  NO EFFECT UNLESS AT PHONE.

23900	IF(OBJ.NE.PHONE)GOTO 2011
23910	IF(CLOSED)GOTO 93200
	SPK=271
	GOTO 2011


C  PLAY.  ONLY FOR HORN OR LYRE.
24000	IF(OBJ.NE.0 .AND. IOBJ.NE.0)GOTO 2060
	IF(OBJ.EQ.0)OBJ=IOBJ
	IOBJ=0
	IF(OBJ.EQ.HORN)GOTO 23600
	IF(OBJ.NE.LYRE)GOTO 2011
	SPK=287
	IF(.NOT.HERE(DOG) .OR. DEAD(DOG))GOTO 2011
	PROP(DOG)=1
	CALL BITON(DOG,DEADBT)
	FIXED(AXE)=0
	PROP(AXE)=0
	SPK=288
	GOTO 2011


C  PICK/PICK UP.  CAN PICK FLOWERS & MUSHROOMS, BUT MUST 'PICK UP' EVERYTHING ELSE.

24100	IF(OBJ.EQ.0)OBJ=IOBJ
	IOBJ=0
	IF(OBJ.EQ.FLOWER .OR. OBJ.EQ.MUSHRM)GOTO 20100
	IF(PREP.NE.0)GOTO 20100
	GOTO 2060

C  PUT DOWN: EQUIVALENT TO DROP.
C  PUT IN: IF LIQUID, MEANS 'FILL'.
C  PUT ON: WEAR OR DROP.

24200	IF(PREP.NE.0)GOTO 24210
	CALL A5LCA1(OTXT(OBJX,1),OTXT(OBJX,2),'?    ',C1ARR,K)
	WRITE (TTYOUT,24204) (C1ARR(I),I=1,K)
24204	FORMAT('Where do you want to put the ',20A1)
	GOTO 2500

24210	IF(PREP.EQ.PREPIN)GOTO 24500

C  PUT ON: "WEAR" OR "PUT OBJ ON IOBJ".
24240	IF(PREP.NE.PREPON)GOTO 24250
	IF(OBJ.EQ.BAR .AND. IOBJ.EQ.BASE)GOTO 24245
	IF(OBJ.NE.0)GOTO 24242
	OBJ=IOBJ
	OTXT(OBJX,1)=IOTXT(IOBX,1)
	OTXT(OBJX,2)=IOTXT(IOBX,2)
	IOBJ=0
24242	IF(WORN(OBJ))GOTO 23300
	IF(IOBJ.EQ.0)GOTO 23310
	GOTO 20200

24245	IF (TOTING(BAR))CALL DROP(BAR,LOC)
	PROP(BAR)=1
	PROP(BASE)=1
	FIXED(BAR)=-1
	SPK=593
	GOTO 2011

C  PUT DOWN: "DROP"
24250	IF(OBJ.EQ.0 .OR. IOBJ.EQ.0)GOTO 24252
	GOTO 2070

24252	IF(OBJ.EQ.0)OBJ=IOBJ
	IOBJ=0
	GOTO 20200


C  TURN ON/OFF.

24300	IF(PREP.EQ.0)GOTO 2060
	IF(OBJ.EQ.0 .AND. IOBJ.EQ.LAMP)OBJ=LAMP
	IF(OBJ.NE.LAMP .AND. OBJ.NE.BOTTLE)GOTO 2070
	IF(PREP.EQ.PREPON)GOTO 20700
	GOTO 20800


C  GET (NO PREP): "TAKE"
C  GET IN: "ENTER"
C  GET OUT: "LEAVE"
C****** NEEDS WORK

24400	IF(PREP.EQ.0 .OR. PREP.EQ.PREPFR)GOTO 20100
	IF(OBJ.NE.0)GOTO 2060
	OBJ=IOBJ
	IOBJ=0
	PREP=0
	GOTO 20100

C  INSERT/PUT IN.

24500	IF(IOBJ.EQ.0)GOTO 10010
	SPK=NOWAY(0)
	IF(OBJ.EQ.SWORD .AND. IOBJ.EQ.ANVIL .AND. PROP(SWORD).EQ.0)SPK=350
	IF(OBJ.EQ.SWORD .AND. PROP(SWORD).NE.0)GOTO 2011
	SPK=54
	IF(.NOT.VESSEL(IOBJ))GOTO 20250
	SPK=NOWAY(0)
	ASSIGN 24510 TO RETN
	GOTO 20190

24510	IF(IOBJ.NE.BOTTLE .AND. IOBJ.NE.CASK .AND. IOBJ.NE.VASE
     1   	.AND.IOBJ.NE.GRAIL .AND. (OBJ.LT.WATER .OR. OBJ.GT.WINE+1))
     2   	GOTO 24515
	IF(OBJ.EQ.ROPE .AND. IOBJ.EQ.BOTTLE)GOTO 24515
	OBJ=IOBJ
	IOBJ=OBJS(OBJX)
	GOTO 22200

24515	SPK=252
	IF(OBJ.EQ.IOBJ)GOTO 2011
	SPK=358
	IF(.NOT.AJAR(IOBJ))GOTO 2011
	IF(IOBJ.NE.BOAT .AND. IOBJ.NE.CHEST)GOTO 24520
	IF(IOBJ.EQ.CHEST .AND. OBJ.EQ.BOAT)GOTO 2070
	GOTO 24590

C  BIRD GOES INTO CAGE AND ONLY CAGE.  CAGE HOLDS NOTHING ELSE.
C  BAR VASE & PILLOW FROM SAFE, TO FORCE PUTTING DOWN ON FLOOR.
24520	IF(IOBJ.EQ.VOLCAN)GOTO 20250
	SPK=591
	IF(IOBJ.EQ.VIAL)GOTO 2011
	SPK=351
	IF(OBJ.EQ.BIRD .AND. IOBJ.NE.CAGE)GOTO 2011
	SPK=329
	IF(IOBJ.EQ.CAGE .AND. OBJ.NE.BIRD)GOTO 2011
	IF(IOBJ.EQ.SCABB .AND. OBJ.NE.SWORD)GOTO 2011
	IF(OBJ.EQ.BIRD)GOTO 20120
	IF(IOBJ.EQ.SAFE .AND. 
     +    (OBJ.EQ.VASE .OR. OBJ.EQ.GLASS .OR. OBJ.EQ.PILLOW))GOTO 2011
	IF(IOBJ.EQ.SHIELD .AND. OBJ.NE.RADIUM)GOTO 2011
	IF(IOBJ.NE.PHONE)GOTO 24530
	IF(OBJ.NE.COINS .AND. OBJ.NE.SLUGS)GOTO 2070
	CALL DSTROY(OBJ)
	SPK=330
	GOTO 2011

24525	SPK=546
	GOTO 2011

24530	IF(IOBJ.NE.VEND)GOTO 24540
	IF(OBJ.NE.COINS .AND. OBJ.NE.SLUGS)GOTO 2070
	CALL DSTROY(OBJ)
	CALL MOVE(BATTER,LOC)
	IF(PROP(BATTER).NE.1)GOTO 24535
	CALL RSPEAK(317)
	PROP(VEND)=1
24535	PROP(BATTER)=0
	CALL PSPEAK(BATTER,0)
	GOTO 2100

C  PUT BATTERIES IN LAMP.
C  THERE IS A GLITCH HERE, IN THAT IF HE TRIES TO GET A THIRD SET OF
C  BATTERIES BEFORE THE SECOND SET HAS BEEN INSERTED, THE SECOND SET
C  DISAPPEARS!  ***FIX THIS SOMETIME***
24540	IF(IOBJ.NE.LAMP)GOTO 24550
	IF(OBJ.NE.BATTER .OR. PROP(BATTER).NE.0)GOTO 2070
	PROP(BATTER)=1
	IF(ENCLSD(BATTER))CALL REMOVE(BATTER)
	IF(HOLDNG(BATTER))CALL DROP(BATTER,LOC)
	LIMIT=1000
	PROP(LAMP)=1
	LMWARN=.FALSE.
	SPK=188
	GOTO 2011

24550	IF(.NOT.SMALL(OBJ))GOTO 2011
24590	IF(.NOT.WEARNG(OBJ))GOTO 24592
  	  PROP(OBJ)=0
	  CALL BITOFF(OBJ,WEARBT)
24592	IF(ENCLSD(OBJ))CALL REMOVE(OBJ)
	IF(IOBJ.EQ.TMACH) GOTO 24594
	CALL INSERT(OBJ,IOBJ)
	GOTO 2009
24594	CALL DROP(OBJ,RMACH)
	GOTO 2009


C  REMOVE/TAKE FROM.

24600	IF (OBJ.NE.GLIQ) GOTO 24605
	SPK = 601
	GOTO 2011

24605	IF(OBJ.NE.RING .OR. PROP(RING).NE.2)GOTO 24610
	PREP=0
	IOBJ=0
	GOTO 20100

24610	SPK=343
	IF(IOBJ.NE.0)GOTO 24620
	IF(WEARNG(OBJ))GOTO 20200
	IF(.NOT.ENCLSD(OBJ))GOTO 20100
	IOBJ=-PLACE(OBJ)
24620	IF(PLACE(OBJ).NE.-IOBJ)SPK=341
	IF(.NOT.AJAR(IOBJ))GOTO 21335
	IF(OBJ.EQ.WATER .OR. OBJ.EQ.OIL .OR. OBJ.EQ.WINE)SPK=342
	IF(.NOT.TOTING(OBJ) .AND. BURDEN(0)+BURDEN(OBJ).GT.MAXCAR)SPK=92
	IF(SPK.NE.343)GOTO 2011
	IF(OBJ.EQ.BIRD)GOTO 20200
	IF(PROP(OBJ).GE.0)  GOTO 24625
	PROP(OBJ)=0
	TALLY=TALLY-1
24625	CALL REMOVE(OBJ)
	GOTO 2009

C  BURN

24700	IF (MCLOCK .EQ. -1) GOTO 2000
	IF (OBJ.EQ.MATCH) GOTO 24750
	SPK=416
	IF (.NOT.(BURNS(OBJ) .OR. (OBJ.EQ.BOTTLE .AND. 
     +	     PROP(BOTTLE).EQ.2))) GOTO 2011
	SPK=417
	IF (IOBJ.NE.0 .AND. IOBJ.NE.TORCH .AND. IOBJ.NE.MATCH)GOTO 2011
	IF (HOLDNG(OBJ)) CALL DROP(OBJ, LOC)
	IF (WEARNG(OBJ)) CALL BITOFF(OBJ, WEARBT)
	IF (IOBJ.EQ.0 .AND. ATHAND(MATCH)) IOBJ=MATCH
	IF (IOBJ.EQ.0 .AND. ATHAND(TORCH)) IOBJ=TORCH
	IF (OBJ .NE. OIL)  GOTO 24705
	IF (-PLACE(OBJ) .NE. BOTTLE)  GOTO 24755
	SPK=553
	IF (-PLACE(ROPE) .NE. BOTTLE)  GOTO 2011
	OBJ=ROPE
24705	SPK=418
	IF (IOBJ.EQ.0) GOTO 2011
	SPK=419
	IF (IOBJ.EQ.MATCH .AND. MCLOCK.EQ.0) GOTO 2011
	SPK=420
	IF (OBJ .EQ. MAGZIN) SPK=421
	IF (OBJ .EQ. BOOK) SPK=422
	IF (OBJ .EQ. ROD2) GOTO 12310
	IF (OBJ .NE. ROPE .OR. -PLACE(OBJ) .NE. BOTTLE .OR.
     +		PROP(BOTTLE) .NE. 2)  GOTO 24710
	LCLOCK = 20
	SPK=548
	GOTO 2011

24710	CALL RSPEAK(SPK)
	MCLOCK=0
	CALL DSTROY(OBJ)
	SPK=426
	IF (IOBJ .EQ. MATCH) GOTO 2011
	GOTO 2100

24750	SPK=29
	IF (.NOT.TOTING(MATCH)) GOTO 2011
	SPK=534
	IF (PROP(MATCH).EQ.5) GOTO 2011
	SPK=528
	PROP(MATCH) = PROP(MATCH)+1
	MCLOCK=1
	CALL RSPEAK(424)
	IF (LIQLOC(LOC).NE.OIL)GOTO 24760
24755	CALL RSPEAK(423)
	GOTO 94100

24760	IF (WZDARK)GOTO 2000
	GOTO 2100

C  GRIPE/COMPLAIN/SUGGEST.

14800	SPK=521
	GOTO 2011

C  LOCK.  CHAIN, GRATE, CHEST, ELFIN DOOR
C  HERE ARE THE CURRENT LOCK/UNLOCK MESSAGES & NUMBERS:
C	31	YOU HAVE NO KEYS.
C	32	IT HAS NO LOCK.
C	34	IT'S ALREADY LOCKED.
C	35	THE GRATE IS NOW LOCKED.
C	36	THE GRATE IS NOW UNLOCKED.
C	37	IT WAS ALREADY UNLOCKED.
C	55	YOU CAN'T UNLOCK THE KEYS.
C	171	The chain is now unlocked.
C	172	The chain is now locked.
C	173	There is nothing here to which the chain can be locked.
C	224	YOUR KEYS ARE ALL TOO LARGE.
C	234	The wrought-iron door is now locked.
C	235	The tiny door is now locked.
C	236	The wrought-iron door is now unlocked.
C	237	The tiny door is now unlocked.
C	375	YOU DON'T HAVE THE RIGHT KEY.
C	333	THE CHEST IS NOW LOCKED.
C	334	THE CHEST IS NOW UNLOCKED.
C	367	THE SAFE'S DOOR SWINGS SHUT.

24900	IF(OBJ.EQ.0)  GOTO 10500
	IF(HINGED(OBJ))GOTO 24905
	CALL A5LCA1(OTXT(OBJX,1),OTXT(OBJX,2),'.    ',C1ARR,K)
	WRITE (TTYOUT,24903) (C1ARR(I),I=1,K)
24903	FORMAT('I don''t know how to lock or unlock the ',20A1)
	GOTO 2100

24905	SPK=375
	IF(.NOT.LOCKS(OBJ))SPK=32
	IF(LOCKED(OBJ))SPK=34
	IF(.NOT.(ATHAND(KEYS) .OR. ATHAND(SKEY) .OR. OBJ.EQ.SAFE))SPK=31
	IF(SPK.NE.375)GOTO 2011

C  CHAIN.
	IF(OBJ.NE.CHAIN)GOTO 24910
	IF(.NOT.ATHAND(KEYS))GOTO 2011
	SPK=173
	IF(LOC.NE.PLAC(CHAIN))GOTO 2011
	SPK=172
	PROP(CHAIN)=2
	IF(ENCLSD(CHAIN))CALL REMOVE(CHAIN)
	IF(HOLDNG(CHAIN))CALL DROP(CHAIN,LOC)
	FIXED(CHAIN)=-1
	GOTO 24990

C  CHEST.
24910	IF(OBJ.NE.CHEST)GOTO 24920
	IF(.NOT.ATHAND(KEYS))GOTO 2011
	SPK=334
	GOTO 24990

C  ELFIN DOOR.
24920	IF(OBJ.NE.TDOOR .AND. OBJ.NE.TDOOR2)GOTO 24930
	SPK=224
	IF(.NOT.TOTING(SKEY))GOTO 2011
	PROP(TDOOR)=0
	PROP(TDOOR2)=0
	SPK=234+2*PROP(TDOOR)+(TDOOR2-OBJ)
	K=TDOOR+(TDOOR2-OBJ)
	CALL BITON(K,LOCKBT)
	CALL BITOFF(K,OPENBT)
	GOTO 24990

C  GRATE.
24930	IF(OBJ.NE.GRATE)GOTO 24940
	IF(.NOT.ATHAND(KEYS))GOTO 2011
	PROP(GRATE)=0
	SPK=35
	GOTO 24990

C  SAFE.
24940	PROP(SAFE)=0
	SPK=367
C	GOTO 24990

24990	CALL BITON(OBJ,LOCKBT)
	CALL BITOFF(OBJ,OPENBT)
	GOTO 2011

C  UNLOCK.  CHAIN, GRATE, CHEST, ELFIN DOOR.

25000	IF(OBJ.EQ.0)  GOTO 10500
	SPK=55
	IF(OBJ.EQ.KEYS .OR. OBJ.EQ.SKEY)GOTO 2011
	IF(.NOT.HINGED(OBJ))GOTO 24900
	SPK=486
	IF(IOBJ.EQ.HANDS)GOTO 2011
	SPK=375
	IF(.NOT.LOCKED(OBJ))SPK=37
	IF(.NOT.LOCKS(OBJ))SPK=32
	IF(OBJ.EQ.SAFE)SPK=342
	IF(OBJ.EQ.SAFE .AND. (IOBJ.EQ.KEYS .OR. IOBJ.EQ.SKEY))SPK=368
	IF(.NOT.(ATHAND(KEYS) .OR. ATHAND(SKEY) .OR. OBJ.EQ.SAFE))SPK=31
	IF(SPK.NE.375)GOTO 2011

C  CHAIN.
	IF(OBJ.NE.CHAIN)GOTO 25020
	IF(.NOT.ATHAND(KEYS))GOTO 2011
	SPK=171
	IF(PROP(BEAR).EQ.0)SPK=41
	IF(SPK.NE.171)GOTO 2011
	PROP(CHAIN)=0
	FIXED(CHAIN)=0
	IF(PROP(BEAR).NE.3)PROP(BEAR)=2
	FIXED(BEAR)=2-PROP(BEAR)
	GOTO 25090

C  CHEST.
25020	IF(OBJ.NE.CHEST)GOTO 25030
	IF(.NOT.ATHAND(KEYS))GOTO 2011
	SPK=333
	GOTO 25090

C  ELFIN DOOR.
C  STUFF TO LOCK/UNLOCK TINY DOOR W/SPECIAL KEY.
C  THE DAMN THING IS REALLY AT FOUR PLACES, AND WE WANT THE RIGHT
C  MESSAGES IF HE ONLY HAS 'BIG' KEYS (OR NO KEYS).  ALSO, HE
C  CAN UNLOCK IT EITHER WHILE HE IS BIG OR SMALL.
25030	IF(OBJ.NE.TDOOR .AND. OBJ.NE.TDOOR2)GOTO 25040
	SPK=224
	IF(.NOT.ATHAND(SKEY))GOTO 2011
	IF(CLOSNG)GOTO 25060
	PROP(TDOOR)=1
	PROP(TDOOR2)=1
	SPK=234+2*PROP(TDOOR)+(TDOOR2-OBJ)
	K=TDOOR+(TDOOR2-OBJ)
	CALL BITOFF(K,LOCKBT)
	CALL BITON(K,OPENBT)
	GOTO 25090

C  GRATE.
25040	IF(.NOT.ATHAND(KEYS))GOTO 2011
	IF(CLOSNG)GOTO 25060
	PROP(GRATE)=1
	SPK=36

25090	CALL BITOFF(OBJ,LOCKBT)
	CALL BITON(OBJ,OPENBT)
	GOTO 2011

C  CLOSING.  NO EXIT THIS WAY.
25060	SPK=130
	IF(.NOT.PANIC)CLOCK2=15
	PANIC=.TRUE.
	GOTO 2011


C  HEALTH.  GIVE HIM A DIAGNOSIS.

25100	IF(HEALTH.LT.100)WRITE (TTYOUT,25102) HEALTH
25102	FORMAT('You''re health rating is ',I2,' out of a possible 100.')
	IF(PCT(50))SPK=349
	IF(HEALTH.GE.95)GOTO 2011
	SPK=381 + (100-HEALTH)/20
	GOTO 2011

C  LOOK.  CAN'T GIVE MORE DETAIL.  PRETEND IT WASN'T DARK (THOUGH IT MAY "NOW"
C  BE DARK) SO HE WON'T FALL INTO A PIT WHILE STARING INTO THE GLOOM.

25200	IF(IOBJ.NE.0)GOTO 25210
	IF(OBJ.EQ.0)GOTO 25201
	IOBJ=OBJ
	OBJ=0
	GOTO 25210
25201	IF(DETAIL.EQ.2)CALL RSPEAK(15)
	DETAIL=1
	WZDARK=.FALSE.
	ABB(LOC)=0
	NEWLOC=LOC
	GOTO 3

C  LOOK INTO SOMETHING (A CONTAINER).
25210	IF(PRINTD(IOBJ) .AND. PREP.NE.PREPIN)GOTO 25220
	IF(.NOT.VESSEL(IOBJ))GOTO 25220
	IF(.NOT.AJAR(IOBJ) .AND. OPAQUE(IOBJ))GOTO 2011
	SPK=357
	IF (BLIND(0)) GOTO 2011
	SPK=359
	IF(HOLDER(IOBJ).NE.0)GOTO 25215
	IF(PREP.NE.PREPIN)GOTO 25220
	GOTO 2011
25215	CALL LOOKIN(IOBJ)
	GOTO 2100

C  LOOK AT SOMETHING.  IF WRITTEN, READ IT.
C  EXAMINE ALSO COMES HERE.

25220	OBJ=IOBJ
	IOBJ=0
	SPK=505
	IF(PLURAL(OBJ))SPK=506
	GOTO 22701


C  COMBO: TRYING TO OPEN SAFE.  SEE COMMENTS FOR FEE FIE FOE FOO.

25300	IF(.NOT.AT(SAFE))GOTO 2060
	K=VOCAB(VTXT(VRBX,1),4)-10
	SPK=42
	IF(COMBO.EQ.1-K)GOTO 25320
	IF(COMBO.NE.0)SPK=366
	GOTO 2011

25320	COMBO=K
	SPK=371
	IF(K.NE.3)GOTO 2011
	COMBO=0
	CALL BITOFF(SAFE,LOCKBT)
	CALL BITON(SAFE,OPENBT)
	PROP(SAFE)=1
	SPK=365

C  IF REMAINING TREASURES TOO ELUSIVE, ZAP HIS LAMP.

	IF(TALLY.EQ.TALLY2 .AND. TALLY.NE.0)LIMIT=MIN0(35,LIMIT)
	GOTO 2011


C  DUST/SWEEP.
25400	IF(.NOT.ATHAND(BRUSH))SPK=342
	IF(CLOSED)GOTO 25410
	IF(.NOT.AT(CARVNG) .OR. .NOT.ATHAND(BRUSH) .OR. PROP(CARVNG).EQ.1)
     1   	GOTO 2011
	PROP(CARVNG)=1
	CALL RSPEAK(363)
	SPK=372
	GOTO 2011

25410	IF(LOC.NE.116 .OR. PROP(CARVNG).EQ.1)GOTO 2011
	PROP(CARVNG)=1
	SPK=414
	GOTO 2011


C  TERSE/UNTERSE.  SUPRESS ALL LONG-FORM DESCRIPTIONS.

25500	TERSE=.NOT.TERSE
	DETAIL=3
	GOTO 2009

C  BOARD (TAKE BOAT)

25600	OBJ=BOAT
	IF(ATHAND(BOAT))GOTO 20100
	SPK=404
	GOTO 2011

C  DISEMBARK (LEAVE BOAT)

25700	OBJ=BOAT
	IF(ATHAND(BOAT))GOTO 20200
	SPK=405
	GOTO 2011

C  PUSH

25800	IF(OBJ.EQ.BAR .AND. PROP(BAR).EQ.1)
     +		GOTO (25860, 25870, 25850), PROP(DIALS)+1
	SPK=439
	IF(OBJ.NE.BELT)GOTO 2011
	BLTCNT = BLTCNT + 1
	BLTCLK = 50
	IF (BLTCNT .LT. 3)  GOTO 25805
	CALL RSPEAK(478+BLTCNT)
	IF (BLTCNT .NE. 5)  GOTO 25805
	CALL BITOFF(BELT, WEARBT) 
	CALL DROP(BELT, LOC)
	PROP(BELT) = 2

25805	SPK=440
	IF(PROP(BELT).EQ.1)SPK=441
	IF(PROP(BELT).EQ.2)SPK=484
	IF(LOC.NE.FALLRM)GOTO 2011
	IF(PROP(BELT).EQ.1)  GOTO 25810
	LOC=FALLRM+1
	IF(PROP(BELT).EQ.2) LOC=FALLRM+2
	GOTO 2000

C  FIGURE OUT WHERE WE WERE

25810	DO 25820 I = 1,NPAIRS
	NN = 2 * I
25820	IF (TOPBOT(NN-1).EQ.TOPLOC)  GOTO 25830
	CALL BUG(36)
25830	LOC = TOPBOT(NN)
	CALL RSPEAK(552)
	GOTO 2000

C  PUSHING LEVER IN TIME MACHINE
C  NEXT STATEMENTS CORRESPOND TO TIMES (50=PAST/80=FUTURE)

25850	LOC=324
	SPK=595
	GOTO 25895

25860	PROP(DIALS)=2
	PROP(NOISES)=0
	GOTO 25890

25870	PROP(DIALS)=0
	PROP(NOISES)=0
	GOTO 25890

25880	PROP(DIALS)=1
	PROP(NOISES)=1

25890	SPK=594
25895	NEWLOC=LOC
	CALL RSPEAK(SPK)
	GOTO 2

C  MELT (ONLY LEADED GLASS FOR NOW)

25900	SPK=446
	IF(OBJ.EQ.AMULET)SPK=461
	IF(OBJ.NE.GLASS)GOTO 2011
	SPK=447
	IF(IOBJ.NE.0)SPK=448
	IF(.NOT.HERE(BOTTLE) .OR. LCLOCK.EQ.0)GOTO 2011
	FIXED(GLASS)=0
	PROP(GLASS)=2
	OBJCON(GLASS) = OBJCON(GLASS) - BITS(17)
	SPK=554
	GOTO 2011

C  ROLL (HOOP ONLY FOR NOW)

26000	SPK=462
	IF (OBJ.EQ.BALL)SPK=576
	IF (OBJ.NE.HOOP .OR. PROP(HOOP).NE.0)  GOTO 2011
	IF (TOTING(HOOP))  CALL DROP(HOOP,LOC)
	IF (PCT(30)) PROP(HOOP)=1
	SPK=463
	IF (PROP(HOOP).EQ.1) SPK=464
	GOTO 2011

C  SIT.  INTRANSITIVE, JUST MESSAGE.

16200	IF (IOBJ.NE.0)  GOTO 26200
	SPK=510
	IF (OUTSID(LOC)) SPK=511
	GOTO 2011

C  TRANSITIVE.  LIKE GET IN.

26200	IF (OBJ.EQ.0)  OBJ=IOBJ
	GOTO 20150

C  KLARF (THANKS MICHAEL)

16300	SPK=42
	IF(.NOT.ATHAND(THRONE) .AND. .NOT.ATHAND(THRONE+1))  GOTO 2011
	CALL RSPEAK(516)
	LOC0=PLACE(THRONE)
	LOC1=PLACE(THRONE+1)
	IF (LOC0.EQ.-1)GOTO 16310
	IF (LOC1.EQ.-1)GOTO 16320
	CALL MOVE(THRONE+1,LOC0)
	CALL MOVE(THRONE,LOC1)
	GOTO 16330
16310	CALL MOVE(THRONE+1,LOC)
	LOC = LOC1
	GOTO 16330
16320	CALL MOVE(THRONE,LOC)
	LOC = LOC0
16330	NEWLOC = LOC
	GOTO 3

C  CLICK -- OVER THE RAINBOW STUFF

26400	SPK=13
	IF (OBJ.NE.HEELS)  GOTO 2011
	SPK=42
	IF (.NOT.WEARNG(HEELS))  GOTO 2011
	NEWLOC=236
	IF (LOC.NE.205) GOTO 26410
	NEWLOC=237
	LOC=202
26410	IF (CHASE.NE.0) NEWLOC=252
	DO 26440 J=1,MAXOBJ
	IF(J.NE.HEELS .OR. NEWLOC.NE.237)GOTO 26420
	PROP(J) = 0
	CALL BITOFF(J, WEARBT)
	GOTO 26430
26420	IF(J.EQ.LAMP .OR. J.EQ.AXE .OR. WEARNG(J)) GOTO 26440
	IF(J.EQ.NUGGET)PROP(STEPS)=0
	IF(J.NE.THRONE .AND. J.NE.THRONE+1)GOTO 26430
	PROP(THRONE)=0
	PROP(THRONE+1)=0
26430	IF(HOLDNG(J))CALL DROP(J,LOC)
26440	CONTINUE
	LOC=NEWLOC
	GOTO 3


C  WEIGHT CALCULATION

16500	KK=BURDEN(0)+130
	IF (KK.EQ.130)WRITE (TTYOUT,16501)
	IF (KK.NE.130)WRITE (TTYOUT,16502) KK
16501	FORMAT ('Your own weight is 130 pounds.')
16502	FORMAT ('Your own weight is 130 pounds.  With all the stuff you''re carrying,'/'the total is ',I3,' pounds.')
	GOTO 2100

26500	SPK=581
	IF (FIXED(OBJ).NE.0)GOTO 2011
	KK=BURDEN(OBJ)
	SPK=580
	IF (KK.EQ.0) GOTO 2011
	IF (KK.LT.10) WRITE (TTYOUT,26501) KK
	IF (KK.GE.10 .AND. KK.LT.100)  WRITE (TTYOUT,26502) KK
	IF (KK.GE.100)  WRITE (TTYOUT,26503) KK
26501	FORMAT('About ', I1, ' pounds.')
26502	FORMAT('About ', I2, ' pounds.')
26503	FORMAT('About ', I3, ' pounds.')
	GOTO 2100


C  ABYSM Magic word

16600	SPK=536
	IF (LOC.NE.Y2 .OR. PROP(GLIQ).LE.1)GOTO 2011
	PROP(GLIQ)=0
	CALL DSTROY(GLIQ)
	PROP(BOX)=1
	SPK=600
	GOTO 2011

C  SAVE

16700	CALL CSAVE()
	GOTO 2500

C  RESTORE

16800	CALL CREST()
	GOTO 2500


C  HINTS

C  COME HERE IF HE'S BEEN LONG ENOUGH AT REQUIRED LOC(S) FOR SOME UNUSED HINT.
C  HINT NUMBER IS IN VARIABLE "HINT".  BRANCH TO QUICK TEST FOR ADDITIONAL
C  CONDITIONS, THEN COME BACK TO DO NEAT STUFF.  GOTO 40010 IF CONDITIONS ARE
C  MET AND WE WANT TO OFFER THE HINT.  GOTO 40020 TO CLEAR HINTLC BACK TO ZERO,
C  40030 TO TAKE NO ACTION YET.

40000	GOTO (40700,40800,40900,41000,41100,41200,41300,41400,41500,
     1        41600,41700)(HINT+1-HNTMIN)
C	      MAZE  DARK  WITT  SWORD SLIDE CAVE1 BIRD  CAVE2 RNBOW
C	      SNAKE STYX

	WRITE (TTYOUT,40002) HINT
40002	FORMAT ('TRYING TO PRINT HINT # ',I1,/)
	CALL BUG(27)

40010	HINTLC(HINT)=0
	IF(.NOT.YES(HINTS(HINT,3),0,54))GOTO 2602
	WRITE (TTYOUT,40012) HINTS(HINT,2)
40012	FORMAT('I am prepared to give you a hint, but it will cost you',I2,' points.')
	HINTED(HINT)=YES(175,HINTS(HINT,4),54)
	IF(HINTED(HINT) .AND. LIMIT.GT.30)LIMIT=LIMIT+30*HINTS(HINT,2)
40020	HINTLC(HINT)=0
40030	GOTO 2602

C  NOW FOR THE QUICK TESTS.  SEE DATABASE DESCRIPTION FOR ONE-LINE NOTES.

40700	IF(ATLOC(LOC).EQ.0 .AND. ATLOC(OLDLOC).EQ.0 .AND. 
     1   	ATLOC(OLDLC2).EQ.0 .AND. BURDEN(0).GT.1)GOTO 40010
	GOTO 40020

40800	IF(PROP(EMRALD).NE.-1 .AND. PROP(PYRAM).EQ.-1)GOTO 40010
	GOTO 40020

40900	GOTO 40010

41000	IF( (PROP(SWORD).EQ.1 .OR. PROP(SWORD).EQ.5)
     1   	.AND..NOT.TOTING(CROWN))GOTO 40010
	GOTO 40020

41100	GOTO 40010

41200	IF(PROP(GRATE).EQ.0 .AND. .NOT.ATHAND(KEYS))GOTO 40010
	GOTO 40020

41300	IF(HERE(BIRD) .AND. ATHAND(ROD) .AND. OBJ.EQ.BIRD)GOTO 40010
	GOTO 40030

41400	IF(ABB(159).EQ.0)GOTO 40010
	GOTO 40020

41500	IF(.NOT.TOTING(SHOES) .OR. ABB(205).EQ.0)GOTO 40010
	GOTO 40020

41600	IF(.NOT.ATHAND(LYRE) .AND. PROP(DOG).NE.1)GOTO 40010
	GOTO 40020

41700	IF(HERE(SNAKE) .AND. .NOT.HERE(BIRD))GOTO 40010
	GOTO 40020

C  CAVE CLOSING AND SCORING


C  THESE SECTIONS HANDLE THE CLOSING OF THE CAVE.  THE CAVE CLOSES "CLOCK1"
C  TURNS AFTER THE LAST TREASURE HAS BEEN LOCATED (INCLUDING THE PIRATE'S
C  CHEST, WHICH MAY OF COURSE NEVER SHOW UP).  NOTE THAT THE TREASURES NEED NOT
C  HAVE BEEN TAKEN YET, JUST LOCATED.  HENCE CLOCK1 MUST BE LARGE ENOUGH TO GET
C  OUT OF THE CAVE (IT ONLY TICKS WHILE INSIDE THE CAVE).  WHEN IT HITS ZERO,
C  WE BRANCH TO 90000 TO START CLOSING THE CAVE, AND THEN SIT BACK AND WAIT FOR
C  HIM TO TRY TO GET OUT.  IF HE DOESN'T WITHIN CLOCK2 TURNS, WE CLOSE THE
C  CAVE; IF HE DOES TRY, WE ASSUME HE PANICS, AND GIVE HIM A FEW ADDITIONAL
C  TURNS TO GET FRANTIC BEFORE WE CLOSE.  WHEN CLOCK2 HITS ZERO, WE BRANCH TO
C  90000 TO TRANSPORT HIM INTO THE FINAL PUZZLE.  NOTE THAT THE PUZZLE DEPENDS
C  UPON ALL SORTS OF RANDOM THINGS.  FOR INSTANCE, THERE MUST BE NO WATER OR
C  OIL, SINCE THERE ARE BEANSTALKS WHICH WE DON'T WANT TO BE ABLE TO WATER,
C  SINCE THE CODE CAN'T HANDLE IT.  ALSO, WE CAN HAVE NO KEYS, SINCE THERE IS A
C  GRATE (HAVING MOVED THE FIXED OBJECT!) THERE SEPARATING HIM FROM ALL THE
C  TREASURES.  MOST OF THESE PROBLEMS ARISE FROM THE USE OF NEGATIVE PROP
C  NUMBERS TO SUPPRESS THE OBJECT DESCRIPTIONS UNTIL HE'S ACTUALLY MOVED THE
C  OBJECTS.

C  WHEN THE FIRST WARNING COMES, WE LOCK THE GRATE, DESTROY THE BRIDGE, KILL
C  ALL THE DWARVES (AND THE PIRATE), REMOVE THE TROLL AND BEAR (UNLESS DEAD),
C  AND SET "CLOSNG" TO TRUE.  LEAVE THE DRAGON; TOO MUCH TROUBLE TO MOVE IT.
C  FROM NOW UNTIL CLOCK2 RUNS OUT, HE CANNOT UNLOCK THE GRATE, MOVE TO ANY
C  LOCATION OUTSIDE THE CAVE (LOC=BITSET(LOCCON,6)), OR CREATE THE BRIDGE.  NOR CAN HE BE
C  RESURRECTED IF HE DIES.  NOTE THAT THE SNAKE IS ALREADY GONE, SINCE HE GOT
C  TO THE TREASURE ACCESSIBLE ONLY VIA THE HALL OF THE MT. KING.  ALSO, HE'S
C  BEEN IN GIANT ROOM (TO GET EGGS), SO WE CAN REFER TO IT.  ALSO ALSO, HE'S
C  GOTTEN THE PEARL, SO WE KNOW THE BIVALVE IS AN OYSTER.  *AND*, THE DWARVES
C  MUST HAVE BEEN ACTIVATED, SINCE WE'VE FOUND CHEST.

90000	PROP(GRATE)=0
	PROP(FISSUR)=0
	PROP(TDOOR)=0
	PROP(TDOOR2)=0

	CALL BITOFF(GRATE,OPENBT)
	CALL BITON(GRATE,LOCKBT)
	CALL BITOFF(TDOOR,OPENBT)
	CALL BITON(TDOOR,LOCKBT)
	CALL BITOFF(TDOOR2,OPENBT)
	CALL BITON(TDOOR2,LOCKBT)

	DO 90010 I=1,6
	DSEEN(I)=.FALSE.
90010	DLOC(I)=0
	CALL MOVE(TROLL,0)
	CALL MOVE(TROLL+MAXOBJ,0)
	CALL MOVE(TROLL2,PLAC(TROLL))
	CALL MOVE(TROLL2+MAXOBJ,FIXD(TROLL))
	CALL JUGGLE(CHASM)
	IF(PROP(BEAR).NE.3)CALL DSTROY(BEAR)
	PROP(CHAIN)=0
	FIXED(CHAIN)=0
	PROP(AXE)=0
	FIXED(AXE)=0
	CALL RSPEAK(129)
	CLOCK1=-1
	CLOSNG=.TRUE.
	GOTO 19999

C  ONCE HE'S PANICKED, AND CLOCK2 HAS RUN OUT, WE COME HERE TO SET UP THE
C  STORAGE ROOM.  THE ROOM HAS TWO LOCS, HARDWIRED AS 115 (NE) AND 116 (SW).
C  AT THE NE END, WE PLACE EMPTY BOTTLES, A NURSERY OF PLANTS, A BED OF
C  OYSTERS, A PILE OF LAMPS, RODS WITH STARS, SLEEPING DWARVES, PHONE BOOTH AND HIM.
C  AT THE SW END WE PLACE GRATE OVER TREASURES, SNAKE PIT, COVEY OF CAGED BIRDS,
C  MORE RODS, AND PILLOWS.  A MIRROR STRETCHES ACROSS ONE WALL.  MANY OF THE
C  OBJECTS COME FROM KNOWN LOCATIONS AND/OR STATES (E.G. THE SNAKE IS KNOWN TO
C  HAVE BEEN DESTROYED AND NEEDN'T BE CARRIED AWAY FROM ITS OLD "PLACE"),
C  MAKING THE VARIOUS OBJECTS BE HANDLED DIFFERENTLY.  WE ALSO DROP ALL OTHER
C  OBJECTS HE MIGHT BE CARRYING (LEST HE HAVE SOME WHICH COULD CAUSE TROUBLE,
C  SUCH AS THE KEYS).  WE DESCRIBE THE FLASH OF LIGHT AND TRUNDLE BACK.
C  THE PHONE MAKES IT IMPOSSIBLE FOR THE WALDO TO FART AROUND IN THE
C  REPOSITORY TOO LONG.  WHEN CLOCK3 TICKS TO ZERO, THE PHONE STARTS
C  RINGING.  WHEN IT HITS -7, THE DWARVES WAKE UP.  IF HE FIDDLES WITH
C  THE PHONE, HE GETS ZONKED IN OTHER WAYS.

91000	CALL RSPEAK(132)
91001	LOC=115
	FOO=PUT(OYSTER,LOC,0)
	FIXED(OYSTER)=LOC
	PROP(OYSTER)=0
	IF (BITSET(LOCCON(LOC),4)) LOCCON(LOC)=LOCCON(LOC) - BITS(4)
	FOO=PUT(PLANT2,LOC,0)
	PROP(PLANT2)=0
	FOO=PUT(LAMP,LOC,0)
	PROP(LAMP)=0
	PROP(ROD)=PUT(ROD,LOC,0)
	PROP(DWARF)=PUT(DWARF,LOC,0)
	PROP(MIRROR)=PUT(MIRROR,LOC,0)

	PROP(BOOTH)=PUT(BOOTH,LOC,-4)
	FOO=PUT(BRUSH,212,0)
	PROP(BRUSH)=0
	PROP(CARVNG)=0
	PROP(PHONE)=PUT(PHONE,212,-4)
	FIXED(BOOTH)=LOC

	LOC=116
	FOO=PUT(GRATE,LOC,0)
	FIXED(GRATE)=244
	PROP(GRATE)=0
	CALL BITOFF(GRATE,OPENBT)
	PROP(SNAKE)=PUT(SNAKE,LOC,1)
	PROP(PILLOW)=PUT(PILLOW,LOC,0)

	PROP(BIRD)=PUT(BIRD,LOC,1)
	PROP(CAGE)=PUT(CAGE,LOC,0)
	CALL BITOFF(CAGE,OPENBT)
	CALL INSERT(BIRD,CAGE)

	FIXED(MIRROR)=LOC

	LOC=245
	FOO=PUT(PLANT,LOC,0)
	PROP(PLANT)=0
	IF (ENCLSD(ROPE)) CALL REMOVE(ROPE)
	CALL DSTROY(ROPE)
	K=LIQ(BOTTLE)
	IF(K.EQ.0)GOTO 91010
	  CALL REMOVE(K)
	  PLACE(K)=0
91010	CALL MOVE(BOTTLE, LOC)
	PLACE(WATER)=-1
	CALL INSERT(WATER,BOTTLE)
	PROP(BOTTLE)=0
	CALL BITON(BOTTLE,OPENBT)

	PROP(TORCH)=-1

	FOO=PUT(VEND,247,0)
	FOO=PUT(BATTER,0,0)
	FOO=PUT(SLUGS,0,0)
	PROP(VEND)=0
	PROP(BATTER)=0

	LIMIT=-1
	CLOCK1=-1
	CLOCK2=-1
	CLOSNG=.TRUE.
	CLOSED=.TRUE.
	LMWARN=.TRUE.

	DO 91020 I=1,MAXOBJ
	IF(TOTING(I) .AND. ENCLSD(I))CALL REMOVE(I)
	IF(WEARNG(I))CALL BITOFF(I,WEARBT)
91020	IF(TOTING(I))CALL DROP(I,0)

	CLOSED=.TRUE.
	LOC=115
	OLDLOC=115
	NEWLOC=115
	GOTO 3


C  ANOTHER WAY WE CAN FORCE AN END TO THINGS IS BY HAVING THE LAMP GIVE OUT.
C  WHEN IT GETS CLOSE, WE COME HERE TO WARN HIM.
C  92000 IS FOR CASES OF LAMP DYING.  92400 IS WHEN IT GOES OUT,
C  AND 92600 IS IF HE'S WANDERED OUTSIDE AND THE LAMP IS USED UP, IN WHICH
C  CASE WE FORCE HIM TO GIVE UP.

92000	IF(LMWARN .OR. .NOT.HERE(LAMP))GOTO 19999
	LMWARN=.TRUE.
	SPK=187
	IF(PROP(BATTER).EQ.1)SPK=323
	IF(PLACE(BATTER).EQ.0)SPK=183
	IF(PROP(VEND).EQ.1)SPK=189
	CALL RSPEAK(SPK)
	GOTO 19999

92400	LIMIT=-1
	PROP(LAMP)=0
	IF(HERE(LAMP))CALL RSPEAK(184)
	GOTO 19999

92600	CALL RSPEAK(185)
	GAVEUP=.TRUE.
	GOTO 95000

C  AND, OF COURSE, DEMO GAMES ARE ENDED BY THE WIZARD.

92800	CALL MSPEAK(1)
	GAVEUP=.TRUE.
	GOTO 95000

C  OH DEAR, HE'S DISTURBED THE DWARVES.

93000	CALL RSPEAK(136)
	GOTO 95000

C  HIT THE PHONE.  JINGLE, JANGLE, CRASH!
93100	CALL RSPEAK(282)
	GOTO 93000

C  WHOOPS.  DOWN THE CHUTE.
93200	CALL RSPEAK(283)
	GOTO 95000

C  DWARVES CAN'T SLEEP THRU ALL THIS RINGING!
93300	CALL RSPEAK(254)
	GOTO 95000

C  "HE'S DEAD, JIM!"
C
C  IF THE CURRENT LOC IS ZERO, IT MEANS THE CLOWN GOT HIMSELF KILLED.  WE'LL
C  ALLOW THIS MAXDIE TIMES.  MAXDIE IS AUTOMATICALLY SET BASED ON THE NUMBER OF
C  SNIDE MESSAGES AVAILABLE.  EACH DEATH RESULTS IN A MESSAGE (81, 83, ETC.)
C  WHICH OFFERS REINCARNATION; IF ACCEPTED, THIS RESULTS IN MESSAGE 82, 84,
C  ETC.  THE LAST TIME, IF HE WANTS ANOTHER CHANCE, HE GETS A SNIDE REMARK AS
C  WE EXIT.  WHEN REINCARNATED, ALL OBJECTS BEING CARRIED GET DROPPED AT OLDLC2
C  (PRESUMABLY THE LAST PLACE PRIOR TO BEING KILLED) WITHOUT CHANGE OF PROPS.
C  THE LOOP RUNS BACKWARDS TO ASSURE THAT THE BIRD IS DROPPED BEFORE THE CAGE.
C  (THIS KLUGE COULD BE CHANGED ONCE WE'RE SURE ALL REFERENCES TO BIRD AND CAGE
C  ARE DONE BY KEYWORDS.)  THE LAMP IS A SPECIAL CASE (IT WOULDN'T DO TO LEAVE
C  IT IN THE CAVE).  IT IS TURNED OFF AND LEFT OUTSIDE THE BUILDING (ONLY IF HE
C  WAS CARRYING IT, OF COURSE).  HE HIMSELF IS LEFT INSIDE THE BUILDING (AND
C  HEAVEN HELP HIM IF HE TRIES TO XYZZY BACK INTO THE CAVE WITHOUT THE LAMP!).
C  OLDLOC IS ZAPPED SO HE CAN'T JUST "RETREAT".

C  THE EASIEST WAY TO GET KILLED IS TO FALL INTO A PIT IN PITCH DARKNESS.

94000	CALL RSPEAK(23)
	OLDLC2=LOC

C  OKAY, HE'S DEAD.  LET'S GET ON WITH IT.

94100	IF(CLOSNG .OR. CLOSED)GOTO 94500
	YEA=YES(81+NUMDIE*2,82+NUMDIE*2,54)
	NUMDIE=NUMDIE+1
	IF(NUMDIE.EQ.MAXDIE .OR. .NOT.YEA)GOTO 95000
	PROP(DIALS)=0
	IF(CHASE.EQ.0)GOTO 94160

C  CHAMP WAS BEING CHASED BY WUMPUS, & DIED ANOTHER WAY.
C  PUT WUMPUS BACK TO SLEEP, IN CASE OUR HERO STILL HASN'T GOT THE CLOAK.
	CHASE=0
	PROP(WUMPUS)=0
	CALL MOVE(WUMPUS,174)
94160	IF(TOTING(LAMP))PROP(LAMP)=0
	DO 94200 J=1,MAXOBJ
	IF(.NOT.HOLDNG(J))GOTO 94200
	LOC=OLDLC2
	IF(J.EQ.LAMP)LOC=1
	IF(J.EQ.NUGGET)PROP(STEPS)=0
	IF(J.NE.THRONE .AND. J.NE.THRONE+1)GOTO 94165
	PROP(THRONE)=0
	PROP(THRONE+1)=0
94165	CALL DROP(J,LOC)
	IF(.NOT.WEARNG(J))GOTO 94200
	PROP(J)=0
	CALL BITOFF(J,WEARBT)
94200	CONTINUE
	LOC=3
	OLDLOC=LOC
	WDX=0
	WORDS(1)=0
	CALL CLRLIN
	HEALTH=100
	GOTO 2000

C  HE DIED DURING CLOSING TIME.  NO RESURRECTION.  TALLY UP A DEATH AND EXIT.

94500	CALL RSPEAK(131)
	NUMDIE=NUMDIE+1
	GOTO 95000

C  IT'S OVER.  TALLY SCORE.

95000	SCORE=RATING(MXSCOR,BONUS,GAVEUP,SCORNG,CLOSNG,CLOSED)

C  THAT SHOULD BE GOOD ENOUGH.  LET'S TELL HIM ALL ABOUT IT.

	KK=1
	IF(GAVEUP)KK=2
	IF(DEMO .AND. TURNS.EQ.35)KK=3
	IF(BONUS.EQ.143)KK=3
	IF(SCORE.EQ.MXSCOR)KK=5
C???	CALL LOG(SCORE,TURNS,NUMDIE,KK,CLOSNG,CLOSED)

	WRITE (TTYOUT,95100) SCORE,MXSCOR,TURNS
95100	FORMAT(/'You scored',I4,' out of a possible',I4,', using',I5,' turns.')

	DO 95200 I=1,CLSSES
	IF(CVAL(I).GE.SCORE)GOTO 95210
95200	CONTINUE
	WRITE(TTYOUT,95202)
95202	FORMAT('You just went off my scale!!')
	GOTO 98000

95210	CALL SPEAK(CTEXT(I))
	IF(I.EQ.CLSSES-1)GOTO 95220
	K=CVAL(I)+1-SCORE
	IF(K.EQ.1)GOTO 95213
	WRITE (TTYOUT,95212) K
95212	FORMAT('To achieve the next higher rating, you need',I3,' more points.'/)
	GOTO 98000
95213	WRITE (TTYOUT,95214) K
95214	FORMAT('To achieve the next higher rating, you need',I3,' more point.'/)
	GOTO 98000


95220	WRITE(TTYOUT,95222)
95222	FORMAT(/'To achieve the next higher rating would be a neat trick!'//' CONGRATULATIONS!!'/)

98000	CONTINUE

	END
