C  aparse.F
C  Last modified on Tue Mar  2 21:10:09 2010 by eroberts
C       modified on Fri Sep 12 07:56:12 1986 by roberts
C  ----------

#include "params.h"

C  WHEN CALLED, CHECKS IF PREVIOUS WORDS VECTOR HAS BEEN EXHAUSTED.
C  IF NOT, BRANCH AROUND THE CODE WHICH READS IN A NEW LINE.  IF VECTOR IS EMPTY,
C  SUCK UP A LINE FROM THE TTY, THEN CHECK EACH WORD FOR INTELLIGIBILITY.
C  IF THE WORD IS VALID, ITS NUMBER GETS STUCK INTO THE WORDS VECTOR.
C  THEN EACH WORD IS PARSED BY THE APPROPRIATE CODE.  THE LABELS BELOW ARE
C  100 TIMES THE WORD CLASS.
C
C  THE FOLLOWING VECTORS ARE USED:
C	TXT(WDX,2)		HOLD THE RAW TEXT FROM GETLIN
C	WORDS(WDX)		LIST OF WORD NUMBERS, CONVERTED FROM TXT(WDX,1).
C	VTXT(VRBX,2)		HOLD THE TEXT FOR VERB VRBX.
C	VERBS(VRBX)		IS THE LIST OF VALIDATED VERB NUMBERS.
C	OTXT(OBJX,2)		HOLDS THE TEXT OF THE OBJECT OBJX.
C	OBJX(OBJX)		IS THE LIST OF VALIDATED OBJECT NUMBERS.
C	IOTXT(IOBX,2)		HOLDS THE TEXT FOR PREP'S IOBJ.

	SUBROUTINE PARSE
	IMPLICIT INTEGER (A-Z)
#include "adjcom.h"
#include "allcom.h"
#include "bitcom.h"
#include "diecom.h"
#include "dwfcom.h"
#include "gencom.h"
#include "liqcom.h"
#include "loccom.h"
#include "mnecom.h"
#include "placom.h"
#include "prpcom.h"
#include "utxcom.h"
#include "wrdcom.h"
	LOGICAL AT,ATHAND,BLIND,ENCLSD,HINGED,LIVING
	LOGICAL TOTING,VESSEL,PFLAG,CJFLAG
	INTEGER ADJS(6), TAKDIR(20)
	CHARACTER*5 C5A, C5B, WORD1, WORD2

C	     MOTION  NOUN  ACTION  MISC   PREP   ADJ    CONJ
	DATA CLASSD,CLASSN,CLASSA,CLASSM,CLASSP,CLASSJ,CLASSC
     1	 /1,2,3,4,5,6,7/
C
C  AND TO GET/DROP EVERYTHING IN SIGHT:
	DATA ALL /100/
C
C  TAKDIR IS A LIST OF MOTION VERBS WHICH ARE ACCEPTABLE AFTER 'TAKE'.
	DATA (TAKDIR(I),I=1,20)/2,6,9,10,11,13,14,17,23,25,33,34,
     1				36,37,39,78,79,80,89,-1/



C  IF WORDS(WDX+1) HAS SOMETHING IN IT, WE ARE STILL PROCESSING OLD INPUT LINE.
C  IF WORDS(1) = -2, SOMEONE ELSE HAS CALLED GETLIN (E.G., KILL DRAGON).

	IF(WORDS(WDX+1).GT.0)GOTO 30

C  IF WORDS(1) HAS BEEN SET TO -2, SOMEONE ELSE HAS ALREADY READ IN
C  THE NEW LINE, PRESUMABLY TO CHECK FOR SOME NON-STANDARD WORD.
C  (THIS HAPPENS WHEN KILLING DRAGON WITH BARE HANDS.)

20	IF(WORDS(1).NE.-2)CALL GETLIN
	WDX=0
	DO 25 I=1,35
	WORDS(I)=0
	IF(TXT(I,1).NE.' ')WORDS(I)=VOCAB(TXT(I,1),-1)
25	CONTINUE
	CJFLAG=.TRUE.

C  THE FIRST WORD OF EACH CLAUSE GETS SPECIAL CHECKING, MOSTLY LOOKING
C  FOR IDIOMS.

30	PFLAG=.FALSE.
	WDX=WDX+1
	WORD=WORDS(WDX)
	IF(WORD)830,820,32

32	KK=CLASS(WORD)
	IF(KK.EQ.-1)GOTO 91
	IF(WDX.EQ.1.AND.KK.EQ.CLASSC)GOTO 800
	IF(WDX.NE.1.AND.KK.NE.CLASSC)GOTO 800
	IF(WDX.NE.1)WDX=WDX+1
	WORD=WORDS(WDX)
	KK=CLASS(WORD)
	IF(KK.EQ.-1)GOTO 91
	IF(KK.EQ.CLASSD.OR.KK.EQ.CLASSM.OR.
     1		(KK.EQ.CLASSA.AND.VERBS(VRBX).NE.0))CALL CLRLIN
	K=VAL(WORD)
	IF(KK.NE.CLASSA.OR.(K.NE.SAY.AND.K.NE.YELL))GOTO 40

C  'SAY' OR 'CALL'.  IF NO NEXT WORD, PASS ON TO HIGHER POWERS.
C  IF OBJECT IS MAGIC WORD ('SAY XYZZY'), FLUSH 'SAY' & TAKE NEXT WORD.
	IF(WORDS(WDX+1).EQ.0.OR.CLASS(WORDS(WDX+1)).EQ.CLASSC)GOTO 99
	WDX=WDX+1
	IF(K.EQ.SAY)CALL A5LCA1(TXT(WDX,1),TXT(WDX,2),'".   ',C1ARR,K)
	IF(K.EQ.YELL)CALL A5LCA1(TXT(WDX,1),TXT(WDX,2),'"!!!!',C1ARR,K)
	WORD=WORDS(WDX)
	IF(WORD.EQ.62.OR.WORD.EQ.65.OR.WORD.EQ.71.OR.WORD.EQ.82
     1		.OR.WORD.EQ.93.OR.WORD.EQ.2025.OR.WORD.EQ.2063)GOTO 99
	WRITE(TTYOUT,37)(C1ARR(I),I=1,K)
37	FORMAT('Okay, "',20A1)
	GOTO 860

C  SPECIAL STUFF FOR 'ENTER'.  CAN'T GO INTO WATER.
C  'ENTER BOAT' MEANS 'TAKE BOAT'.
40	WORD1=TXT(WDX,1)
	WORD2=TXT(WDX+1,1)
	IF(WORD1.NE.'ENTER')GOTO 50
	IF(WORD2.EQ.' ')GOTO 91
	SPK=43
	IF(LIQLOC(LOC).EQ.WATER)SPK=70
	IF(WORD2.EQ.'STREA'.OR.WORD2.EQ.'WATER'.OR.WORD2.EQ.'RESER'
     1		.OR.WORD2.EQ.'OCEAN'.OR.WORD2.EQ.'SEA'
     2		.OR.WORD2.EQ.'POOL')GOTO 810
	IF(WORD2.NE.'BOAT'.AND.WORD2.NE.'ROWBO')GOTO 99
	WORD=TAKE+2000
	GOTO 99

C  'LEAVE' IS A MOTION VERB, UNLESS LEAVING AN OBJECT,
C  E.G., 'LEAVE BOAT' OR 'LEAVE BOTTLE'.  BUT MAKE SURE TO LEAVE ('DROP')
C  ONLY TOTABLE OBJECTS.
50	KK=WORDS(WDX+1)
	IF(WORD1.NE.'LEAVE'.OR.CLASS(KK).NE.CLASSN)
     1		GOTO 55
	IF(HINGED(VAL(KK)).OR.FIXED(VAL(KK)).NE.0)GOTO 99
	WORD=LEAVE+2000
	GOTO 99

C  IF 'LIGHT LAMP', LIGHT MUST BE TAKEN AS AN ACTION VERB, NOT A NOUN.
55	IF(WORD1.NE.'LIGHT'.OR.WORDS(WDX+1).NE.(LAMP+1000))GOTO 60
	WORD=LIGHT+2000
	GOTO 99

C  'WATER PLANT' BECOMES 'POUR WATER', IF WE ARE AT PLANT.
C  'OIL DOOR' BECOMES 'POUR OIL', ETC., ETC.
60	IF((WORD1.NE.'WATER'.AND.WORD1.NE.'OIL')
     1	  .OR.(WORD2.NE.'PLANT'.AND.WORD2.NE.'DOOR'
     2	     .AND.WORD2.NE.'SWORD'.AND.WORD2.NE.'ANVIL'))GOTO 65
	IF(.NOT.AT(VOCAB(WORD2,CLASSN)))GOTO 61
	WORDS(WDX+1)=WORDS(WDX)
	TXT(WDX+1,1)=WORD1
	TXT(WDX+1,2)=TXT(WDX,2)
61	WORD=POUR+2000
	GOTO 99

C  CHECK FILLING OR EMPTYING A CONTAINER.
65	IF((WORD1.NE.'EMPTY'.AND.WORD1.NE.'FILL').OR.
     1		(CLASS(WORDS(WDX+1)).NE.CLASSN))GOTO 91
	KK=VAL(WORDS(WDX+1))
	IF(KK.NE.SACK.AND.KK.NE.SAFE.AND.KK.NE.BOAT.AND.KK.NE.CHEST.AND.
     +	   KK.NE.THRONE.AND.KK.NE.THRONE+1) GOTO 91
	GOTO 91
C  *** UNFINISHED CODE HERE ***


C  THIS IS THE 'INNER' LOOP.  DISPATCHING OF ALL WORDS IN A CLAUSE AFTER
C  THE FIRST COMES THRU HERE.

90	WDX=WDX+1
	WORD=WORDS(WDX)
91	IF(WORD)830,900,92

96	WCLASS=WCLASS+1
	WORD=VOCAB(TXT(WDX,1),-(WCLASS+1))
	IF(WORD.EQ.-1)GOTO 800
	WORDS(WDX)=WORD
92	IF(CLASS(WORD).NE.CLASSN)GOTO 99

C  IT'S NOT THE FIRST: MAKE SURE HE INCLUDED A COMMA OR 'AND'.
C  DIFFERENTIATE BETWEEN DIR & INDIR OBJECTS.
C  ALSO MAKE SPECIAL CASE FOR "OIL LAMP"
C  CHECK FOR SPECIAL CASE OF MULTIPLE OBJECTS: 'FEED BEAR HONEY' OR
C  'THROW TROLL NUGGET'.

	K=OBJX
	IF (PFLAG) K = IOBX
	IF(K.EQ.0 .OR. CJFLAG)GOTO 98
	KK=VAL(VERBS(VRBX))
	IF(.NOT.LIVING(OBJS(OBJX)).OR.(KK.NE.THROW.AND.KK.NE.FEED))
     1		GOTO 800
	IOBX=IOBX+1
	IOBJS(IOBX)=OBJS(OBJX)
	OBJS(OBJX)=0
	OBJX=OBJX-1

98	CJFLAG=.FALSE.
99	WCLASS=CLASS(WORD)
	GOTO(100,200,300,400,500,600,700)WCLASS
C	     MWD OBJ AVB MVB PRP ADJ CNJ
	CALL BUG(33)



C  MOTION VERB.
C  A MOTION VERB IS EITHER A DIRECTION ('WEST') OR A MOTION ('JUMP').
C  MULTIPLE MOTIONS MUST BE SEPARATED BY COMMAS OR AND'S.  THERE ARE
C  SOME IDIOMATIC USES WHICH MUST BE SCANNED FOR, SUCH AS 'TAKE BRIDGE',
C  WHICH BECOMES 'BRIDGE' AND 'GO WEST', WHICH BECOMES 'WEST', AND 'LEAVE THING'
C  IS DIFFERENT FROM JUST 'LEAVE'.
C
C  IF ORIGINAL VERB WAS 'GO', FLUSH IT & REPLACE WITH THIS ONE.
C  I.E., 'GO WEST' BECOMES 'WEST'.
C
C  CHECK TAKDIR(20) LIST FOR VALID OBJECT MOTION VERBS FOR 'TAKE'.
C  IF FOUND, THROW AWAY 'TAKE' AND USE THE MOTION VERB.
C
C  SINCE THE ORIGINAL VERB IS AN ACTION VERB, CHECK THIS WORD IN THE
C  NOUN TABLE.  MAYBE IT IS AN OBJECT SYNONYMOUS WITH A VERB ('ROCKS').
C
C  IF IT ISN'T A VALID MOTION-OBJECT OF 'TAKE' OR 'GO', NOR AN OBJECT,
C  CHECK THE PREP TABLE.  IF FOUND, HAND IT TO THE PREPOSITION ANALYZER.

100	IF(VRBX.EQ.0)GOTO 180
	K=VERBS(VRBX)
	IF(TXT(WDX,1).EQ.'CAVE'.AND.VAL(K).EQ.FIND)  GOTO 180
	IF(TXT(WDX,1).EQ.'OVER'.AND.
     +	   (VAL(K).EQ.DROPVB.OR.VAL(K).EQ.THROW))  GOTO 170
	IF(CLASS(K).GT.CLASSA)GOTO 800
	IF(CLASS(K).NE.CLASSA)GOTO 140
	IF(VAL(K).EQ.GO)GOTO 180
	IF(VAL(K).NE.TAKE)GOTO 96
	KK=VAL(WORD)
	DO 110 I=1,20
	IF(TAKDIR(I).EQ.KK)GOTO 180
110	CONTINUE
	GOTO 96

C  IF ORIGINAL MOTION VERB WAS CRAWL, JUMP OR CLIMB, IGNORE CURRENT WORD.
C  I.E., 'CLIMB UP' OR 'JUMP OVER' BECOME 'CLIMB' & 'JUMP' ONLY.

140	IF(K.EQ.17.OR.K.EQ.39.OR.K.EQ.56)GOTO 90
	GOTO 180

C  SIMPLE HACK FOR DROP OVER, CHANGE TO DROP THROUGH

170	WORD=VOCAB('THROU',-(CLASSP+1))
	IF (WORD.NE.-1)  GOTO 500
	CALL BUG(5)

180	VERBS(1)=WORD
	VRBX=1
	IF(TXT(WDX,1).NE.'WEST')GOTO 90
	IWEST=IWEST+1
	IF(IWEST.EQ.10)CALL RSPEAK(17)
	K=VAL(WORD)
	IF(K.EQ.EXIT.OR.K.EQ.ENTER)GOTO 860
	GOTO 90

190	WDX = WDX + 1
	WORD = WORDS(WDX)
	IF (WORD .EQ. 0)  GOTO 900
	IF (CLASS(WORD).EQ.CLASSC)  GOTO 900
	GOTO 190



C  ANALYZE OBJECT.
C  IF PFLAG IS TRUE, THEN WE ARE PROCESSING A SET OF INDIRECT (PREP)
C  OBJECTS, NOT DIRECT OBJS.

200	IF(PFLAG)GOTO 503
	IF(VRBX.NE.0)GOTO 220
	K=VOCAB(TXT(WDX,1),-(CLASSA+1))
	IF(K.EQ.-1.OR.CLASS(K).EQ.CLASSJ)GOTO 220
	WORD=K
	GOTO 300

220	WORD=VAL(WORD)
	IF(WORD.EQ.ALL)GOTO 280
222	CALL GETOBJ(WORD)
	IF(WORD)230,860,240

C  IT WASN'T REALLY AN OBJECT.  GO SEE WHAT IT WAS.

230	IF(WORD.EQ.-1)GOTO 270
	WORD=-WORD
	GOTO 99

C  IT WAS REALLY AN OBJECT & IT IS HERE.
240	OBJX=OBJX+1
	OBJS(OBJX)=WORD
	OTXT(OBJX,1)=TXT(WDX,1)
	OTXT(OBJX,2)=TXT(WDX,2)
	GOTO 90

C  TAKE "THEM" AFTER TAKE "ALL".

270	OBJX=OLDJX
	DO 272 I=1,OBJX
	OBJS(I)=OLDOBJ(I)
	OTXT(I,1)=OLDTXT(I,1)
272	OTXT(I,2)=OLDTXT(I,2)
	GOTO 90

C  TAKE EVERYTHING NOT BATTENED DOWN.

280	KK=VAL(VERBS(VRBX))
	K=0
	IF(KK.EQ.DROPVB.OR.KK.EQ.LEAVE)K=1
	IF(KK.EQ.TAKE.OR.KK.EQ.PICK.OR.KK.EQ.GET)K=2
	IF(KK.EQ.PUTVB)K=3
	SPK=357
	IF(K.NE.1 .AND. BLIND(0))GOTO 810
281	DO 287 I=1,MAXOBJ
	IF(.NOT.ATHAND(I).OR.FIXED(I).NE.0)GOTO 287
	IF(I.GE.WATER.AND.I.LE.WINE+1)GOTO 287
	IF(((K.EQ.1).AND..NOT.TOTING(I)) .OR. 
     +	  ((K.EQ.2).AND.TOTING(I)) .OR.
     +	  ((K.EQ.3).AND.(ENCLSD(I).OR.VESSEL(I))) )GOTO 287
	OBJX=OBJX+1
	OBJS(OBJX)=I
	OTXT(OBJX,1)=NTXT(I,1)
	OTXT(OBJX,2)=NTXT(I,2)
	IF(OBJX.EQ.44)GOTO 90
287	CONTINUE
	GOTO 90



C  ACTION VERB.
300	IF(VRBX.EQ.0)GOTO 370
	
	IF(VAL(VERBS(VRBX)).NE.TAKE.OR.CJFLAG)
     1		GOTO 320
	CJFLAG=.FALSE.
	K=VAL(WORD)
	IF(K.EQ.DRINK.OR.K.EQ.INVENT.OR.K.EQ.SCORE.OR.K.EQ.NOTHNG
     1		.OR.K.EQ.LOOK)GOTO 371
	IF(K.NE.GO)GOTO 800
	C5A=TXT(WDX,1)
	IF(C5A.EQ.'WALK'.OR.C5A.EQ.'RUN'.OR.C5A.EQ.'HIKE')GOTO 371
	GOTO 800

310	VERBS(VRBX)=VOCAB('UNLOC',-(CLASSA+1))
	IOBX=IOBX+1
	IOBJS(IOBX)=VAL(VOCAB('HANDS',-(CLASSN+1)))
	IOTXT(IOBX,1)='HANDS'
	IOTXT(IOBX,2)=' '
	GOTO 90

320	IF(WORD.EQ.VOCAB('LOCK ',-(CLASSA+1)).AND.
     +    VAL(VERBS(VRBX)).EQ.PICK) GOTO 310
	IF(OBJX.NE.0.OR..NOT.CJFLAG)GOTO 800
370	VRBX=VRBX+1
371	VERBS(VRBX)=WORD
	VTXT(VRBX,1)=TXT(WDX,1)
	VTXT(VRBX,2)=TXT(WDX,2)
	GOTO 90

C  MISCELLANEOUS WORDS/VERBS.
400	VERBS(1)=WORD
	VRBX=1
	GOTO 90



C  ANALYZE A PREPOSITION AND ITS OBJECT.  CHECK THAT PREP
C  IS VALID FOR THIS VERB, AND THEN CHECK THAT THE OBJECT IS VALID
C  FOR THIS PREPOSITION.  IF FIRST CHECK FAILS, SYNTAX IS MESSED
C  UP; IF SECOND PART FAILS, IT MAY MERELY BE AN IMPOSSIBLE ACT.

500	IF(TXT(WDX,1).EQ.'OF')GOTO 550
	IF(CLASS(VERBS(VRBX)).NE.CLASSA.OR.IOBX.NE.0)GOTO 800
	IF(PFLAG)GOTO 503
	VRBKEY=VKEY(VAL(VERBS(VRBX)))
	IF(VRBKEY.EQ.0)GOTO 800
	PREP=VAL(WORD)
	PFLAG=.TRUE.
	WDX=WDX+1
	WORD=WORDS(WDX)
	GOTO(510,501,503,800,800,800,600,510)CLASS(WORD)+1
	GOTO 830

501	WORD=VOCAB(TXT(WDX,1),-(CLASSN+1))
	IF (WORD.EQ.-1)  GOTO 800
	WORDS(WDX)=WORD
503	WORD=VAL(WORD)
	IF(WORD.EQ.ALL)GOTO 510
504	CALL GETOBJ(WORD)
	IF(WORD)570,860,505

505	IOBX=IOBX+1
	IOBJS(IOBX)=WORD
	IOTXT(IOBX,1)=TXT(WDX,1)
	IOTXT(IOBX,2)=TXT(WDX,2)
510	KK=IABS(PTAB(VRBKEY)/1000)
	IF(KK.NE.PREP)GOTO 525

C  PREP IS VALID WITH THIS VERB.  NOW CHECK OBJECT OF PREP.
	IF(WORD.EQ.0.OR.CLASS(WORD).EQ.CLASSC)GOTO 530

C  AN OBJ FOLLOWS THE PREP.  SEE IF IT'S PLAUSIBLE.
520	KK=IABS(VAL(PTAB(VRBKEY)))
	IF(KK.EQ.WORD.AND.KK.EQ.ALL)GOTO 280
	IF(KK.EQ.WORD.OR.KK.EQ.999)GOTO 90
525	VRBKEY=VRBKEY+1
	IF(PTAB(VRBKEY-1).GE.0)GOTO 510
	GOTO 570

C  NO OBJ FOLLOWS PREP.  CHECK SPECIAL CASES.
530	PFLAG=.FALSE.
	WDX=WDX-1
	C5A=TXT(WDX,1)
	C5B=VTXT(VRBX,1)
	IF((C5A.NE.'ON'.AND.C5A.NE.'OFF').AND.
     1	 (C5B.NE.'TURN'.OR.OBJS(OBJX).NE.LAMP) .AND.
     2	 (C5B.NE.'TAKE'.AND.C5B.NE.'PUT') )GOTO 570
	IF((C5A.EQ.'UP'.AND.C5B.NE.'PICK').OR.
     1	 (C5A.EQ.'DOWN'.AND.(C5B.NE.'PUT'.AND.VERBS(VRBX).NE.THROW)))
     2	 GOTO 570
	IF(WORDS(WDX+1).NE.0.AND.CLASS(WORDS(WDX+1)).NE.CLASSC)GOTO 800
	GOTO 90

C  "OF" IS A SPECIAL CASE.  JUST FLUSH WORDS AS LONG AS ADJS OR NOUNS

550	WDX=WDX+1
	IF(WORDS(WDX).EQ.0)GOTO 900
	WORD=VOCAB(TXT(WDX,1),-1)
	IF(WORD)830,900,551
551	CWORD=CLASS(WORD)
	IF(CWORD.EQ.CLASSJ.OR.CWORD.EQ.CLASSN)GOTO 550
	GOTO 99

C  YOU CAN'T DO THAT!!
570	SPK=NOWAY(0)
	GOTO 810



C  ADJECTIVE HANDLER.
C  SCARF THE NEXT WORD, MAKE SURE IT IS A VALID OBJECT FOR THIS ADJ.
C  THEN CALL GETOBJ TO SEE IF IT IS REALLY THERE, THEN LINK INTO OBJ
C  CODE.

600	NADJ=0
601	ADJ=VAL(WORD)
	NADJ=NADJ+1
	ADJS(NADJ)=ADJ
	WDX=WDX+1
	WORD=WORDS(WDX)
	IF(WORD)830,620,605

605	WORD=VOCAB(TXT(WDX,1),-(CLASSN+1))
	CWORD = CLASS(WORD)
	IF(CWORD.EQ.CLASSC.OR.CWORD.EQ.CLASSP) GOTO 620
	IF(CWORD.EQ.CLASSJ) GOTO 601
	IF(WORD.EQ.-1.OR.CLASS(WORD).NE.CLASSN.OR.VAL(WORD).EQ.ALL)
     1		GOTO 800
	WORDS(WDX)=WORD
	KK=VAL(WORD)
	DO 615 IADJ=1,NADJ
	ADJ=ADJS(IADJ)
	K=ADJKEY(ADJ)
610	IF(KK.EQ.IABS(ADJTAB(K)))GOTO 615
	IF(ADJTAB(K).LT.0)GOTO 800
	K=K+1
	GOTO 610
615	CONTINUE
	GOTO 92

620	WDX=WDX-1
	ASPK=539
	DO 635 IADJ=1,NADJ
	ADJ=ADJS(IADJ)
	UNIQUE=-1
	DO 630 II=1,MAXOBJ
	IF (.NOT.ATHAND(II))  GOTO 630
	K=ADJKEY(ADJ)
625	IF(II.EQ.IABS(ADJTAB(K)))GOTO 627
	IF(ADJTAB(K).LT.0)GOTO 630
	K=K+1
	GOTO 625
627	IF (UNIQUE .GE. 0)  GOTO 634
	UNIQUE = II + 1000
630	CONTINUE
	IF (UNIQUE .LT. 0)  GOTO 635
	WORD = UNIQUE
	GOTO 92
634	ASPK=540
635	CONTINUE

640	CALL RSPEAK(ASPK)
	GOTO 20


C  ANALYZE A CONJUNCTION.  MAY BE A COMMA OR AN EXPLICIT "AND".
C  LOOK AHEAD AT NEXT WORD.  IF IT IS AN ACTION VERB AND NO OBJECT
C  HAS YET BEEN SPECIFIED, PUT IT INTO THE VERB STACK.  IF IT IS
C  AN OBJECT, ADD IT TO THE PILE.
C  ELSE, BUMP BACK THE WORD POINTER, ASSUME END OF CLAUSE, AND
C  RETURN.

700	WDX=WDX+1
	WORD=WORDS(WDX)
	IF (WORD) 830,800,710

C???	CJFLAG=.TRUE.
710	GOTO(790,200,790,790,800,600,700)CLASS(WORD)
C	     MWD OBJ AVB MVB PRP ADJ CNJ

790	WDX=WDX-2
	GOTO 900



C  GEE, I DON'T UNDERSTAND.  FLUSH REST OF CURRENT CLAUSE, UP TO
C  EOL CONTINUE.
800	SPK=CONFUZ(0)
810	CALL RSPEAK(SPK)
820	CALL CLRLIN
	GOTO 20

830	CALL A5LCA1(TXT(WDX,1),TXT(WDX,2),'".   ',C1ARR,K)
	WRITE(TTYOUT,832)(C1ARR(I),I=1,K)
832	FORMAT('I don''t understand the word "',20A1)
	CALL CLRLIN
	GOTO 20

C  SCAN TO CONJUNCTION OR END OF LINE.
860	CALL CLRLIN
	PFLAG=.FALSE.
	CJFLAG=.TRUE.
862	WDX=WDX+1
864	IF(WORDS(WDX).EQ.0)GOTO 20
	IF(CLASS(WORDS(WDX)).EQ.CLASSC)GOTO 90
	GOTO 862

C  END OF CLAUSE.  WE APPEAR TO HAVE REACHED THE END OF A SENTENCE.
C  IT WAS TERMINATED EITHER BY CRLF OR A CONJUNCTION.  IF A CONJ,
C  THE CONJ ANALYZER CLAIMS  THAT THE NEXT WORDS ARE NOT PART OF
C  THIS CLAUSE.  DECIDE WHETHER OR NOT WE HAVE ENOUGH TO WORK WITH.
900	PFLAG=.FALSE.
	IF(VERBS(1).NE.0)GOTO 930
	IF(OBJS(1).EQ.0)GOTO 800
	IF(OBJS(2).NE.0)GOTO 920
	CALL A5LCA1(OTXT(1,1),OTXT(1,2),'?    ',C1ARR,K)
	WRITE(TTYOUT,915)(C1ARR(I),I=1,K)
915	FORMAT('What do you want to do with the ',20A1)
	GOTO 20

920	CALL A5LCA1('them ','     ','?    ',C1ARR,K)
	WRITE(TTYOUT,926)(C1ARR(I),I=1,K)
926	FORMAT('What do you want to do with ',20A1)
	GOTO 20

930	IF(OBJX.GT.1.AND.IOBX.GT.1)GOTO 800
	IF(IOBJX.GT.1)GOTO 950
	OLDJX=OBJX
	DO 940 I = 1,OBJX
	OLDOBJ(I)=OBJS(I)
	OLDTXT(I,1)=OTXT(I,1)
940	OLDTXT(I,2)=OTXT(I,2)
	RETURN

950	OLDJX=IOBX
	DO 960 I = 1,IOBX
	OLDOBJ(I)=IOBJS(I)
	OLDTXT(I,1)=IOTXT(I,1)
960	OLDTXT(I,2)=IOTXT(I,2)
	RETURN

	END



C  ANALYSE AN OBJECT WORD.  SEE IF THE THING IS HERE, WHETHER WE'VE GOT A VERB
C  YET, AND SO ON.  OBJECT MUST BE HERE UNLESS VERB IS "FIND" OR "INVENT(ORY)"
C  (AND NO NEW VERB YET TO BE ANALYSED).  WATER, OIL AND WINE ARE ALSO
C  FUNNY, SINCE THEY ARE NEVER ACTUALLY DROPPED AT ANY LOCATION, BUT MIGHT
C  BE HERE INSIDE THE BOTTLE OR AS A FEATURE OF THE LOCATION.
C
C  HAS THREE POSSIBLE RETURN VALUES FOR 'OBJ':
C	VAL > 0 :: A POSITIVE OBJECT NUMBER
C	VAL = 0 :: OBJECT NOT FOUND HERE OR SPECIAL.  MESSAGE ALREADY PRINTED.
C		   OBJECT NOT FOUND GETS THIS.  ALSO DISAPPEARING DWARVES'
C		   KNIVES.
C	VAL < 0 :: OBJECT WORD REALLY SOMETHING ELSE.  RETURN NEGATIVE
C			VALUE OF SUBSTITUTED WORD.

	SUBROUTINE GETOBJ(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "bitcom.h"
#include "dwfcom.h"
#include "gencom.h"
#include "liqcom.h"
#include "loccom.h"
#include "mnecom.h"
#include "objcom.h"
#include "placom.h"
#include "utxcom.h"
#include "wrdcom.h"
	LOGICAL AJAR,AT,ATHAND,BLIND,ENCLSD,HOLDNG,LOCKED,OPAQUE
	DATA CLASSD,CLASSN,CLASSA,CLASSM,CLASSP,CLASSJ,CLASSC
     1		/1,2,3,4,5,6,7/

	IF(OBJ.NE.1) GOTO 10
	OBJ=-1
	RETURN

10	IF(OBJ.EQ.0) RETURN
	IF(OBJ.EQ.THRONE.AND.ATHAND(THRONE+1)) OBJ=OBJ+1
	IF(HOLDNG(OBJ))GOTO 900
	IF(BLIND(0))GOTO 280
	IF(FIXED(OBJ).EQ.LOC.OR.ATHAND(OBJ)) GOTO 900
	IF(OBJ.EQ.ROD.AND.((PLACE(ROD2).EQ.115.AND.LOC.EQ.116).OR.
     1		(PLACE(ROD2).EQ.116.AND.LOC.EQ.115)))GOTO 900
	IF (.NOT.ENCLSD(OBJ)) GOTO 210
	CTLOC=-PLACE(OBJ)
	IF (CTLOC.LE.0) GOTO 210
	IF (OPAQUE(CTLOC)) GOTO 210
	IF (.NOT.AJAR(CTLOC).AND..NOT.LOCKED(CTLOC)) GOTO 15
	SPK=335
	IF (AJAR(CTLOC)) SPK=545
	CALL RSPEAK(SPK)
	OBJ=0
	RETURN

15	CALL BITON(CTLOC,OPENBT)
	GOTO 900

210	IF(OBJ.NE.DWARF)GOTO 220
	DO 212 I=1,DWFMAX-1
	IF(DLOC(I).EQ.LOC.AND.DFLAG.GE.2) GOTO 900
212	CONTINUE
	GOTO 280

220	IF(OBJ.EQ.LIQLOC(LOC).OR.
     1		(ATHAND(BOTTLE).AND.LIQ(BOTTLE).EQ.OBJ).OR.
     2		(ATHAND(CASK).AND.LIQ(CASK).EQ.OBJ)) GOTO 900
	IF(OBJ.NE.PLANT.OR..NOT.AT(PLANT2).OR.PROP(PLANT2).EQ.0)GOTO 230
	OBJ=PLANT2
	GOTO 900

230	IF(OBJ.NE.ROCKS.OR..NOT.AT(CARVNG))GOTO 240
	OBJ=CARVNG
	GOTO 900

240	IF(OBJ.NE.ROD.OR..NOT.ATHAND(ROD2))GOTO 250
	OBJ=ROD2
	GOTO 900

250	IF(OBJ.NE.DOOR.OR..NOT.
     1		(AT(SAFE).OR.AT(TDOOR).OR.AT(TDOOR+1).OR.AT(PDOOR)))
     2		GOTO 265
	OBJ=TDOOR
	IF(AT(TDOOR+1))OBJ=TDOOR+1
	IF(AT(PDOOR))OBJ=PDOOR
	IF(AT(SAFE))OBJ=SAFE
	GOTO 900

C  DWARVES' KNIVES DISAPPEAR AS SOON AS THEY HIT THE WALL.  (CAN'T GET
C  THEM.)

265	IF(OBJ.NE.KNIFE.OR.KNFLOC.NE.LOC)GOTO 270
	KNFLOC=-1
	CALL RSPEAK(116)
	OBJ=0
	GOTO 900

270	IF(OBJ.EQ.VAL(VOCAB('HANDS',-(CLASSN+1))))  GOTO 900
	VX = MOD(VERBS(VRBX), 1000)
	IF(VX.EQ.FIND.OR.VX.EQ.INVENT.OR.VX.EQ.WZGOTO)  GOTO 900
	IF(PREP.EQ.VAL(VOCAB('THROU',-(CLASSP+1))) .AND. 
     +      OBJ.EQ.VAL(VOCAB('FISSU',-1)))GOTO 900

C  IT ISN'T HERE.  TELL HIM & RETURN.

280	IF (OBJ.EQ.TORCH.AND.
     +      (LOC.EQ.246.OR.LOC.EQ.115.OR.LOC.EQ.116))GOTO 285
	OBJ=0
	CALL A5LCA1(TXT(WDX,1),TXT(WDX,2),'here.',C1ARR,K)
	WRITE (TTYOUT,282) (C1ARR(I),I=1,K)
282	FORMAT('I see no ',20A1)
	GOTO 900
285	OBJ=0
	CALL RSPEAK(550)
	RETURN

900	IF (OBJ.LE.0.OR.PREP.NE.0) RETURN
	RETURN

	END



C  FIGURE OUT THE NEW LOCATION
C
C  GIVEN THE CURRENT LOCATION IN "LOC", AND A MOTION VERB NUMBER IN "K", PUT
C  THE NEW LOCATION IN "NEWLOC".  THE CURRENT LOC IS SAVED IN "OLDLOC" IN CASE
C  HE WANTS TO RETREAT.  THE CURRENT OLDLOC IS SAVED IN OLDLC2, IN CASE HE
C  DIES.  (IF HE DOES, NEWLOC WILL BE LIMBO, AND OLDLOC WILL BE WHAT KILLED
C  HIM, SO WE NEED OLDLC2, WHICH IS THE LAST PLACE HE WAS SAFE.)

	SUBROUTINE TRAVL(K)
	IMPLICIT INTEGER (A-Z)
#include "trvcom.h"
#include "bltcom.h"
#include "gencom.h"
#include "lincom.h"
#include "liqcom.h"
#include "ltxcom.h"
#include "placom.h"
#include "objcom.h"
#include "loccom.h"
#include "mnecom.h"
	LOGICAL TEETER,PCT
	LOGICAL OUTSID,TOTING,AT,FORCED,HOLDNG,WEARNG

	KILLED=.FALSE.
	KK=KEY(LOC)
	NEWLOC=LOC
	IF(KK.EQ.0)CALL BUG(26)
	IF(K.EQ.NULL)RETURN
	IF(K.EQ.BACK)GOTO 20
	IF(K.EQ.CAVE)GOTO 40
	OLDLC2=OLDLOC
	OLDLOC=LOC

9	LL=IABS(TRAVEL(KK))
	IF(TRKEY(KK).EQ.1.OR.TRKEY(KK).EQ.K)GOTO 10
	IF(TRAVEL(KK).LT.0)GOTO 50
	KK=KK+1
	GOTO 9

10	NEWLOC=LL/5000
	K=MOD(NEWLOC,1000)
	IF(NEWLOC.LE.3000)GOTO 13
	IF(PROP(K).NE.NEWLOC/1000-3)GOTO 16
12	IF(TRAVEL(KK).LT.0)CALL BUG(25)
	KK=KK+1
	NEWLOC=IABS(TRAVEL(KK))
	IF(NEWLOC.EQ.LL)GOTO 12
	LL=NEWLOC
	GOTO 10

13	IF(NEWLOC.LE.1000)GOTO 14
	IF(TOTING(K).OR.(NEWLOC.GT.2000.AND.AT(K)))GOTO 16
	GOTO 12

14	IF(NEWLOC.LE.100) GOTO 15
	TLOC=MOD(LL,5000)
	GOTO (10010, 10020, 10030) NEWLOC-100
	CALL BUG(20)

15	IF(NEWLOC.NE.0.AND..NOT.PCT(NEWLOC))GOTO 12
16	NEWLOC=MOD(LL,5000)
	IF(NEWLOC.LE.MAXLOC)RETURN
	IF(NEWLOC.LE.4000)GOTO 30000
	CALL RSPEAK(NEWLOC-4000)
	NEWLOC=LOC
	RETURN

C  HANDLE "GO BACK".  LOOK FOR VERB WHICH GOES FROM LOC TO OLDLOC, OR TO OLDLC2
C  IF OLDLOC HAS FORCED-MOTION.  K2 SAVES ENTRY -> FORCED LOC -> PREVIOUS LOC.

20	K=OLDLOC
	IF(FORCED(K))K=OLDLC2
	OLDLC2=OLDLOC
	OLDLOC=LOC
	K2=0
	IF(K.NE.LOC)GOTO 21
	CALL RSPEAK(91)
	RETURN

21	LL=MOD(IABS(TRAVEL(KK)),10000)
	IF(LL.EQ.K)GOTO 25
	IF(LL.GT.MAXLOC)GOTO 22
	J=KEY(LL)
	IF(FORCED(LL).AND.MOD(IABS(TRAVEL(J)),10000).EQ.K)K2=KK
22	IF(TRAVEL(KK).LT.0)GOTO 23
	KK=KK+1
	GOTO 21

23	KK=K2
	IF(KK.NE.0)GOTO 25
	CALL RSPEAK(140)
	RETURN

25	K=IABS(TRAVEL(KK))
	KK=KEY(LOC)
	GOTO 9

C  CAVE.  DIFFERENT MESSAGES DEPENDING ON WHETHER ABOVE GROUND.

40	IF(OUTSID(LOC))CALL RSPEAK(57)
	IF(.NOT.OUTSID(LOC))CALL RSPEAK(58)
	RETURN

C  NON-APPLICABLE MOTION.  VARIOUS MESSAGES DEPENDING ON WORD GIVEN.

50	SPK=12
	IF(K.GE.43.AND.K.LE.50)SPK=9
	IF(K.EQ.29.OR.K.EQ.30)SPK=9
	IF(K.EQ.7.OR.K.EQ.36.OR.K.EQ.37)SPK=10
	IF(K.EQ.11.OR.K.EQ.19)SPK=11
	IF(VERB.EQ.FIND.OR.VERB.EQ.INVENT)SPK=59
	IF(K.EQ.62.OR.K.EQ.65)SPK=518
	IF(K.EQ.94)SPK=547
	IF(K.EQ.82)SPK=519
	IF(K.EQ.82.AND..NOT.(OUTSID(LOC)))SPK=42
	IF(K.EQ.17)SPK=80
	CALL RSPEAK(SPK)
	RETURN


C  SPECIAL CONDITIONS COME HERE.

10010	IF (.NOT.TEETER(TLOC))GOTO 16
	CALL RSPEAK(559)
	CALL BLKLIN
	GOTO 16

10020	IF (.NOT.TEETER(TLOC)) GOTO 16
	CALL RSPEAK(560)
	CALL BLKLIN
	GOTO 12

10030	IF (.NOT.TEETER(TLOC)) GOTO 16
	CALL RSPEAK(561)
	CALL BLKLIN
	GOTO 12



C  SPECIAL MOTIONS COME HERE.  LABELLING CONVENTION: STATEMENT NUMBERS NNNXX
C  (XX=00-99) ARE USED FOR SPECIAL CASE NUMBER NNNN (NNNN=3001-5000).

30000	NEWLOC=NEWLOC-3000
	GOTO (30010,30020,30030,30040,30050,30060,30070,30080,
     +        30090,30100,30110,30120)NEWLOC
C	      ALCOV PLOVR TROLL PHUCE BOOTH BRDGE FRIEN PRAY
C             CRACK JUMP  GOLLU TMACH
	CALL BUG(20)

C  SPECIAL TRAVEL #1.  PLOVER-ALCOVE PASSAGE.  CAN'T CARRY ANYTHING.
C  NOTE: TRAVEL TABLE MUST INCLUDE "USELESS" ENTRIES GOING THROUGH
C  PASSAGE, WHICH CAN NEVER BE USED FOR ACTUAL MOTION, BUT CAN BE
C  SPOTTED BY "GO BACK".

30010	DO 30011 I = 1,MAXOBJ
30011	IF(HOLDNG(I)) GOTO 30012
	NEWLOC=99+100-LOC
	RETURN
30012	NEWLOC=LOC
	CALL RSPEAK(117)
	RETURN

C  SPECIAL TRAVEL #2.  LEAVING THRONE.

30020	IF (TOTING(THRONE)) CALL DROP(THRONE,LOC)
	IF (TOTING(THRONE+1)) CALL DROP(THRONE+1,LOC)
	PROP(THRONE)=0
	PROP(THRONE+1)=0
	NEWLOC=LOC
	CALL RSPEAK(513)
	RETURN

C  SPECIAL TRAVEL #3.  TROLL BRIDGE.  MUST BE DONE ONLY AS SPECIAL MOTION SO THAT
C  DWARVES WON'T WANDER ACROSS AND ENCOUNTER THE BEAR.  (THEY WON'T FOLLOW THE
C  PLAYER THERE BECAUSE THAT REGION IS FORBIDDEN TO THE PIRATE.)  IF
C  PROP(TROLL)=1, HE'S CROSSED SINCE PAYING, SO STEP OUT AND BLOCK HIM.
C  (STANDARD TRAVEL ENTRIES CHECK FOR PROP(TROLL)=0.)  SPECIAL STUFF FOR BEAR.

30030	IF(PROP(TROLL).NE.1)GOTO 30031
	CALL PSPEAK(TROLL,1)
	PROP(TROLL)=0
	CALL MOVE(TROLL+1,0)
	CALL MOVE(TROLL+1+MAXOBJ,0)
	CALL MOVE(TROLL,PLAC(TROLL))
	CALL MOVE(TROLL+MAXOBJ,FIXD(TROLL))
	CALL JUGGLE(CHASM)
	NEWLOC=LOC
	RETURN

30031	NEWLOC=PLAC(TROLL)+FIXD(TROLL)-LOC
	IF(PROP(TROLL).EQ.0)PROP(TROLL)=1
	IF(.NOT.HOLDNG(BEAR))RETURN
	CALL RSPEAK(162)
	PROP(CHASM)=1
	PROP(TROLL)=2
	CALL DROP(BEAR,NEWLOC)
	FIXED(BEAR)=-1
	PROP(BEAR)=3
	IF(PROP(SPICES).LT.0)TALLY2=TALLY2+1
	OLDLC2=NEWLOC
	KILLED=.TRUE.
	RETURN

C  SPECIAL TRAVEL #4.  GROWING OR SHRINKING IN AREA OF TINY DOOR.  EACH TIME
C  HE DOES THIS, EVERYTHING MUST BE MOVED TO THE NEW LOC.  PRESUMABLY,
C  ALL HIS POSSESIONS ARE SHRUNK OR STRECHED ALONG WITH HIM.
C  PHUCE(2,4) IS AN ARRAY CONTAINING FOUR PAIRS OF "HERE" (K) AND
C  "THERE" (KK) LOCATIONS.

30040	K=PHUCE(1,LOC-161+1)
	NEWLOC=PHUCE(2,LOC-161+1)
	DO 30042 OBJ=1,MAXOBJ
30041	IF(OBJ.EQ.BOAT.OR.OBJ.EQ.RING)GOTO 30042
	IF(PLACE(OBJ).EQ.K.AND.(FIXED(OBJ).EQ.0.OR.FIXED(OBJ).EQ.-1))
     1		CALL MOVE(OBJ,NEWLOC)
30042	CONTINUE
	IF (.NOT.(WEARNG(RING).OR.TOTING(RING)))  RETURN
	CALL RSPEAK(479)
	CALL DROP(RING,LOC)
	RETURN

C  SPECIAL TRAVEL #5.

30050	RETURN

C  SPECIAL TRAVEL #6.  COLLAPSING CLAY BRIDGE. CAN CROSS WITH 155 POUNDS OR
C  LESS.  IF MORE, HE MAY END UP IN THE DRINK.

30060	BCROSS=BCROSS+1
	KK=BURDEN(0)+130
	IF(KK.LE.155) GOTO 30061
	K=MIN0(100, KK-120)
	IF(PCT(K))GOTO 30062
30061	NEWLOC=235
	IF(LOC.EQ.235)NEWLOC=190
	IF(KK.GT.145)CALL RSPEAK(318)
	RETURN

30062	CALL RSPEAK(319)
	PROP(CHASM2)=1
	GOTO 30100


C	SPECIAL TRAVEL #7, SAYING FRIEND

30070	PROP(CLIFF)=1-PROP(CLIFF)
	CALL RSPEAK(435+PROP(CLIFF))
	NEWLOC=LOC
	RETURN

C	SPECIAL TRAVEL #8, PRAYING AT ALTAR

30080	PROP(STALAG)=1-PROP(STALAG)
	CALL RSPEAK(469-PROP(STALAG))
	NEWLOC=LOC
	RETURN

C	SPECIAL TRAVEL #9, GET RID OF RING

30090	CALL RSPEAK(477)
	NEWLOC=12
	IF (.NOT.(WEARNG(RING).OR.TOTING(RING)))  RETURN
	CALL RSPEAK(478)
	CALL DROP(RING,LOC)
	RETURN

C	SPECIAL TRAVEL #10, GO TO MIDAIR ROOM

30100	TOPLOC=LOC
	NEWLOC=FALLRM
	RETURN

C	SPECIAL TRAVEL #11, GOLLUM IN POOL

30110	CALL MOVE(BALL, 319)
	CALL RSPEAK(579)
	NEWLOC=310
	LOC=310
	RETURN

C	SPECIAL TRAVEL #12, TIME MACHINE IN PAST

30120	NEWLOC=322
	LOC=322
	IF (PROP(VIAL).NE.0)  RETURN
	PROP(VIAL)=1
	CALL RSPEAK(597)
	INDLIN=.TRUE.
	CALL RSPEAK(598)
	INDLIN=.FALSE.
	CALL RSPEAK(599)
	RETURN

C  END OF SPECIALS.

	END

	LOGICAL FUNCTION TEETER(MYLOC)
	IMPLICIT INTEGER (A-Z)
#include "mnecom.h"
#include "placom.h"
#include "objcom.h"

	INTEGER SMOVE(6)
	DATA SMOVE /311,313,314,316,317,318/

	WEAST=0
	WWEST=95
	IF (MYLOC.EQ.314.OR.MYLOC.EQ.316) WEAST = 130+BURDEN(0)
	IF (MYLOC.EQ.311.OR.MYLOC.EQ.313) WWEST = 235+BURDEN(0)
	DO 100 OBJ = 1,MAXOBJ
	P = PLACE(OBJ)
	IF (P.EQ.314.OR.P.EQ.316) WEAST = WEAST + BURDEN(OBJ)
	IF (P.EQ.311.OR.P.EQ.313) WWEST = WWEST + WEIGHT(OBJ)
100	CONTINUE

	SSTATE=0
	IF (WEAST .GT. WWEST)  SSTATE=1	
	TEETER = PROP(SLAB) .NE. SSTATE
	PROP(SLAB) = SSTATE
	IF (.NOT.TEETER) RETURN
	DO 200 I = 1,3
	FROMRM = SMOVE(2*I-PROP(SLAB))
	TORM = SMOVE(2*I-(1-PROP(SLAB)))
	DO 150 OBJ=1,MAXOBJ
	IF(PLACE(OBJ).EQ.FROMRM.AND.FIXED(OBJ).EQ.0)
     +	  CALL MOVE(OBJ,TORM)
	IF(MYLOC.EQ.FROMRM)MYLOC=TORM
150	CONTINUE
200	CONTINUE
	RETURN

	END
