C  advlib.F
C  Last modified on Wed May 19 20:05:38 2021 by eroberts
C       modified on Tue May 19 16:42:24 1987 by roberts
C  ----------

#include "params.h"

C  LOGICAL FUNCTIONS

C  THE FIRST BUNCH DESCRIBE WHERE OBJECTS ARE.
C  (AT, ATHAND, ENCLSD, HERE, HOLDNG, TOTING)

	LOGICAL FUNCTION AT(OBJ)

C  AT(OBJ)	= TRUE IF ON EITHER SIDE OF TWO-PLACED OBJECT

	IMPLICIT INTEGER (A-Z)
#include "loccom.h"
#include "placom.h"
	AT=PLACE(OBJ).EQ.LOC.OR.FIXED(OBJ).EQ.LOC
	RETURN
	END



C  ATHAND(OBJ)	= TRUE IF OBJ IS READILY REACHABLE.
C		  IT CAN BE LYING HERE, IN HAND OR IN OPEN CONTAINER.

	LOGICAL FUNCTION ATHAND(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "loccom.h"
#include "placom.h"
	LOGICAL TOTING,AJAR,ENCLSD,HOLDNG,AAA

	CONTNR=-PLACE(OBJ)
	AAA=ENCLSD(OBJ).AND.AJAR(CONTNR)

	ATHAND=PLACE(OBJ).EQ.LOC.OR.HOLDNG(OBJ).OR.
     1		    (AAA.AND.
     2			(PLACE(CONTNR).EQ.LOC.OR.
     3			(TOTING(OBJ).AND.HOLDNG(CONTNR))))

	RETURN
	END



C  ENCLSD(OBJ) = TRUE IF THE OBJ IS IN A CONTAINER

	LOGICAL FUNCTION ENCLSD(OBJECT)
	IMPLICIT INTEGER (A-Z)
#include "placom.h"
	ENCLSD=PLACE(OBJECT).LT.-1
	RETURN
	END



C  HERE(OBJ)	= TRUE IF THE OBJ IS AT "LOC" (OR IS BEING CARRIED)

	LOGICAL FUNCTION HERE(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "loccom.h"
#include "placom.h"
	LOGICAL TOTING
	HERE=PLACE(OBJ).EQ.LOC.OR.TOTING(OBJ)
	RETURN
	END



C  HOLDNG(OBJ)	= TRUE IF THE OBJ IS BEING CARRIED IN HAND.

	LOGICAL FUNCTION HOLDNG(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "placom.h"
	HOLDNG=PLACE(OBJ).EQ.-1
	RETURN
	END



C  TOTING(OBJ)	= TRUE IF THE OBJ IS BEING CARRIED (IN HAND OR
C 		  CONTAINER).  OBJ MAY NOT BE REACHABLE.  SEE
C		  ALSO: ENCLSD, ATHAND, HOLDNG.

	LOGICAL FUNCTION TOTING(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "placom.h"
	LOGICAL HOLDNG,ENCLSD,AAA,BBB,CCC

	CONTNR=-PLACE(OBJ)
	OUTER=-PLACE(CONTNR)
	OUTER2=-PLACE(OUTER)

	AAA=HOLDNG(CONTNR)
	BBB=ENCLSD(CONTNR).AND.HOLDNG(OUTER)
	CCC=ENCLSD(OUTER).AND.HOLDNG(OUTER2)

	TOTING=HOLDNG(OBJ).OR.(ENCLSD(OBJ).AND.(AAA.OR.BBB.OR.CCC))
	RETURN
	END



C  THE NEXT LOGICAL FUNCTIONS DESCRIBE ATTRIBUTES OF OBJECTS.
C  (AJAR, HINGED, LOCKED, OPAQUE, PRINTD, TREASR, VESSEL, WEARNG)


C  AJAR(OBJ)	= TRUE IF OBJECT IS AN OPEN OR UNHINGED CONTAINER.

	LOGICAL FUNCTION AJAR(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "bitcom.h"
#include "concom.h"

	LOGICAL BITSET,HINGED,VESSEL
	AJAR=BITSET(OBJCON(OBJ),OPENBT).OR.
     1		(VESSEL(OBJ).AND..NOT.HINGED(OBJ))
	RETURN
	END



C  HINGED(OBJ)	= TRUE IF OBJECT CAN BE OPENED/SHUT.

	LOGICAL FUNCTION HINGED(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	HINGED=BITSET(OBJCON(OBJ),1)

	RETURN
	END



C  LOCKED(OBJ)	= TRUE IF OBJECT IS CURRENTLY LOCKED.

	LOGICAL FUNCTION LOCKED(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "bitcom.h"
#include "concom.h"
	LOGICAL BITSET

	LOCKED=BITSET(OBJCON(OBJ),LOCKBT)

	RETURN
	END




C  LIVING(OBJ)	= TRUE IF OBJ IS SOME SORT OF CRITTER

	LOGICAL FUNCTION LIVING(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	LIVING=BITSET(OBJCON(OBJ),9)

	RETURN
	END



C  OPAQUE(OBJ)	= TRUE IF OBJECT IS NOT TRANSPARENT.  E.G., BAG & CHEST
C                 ARE OPAQUE.
C		  WICKER CAGE & GLASS BOTTLE ARE TRANSPARENT.

	LOGICAL FUNCTION OPAQUE(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	OPAQUE=BITSET(OBJCON(OBJ),18)

	RETURN
	END



C  PLURAL(OBJ)	= TRUE IF OBJECT IS A "BUNCH" OF THINGS (COINS, SHOES).

	LOGICAL FUNCTION PLURAL(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	PLURAL=BITSET(OBJCON(OBJ),13)

	RETURN
	END



C  PRINTD(OBJ)	= TRUE IF OBJECT CAN BE READ.

	LOGICAL FUNCTION PRINTD(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	PRINTD=BITSET(OBJCON(OBJ),8)

	RETURN
	END



C  TREASR(OBJ)	= TRUE IF OBJECT IS A TREASURE

	LOGICAL FUNCTION TREASR(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	TREASR=BITSET(OBJCON(OBJ),14)

	RETURN
	END



C  VESSEL(OBJ)	= TRUE IF OBJECT IS A CONTAINER

	LOGICAL FUNCTION VESSEL(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	VESSEL=BITSET(OBJCON(OBJ),15)

	RETURN
	END



C  WEARNG(OBJ)	= TRUE IF THE OBJ IS BEING WORN

	LOGICAL FUNCTION WEARNG(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "bitcom.h"
#include "concom.h"
	LOGICAL BITSET

	WEARNG=BITSET(OBJCON(OBJ),WEARBT)
	RETURN
	END



C  IF OBJ=0, BURDEN CALCULATES THE TOTAL WEIGHT OF THE ADVENTURER'S BURDEN,
C	INCLUDING EVERYTHING IN ALL CONTAINERS (EXCEPT THE BOAT) THAT HE IS
C	CARRYING.
C  IF OBJ#0 AND OBJ IS A CONTAINER, CALCULATE THE WEIGHT OF EVERYTHING INSIDE
C	THE CONTAINER (INCLUDING THE CONTAINER ITSELF).  SINCE DONKEY FORTRAN
C	ISN'T RECURSIVE, WE WILL ONLY CALCULATE WEIGHTS OF CONTAINED CONTAINERS
C	ONE LEVEL DOWN.  THE ONLY SERIOUS CONTAINED CONTAINER WOULD BE THE
C	SACK ANYWAY, THE ONLY THINGS WE'LL MISS WILL BE FILLED VS EMPTY
C       BOTTLE OR CAGE.
C  IF OBJ#0 AND ISN'T A CONTAINER, RETURN ITS WEIGHT.

	INTEGER FUNCTION BURDEN(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "objcom.h"
#include "hldcom.h"
#include "placom.h"
	LOGICAL TOTING
	DATA BOAT,CASK,THRONE /48,71,142/

	BURDEN=0
	IF(OBJ.NE.0)GOTO 200
	DO 100 I=1,MAXOBJ
	IF(.NOT.TOTING(I).OR.PLACE(I).EQ.-BOAT.OR.
     +     PLACE(I).EQ.-THRONE.OR.PLACE(I).EQ.-(THRONE+1))GOTO 100
	BURDEN=BURDEN+WEIGHT(I)
	IF (I.EQ.CASK.AND.PROP(I).NE.1) BURDEN = BURDEN + 20
100	CONTINUE
	RETURN

200	BURDEN=WEIGHT(OBJ)
	IF (OBJ.EQ.CASK.AND.PROP(OBJ).NE.1) BURDEN = BURDEN + 20
	IF(OBJ.EQ.BOAT.OR.OBJ.EQ.THRONE.OR.OBJ.EQ.THRONE+1)RETURN
	TEMP=HOLDER(OBJ)
210	IF(TEMP.EQ.0)RETURN
	BURDEN=BURDEN+WEIGHT(TEMP)
	TEMP=HLINK(TEMP)
	GOTO 210

	END



C  LOCATION ATTRIBUTES.  (BLIND, DARK, FORCED, INSIDE, OUTSID, PORTAL)

C  TRUE IF ADVENTURER IS "BLIND" AT THIS LOC, (DARKNESS OR GLARE)

	LOGICAL FUNCTION BLIND(DUMMY)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
#include "loccom.h"
#include "objcom.h"
	LOGICAL ATHAND, DARK
	DATA LAMP /2/

	BLIND=DARK(0).OR.(LOC.EQ.200.AND.ATHAND(LAMP).AND.PROP(LAMP).EQ.1)

	RETURN
	END



C  TRUE IF LOCATION "LOC" IS DARK

	LOGICAL FUNCTION DARK(DUMMY)
	IMPLICIT INTEGER (A-Z)
#include "diecom.h"
#include "concom.h"
#include "loccom.h"
#include "objcom.h"
	LOGICAL ATHAND, HERE
	DATA LAMP,BOTTLE,TORCH /2,20,74/

	DARK=MOD(LOCCON(LOC),2).EQ.0.AND.(PROP(LAMP).EQ.0.OR.
     1		.NOT.ATHAND(LAMP)).AND..NOT.ATHAND(TORCH).AND.
     2		MCLOCK.LE.0.AND.(LCLOCK.EQ.0.OR..NOT.HERE(BOTTLE))
	RETURN
	END



C  A FORCED LOCATION IS ONE FROM WHICH HE IS IMMEDIATELY BOUNCED TO ANOTHER.
C  NORMAL USE IS FOR DEATH (FORCE TO LOC ZERO) AND FOR DESCRIPTIONS OF
C  JOURNEY FROM ONE PLACE TO ANOTHER.

	LOGICAL FUNCTION FORCED(LOC)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"

	FORCED=LOCCON(LOC).EQ.2

	RETURN
	END



C  INSIDE(LOC)	= TRUE IF LOCATION IS WELL WITHIN THE CAVE

	LOGICAL FUNCTION INSIDE(LOC)
	IMPLICIT INTEGER (A-Z)
	LOGICAL OUTSID,PORTAL
	INSIDE=.NOT.OUTSID(LOC).AND..NOT.PORTAL(LOC)
	RETURN
	END



C  OUTSID(LOC)	= TRUE IF LOCATION IS OUTSIDE THE CAVE

	LOGICAL FUNCTION OUTSID(LOC)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	OUTSID=BITSET(LOCCON(LOC),6)

	RETURN
	END



C  PORTAL(LOC)	= TRUE IS LOCATION IS IN CAVE "ENTRANCE"

	LOGICAL FUNCTION PORTAL(LOC)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	PORTAL=BITSET(LOCCON(LOC),5)

	RETURN
	END



C  NON-LOGICAL (ILLOGICAL?) FUNCTIONS (CLASS,LIQ,LIQ2,LIQLOC,VAL)

	FUNCTION LIQ2(PBOTL)
	IMPLICIT INTEGER (A-Z)
#include "liqcom.h"

	LIQ2=(1-PBOTL)*WATER+(PBOTL/2)*(WATER+OIL)+(PBOTL/4)
     1		*(WATER+WINE-2*OIL)
	RETURN
	END


	FUNCTION LIQ(OBJ)
	IMPLICIT INTEGER (A-Z)
#include "liqcom.h"
#include "objcom.h"

	LIQ=LIQTYP(MAX0(PROP(OBJ)+1,-1-(PROP(OBJ)+1)))
	IF(OBJ.NE.BOTTLE.AND.OBJ.NE.CASK)LIQ=0
	RETURN
	END



	FUNCTION LIQLOC(LOC)
	IMPLICIT INTEGER (A-Z)
#include "liqcom.h"
#include "concom.h"

	LIQLOC=LIQ2(MOD(LOCCON(LOC)/8,2)*(MOD(LOCCON(LOC)/2*2,16)-9)+1)

	RETURN
	END



	FUNCTION CLASS(WORD)

C  RETURNS WORD CLASS NUMBER (1=MOTION VERB; 2=NOUN; 3=ACTION VERB;
C  4=MISCELLANEOUS WORD; 5=PREPOSITION; 6=ADJECTIVE; 7=CONJUNCTION).
C  RETURNS ZERO IF WORD=ZERO, AND -1 IF WORD < ZERO.


	IMPLICIT INTEGER (A-Z)

	CLASS=WORD/1000 +1
	IF(WORD.LT.0)CLASS=-1
	IF(WORD.EQ.0)CLASS=0
	RETURN
	END



	FUNCTION VAL(WORD)

C  RETURNS THE 'VALUE' OF A WORD, MODULO 1000.

	IMPLICIT INTEGER (A-Z)
	VAL=MOD(WORD,1000)
	RETURN
	END



C  I/O ROUTINES
C  (SPEAK, PSPEAK, RSPEAK, GETIN, YES, A5TOA1, GETLIN, A1TOA5, CONFUZ,
C   BLKLIN, CLRLIN, NOWAY)


C  PRINT THE MESSAGE WHICH STARTS AT LINES(N).
C  IF INDLIN IS TRUE, INDENT THE LINE 4 SPACES.

	SUBROUTINE SPEAK(N)
	IMPLICIT INTEGER (A-Z)
#include "txtcom.h"
#include "lincom.h"

	IF(N.EQ.0)RETURN
	IF(LINES(N+1).EQ.'>$<')RETURN
	K=N
1	L=IABS(C5TOI(LINES(K)))-K-1
	IF(L.EQ.1.AND.LINES(K+L).EQ.'<NL>')GOTO 5
	IF(.NOT.INDLIN) WRITE (TTYOUT,3) (LINES(K+I),I=1,L)
3	FORMAT(14A5)
	IF(INDLIN) WRITE (TTYOUT,4) (LINES(K+I),I=1,L)
4	FORMAT(4X,14A5)
	GOTO 6
5	WRITE(TTYOUT,3)
6	K=K+L+1
	IF(C5TOI(LINES(K)).GE.0)GOTO 1
	RETURN

	END



C  FIND THE SKIP+1ST MESSAGE FROM MSG AND PRINT IT.  MSG SHOULD BE THE INDEX OF
C  THE INVENTORY MESSAGE FOR OBJECT.  (INVEN+N+1 MESSAGE IS PROP=N MESSAGE).

	SUBROUTINE PSPEAK(MSG,SKIP)
	IMPLICIT INTEGER (A-Z)
#include "txtcom.h"
#include "hldcom.h"

	M=PTEXT(MSG)
	IF(SKIP.LT.0)GOTO 9
	DO 3 I=0,SKIP
1	M=IABS(C5TOI(LINES(M)))
	IF(C5TOI(LINES(M)).GE.0)GOTO 1
3	CONTINUE
9	CALL SPEAK(M)
	RETURN

	END



C  PRINT THE I-TH "RANDOM" MESSAGE (SECTION 6 OF DATABASE).

	SUBROUTINE RSPEAK(I)
	IMPLICIT INTEGER (A-Z)
#include "txtcom.h"

	IF(I.NE.0)CALL SPEAK(RTEXT(I))
	RETURN
	END



C  PRINT THE I-TH "MAGIC" MESSAGE (SECTION 12 OF DATABASE).

	SUBROUTINE MSPEAK(I)
	IMPLICIT INTEGER (A-Z)
#include "txtcom.h"

	IF(I.NE.0)CALL SPEAK(MTEXT(I))
	RETURN
	END



C  CALL YESX (BELOW) WITH MESSAGES FROM SECTION 6.

	LOGICAL FUNCTION YES(X,Y,Z)
	IMPLICIT INTEGER (A-Z)
	EXTERNAL RSPEAK
	LOGICAL YESX

	YES=YESX(X,Y,Z,.FALSE.)
	RETURN
	END


C  CALL YESX (BELOW) WITH MESSAGES FROM SECTION 12.

	LOGICAL FUNCTION YESM(X,Y,Z)
	IMPLICIT INTEGER (A-Z)
	EXTERNAL MSPEAK
	LOGICAL YESX

	YESM=YESX(X,Y,Z,.TRUE.)
	RETURN
	END


C  PRINT MESSAGE X, WAIT FOR YES/NO ANSWER.  IF YES, PRINT Y AND LEAVE YEA
C  TRUE; IF NO, PRINT Z AND LEAVE YEA FALSE.

	LOGICAL FUNCTION YESX(X,Y,Z,MFLAG)
	IMPLICIT INTEGER (A-Z)
	CHARACTER*1 CHRS(BUFMAX)
	LOGICAL MFLAG

1	IF(X.NE.0 .AND. .NOT. MFLAG)CALL RSPEAK(X)
	IF(X.NE.0 .AND. MFLAG)CALL MSPEAK(X)
	CALL READLN(CHRS)
	IF (CHRS(1).EQ.'Y' .OR. CHRS(1).EQ.'y') GOTO 10
	IF (CHRS(1).EQ.'N' .OR. CHRS(1).EQ.'n') GOTO 20
	WRITE(TTYOUT,9)
9	FORMAT(/'Please answer the question.')
	GOTO 1
10	YESX=.TRUE.
	IF(Y.NE.0 .AND. .NOT. MFLAG)CALL RSPEAK(Y)
	IF(Y.NE.0 .AND. MFLAG)CALL MSPEAK(Y)
	RETURN
20	YESX=.FALSE.
	IF(Z.NE.0 .AND. .NOT. MFLAG)CALL RSPEAK(Z)
	IF(Z.NE.0 .AND. MFLAG)CALL MSPEAK(Z)
	RETURN
	END



C  A AND B CONTAIN A 1- TO 9-CHARACTER WORD IN A5 FORMAT, C CONTAINS ANOTHER
C  WORD AND/OR PUNCTUATION.  THEY ARE UNPACKED TO ONE CHARACTER PER WORD IN THE
C  ARRAY "CHARS", WITH EXACTLY ONE BLANK BETWEEN B AND C (OR NONE, IF C => 0).
C  THE INDEX OF THE LAST NON-BLANK CHAR IN CHARS IS RETURNED IN LENG.

	SUBROUTINE A5TOA1(A,B,C,CHARS,LENG)
	IMPLICIT INTEGER (A-Z)
	CHARACTER*5 A,B,C
	CHARACTER*1 CHARS(20)
	CALL A5CONV(A,B,C,CHARS,L,.FALSE.)
	LENG = L
	RETURN
	END

C  SAME AS A5TOA1 EXCEPT CONVERTS TO LOWER CASE.

	SUBROUTINE A5LCA1(A,B,C,CHARS,LENG)
	IMPLICIT INTEGER (A-Z)
	CHARACTER*5 A,B,C
	CHARACTER*1 CHARS(20)
	CALL A5CONV(A,B,C,CHARS,L,.TRUE.)
	LENG = L
	RETURN
	END

	SUBROUTINE A5CONV(A,B,C,CHARS,LENG,LCFLAG)
	IMPLICIT INTEGER (A-Z)
	CHARACTER*5 A,B,C
	CHARACTER*1 CH,CHARS(20),LOWER
	LOGICAL LCFLAG

	LENG = 0
	DO 10 I=1,5
	CH = A(I:I)
	IF (CH .EQ. ' ') GOTO 30
	LENG = LENG + 1
	IF (LCFLAG) CH = LOWER(CH)
	CHARS(LENG) = CH
10	CONTINUE
	DO 20 I=1,5
	CH = B(I:I)
	IF (CH .EQ. ' ') GOTO 30
	LENG = LENG + 1
	IF (LCFLAG) CH = LOWER(CH)
	CHARS(LENG) = CH
20	CONTINUE
30	IF (C(1:1) .LT. 'A') GOTO 40
	LENG = LENG + 1
	CHARS(LENG) = ' '
40	DO 50 I=1,5
	CH = C(I:I)
	IF (CH .EQ. ' ') GOTO 60
	LENG = LENG + 1
	IF (LCFLAG) CH = LOWER(CH)
	CHARS(LENG) = CH
50	CONTINUE
60	RETURN
	END



	CHARACTER*1 FUNCTION LOWER(CH)
	CHARACTER*1 CH
        LOWER = CH
	IF (CH .LT. 'A' .OR. CH .GT. 'Z') RETURN
	LOWER = CHAR(ICHAR(CH)+32)
	RETURN
	END

	CHARACTER*1 FUNCTION RAISE(CH)
	CHARACTER*1 CH
        RAISE = CH
	IF (CH .LT. 'a' .OR. CH .GT. 'z') RETURN
	RAISE = CHAR(ICHAR(CH)-32)
	RETURN
	END



C  SUCKS UP A LINE FROM THE TTY, THEN CALLS A1TOA5 TO SEPARATE
C  OUT EACH WORD (AND MAKE SURE IT'S ALL UPPER CASE).  THE TEXT OF
C  EACH WORD IS MOVED INTO AN ARRAY (TXT(I,J), FOR HIGHER
C  LEVEL ANALYSIS.  A LINE IS TERMINATED
C  WHEN A WORD=ZERO IS RETURNED.  INTRA-LINE CLAUSE TERMINATORS, LIKE
C  COMMA, PERIOD AND 'AND', ARE MOVED INTO THE TXT VECTOR AS 'AND'.
C  AN UNEXPECTED TERMINATOR IS CAUSE FOR ALARM.
C  THE ONLY OTHER PRE-PROCESSING THAT IS DONE IS TO FLUSH ALL
C  OCCURRENCES OF "THE", "AN" AND "A".  IF THE LINE ENDS WITH ANY
C  OF THESE, AN ERROR MESSAGE IS PRINTED AND THE WHOLE LINE IS FLUSHED.

	SUBROUTINE GETLIN
	IMPLICIT INTEGER (A-Z)
#include "lincom.h"
#include "utxcom.h"
	CHARACTER*5 C5, WDS(2)
	CHARACTER*1 CHRS(BUFMAX), TERM

10	DO 15 I=1,35
	DO 15 J=1,2
15	TXT(I,J)=' '
	WRITE(TTYOUT, 20)
20	FORMAT('> '$)

30	CALL READLN(CHRS)
	CINDEX=1
	WDX=0
100	CALL A1TOA5(CHRS,CINDEX,WDS,TERM)
C	IF(TERM.EQ.'@' .AND. WDX.EQ.0)GOTO 30
	C5=WDS(1)
	IF(C5.NE.'THE'.AND.C5.NE.'AN'.AND.C5.NE.'A'.AND.
     +	   C5.NE.'IS'.AND.C5.NE.'ARE')GOTO 110
	IF(TERM.EQ.' ')GOTO 100
	TXT(WDX,1) = ' '
	TXT(WDX,2) = ' '
	WDX=WDX-1
	GOTO 120

110	IF(WDS(1).EQ.' ')GOTO 120
	WDX=WDX+1
	TXT(WDX,1)=WDS(1)
	TXT(WDX,2)=WDS(2)
	IF(TXT(WDX,1).NE.'NORTH') GOTO 112
	IF(TXT(WDX,2).NE.'WEST') GOTO 111
	TXT(WDX,1)='NW'
	GOTO 119
111	IF(TXT(WDX,2).NE.'EAST') GOTO 120
	TXT(WDX,1)='NE'
	GOTO 119
112	IF(TXT(WDX,1).NE.'SOUTH') GOTO 120
	IF(TXT(WDX,2).NE.'WEST') GOTO 113
	TXT(WDX,1)='SW'
	GOTO 119
113	IF(TXT(WDX,2).NE.'EAST') GOTO 120
	TXT(WDX,1)='SE'
119	TXT(WDX,2)=' '
120	IF(TERM.EQ.' ')GOTO 100
	IF(TXT(WDX,1).NE.'AND') GOTO 130
	TXT(WDX,1)=' '
	TXT(WDX,2)=' '
	WDX=WDX-1
130	IF(TERM.EQ.'@' .OR. TERM.EQ.';') RETURN
	IF(TERM.NE.',' .AND. TERM.NE.'.')CALL BUG(31)
	WDX=WDX+1
	TXT(WDX,1)='AND'
	TXT(WDX,2)=' '
	GOTO 100

	END



	SUBROUTINE A1TOA5(CHARS,CINDEX,WDS,PUNC)
	IMPLICIT INTEGER (A-Z)
	CHARACTER*1 CHARS(BUFMAX), C, RAISE, PUNC
	CHARACTER*5 WDS(2)
	LOGICAL	PUNCT

	PUNCT(C)=C.EQ.' ' .OR. C.EQ.',' .OR. C.EQ.';' .OR. C.EQ.'.'

	WDS(1)=' '
	WDS(2)=' '
	DO 2 CINDEX=CINDEX,BUFMAX
	IF(.NOT.PUNCT(CHARS(CINDEX)))GOTO 4
	IF(CHARS(CINDEX).EQ.';')GOTO 7
2	CONTINUE
	PUNC='@'
	RETURN

4	K=BUFMAX-CINDEX
	WDX=MIN0(2,(K/10))
	CHX=MIN0(5,MAX0(K,MOD(K,5)))

	DO 3 WD=1,WDX
	DO 3 CH=1,CHX
	IF(PUNCT(CHARS(CINDEX)))GOTO 8
	CHARS(CINDEX)=RAISE(CHARS(CINDEX))
	WDS(WD)(CH:CH) = CHARS(CINDEX)
3	CINDEX=CINDEX+1
5	IF(PUNCT(CHARS(CINDEX)))GOTO 8
	CINDEX=CINDEX+1
	GOTO 5

7	CHARS(CINDEX)=' '
8	PUNC=CHARS(CINDEX)

	RETURN
	END




C	PRINTS OUT A BLANK LINE

	SUBROUTINE BLKLIN
	IMPLICIT INTEGER (A-Z)

	WRITE(TTYOUT, 10)
10	FORMAT(1X)
	RETURN
	END



C  CLEARS OUT ALL CURRENT SYNTAX ARGS IN PREPARATION FOR A NEW INPUT LINE

	SUBROUTINE CLRLIN
	IMPLICIT INTEGER (A-Z)
#include "wrdcom.h"

	DO 1 I=1,45
	OBJS(I)=0
	VERBS(I)=0
	DO 1 J=1,2
1	VTXT(I,J)=' '

	DO 3 I=1,15
	IOBJS(I)=0
	DO 3 J=1,2
	IOTXT(I,J)=' '
3	OTXT(I,J)=' '

	VRBX=0
	OBJX=0
	IOBX=0
	PREP=0
	RETURN

	END


C  GENERATES SOME VARIANT OF "CAN'T DO THAT" MESSAGE.

	FUNCTION NOWAY(DUMMY)
	IMPLICIT INTEGER (A-Z)
	LOGICAL PCT

	NOWAY=14
	IF(PCT(50))NOWAY=110
	IF(PCT(33))NOWAY=147
	IF(PCT(25))NOWAY=250
	IF(PCT(20))NOWAY=262
	IF(PCT(17))NOWAY=25
	IF(PCT(14))NOWAY=345
	IF(PCT(12))NOWAY=346
	RETURN
	END



C  GENERATES SOME VARIANT OF "DON'T UNDERSTAND THAT" MESSAGE.

	FUNCTION CONFUZ(DUMMY)
	IMPLICIT INTEGER (A-Z)
	LOGICAL PCT
#include "detcom.h"

	CONFUZ=60
	IF(PCT(50).AND.(TERSE .OR. DETAIL.EQ.1))CONFUZ=61
	IF(PCT(50).AND.(TERSE .OR. DETAIL.EQ.1))CONFUZ=347
	IF(PCT(33))CONFUZ=13
	IF(PCT(20))CONFUZ=195
	RETURN
	END



C  DATA STRUCTURE ROUTINES
C	VOCAB, VOCAB, DSTROY, JUGGLE, MOVE, PUT, CARRY, DROP, INSERT, REMOVE)


C  LOOK UP ID IN THE VOCABULARY (ATAB) AND RETURN ITS "DEFINITION" (KTAB), OR
C  -1 IF NOT FOUND.  IF INIT IS POSITIVE, THIS IS AN INITIALIZING CALL SETTING
C  UP A KEYWORD VARIABLE, AND NOT FINDING IT CONSTITUTES A BUG.  IT ALSO MEANS
C  THAT ONLY KTAB VALUES WHICH TAKEN OVER 1000 EQUAL INIT MAY BE CONSIDERED.
C  (THUS "STEPS", WHICH IS A MOTION VERB AS WELL AS AN OBJECT, MAY BE LOCATED
C  AS AN OBJECT.)  AND IT ALSO MEANS THE KTAB VALUE IS TAKEN MOD 1000.

	INTEGER FUNCTION VOCAB(ID,INIT)
	IMPLICIT INTEGER (A-Z)
#include "voccom.h"
	CHARACTER*5 ID

	WDCLAS=INIT
	IF(INIT.LT.0)WDCLAS=-INIT-1
	DO 1 I=1,TABSIZ
	IF(KTAB(I).EQ.-1)GOTO 2
	IF(ATAB(I).NE.ID)GOTO 1
	IF(CLASS(KTAB(I)).GE.WDCLAS)GOTO 3
1	CONTINUE
	CALL BUG(21)

2	VOCAB=-1
	IF(INIT.LT.0)RETURN
	WRITE (TTYOUT,4) ID
4	FORMAT (' VOCAB ERROR: CAN''T FIND WORD ''',A5,''' IN TABLE.')
	CALL BUG(5)

3	VOCAB=KTAB(I)
	IF(INIT.GE.0)VOCAB=MOD(VOCAB,1000)
	RETURN
	END



C  PERMANENTLY ELIMINATE "OBJECT" BY MOVING TO A NON-EXISTENT LOCATION.

	SUBROUTINE DSTROY(OBJECT)
	IMPLICIT INTEGER (A-Z)

	CALL MOVE(OBJECT,0)
	RETURN
	END




C  JUGGLE AN OBJECT BY PICKING IT UP AND PUTTING IT DOWN AGAIN, THE PURPOSE
C  BEING TO GET THE OBJECT TO THE FRONT OF THE CHAIN OF THINGS AT ITS LOC.

	SUBROUTINE JUGGLE(OBJECT)
	IMPLICIT INTEGER (A-Z)
#include "placom.h"

	I=PLACE(OBJECT)
	J=FIXED(OBJECT)
	CALL MOVE(OBJECT,I)
	CALL MOVE(OBJECT+MAXOBJ,J)
	RETURN
	END



C  PLACE ANY OBJECT ANYWHERE BY PICKING IT UP AND DROPPING IT.  MAY ALREADY BE
C  TOTING, IN WHICH CASE THE CARRY IS A NO-OP.  MUSTN'T PICK UP OBJECTS WHICH
C  ARE NOT AT ANY LOC, SINCE CARRY WANTS TO REMOVE OBJECTS FROM ATLOC CHAINS.

	SUBROUTINE MOVE(OBJECT,WHERE)
	IMPLICIT INTEGER (A-Z)
#include "placom.h"
	LOGICAL ENCLSD

	IF(ENCLSD(OBJECT))CALL REMOVE(OBJECT)
	FROM=PLACE(OBJECT)
	IF(OBJECT.GT.MAXOBJ)FROM=FIXED(OBJECT-MAXOBJ)
	IF(FROM.GT.0)CALL CARRY(OBJECT,FROM)
	CALL DROP(OBJECT,WHERE)
	RETURN
	END



C  PUT IS THE SAME AS MOVE, EXCEPT IT RETURNS A VALUE USED TO SET UP THE
C  NEGATED PROP VALUES FOR THE REPOSITORY OBJECTS.

	INTEGER FUNCTION PUT(OBJECT,WHERE,PVAL)
	IMPLICIT INTEGER (A-Z)

	CALL MOVE(OBJECT,WHERE)
	PUT=(-1)-PVAL
	RETURN
	END



C  START TOTING AN OBJECT, REMOVING IT FROM THE LIST OF THINGS AT ITS FORMER
C  LOCATION.  IF OBJECT>MAXOBJ (MOVING "FIXED" SECOND LOC),
C  DON'T CHANGE PLACE.

	SUBROUTINE CARRY(OBJECT,WHERE)
	IMPLICIT INTEGER (A-Z)
#include "placom.h"

	IF(OBJECT.GT.MAXOBJ)GOTO 5
	IF(PLACE(OBJECT).EQ.-1)RETURN
	PLACE(OBJECT)=-1
5	IF(ATLOC(WHERE).NE.OBJECT)GOTO 6
	ATLOC(WHERE)=LINK(OBJECT)
	RETURN

6	TEMP=ATLOC(WHERE)
7	IF(LINK(TEMP).EQ.OBJECT)GOTO 8
	TEMP=LINK(TEMP)
	IF(TEMP.NE.0)GOTO 7
	CALL BUG(35)

8	LINK(TEMP)=LINK(OBJECT)
	RETURN
	END




C  PLACE AN OBJECT AT A GIVEN LOC, PREFIXING IT ONTO THE ATLOC LIST.

	SUBROUTINE DROP(OBJECT,WHERE)
	IMPLICIT INTEGER (A-Z)
#include "placom.h"
#include "bltcom.h"
	
	W=WHERE
	IF (W.NE.FALLRM)  GOTO 50
10	DO 20 I = 1,NPAIRS
	NN = 2 * I
20	IF (TOPBOT(NN-1).EQ.TOPLOC)  GOTO 30
	CALL BUG(36)
30	W = TOPBOT(NN)

50	IF(OBJECT.GT.MAXOBJ)GOTO 100
	PLACE(OBJECT)=W
	GOTO 200

100	FIXED(OBJECT-MAXOBJ)=W
200	IF(W.LE.0)RETURN
	LINK(OBJECT)=ATLOC(W)
	ATLOC(W)=OBJECT
	RETURN
	END



	SUBROUTINE INSERT(OBJECT,CONTNR)
	IMPLICIT INTEGER (A-Z)
#include "hldcom.h"
#include "loccom.h"
#include "placom.h"

	IF(CONTNR.EQ.OBJECT)CALL BUG(32)
	CALL CARRY(OBJECT,LOC)

	TEMP=HOLDER(CONTNR)
	HOLDER(CONTNR)=OBJECT
	HLINK(OBJECT)=TEMP
	PLACE(OBJECT)=-CONTNR
	RETURN

	END



	SUBROUTINE REMOVE(OBJECT)
	IMPLICIT INTEGER (A-Z)
#include "hldcom.h"
#include "placom.h"

	CONTNR=-PLACE(OBJECT)
	PLACE(OBJECT)=-1

	IF(HOLDER(CONTNR).NE.OBJECT)GOTO 1
	HOLDER(CONTNR)=HLINK(OBJECT)
	RETURN

1	TEMP=HOLDER(CONTNR)
2	IF(HLINK(TEMP).EQ.OBJECT)GOTO 3
	TEMP=HLINK(TEMP)
	GOTO 2

3	HLINK(TEMP)=HLINK(OBJECT)
	RETURN
	END



C  LIST CONTENTS IF OBJ IS A CONTAINER AND IS OPEN OR TRANSPARENT.

	SUBROUTINE LOOKIN(CONTNR)
	IMPLICIT INTEGER (A-Z)
#include "lincom.h"
#include "hldcom.h"
#include "objcom.h"
	LOGICAL VESSEL,AJAR,OPAQUE

	IF(.NOT.VESSEL(CONTNR).OR.
     1		(.NOT.AJAR(CONTNR).AND.OPAQUE(CONTNR)) )RETURN
	TEMP=HOLDER(CONTNR)
	IF(HLINK(TEMP).EQ.0 .AND. PROP(TEMP).LT.0)  GOTO 40
	LOOP=0
	INDLIN=.FALSE.
20	IF(TEMP.EQ.0)GOTO 30
	RSPK=360
	IF(CONTNR.EQ.126)RSPK=361
	IF(LOOP.EQ.0)CALL RSPEAK(RSPK)
	INDLIN=.TRUE.
	CALL PSPEAK(TEMP,-1)
	TEMP=HLINK(TEMP)
	LOOP=-1
	GOTO 20

30	INDLIN=.FALSE.
	RETURN

40	INDLIN=.FALSE.
	CALL PSPEAK(TEMP,2)
	RETURN
	END



C  UTILITY ROUTINES (RANINT, DATIME, CIAO, BUG, LOG, BITON, BITOFF)

	INTEGER FUNCTION RANINT(RANGE)
	IMPLICIT INTEGER (A-Z)
	REAL CRAND

	RANINT = CRAND() * RANGE

	END



C  SUBROUTINES FOR TURNING BITS ON AND OFF (BITON, BITOFF).

	SUBROUTINE BITON(OBJ,BIT)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	IF (.NOT. BITSET(OBJCON(OBJ), BIT))
     1		OBJCON(OBJ)=OBJCON(OBJ) + BITS(BIT+1)
	RETURN
	END


C  TURNS OFF (SETS=0) A BIT IN OBJCON.

	SUBROUTINE BITOFF(OBJ,BIT)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"
	LOGICAL BITSET

	IF (BITSET(OBJCON(OBJ), BIT))
     1		OBJCON(OBJ)=OBJCON(OBJ) - BITS(BIT+1)
	RETURN
	END



C  MISCELLANEOUS LOGICAL FUNCTIONS (BITSET, PCT)

C  BITSET(COND,N) = TRUE IF COND HAS BIT N SET

	LOGICAL FUNCTION BITSET(COND,N)
	IMPLICIT INTEGER (A-Z)
#include "concom.h"

	BITSET = MOD(COND/BITS(N+1), 2) .NE. 0
	RETURN
	END



C  PCT(N)       = TRUE N% OF THE TIME (N INTEGER FROM 0 TO 100)

	LOGICAL FUNCTION PCT(N)
	IMPLICIT INTEGER (A-Z)
	INTEGER RANINT

	PCT=RANINT(100).LT.N
	RETURN
	END



	SUBROUTINE BUG(NUM)
	IMPLICIT INTEGER (A-Z)

C  THE FOLLOWING CONDITIONS ARE CURRENTLY CONSIDERED FATAL BUGS.  NUMBERS < 20
C  ARE DETECTED WHILE READING THE DATABASE; THE OTHERS OCCUR AT "RUN TIME".
C	0	MESSAGE LINE > BUFMAX CHARACTERS
C	1	NULL LINE IN MESSAGE
C	2	TOO MANY WORDS OF MESSAGES
C	3	TOO MANY TRAVEL OPTIONS
C	4	TOO MANY VOCABULARY WORDS
C	5	REQUIRED VOCABULARY WORD NOT FOUND
C	6	TOO MANY RTEXT OR MTEXT MESSAGES
C	7	TOO MANY HINTS
C	8	LOCATION HAS COND BIT BEING SET TWICE
C	9	INVALID SECTION NUMBER IN DATABASE
C	10	OUT OF ORDER LOCS OR RSPEAK ENTRIES.
C	11	ILLEGAL MOTION WORD IN TRAVEL TABLE
C	12	TOO MANY ENTRIES IN MILESTONE TABLE
C	13	UNKNOWN OR ILLEGAL WORD IN ADJECTIVE TABLE.
C	14	ILLEGAL WORD IN PREP/OBJ TABLE
C	15	TOO MANY ENTRIES IN PREP/OBJ TABLE
C	16	OBJECT HAS CONDITION BIT SET TWICE
C	17	OBJECT NUMBER TOO LARGE
C	18	TOO MANY ENTRIES IN ADJECTIVE/NOUN TABLE.
C	20	SPECIAL TRAVEL (500>L>300) EXCEEDS GOTO LIST
C	21	RAN OFF END OF VOCABULARY TABLE
C	22	VERB CLASS (N/1000) NOT BETWEEN 1 AND 3
C	23	INTRANSITIVE ACTION VERB EXCEEDS GOTO LIST
C	24	TRANSITIVE ACTION VERB EXCEEDS GOTO LIST
C	25	CONDITIONAL TRAVEL ENTRY WITH NO ALTERNATIVE
C	26	LOCATION HAS NO TRAVEL ENTRIES
C	27	HINT NUMBER EXCEEDS GOTO LIST
C	28	INVALID MONTH RETURNED BY DATE FUNCTION
C	29	ACTION VERB 'LEAVE' HAS NO OBJECT.
C	30	PREPOSITION FOUND IN UNEXPECTED TABLE
C	31	RECEIVED AN UNEXPECTED WORD TERMINATOR FROM A1TOA5
C	32	TRYING TO PUT A CONTAINER INTO ITSELF (TRICKY!)
C	33	UNKNOWN WORD CLASS IN PARSE
C	34	** UNUSED **
C	35	TRYING TO CARRY A NON-EXISTENT OBJECT
C	36	GOT TO FALLING IN MIDAIR ROOM FROM UNKNOWN PLACE.

	WRITE (TTYOUT,1)
	WRITE (TTYOUT,2)
	WRITE (TTYOUT,3) NUM
1	FORMAT (' FATAL ERROR, SEE SOURCE CODE FOR INTERPRETATION.')
2	FORMAT (' PROBABLE CAUSE: ERRONEOUS INFO IN DATABASE.')
3       FORMAT (' ERROR CODE =',I2)
	STOP
	END


C  UTILITY ROUTINES FOR CREATING A READABLE CAVE MAP. (XMAP, XSPEAK)

C  PRINT A CAVE MAP.

	SUBROUTINE XMAP
	IMPLICIT INTEGER (A-Z)
#include "voccom.h"
#include "ltxcom.h"
#include "trvcom.h"

	OPEN(2, FILE='advmap.txt')
	DO 9 LOC=1,LOCSIZ
	IF(STEXT(LOC).EQ.0.AND.LTEXT(LOC).EQ.0)GOTO 9
	CALL XSPEAK(LOC)
	N=KEY(LOC)

3	LL=IABS(TRAVEL(N))
	CD=LL/5000
	RM=LL-CD*5000
	WRITE (2,10) CD,RM
4	K=TRKEY(N)
	IF(K.GT.1)GOTO 6
	IF(K.EQ.1)WRITE (2,14)
	GOTO 9

6	KK=0
	DO 7 J=1,TABSIZ
	IF(KTAB(J).EQ.-1)GOTO 8
	IF(K.NE.KTAB(J))GOTO 7
	IF(KK.NE.1)WRITE (2,11) ATAB(J)
	IF(KK.EQ.1)WRITE (2,12) ATAB(J)
	KK=KK+1
7	CONTINUE

8	N=N+1
	IF(KK.GT.1)WRITE (2,13)
	IF(TRAVEL(N-1).LT.0)GOTO 9
	JJ=IABS(TRAVEL(N))/1000
	IF(JJ.EQ.LL)GOTO 4
	WRITE (2,15)
	GOTO 3

9	WRITE (2,15)
	ENDFILE(2)
	CLOSE(2)
	RETURN

10	FORMAT ('  ', 2I8, $)
11	FORMAT ('  ', A5, $)
12	FORMAT (' (', A5, $)
13	FORMAT (')', $)
14	FORMAT ('	[FORCED LOC]', $)
15	FORMAT ('')

	END



C  Like SPEAK, but prefix location number on each line

	SUBROUTINE XSPEAK(LOC)
	IMPLICIT INTEGER (A-Z)
#include "txtcom.h"
#include "ltxcom.h"
#include "lincom.h"

	N = LTEXT(LOC)
	IF(N.EQ.0)RETURN
	IF(LINES(N+1).EQ.'>$<')RETURN
	K=N
1	L=IABS(C5TOI(LINES(K)))-K-1
	IF(L.EQ.1.AND.LINES(K+L).EQ.'<NL>')GOTO 5
	WRITE (2,3) LOC, (LINES(K+I),I=1,L)
3	FORMAT(I3, '	', 14A5)
	GOTO 6
5	WRITE (2,3) LOC
6	K=K+L+1
	IF(C5TOI(LINES(K)).GE.0)GOTO 1
	RETURN

	END



	INTEGER FUNCTION RATING(MXSCOR,BONUS,GAVEUP,SCORNG,CLOSNG,CLOSED)

C  CALCULATE WHAT THE PLAYER'S SCORE WOULD BE IF HE QUIT NOW.
C  THIS MAY BE THE END OF THE GAME, OR HE MAY JUST BE WONDERING
C  HOW HE IS DOING.  ALSO, PRINT IT AS PART OF A GRIPE REPORT.

	IMPLICIT INTEGER (A-Z)
	LOGICAL TREASR,GAVEUP,CLOSNG,CLOSED,SCORNG
#include "diecom.h"
#include "dwfcom.h"
#include "hntcom.h"
#include "mnecom.h"
#include "objcom.h"
#include "placom.h"

C  THE PRESENT SCORING ALGORITHM IS AS FOLLOWS:
C  (TREASURE POINTS ARE EXPLAINED IN A FOLLOWING COMMENT)
C     OBJECTIVE:          POINTS:        PRESENT TOTAL POSSIBLE:
C  GETTING WELL INTO CAVE   25                    25
C  TOTAL POSSIBLE FOR TREASURES (+MAG)		 ???
C  SURVIVING             (MAX-NUM)*10             30
C  NOT QUITTING              4                     4
C  REACHING "CLOSNG"        20                    20
C  "CLOSED": QUIT/KILLED    10
C            KLUTZED        20
C            WRONG WAY      25
C            SUCCESS        30                    30
C  ROUND OFF FACTOR                               16


	SCORE=0
	MXSCOR=0

	DO 1010 OBJ=1,MAXOBJ
	IF(POINTS(OBJ).EQ.0)GOTO 1010
	IF(.NOT.TREASR(OBJ))GOTO 1010
	TPTS = POINTS(OBJ) / 1000
	TPROP = POINTS(OBJ) - TPTS*1000
	GPLACE = 3
	IF(TPROP.NE.999)GOTO 1003
	GPLACE = 299
	TPROP = 0
1003	IF(PROP(OBJ).GE.0)SCORE=SCORE+TPTS*3
	OPLACE = PLACE(OBJ)
1005	IF (OPLACE .GE. -1) GOTO 1007
	OPLACE = PLACE(-OPLACE)
	GOTO 1005
1007	IF(OPLACE.EQ.GPLACE.AND.PROP(OBJ).EQ.TPROP)SCORE=SCORE+TPTS*2
	MXSCOR=MXSCOR+TPTS*5
1010	CONTINUE

C  NOW LOOK AT HOW HE FINISHED AND HOW FAR HE GOT.  MAXDIE AND NUMDIE TELL US
C  HOW WELL HE SURVIVED.  GAVEUP SAYS WHETHER HE EXITED VIA QUIT.  DFLAG WILL
C  TELL US IF HE EVER GOT SUITABLY DEEP INTO THE CAVE.  CLOSNG STILL INDICATES
C  WHETHER HE REACHED THE ENDGAME.  AND IF HE GOT AS FAR AS "CAVE CLOSED"
C  (INDICATED BY "CLOSED"), THEN BONUS IS ZERO FOR MUNDANE EXITS OR 133, 134,
C  135 IF HE BLEW IT (SO TO SPEAK).

1011	SCORE=SCORE+(MAXDIE-NUMDIE)*10
	MXSCOR=MXSCOR+MAXDIE*10
	IF(.NOT.(SCORNG.OR.GAVEUP))SCORE=SCORE+4
	MXSCOR=MXSCOR+4
	IF(DFLAG.NE.0)SCORE=SCORE+25
	MXSCOR=MXSCOR+25
	IF(CLOSNG)SCORE=SCORE+20
	MXSCOR=MXSCOR+20
	IF(.NOT.CLOSED)GOTO 1020
	IF(BONUS.EQ.0)SCORE=SCORE+10
	IF(BONUS.EQ.135)SCORE=SCORE+20
	IF(BONUS.EQ.134)SCORE=SCORE+25
	IF(BONUS.EQ.133)SCORE=SCORE+30
1020	MXSCOR=MXSCOR+30

C  ROUND IT OFF.

	SCORE=SCORE+16
	MXSCOR=MXSCOR+16

C  DEDUCT POINTS FOR HINTS.  HINTS < HNTMIN ARE SPECIAL; SEE DATABASE DESCRIPTION.

	DO 1030 I=1,HNTMAX
1030	IF(HINTED(I))SCORE=SCORE-HINTS(I,2)

	RATING=SCORE

	RETURN
	END



C  Temporary

	LOGICAL FUNCTION CKMAIL(DUMMY)
	IMPLICIT INTEGER (A-Z)
	CKMAIL = .FALSE.
	RETURN
	END

	SUBROUTINE RDMAIL
	IMPLICIT INTEGER (A-Z)
	RETURN
	END

	SUBROUTINE CIAO
	CALL EXIT(0)
	END

	SUBROUTINE AQUIT
	CALL EXIT(0)
	END

	CHARACTER*5 FUNCTION ITOC5(N)
	IMPLICIT INTEGER (A-Z)
	CHARACTER*4 CTYPE
	EQUIVALENCE (CTYPE,ITYPE)
	ITYPE = N
	ITOC5 = CTYPE
	RETURN
	END

	INTEGER FUNCTION C5TOI(C5)
	IMPLICIT INTEGER (A-Z)
	CHARACTER*4 CTYPE, C5
	EQUIVALENCE (CTYPE,ITYPE)
	CTYPE = C5
	C5TOI = ITYPE
	RETURN
	END
