#!/bin/tcsh

# This script should run in the directory of the input fasta file.
# There should be only one input file per directory.  The output 
# and intermediate files will be created in that same directory.

set GENOVO_DIR=..
set WORK_DIR=./synthetic
set INPUT_FASTA=all_reads.fa
set OUTPUT_FASTA=genovo.fa
set N_ITER=40
set CUTOFF=500

cd ${WORK_DIR}

# Assembling the reads in the input fast file.
# the output are the state files:
#  all_reads.fa.status    (prints one line per iteration)
#  all_reads.fa.dump1     (dumped state, generated every 10 iterations)
#  all_reads.fa.dump.best (best assembly so far)
#
#  remark: In this demo we run for only 40 iteraitons.
#          In our experiments we run hundreds of iteraions.

${GENOVO_DIR}/assemble ${INPUT_FASTA} ${N_ITER}

# Gathering the results from the bin_*.fasta.dump.best files
# The results from all files are combined to the output file OUTPUT_FASTA.
# The output fasta file shows only contigs with length > CUTOFF
${GENOVO_DIR}/finalize $CUTOFF ${OUTPUT_FASTA} all_reads.fa.dump.best

# [optional] Computing our score by mapping all the INPUT_FASTA reads to 
# the contigs in OUTPUT_FASTA. 
${GENOVO_DIR}/compute_score_denovo ${INPUT_FASTA} ${OUTPUT_FASTA}

cd ..
