// athlete.cc
// solution assumes input coordinates are bounded in the
// ranges [0, N] (horizontally) and [0, M] (vertically)
// where 9MN^3 is a valid signed integer

#include <iostream>
#include <cstdio>
#include <utility>
#include <set>

using namespace std;

typedef long long int INT;
typedef set< pair<INT, INT> > SPII;

int consistent_quad(SPII &points) {
	int arc_length = 0;
	int arc_allowed = 1;

	INT x[3], y[3];

	SPII::const_iterator it;
	INT prev_x;

	for(it = points.begin(); it != points.end(); it++) {
		// no two points lie on a vertical line
		if(it != points.begin() && (prev_x == it->first))
			return 0;

		if(it->second) {
			if(!arc_allowed)
				return 0;

			if(arc_length < 3) {
				x[arc_length] = it->first;
				y[arc_length] = it->second;
			}

			arc_length++;
		}

		else {
			if(arc_length)
				// arc points must be contiguous
				arc_allowed = 0;
		}

		prev_x = it->first;
	}
	
	if(arc_length < 3)
		// can make parabola arbitrarily steep
		return 1;

	// lagrange interpolation formula to fit a polynomial
	// (ax^2 + bx + c)/d to the 3 given points

	// bounded by N^3
	INT d = (x[0] - x[1])*(x[1] - x[2])*(x[2] - x[0]);

	// bounded by 3MN
	INT a = y[0]*(x[2] - x[1])
		+ y[1]*(x[0] - x[2])
		+ y[2]*(x[1] - x[0]);

	// bounded by 3MN^2
	INT b = y[0]*(x[1]*x[1] - x[2]*x[2])
		+ y[1]*(x[2]*x[2] - x[0]*x[0])
		+ y[2]*(x[0]*x[0] - x[1]*x[1]);

	// bounded by 3MN^3
	INT c = y[0]*(x[2] - x[1])*x[1]*x[2]
		+ y[1]*(x[0] - x[2])*x[2]*x[0]
		+ y[2]*(x[1] - x[0])*x[0]*x[1];

	// note: the polynomial ax^2 + bx + c, when restricted to the range
	// [0, N], takes values in [-9MN^3, 9MN^3]

	// parabola must open downwards
	if(a >= 0)
		return 0;

	for(it = points.begin(); it != points.end(); it++) {
		const INT &X = it->first;
		const INT &Y = it->second;

		if(d*Y != max((INT)0, a*X*X + b*X + c))
			return 0;
	}

	return 1;
}

int main() {
	int n,m;
	INT x,y;

	while(cin >> n >> m, n) {
		SPII points;

		int first_length = 0;
		int second_length = 0;

		for(int i=0; i<n+m; i++) {
			cin >> x >> y;
			points.insert(pair<INT, INT>(x, y));

			if(y) {
				if(i<n)
					first_length++;
				else
					second_length++;
			}
		}

		if(!consistent_quad(points))
			cout << "different" << endl;
		else {
			if(first_length > 2 && second_length > 2)
				cout << "same" << endl;
			else
				cout << "unsure" << endl;
		}
	}

	return 0;
}
