#include <cmath>
#include <map>
#include <iostream>
#include <vector>
using namespace std;

typedef long long int INT;

vector<double> GetParabola(const vector<INT> &x, const vector<INT> &y) {
  vector<double> result;
  result.push_back((double(y[2]-y[1])/(x[2]-x[1]) - double(y[0]-y[1])/(x[0]-x[1])) / (x[2]-x[0]));
  result.push_back(double(y[2]-y[1])/(x[2]-x[1]) - result[0]*(x[1]+x[2]));
  result.push_back(y[2] - result[0]*x[2]*x[2] - result[1]*x[2]);
  return result;
}

bool MustBeDifferent(const vector<INT> &x1, const vector<INT> &y1, const vector<INT> &x2,
                     const vector<INT> &y2) {
  // Merge the two lists
  map<INT, INT> m;
  for (INT i = 0; i < (INT)x1.size(); i++) {
    if (m.count(x1[i]) && m[x1[i]] != y1[i])
      return true;
    else
      m[x1[i]] = y1[i];
  }
  for (INT i = 0; i < (INT)x2.size(); i++) {
    if (m.count(x2[i]) && m[x2[i]] != y2[i])
      return true;
    else
      m[x2[i]] = y2[i];
  }

  // Handle leading and trailing zeroes
  vector<INT> x, y;
  for (map<INT,INT>::iterator it = m.begin(); it != m.end(); ++it)
  if (x.size() > 0 || it->second != 0) {
    x.push_back(it->first);
    y.push_back(it->second);
  }
  while (y.size() > 0 && y[y.size()-1] == 0) {
    x.pop_back();
    y.pop_back();
  }

  // Build the common parabola and check
  if (x.size() < 3)
    return false;
  vector<double> parab = GetParabola(x, y);
  if (parab[0] >= 0)
    return true;
  for (map<INT,INT>::iterator it = m.begin(); it != m.end(); ++it) {
    double z = it->first*it->first*parab[0] + it->first*parab[1] + parab[2];
    if (fabs(z - it->second) >= 1e-8 && (z >= 0 || it->second != 0))
      return true;
  }
  return false;
}

bool IsUnique(const vector<INT> &x, const vector<INT> &y) {
  INT cnt = 0;
  for (INT i = 0; i < (INT)y.size(); i++)
  if (y[i] != 0)
    cnt++;
  return cnt >= 3;
}

int main() {
  INT n1, n2;
  while ((cin >> n1 >> n2) && n1 != 0) {
    vector<INT> x1(n1), y1(n1), x2(n2), y2(n2);
    for (INT i = 0; i < n1; i++)
      cin >> x1[i] >> y1[i];
    for (INT i = 0; i < n2; i++)
      cin >> x2[i] >> y2[i];
    vector<double> v = GetParabola(x1, y1);
    if (MustBeDifferent(x1, y1, x2, y2))
      cout << "different" << endl;
    else if (IsUnique(x1, y1) && IsUnique(x2, y2))
      cout << "same" << endl;
    else
      cout << "unsure" << endl;
  }
}
