#include <iostream>
#include <vector>

using namespace std;

typedef long long int LL;
typedef pair<LL,LL> P;
typedef vector<P> VP;
typedef vector<LL> VL;

LL Det(LL a, LL b, LL c,
       LL d, LL e, LL f,
       LL g, LL h, LL i) {
    return a*e*i + b*f*g + c*d*h - a*f*h - b*d*i - c*e*g;
}

VL GetPoly(VP p) {
    VL ret;
    ret.push_back(Det(p[0].second, p[0].first, 1,
                      p[1].second, p[1].first, 1,
                      p[2].second, p[2].first, 1));

    ret.push_back(Det(p[0].first*p[0].first, p[0].second, 1,
                      p[1].first*p[1].first, p[1].second, 1,
                      p[2].first*p[2].first, p[2].second, 1));

    ret.push_back(Det(p[0].first*p[0].first, p[0].first, p[0].second,
                      p[1].first*p[1].first, p[1].first, p[1].second,
                      p[2].first*p[2].first, p[2].first, p[2].second));

    ret.push_back(Det(p[0].first*p[0].first, p[0].first, 1,
                      p[1].first*p[1].first, p[1].first, 1,
                      p[2].first*p[2].first, p[2].first, 1));

    if (ret[3] < 0) for (int i = 0; i < ret.size(); i++) ret[i] = -ret[i];
    return ret;
}

bool IsConsistent(VP p) {
    sort(p.begin(), p.end());
    p.erase(unique(p.begin(), p.end()), p.end());

    VP q;
    for (int i = 0; i < p.size(); i++) {
        if (p[i].second != 0) q.push_back(p[i]);
        if (i > 0 && p[i].first == p[i-1].first && p[i].second != p[i-1].second) return false;
    }

    if (q.size() > 3) q.resize(3);
    if (q.size() == 3) {
        VL poly = GetPoly(q);
        if (poly[0] >= 0) return false;

        for (int i = 0; i < p.size(); i++) {
            LL num = max(poly[0]*p[i].first*p[i].first + poly[1]*p[i].first + poly[2], 0LL);
            LL den = poly[3];
            if (num != p[i].second * den) return false;
        }
        return true;
    } else if (q.size() == 2) {

        // check for separation by a zero
        for (int i = 0; i < p.size(); i++) {
            if (p[i].second != 0 &&
                (i == 0 || p[i-1].second == 0) &&
                (i == p.size()-1 || p[i+1].second == 0))
                return false;
        }

        return true;
    }
    
    return true;
}

int main() {
    while (true) {
        int n1, n2;
        cin >> n1 >> n2;

        if (n1 == 0 && n2 == 0) break;
        
        VP p;
        int x, y;
        int nz1 = 0, nz2 = 0;
        for (int i = 0; i < n1; i++) {
            cin >> x >> y;
            if (y != 0) nz1++;
            p.push_back(P(x,y));
        }
        for (int i = 0; i < n2; i++) {
            cin >> x >> y;
            if (y != 0) nz2++;
            p.push_back(P(x,y));
        }

        if (IsConsistent(p)) {
            if (nz1 >= 3 && nz2 >= 3) {
                cout << "same" << endl;
            } else {
                cout << "unsure" << endl;
            }
        } else {
            cout << "different" << endl;
        }
    }
}
