#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct gtube 
{
    double d;
    int n, limit;
    vector< double> radii;
    vector< vector<bool> > know; 
    vector< vector<double> > memo;
    
    gtube(int nn) : n(nn) {
        limit = 1 << n;
        radii = vector<double>(n);
        know = vector< vector<bool> >(n, vector<bool>(limit, false));
        memo = vector< vector<double> >(n, vector<double>(limit));
    }
    
    // recursive search that starts by asking for length of full tube
    double pack(int top, int drops) {
        // boundary case is one gumdrop
        int it = 1 << top;
        if (drops == it) return 2.0*radii[top];
        
        if (know[top][drops]) return memo[top][drops];
        
        // try every possible next-to-top one
        int next = drops - it;
        double best = 1e10;
        for (int i = 0; i < n; ++i) {
            if (next & (1 << i)) {
                double c = radii[i] + radii[top];
                double a = d - radii[i] - radii[top];
                double h = sqrt(c*c - a*a);
                best = min(best, pack(i, next) - radii[i] + h + radii[top]);
            }
        }
        
        // memoize for next time
        know[top][drops] = true;
        return memo[top][drops] = best;
    }
    
    // find the best packing
    double length() {
        int start = (1 << n) - 1;
        double best = 1e10;
        for (int i = 0; i < n; ++i)
            best = min(best, pack(i, start));
        return best;
    }
    
};

istream &operator>>(istream &stream, gtube &g)
{
    stream >> g.d;
    for (int i = 0; i < g.n; ++i)
        stream >> g.radii[i];
    return stream;
}

int main()
{
    int n;
    while (cin >> n) {
        if (n == 0) break;
        
        gtube g(n);
        cin >> g;
        
        cout << int(g.length() + 0.5) << endl;
    }
    
    return 0;
}

