#include <iostream>
#include <cmath>
#include <vector>

using namespace std;

typedef vector<double> VD;
typedef vector<VD> VVD;

int main() {
    while (true) {
        int n;
        double d;
        cin >> n >> d;
        if (n == 0) break;
        
        VD r(n);
        for (int i = 0; i < n; i++) cin >> r[i];

        // increment[from][to]
        VVD increment(n, VD(n));
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                double theta = acos((d - r[i] - r[j]) / (r[i] + r[j]));
                increment[i][j] = (r[i] + r[j]) * sin(theta);
            }
        }

        // minLength[subsetUsed][topMostGumdrop]
        VVD minLength(1 << n, VD(n, 1e10));
        for (int i = 0; i < n; i++) {
            minLength[1 << i][i] = 2 * r[i];
        }

        // DP on subsets
        for (int subset = 1; subset < (1 << n); subset++) {
            for (int i = 0; i < n; i++) {
                if ((subset & (1 << i)) == 0) continue;
                
                for (int j = 0; j < n; j++) {
                    if ((subset & (1 << j)) != 0) continue;
                    minLength[subset | (1 << j)][j] = min(minLength[subset | (1 << j)][j],
                                                          minLength[subset][i] + increment[i][j] - r[i] + r[j]);
                }
            }
        }
        
        double best = 1e10;
        for (int i = 0; i < n; i++) {
            best = min(best, minLength[(1 << n) - 1][i]);
        }

        cout << (int)(best + 0.5) << endl;
    }
}
