// Sonny's solution to Folded Fixtures
// October 2, 2008

#include <iostream>
#include <vector>
#include <queue>
#include <utility>
#include <algorithm>

using namespace std;
const int sentry = 0x10000000;

int main()
{
    int n, m;
    while (cin >> n >> m)
    {
        if (n == 0) break;

        // read in sparse representation of the fixture graph
        vector< vector<int> > fixture(n);
        for (int a, b, i = 0; i < m; ++i) {
            cin >> a >> b;
            fixture[a-1].push_back(b-1);
            fixture[b-1].push_back(a-1);
        }

        // try hanging up by each vertex
        bool odd = false;
        int height = sentry;
        for (int v = 0; v < n; ++v)
        {
            queue< pair<int,int> > bfsq;
            bfsq.push(pair<int,int>(v, 0));
            int h = 0;

            vector<int> seen(n, sentry);
            while (!bfsq.empty()) 
            {
                int w = bfsq.front().first;
                int d = bfsq.front().second;
                bfsq.pop();
                h = max(h, d);
                ++d;

                // check all back edges for odd cycle
                for (vector<int>::iterator it = fixture[w].begin(); 
                                           it != fixture[w].end(); ++it) 
                {
                    if (seen[*it] < sentry) {
                        if (seen[*it]%2 != d%2) { odd = true; goto end; }
                    }
                    else if (seen[w] == sentry) bfsq.push(pair<int,int>(*it, d));
                }
                seen[w] = d-1;
            }
            height = min(height, h);
        }

end:
        if (odd)    cout << "impossible" << endl;
        else        cout << height << endl;

    }

    return 0;
}
