#include <iostream>
#include <vector>

using namespace std;

typedef vector<int> VI;
typedef vector<VI> VVI;

int INF = 1000000;

int main() {
    
    while (true) {

        // read input
        int n, m;
        cin >> n >> m;
        if (n == 0 && m == 0) break;

        VVI adj(n, VI(n, INF));
        for (int i = 0; i < m; i++) {
            int a, b;
            cin >> a >> b;
            a--; b--;
            adj[a][b] = adj[b][a] = 1;
        }

        // Floyd's algorithm
        VVI dist(adj);
        for (int i = 0; i < n; i++)
            dist[i][i] = 0;
        for (int k = 0; k < n; k++) 
            for (int i = 0; i < n; i++) 
                for (int j = 0; j < n; j++) 
                    dist[i][j] = min(dist[i][j], dist[i][k] + dist[k][j]); 

        int result = -1;

        // consider all possible root nodes
        for (int i = 0; i < n; i++) {
            
            int diameter = 0;
            bool found_problem = false;
            for (int j = 0; !found_problem && j < n; j++) {
                for (int k = 0; !found_problem && k < n; k++) {
                    if (dist[i][j] == dist[i][k] && adj[j][k] == 1)
                        found_problem = true;
                }
                diameter = max(diameter, dist[i][j]);
            }
            
            if (!found_problem) {
                if (result == -1 || diameter < result) {
                    result = diameter;
                }
            }
        }
        
        // print results
        if (result == -1) {
            cout << "impossible" << endl;
        } else {
            cout << result << endl;
        }
    }
    return 0;
}
