#include <stdio.h>
#include <stdlib.h>

#define MAXPOLY 25
#define MAXVERT 110

int assignment[MAXPOLY+1];
int polyData[MAXPOLY+1][MAXVERT+1][2];
int polyCount = 0;

/* reads a polygon and converts to vectors */
void read_poly(int polyIx) {
  int oriX, oriY, curX, curY, newX, newY, offset=0;
  
  scanf("%d %d ", &oriX, &oriY); curX = oriX; curY = oriY; 
  scanf("%d %d ", &newX, &newY); 

  while (newX != oriX || newY != oriY) {
    polyData[polyIx][offset][0] = newX-curX;
    polyData[polyIx][offset][1] = newY-curY;

    curX = newX; 
    curY = newY;
    scanf("%d %d ", &newX, &newY); 

    offset++;    
  }

  polyData[polyIx][offset][0] = newX-curX;
  polyData[polyIx][offset][1] = newY-curY;
  offset++;

  polyData[polyIx][MAXVERT][0] = offset;
}

/* matches poly[MAXPOLY] to one of the pieces, outputs index */
int match_poly(void) {
  int polyIx;
  int polySize = polyData[MAXPOLY][MAXVERT][0];
  int base, offset;

  for (polyIx = 0; polyIx < polyCount; polyIx++) {
    if (polyData[polyIx][MAXVERT][0] != polySize)
      continue;
    
    for (base = 0; base < polySize; base++) {
      for (offset = 0; offset < polySize; offset++) {
	if (polyData[polyIx][(offset+base)%polySize][0] != 
	    polyData[MAXPOLY][offset][0] ||
	    polyData[polyIx][(offset+base)%polySize][1] != 
	    polyData[MAXPOLY][offset][1])
	  goto no_match;
      }
      return polyIx;

    no_match:
      /* try next base offset.. */
      1;
    }

    for (base = 0; base < polySize; base++) {
      for (offset = 0; offset < polySize; offset++) {
	if (polyData[polyIx][(offset+base)%polySize][0] != 
	    polyData[MAXPOLY][offset][1] ||
	    polyData[polyIx][(offset+base)%polySize][1] != 
	    -polyData[MAXPOLY][offset][0])
	  goto no_match2;
      }
      return polyIx;

    no_match2:
      /* try next base offset.. */
      1;
    }

    for (base = 0; base < polySize; base++) {
      for (offset = 0; offset < polySize; offset++) {
	if (polyData[polyIx][(offset+base)%polySize][0] != 
	    -polyData[MAXPOLY][offset][0] ||
	    polyData[polyIx][(offset+base)%polySize][1] != 
	    -polyData[MAXPOLY][offset][1])
	  goto no_match3;
      }
      return polyIx;

    no_match3:
      /* try next base offset.. */
      1;
    }

    for (base = 0; base < polySize; base++) {
      for (offset = 0; offset < polySize; offset++) {
	if (polyData[polyIx][(offset+base)%polySize][0] != 
	    -polyData[MAXPOLY][offset][1] ||
	    polyData[polyIx][(offset+base)%polySize][1] != 
	    polyData[MAXPOLY][offset][0])
	  goto no_match4;
      }
      return polyIx;

    no_match4:
      /* try next base offset.. */
      1;
    }
  }

  fprintf(stderr, "Should not get here.");
  return -1;
}

/* loop through all input */
int main(int argc, char **argv) {  
  scanf("%d ", &polyCount);
  while (polyCount > 0) {
    int polyIx;
    for (polyIx=0; polyIx<polyCount; polyIx++) {
      read_poly(polyIx);
    }
    for (polyIx=0; polyIx<polyCount; polyIx++) {
      read_poly(MAXPOLY);
      assignment[match_poly()] = polyIx;
    }
    for (polyIx=0; polyIx<polyCount; polyIx++) {
      if (polyIx > 0) printf(" ");
      printf("%d", assignment[polyIx]+1);
    }
    printf("\n");
    scanf("%d ", &polyCount);
  }

  return 0;
}
