#include <algorithm>
#include <iostream>
#include <string>
#include <vector>
using namespace std;

bool Matches(const vector<int> &x1, const vector<int> &y1,
             const vector<int> &x2, const vector<int> &y2) {
  if (x1.size() != x2.size())
    return false;
  for (int rot = 0; rot < 4; rot++)
  for (int shift = 0; shift < (int)x1.size(); shift++)
  for (int reverse = 0; reverse < 2; reverse++) {
    bool is_okay = true;
    int dx, dy;
    for (int i = 0; i < (int)x1.size(); i++) {
      int i2 = ((i + shift) % (int)x1.size());
      if (reverse)
        i2 = (int)x1.size() - 1 - i2;
      int x, y;
      switch (rot) {
        case 0: x = x2[i2]; y = y2[i2]; break;
        case 1: x = -y2[i2]; y = x2[i2]; break;
        case 2: x = -x2[i2]; y = -y2[i2]; break;
        case 3: x = y2[i2]; y = -x2[i2]; break;
      };
      if (i == 0) {
        dx = x - x1[i];
        dy = y - y1[i];
      }
      if (x - x1[i] != dx || y - y1[i] != dy)
        is_okay = false;
    }
    if (is_okay)
      return true;
  }
  return false;
}

int main() {
  int n;
  while ((cin >> n) && n != 0) {
    vector<vector<int> > poly_x(n), poly_y(n);
    vector<vector<int> > goal_x(n), goal_y(n);
    int m = 0;
    for (int i = 0; i < n; i++) {
      int x, y;
      while ((cin >> x >> y) && (poly_x[i].size() == 0 || x != poly_x[i][0] || y != poly_y[i][0])) {
        poly_x[i].push_back(x);
        poly_y[i].push_back(y);
      }
    }
    for (int i = 0; i < n; i++) {
      int x, y;
      while ((cin >> x >> y) && (goal_x[i].size() == 0 || x != goal_x[i][0] || y != goal_y[i][0])) {
        goal_x[i].push_back(x);
        goal_y[i].push_back(y);
      }
    }

    for (int i = 0; i < n; i++)
    for (int j = 0; j < n; j++)
    if (Matches(poly_x[i], poly_y[i], goal_x[j], goal_y[j])) {
      cout << (j+1);
      if (i == n-1)
        cout << endl;
      else
        cout << " ";
    }
  }
}
