#include <iostream>
#include <vector>

using namespace std;

typedef pair<int,int> PII;
typedef vector<PII> VPII;
typedef vector<VPII> VVPII;
typedef vector<VVPII> VVVPII;

VPII GetPolygon() {
    int i, j;
    cin >> i >> j;
    VPII polygon;
    
    while (true) {
        int x, y;
        cin >> x >> y;
        polygon.push_back(make_pair(x, y));
        if (x == i && y == j) break;
    }
    return polygon;
}

VPII Standardize(const VPII &poly) {
    int index = 0;
    for (int i = 1; i < poly.size(); i++) {
        if (poly[i].first < poly[index].first ||
            (poly[i].first == poly[index].first &&
             poly[i].second < poly[index].second)) {
            index = i;
        }
    }

    VPII ret(poly.size());
    for (int i = 0; i < poly.size(); i++) {
        ret[i] = poly[(i + index) % poly.size()];
    }

    int min_x = ret[0].first;
    int min_y = ret[0].second;
    for (int i = 0; i < ret.size(); i++) {
        min_x = min(min_x, ret[i].first);
        min_y = min(min_y, ret[i].second);
    }

    for (int i = 0; i < ret.size(); i++) {
        ret[i].first -= min_x;
        ret[i].second -= min_y;            
    }

    return ret;    
}

VPII Rotate(const VPII &poly) {
    VPII ret(poly.size());
    for (int i = 0; i < poly.size(); i++) {
        ret[i] = make_pair(-poly[i].second, poly[i].first);
    }
    return ret;
}

int main() {
    while (true) {
        int n;
        cin >> n;

        if (n == 0) break;

        VVVPII descriptions(n, VVPII(4));
        VVPII schematic(n);
        
        for (int i = 0; i < n; i++) {
            descriptions[i][0] = Standardize(GetPolygon());
            for (int j = 1; j < 4; j++)
                descriptions[i][j] = Standardize(Rotate(descriptions[i][j-1]));
        }
        for (int i = 0; i < n; i++) {
            schematic[i] = Standardize(GetPolygon());
        }

        for (int i = 0; i < n; i++) {
            if (i > 0) cout << " ";

            bool match_found = false;
            for (int j = 0; !match_found && j < n; j++) {
                for (int k = 0; !match_found && k < 4; k++) {
                    if (descriptions[i][k] == schematic[j]) {
                        match_found = true;
                        cout << j+1;
                    }
                }
            }
        }
        cout << endl;
    }
}
