// Sonny's lengthy solution to Tom's dreadful deadlines
// Septemer 30, 2008

#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct assignment {
    int x, d;
};

// so that we can sort assignments by due date
bool operator<(const assignment &a, const assignment &b)
{
    return a.d < b.d;
}

int main()
{
    int n;
    while (cin >> n)
    {
        if (n == 0) break;

        vector<assignment> a(n);

        // read assignment lengths and due dates
        for (int i = 0; i < n; ++i) cin >> a[i].x;
        for (int i = 0; i < n; ++i) cin >> a[i].d;

        // sort the assignments by due date, and then do them in order,
        // keeping track of how much spare time Jim has for each one
        sort(a.begin(), a.end());
        int spare = 1000;
        for (int i = 0, t = 0; i < n; ++i) {
            t += a[i].x;
            spare = min(spare, a[i].d - t);
        }

        // latest start time is minimum spare time
        if (spare >= 0) cout << spare << endl;
        else            cout << "impossible" << endl;
    }

    return 0;
}
