#include <iostream>
#include <vector>

using namespace std;

typedef pair<int,int> PII;
typedef vector<PII> VPII;

int main() {
    
    while (true) {

        // read input
        int n;
        cin >> n;
        if (n == 0) break;
        VPII assignments(n);

        for (int i = 0; i < n; i++) cin >> assignments[i].second; // amount of time
        for (int i = 0; i < n; i++) cin >> assignments[i].first;  // deadline

        // sort assignments in order of latest deadline
        sort(assignments.begin(), assignments.end());
        reverse(assignments.begin(), assignments.end());

        int starting_time = assignments[0].first;

        // greedy algorithm
        for (int i = 0; i < n; i++) {
            starting_time = min(starting_time, assignments[i].first) - assignments[i].second;
        }

        if (starting_time >= 0)
            cout << starting_time << endl;
        else
            cout << "impossible" << endl;
    }
    
    return 0;
}
