#include <iostream>
#include <string>
#include <vector>
using namespace std;

struct Light {
  char dir;
  int horz_period, vert_period;

  bool IsHorizontal(int t) {
    t %= (horz_period + vert_period);
    if (dir == '-')
      return t < horz_period;
    else
      return t >= vert_period;
  }
};

int main() {
  int maxx, maxy, startpos, endpos;
  while ((cin >> maxy >> maxx) && maxx != 0) {
    vector<string> grid(maxy);
    for (int y = 0; y < maxy; y++)
      cin >> grid[y];

    int num_lights = 0;
    for (int y = 0; y < maxy; y++)
    for (int x = 0; x < maxx; x++)
    if (grid[y][x] == 'A')
      startpos = y*maxx+x;
    else if (grid[y][x] == 'B')
      endpos = y*maxx+x;
    else if (grid[y][x] >= '0' && grid[y][x] <= '9')
      num_lights = max(num_lights, grid[y][x] - '0' + 1);
    vector<Light> lights(num_lights);
    for (int i = 0; i < num_lights; i++) {
      int temp;
      cin >> temp >> lights[i].dir >> lights[i].horz_period >> lights[i].vert_period;
    }

    vector<int> best_time(maxx*maxy, -1);
    best_time[startpos] = 0;
    for (int t = 0; t <= 20*20 + 100*10; t++) {
      vector<int> new_best_time = best_time;
      for (int y = 0; y < maxy; y++)
      for (int x = 0; x < maxx; x++)
      if (best_time[y*maxx+x] != -1)
      for (int dy = -1; dy <= 1; dy++)
      for (int dx = -1; dx <= 1; dx++)
      if (dx*dx + dy*dy == 1) {
        int y2 = y+dy, x2 = x+dx;
        if (y2 < 0 || x2 < 0 || y2 >= maxy || x2 >= maxx || grid[y2][x2] == '.')
          continue;
        if (grid[y2][x2] >= '0' && grid[y2][x2] <= '9') {
          bool is_horizontal = lights[grid[y2][x2]-'0'].IsHorizontal(t);
          if ((is_horizontal && dy != 0) || (!is_horizontal && dx != 0))
            continue;
        }
        if (best_time[y2*maxx+x2] == -1)
          new_best_time[y2*maxx+x2] = t+1;
      }
      best_time = new_best_time;
    }

    if (best_time[endpos] == -1)
      cout << "impossible" << endl;
    else
      cout << best_time[endpos] << endl;
  }
}
