#include <iostream>
#include <vector>
#include <string>
#include <queue>
#include <iomanip>

using namespace std;

typedef vector<string> VS;
typedef vector<char> VC;
typedef vector<int> VI;
typedef vector<VI> VVI;

struct Entry {
    int i, j, t;
    Entry(int i, int j, int t) : i(i), j(j), t(t) {}

    bool operator<(const Entry &rhs) const {
        return (t > rhs.t);
    }
};

int main() {
    while (true) {

        // read input
        int m, n;
        cin >> m >> n;

        if (m == 0 && n == 0) break;

        Entry source(0,0,0);
        Entry sink(0,0,0);
        
        VS grid(m);
        int num_intersections = 0;
        for (int i = 0; i < m; i++) {
            cin >> grid[i];

            for (int j = 0; j < n; j++) {
                if (grid[i][j] >= '0' && grid[i][j] <= '9') {
                    num_intersections++;
                } else if (grid[i][j] == 'A') {
                    source = Entry(i, j, 0);
                } else if (grid[i][j] == 'B') {
                    sink = Entry(i, j, 0);
                }
            }
        }

        VC initial(num_intersections);
        VI ew(num_intersections);
        VI ns(num_intersections);
        
        for (int i = 0; i < num_intersections; i++) {
            int temp;
            cin >> temp >> initial[i] >> ew[i] >> ns[i];
        }

        // run BFS
        VVI min_time(m, VI(n, -1));
            
        priority_queue<Entry> Q;
        Q.push(source);

        while (!Q.empty()) {
            Entry e = Q.top();
            Q.pop();

            if (min_time[e.i][e.j] != -1) continue;
            min_time[e.i][e.j] = e.t;
            if (e.i == sink.i && e.j == sink.j) break;

            int di[] = {1, -1, 0, 0};
            int dj[] = {0, 0, 1, -1};
            for (int d = 0; d < 4; d++) {
                int ni = e.i + di[d];
                int nj = e.j + dj[d];
                if (ni < 0 || ni >= m || nj < 0 || nj >= n) continue;

                if (grid[ni][nj] == '#' || grid[ni][nj] == 'B') {
                    Q.push(Entry(ni, nj, e.t+1));
                } else if (grid[ni][nj] >= '0' && grid[ni][nj] <= '9') {
                    int nt = e.t+1;
                    
                    while (true) {
                        int light_no = (int)(grid[ni][nj] - '0');
                        char curr_dir;
                        
                        int wrapped_t = nt % (ew[light_no] + ns[light_no]);
                        if (wrapped_t == 0) wrapped_t += ew[light_no] + ns[light_no];
                        
                        if (initial[light_no] == '-') {
                            curr_dir = (wrapped_t <= ew[light_no] ? '-' : '|');
                        } else {
                            curr_dir = (wrapped_t <= ns[light_no] ? '|' : '-');
                        }
                        
                        if (curr_dir == '-' && d >= 2) break;
                        if (curr_dir == '|' && d < 2) break;
                        nt++;
                    }
                    
                    Q.push(Entry(ni, nj, nt));
                }
            }
        }

        if (min_time[sink.i][sink.j] == -1) {
            cout << "impossible" << endl;
        } else {
            cout << min_time[sink.i][sink.j] << endl;
        }
    }
}
