// Sonny's solution to Boundless Boxes
// October 1, 2008

#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

const int sentry = 0x10000000;

int main()
{
    int m, n, s;
    while (cin >> m >> n >> s)
    {
        if (m == 0 || n == 0) break;

        // create an empty canvas
        vector< vector<int> > canvas(m, vector<int>(n, sentry));

        // read and paint the seed squares
        for (int i = 0; i < s; ++i) {
            int r, c;
            cin >> r >> c;
            canvas[r-1][c-1] = 1;
        }

        // now paint bottom-right portions by scanning through
        for (int r = 0; r < m; ++r)
            for (int c = 0; c < n; ++c) {
                int shade = sentry;
                if (r > 0) {
                    if (c > 0)  shade = min(shade, canvas[r-1][c-1]);   // above left
                                shade = min(shade, canvas[r-1][c]);     // above
                    if (c < n-1)shade = min(shade, canvas[r-1][c+1]);   // above right
                }
                if (c > 0)      shade = min(shade, canvas[r][c-1]);     // left
                canvas[r][c] = min(canvas[r][c], shade + 1);
            }

        // for counting shades
        int total = 0;

        // finally paint top-left portions by scanning through in reverse
        for (int r = m-1; r >= 0; --r)
            for (int c = n-1; c >= 0; --c) {
                int shade = sentry;
                if (r < m-1) {
                    if (c > 0)  shade = min(shade, canvas[r+1][c-1]);   // below left
                                shade = min(shade, canvas[r+1][c]);     // below
                    if (c < n-1)shade = min(shade, canvas[r+1][c+1]);   // below right
                }
                if (c < n-1)    shade = min(shade, canvas[r][c+1]);     // right;
                canvas[r][c] = min(canvas[r][c], shade + 1);

                // track the lightest shade
                total = max(total, canvas[r][c]);
            }

        cout << total << endl;
    }

    return 0;
}
