#include <iostream>
#include <queue>
#include <vector>
using namespace std;

int main() {
  int maxx, maxy, seeds;
  while ((cin >> maxx >> maxy >> seeds) && (maxx != 0)) {
    queue<int> q;
    vector<int> dist(maxx*maxy, -1);
    for (int i = 0; i < seeds; i++) {
      int x, y;
      cin >> x >> y;
      int pos = (y-1)*maxx + (x-1);
      dist[pos] = 0;
      q.push(pos);
    }

    int max_dist = 0;
    while (!q.empty()) {
      int x = q.front() % maxx, y = q.front() / maxx;
      q.pop();
      for (int dy = -1; dy <= 1; dy++)
      for (int dx = -1; dx <= 1; dx++) {
        int x2 = x + dx, y2 = y + dy;
        if (x2 < 0 || y2 < 0 || x2 >= maxx || y2 >= maxy || dist[y2*maxx+x2] != -1) continue;
        max_dist = dist[y2*maxx+x2] = dist[y*maxx+x] + 1;
        q.push(y2*maxx+x2);
      }
    }

    cout << (max_dist + 1) << endl;
  }
}
