#include <iostream>
#include <set>
#include <vector>
#include <queue>

using namespace std;

struct Seed {
    int r, c, color;
    Seed(int r, int c, int color) : r(r), c(c), color(color) {}
};

typedef vector<int> VI;
typedef vector<VI> VVI;

int main() {
    while (true) {
        int m, n, s;
        cin >> m >> n >> s;
        if (m == 0 && n == 0 && s == 0) break;

        VVI grid(m, VI(n, -1));
        queue<Seed> Q;
        for (int i = 0; i < s; i++) {
            int r, c;
            cin >> r >> c;
            Q.push(Seed(r-1, c-1, 0));
        }
        
        while (!Q.empty()) {
            Seed e = Q.front();
            Q.pop();
            
            if (grid[e.r][e.c] != -1) continue;
            grid[e.r][e.c] = e.color;

            for (int dr = -1; dr <= 1; dr++) {
                for (int dc = -1; dc <= 1; dc++) {
                    int nr = e.r + dr;
                    int nc = e.c + dc;
                    if (nr >= 0 && nr < m && nc >= 0 && nc < n) {
                        Q.push(Seed(nr, nc, e.color+1));
                    }
                }
            }
        }
        
        set<int> colors;
        for (int i = 0; i < m; i++) {
            for (int j = 0; j < n; j++) {
                colors.insert(grid[i][j]);
            }
        }
        cout << colors.size() << endl;
    }
}
