#include <iostream>
#include <vector>

using namespace std;

typedef vector<int> VI;
typedef vector<VI> VVI;
typedef vector<VVI> VVVI;

int main() {
    int num_cases;
    cin >> num_cases;
    
    for (int testno = 0; testno < num_cases; testno++) {
        string s, t;
        cin >> s >> t;
        int n = s.length();

        s = "@" + s;
        t = "@" + t;

        // wipe[c][i][j] = cost of painting over characters i through j using color c
        //               = 1 + # of times of substrings of color !c that appear in t[i...j]
        VVVI wipe(2, VVI(n+1, VI(n+1)));

        for (char c = 'A'; c <= 'B'; c++) {
            for (int i = 1; i <= n; i++) {
                wipe[c - 'A'][i][i] = 1 + (t[i] == c ? 0 : 1);
                for (int j = i+1; j <= n; j++) {
                    wipe[c - 'A'][i][j] = wipe[c - 'A'][i][j-1] + (t[j-1] == c && t[j] != c ? 1 : 0);
                }
            }
        }

        // cost[i] = optimal cost of transforming s[1...i] into t[1...i]
        VI cost(n+1, 1000);
        cost[0] = 0;
        for (int i = 1; i <= n; i++) {

            // character doesn't need painting over
            if (s[i] == t[i]) {
                cost[i] = min(cost[i], cost[i-1]);
            } else {

                // consider painting over s[j+1...i]
                for (int j = 0; j < i; j++) {
                    cost[i] = min(cost[i], cost[j] + min(wipe[0][j+1][i], wipe[1][j+1][i]));
                }
            }
        }

        cout << cost[n] << endl;
    }
}
