#define TRUE 1
#define FALSE 0

#define ROUTER_PORT 5001
#define ROUTER_ADDR "172.24.32.11"

typedef uint32_t IP_addr;

struct Law{
	unsigned int id;    /* Rule serial number */
	int protocol;		/* protocol allowed */
	int action;			/* action to be taken - ACCEPT (forward and notify), DENY (drop and notify), REJECT (just drop) */
	IP_addr src_addr;     /* Source IP address */
	IP_addr dst_addr;     /* Dest IP address */
	int src_port;		/* Source port number */
	int dst_port;		/* Dest port number */
	int src_mask;		/* flag which represents weather src_addr is an ip or a network mask */
	int dst_mask;		/* flag which represents weather dst_addr is an ip or a network mask */
};

struct LawNode {
  struct Law *law; 				/* The rule itself */
  struct LawNode *next;		/* Pointer to next node */
  struct LawNode *prev; 	/* Pointer to prev node */
};

struct TreeNode {
  char *prefix;
  struct TreeNode *right;  
  struct TreeNode *left;
  struct TreeNode *parent;
  struct LawNode *head; /* Pointer to head of rule list for this node */
  struct LawNode *tail; /* POinter to tail of rule list for this node */
};

struct LawTree {
  struct TreeNode *root;        /* Pointer to tree root */
};
